# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from devtools_testutils.aio import recorded_by_proxy_async
from testpreparer import WebPubSubServicePreparer
from testpreparer_async import WebPubSubServiceClientTestBaseAsync


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebPubSubServiceAsync(WebPubSubServiceClientTestBaseAsync):
    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_get_service_status(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.get_service_status()

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_add_connections_to_groups(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.add_connections_to_groups(
            groups_to_add={"filter": "str", "groups": ["str"]},
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_close_all_connections(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.close_all_connections()

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_get_client_access_token(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.get_client_access_token()

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_remove_connections_from_groups(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.remove_connections_from_groups(
            groups_to_remove={"filter": "str", "groups": ["str"]},
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_send_to_all(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.send_to_all(
            message=bytes("bytes", encoding="utf-8"),
            content_type="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_close_connection(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.close_connection(
            connection_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_connection_exists(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.connection_exists(
            connection_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_send_to_connection(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.send_to_connection(
            connection_id="str",
            message=bytes("bytes", encoding="utf-8"),
            content_type="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_remove_connection_from_all_groups(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.remove_connection_from_all_groups(
            connection_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_group_exists(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.group_exists(
            group="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_close_group_connections(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.close_group_connections(
            group="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_send_to_group(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.send_to_group(
            group="str",
            message=bytes("bytes", encoding="utf-8"),
            content_type="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_list_connections(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = client.list_connections(
            group="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_remove_connection_from_group(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.remove_connection_from_group(
            group="str",
            connection_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_add_connection_to_group(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.add_connection_to_group(
            group="str",
            connection_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_revoke_permission(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.revoke_permission(
            permission="str",
            connection_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_has_permission(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.has_permission(
            permission="str",
            connection_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_grant_permission(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.grant_permission(
            permission="str",
            connection_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_user_exists(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.user_exists(
            user_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_close_user_connections(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.close_user_connections(
            user_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_send_to_user(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.send_to_user(
            user_id="str",
            message=bytes("bytes", encoding="utf-8"),
            content_type="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_remove_user_from_all_groups(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.remove_user_from_all_groups(
            user_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_remove_user_from_group(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.remove_user_from_group(
            group="str",
            user_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @WebPubSubServicePreparer()
    @recorded_by_proxy_async
    async def test_add_user_to_group(self, webpubsubservice_endpoint):
        client = self.create_async_client(endpoint=webpubsubservice_endpoint)
        response = await client.add_user_to_group(
            group="str",
            user_id="str",
        )

        # please add some check logic here by yourself
        # ...
