% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{make_splits}
\alias{make_splits}
\alias{make_splits.default}
\alias{make_splits.list}
\alias{make_splits.data.frame}
\title{Constructors for split objects}
\usage{
make_splits(x, ...)

\method{make_splits}{default}(x, ...)

\method{make_splits}{list}(x, data, class = NULL, ...)

\method{make_splits}{data.frame}(x, assessment, class = NULL, ...)
}
\arguments{
\item{x}{A list of integers with names "analysis" and "assessment", or a
data frame of analysis or training data.}

\item{...}{Not currently used.}

\item{data}{A data frame.}

\item{class}{An optional class to give the object.}

\item{assessment}{A data frame of assessment or testing data, which can be empty.}
}
\description{
Constructors for split objects
}
\examples{
df <- data.frame(
  year = 1900:1999,
  value = 10 + 8*1900:1999 + runif(100L, 0, 100)
)
split_from_indices <- make_splits(
  x = list(analysis = which(df$year <= 1980),
           assessment = which(df$year > 1980)),
  data = df
)
split_from_data_frame <- make_splits(
  x = df[df$year <= 1980,],
  assessment = df[df$year > 1980,]
)
identical(split_from_indices, split_from_data_frame)
}
