// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2012 - INRIA - Serge STEER
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

//3-D transform  *******************************************************************************

//R2R case  ------------------------------------------------------------------------------------
A=[0   1   1
   2  -1  -1
   3   4   4
   2  -1  -1];
A(:,:,2)=A+1;
A(:,:,3)=A(:,:,2);
y_ref=matrix([63;-27;39;-27;12;0;-24;0;12;0;-24;0;-12;
              0;0;0;0;0;0;0;0;0;0;0;
              -12;0;0;0;0;0;0;0;0;0;0;0],[4 3 3]);
y=fft(A);
assert_checktrue(isreal(y));
assert_checkalmostequal(y,y_ref); 
assert_checkalmostequal(A,fft(y,1),0,10*%eps);

y=fft(A,"symmetric");
assert_checktrue(isreal(y));
assert_checkalmostequal(y,y_ref); 
assert_checkalmostequal(A,fft(y,1,"symmetric"),0,10*%eps);

y=fft(A,"nonsymmetric"); //use R2C
assert_checktrue(~isreal(y));
assert_checkalmostequal(y,y_ref); 
assert_checkalmostequal(A,fft(y,1,"nonsymmetric"),0,10*%eps);


A=matrix([4750;-163;138;138;-163;-100;-2;9;-148;42;10;-301;246;246;-301;-100;42;-148;9;-2;-12;157;
          -110;224;37;-101;-94;260;258;345;-49;175;227;110;161;65;-40;-182;161;-390;412;101;168;
          138;35;21;-95;-81;236;1;219;-215;120;284;-232;-35;-23;215;-191;122;412;35;138;168;101;
          -35;122;-191;215;-23;219;-232;284;120;-215;21;1;236;-81;-95;-12;37;224;-110;157;65;-390;
          161;-182;-40;-49;161;110;227;175;-101;345;258;260;-94],[5,4,5]);
y_ref=matrix([ 9006; 1997.01835368650836; 7499.98164631349118; 7499.98164631349118;
               1997.01835368650836; 5500; 8003.03595972396761; 4499.30203473224719;
               3496.74144394796622; 4500.92056159581989; 7994; 4500.41996658886728;
               7002.58003341113272; 7002.58003341113272; 4500.41996658886728; 5500;
               4500.92056159581989; 3496.74144394796622; 4499.30203473224719; 8003.03595972396761;
               3003.23606797749972; 4503.21094298379558; 2498.80193260011856; 4500.56038652002371;
               3002.80933008143711; 1502.48409399493175; 4997.98726249178435; 6998.63971425121235;
               4503.41908441918713; 5499.99740938413652; 4000.79645449752343; 3004.49048964150825;
               3499; 4495.40709100495314; 4504.89210254386671; 5498.03152064027927;
               3999.73866895309675; 1500.9206722688125; 7001.49266501579041; 3003.15588613093223;
               2998.76393202250028; 5001.43961347997629; 5493.78905701620442; 6994.19066991856289;
               5003.19806739988144; 4499.2782026543191; 4996.34845842043978; 3004.96649100621744;
               7499.64517406068444; 5505.14335301404844; 4497.20354550247703; 3502.59290899504595;
               8498.50951035849175; 6998.10789745613329; 3499; 7000.20618271046988;
               5998.73979214458359; 3497.30757754890101; 2497.2015304242459; 3495.29626046592784;
               2998.76393202250028; 5003.19806739988144; 6994.19066991856289; 5493.78905701620442;
               5001.43961347997629; 7000.20618271046988; 3495.29626046592784; 2497.2015304242459;
               3497.30757754890101; 5998.73979214458359; 4497.20354550247703; 3499;
               6998.10789745613329; 8498.50951035849175; 3502.59290899504595; 4499.2782026543191;
               5505.14335301404844; 7499.64517406068444; 3004.96649100621744; 4996.34845842043978;
               3003.23606797749972; 3002.80933008143711; 4500.56038652002371; 2498.80193260011856;
               4503.21094298379558; 5498.03152064027927; 3003.15588613093223; 7001.49266501579041;
               1500.9206722688125; 3999.73866895309675; 4000.79645449752343; 4504.89210254386671;
               4495.40709100495314; 3499; 3004.49048964150825; 1502.48409399493175;
               5499.99740938413652; 4503.41908441918713; 6998.63971425121235; 4997.98726249178435],[5,4,5]);

y=fft(A);
assert_checktrue(isreal(y));
assert_checkalmostequal(y,y_ref); 


//R2C case   ------------------------------------------------------------------------------------
A=matrix([5;4;3;6;4;9;0;5;3;4;3;1;8;2;1;7;2;7;8;4;4;9;
          1;2;6;6;7;9;5;3;4;9;9;3;4;7;3;5;3;5;5;1;2;6;
          8;0;7;2;4;8;6;5;2;8;1;3;9;8;5;10],[4,3,5]);
y_ref=matrix([ 290; 22+%i*4;-26; 22-%i*4; 9.5+%i*9.52627944162882301;
               -1.1339745962155614+%i*17.1602540378443891;-3.5+%i*25.1147367097487191;
               -2.8660254037844384+%i*0.16025403784438552; 9.5-%i*9.52627944162882301;
               -2.8660254037844384-%i*0.16025403784438552;-3.5-%i*25.1147367097487191;
               -1.1339745962155614-%i*17.1602540378443891;-10.9549150281252636-%i*1.37984007917967944;
               5.35973404130009712-%i*26.1183685942109989;-23.4614928368734752-%i*1.14281435514402396;
               -3.59580201879988692+%i*23.0406850570357449;-21.3658553026453930-%i*8.84359942677465227;
               20.7330326917071268-%i*8.81688081018132586; 3.64531223802112692-%i*9.52499614355328994;
               7.43941996380932657-%i*16.867370295570808; 17.5396173813961269+%i*3.3290181678526012;
               15.0849628274577707+%i*11.593028238175755; 25.597333548226878-%i*1.41840966171390725;
               -18.8967357079763296-%i*30.6614339614318183;-16.5450849718747364+%i*32.005406439473461;
               -2.0005198567285527+%i*10.4427980896260522; 8.9614928368734752-%i*15.1639036975864734;
               8.23658783422834162-%i*9.7162555616206916;-4.97109202629695890-%i*8.30757202395887973;
               0.92910806515476718-%i*30.3790246133370161;-5.43718181239582421+%i*23.1017112524799586;
               -14.884673669748171-%i*11.3804574337330209; 16.7973299475462241+%i*19.3569789554980396;
               -0.44355669881229343+%i*5.1399061460535682;-7.8054639738521807-%i*7.52153572775482537;
               -5.96155747159219818-%i*1.55370934855336351;-16.5450849718747364-%i*32.005406439473461;
               8.23658783422834162+%i*9.7162555616206916; 8.9614928368734752+%i*15.1639036975864734;
               -2.0005198567285527-%i*10.4427980896260522; 16.7973299475462241-%i*19.3569789554980396;
               -5.96155747159219818+%i*1.55370934855336351;-7.8054639738521807+%i*7.52153572775482537;
               -0.44355669881229343-%i*5.1399061460535682;-4.97109202629695890+%i*8.30757202395887973;
               -14.884673669748171+%i*11.3804574337330209;-5.43718181239582421-%i*23.1017112524799586;
               0.92910806515476718+%i*30.3790246133370161;-10.9549150281252636+%i*1.37984007917967944;
               -3.59580201879988692-%i*23.0406850570357449;-23.4614928368734752+%i*1.14281435514402396;
               5.35973404130009712+%i*26.1183685942109989; 17.5396173813961269-%i*3.3290181678526012;
               -18.8967357079763296+%i*30.6614339614318183; 25.597333548226878+%i*1.41840966171390725;
               15.0849628274577707-%i*11.593028238175755;-21.3658553026453930+%i*8.84359942677465227;
               7.43941996380932657+%i*16.867370295570808; 3.64531223802112692+%i*9.52499614355328994;
               20.7330326917071268+%i*8.81688081018132586],[4,3,5]);
y=fft(A);
assert_checkalmostequal(y,y_ref); 

//C2R case   ------------------------------------------------------------------------------------
A=matrix([ 2900; 220+%i*40;-260; 220-%i*40; 95+%i*95;-11+%i*172;-35+%i*251;-29+%i*2; 95-%i*95;
           -29-%i*2;-35-%i*251;-11-%i*172;-110-%i*14; 54-%i*261;-235-%i*11;-36+%i*230;-214-%i*88;
           207-%i*88; 36-%i*95; 74-%i*169; 175+%i*33; 151+%i*116; 256-%i*14;-189-%i*307;
           -165+%i*320;-20+%i*104; 90-%i*152; 82-%i*97;-50-%i*83; 9-%i*304;-54+%i*231;-149-%i*114;
           168+%i*194;-4+%i*51;-78-%i*75;-60-%i*16;-165-%i*320; 82+%i*97; 90+%i*152;-20-%i*104;
           168-%i*194;-60+%i*16;-78+%i*75;-4-%i*51;-50+%i*83;-149+%i*114;-54-%i*231; 9+%i*304;
           -110+%i*14;-36-%i*230;-235+%i*11; 54+%i*261; 175-%i*33;-189+%i*307; 256+%i*14;
           151-%i*116;-214+%i*88; 74+%i*169; 36+%i*95; 207+%i*88],[4,3,5]);
y_ref=matrix([ 2996; 3600; 1800; 2396; 1804.08726109815325; 601.420841162336728; 1797.20231832067839;
               2402.0440006453523; 2399.91273890184675; 2998.57915883766327; 2.79768167932161305;
               5401.95599935464725; 2396.96074950014463; 2999.02579525054898; 3601.07865923712325;
               4800.47728151174852; 5402.68357811465103; 5996.71587420499782; 2994.98775825329631;
               4800.7569165971172; 1194.78718041472757; 1801.42138987713292; 597.945126438306488;
               4795.69787130615623; 1806.28063851446973; 2996.33933739403255; 1802.22357633135243;
               2999.61398771896711; 4800.14227629597099; 1194.58106615498582; 4200.9816123952096;
               -1.643335439786938; 3000.6599157117771; 3602.13659702117502; 1207.26152998727684;
               601.910475422587638; 3601.29217048561441; 5398.45474462091079; 4205.6200225335615;
               3606.49125722100416; 5397.78905489267254; 4200.45827894945342; 2396.05617461713109;
               1802.27482470993255; 3000.2119789042963; 5400.98960279924631; 2403.91117288032501;
               1800.15817472797062; 4799.46644149977146; 4206.18012273450677; 591.077741897962369;
               1197.41747354827976; 2398.62992927763071; 1199.93973694330134; 600.335830922918376;
               5401.45253626486101; 1201.09608638827149; 2403.75745404970803; 4798.52079450553538;
               4195.39253641116193],[4,3,5]);
y=fft(A);
assert_checktrue(isreal(y));
assert_checkalmostequal(y,y_ref); 
y=fft(A,"symmetric");
assert_checktrue(isreal(y));
assert_checkalmostequal(y,y_ref);

y=fft(A,"nonsymmetric");
assert_checktrue(~isreal(y));
assert_checkalmostequal(y,y_ref);

//C2C case
//------------------------------------------------------------------------------------
A=[0      %i  3-%i
   2+%i   -1  -1
   3       4   4
   2-3*%i -1  -1];
A(:,:,2)=A+1;
A(:,:,3)=A(:,:,2).*A(:,:,2);
y=fft(A);
y_ref=matrix([ 130-%i*22;-34-%i*14; 102+%i*10;-98+%i*2; 11.624355652982139+%i*5.18653347947321031;
               45.6243556529821319+%i*13.1865334794732103;-28.375644347017861+%i*37.1865334794732121;
               -18.375644347017861+%i*29.1865334794732121;-12.624355652982139-%i*31.1865334794732121;
               21.3756443470178574-%i*23.1865334794732121;-52.6243556529821319+%i*0.81346652052678969;
               -42.624355652982139-%i*7.18653347947321031;-30.1435935394489825+%i*63.4256258422040702;
               23.124355652982139-%i*12.0525588832576496;-33.464101615137757+%i*49.9615242270663131;
               29.2679491924311215-%i*54.6935750346351952;-0.90192378864668221-%i*5.2224318643354568;
               -19.633974596215559+%i*23.2224318643354550;-16.2224318643354550-%i*18.6865334794732121;
               -13.4903810567665765-%i*19.4185842870420871; 24.026279441628823-%i*6.83012701892219098;
               5.29422863405994804+%i*21.6147367097487226; 8.7057713659400484-%i*20.2942286340599445;
               11.4378221735089287-%i*21.026279441628823;-57.8564064605510140-%i*47.4256258422040702;
               -1.1243556529821408+%i*26.0525588832576496;-26.5358983848622465-%i*53.9615242270663131;
               32.732050807568875+%i*52.6935750346351952; 4.97372055837117344+%i*1.83012701892219409;
               -10.2942286340599463-%i*28.614736709748719; 24.2942286340599480-%i*4.705771365940052;
               23.5621778264910695-%i*1.9737205583711752;-6.09807621135331601+%i*24.2224318643354550;
               -21.3660254037844375-%i*6.2224318643354586; 13.2224318643354550+%i*17.6865334794732085;
               12.4903810567665818+%i*20.4185842870420871],[4,3,3]);
assert_checkalmostequal(y,y_ref); 

//N-D transform  *******************************************************************************
//R2R case  ------------------------------------------------------------------------------------

A=matrix([7090;265;265;180;-42;-198;30;15;15;180;-198;-42;160;235;-245;-335;135;182;240;-75;75;
          -265;465;148;160;-245;235;-265;148;465;240;75;-75;-335;182;135;-410;446;204;-280;-253;
          353;-450;-198;-372;140;351;229;-48;236;-312;456;181;-279;262;-540;-50;363;385;-99;368;
          242;-6;-236;-71;-321;158;20;-90;397;109;195;-110;265;265;-120;-370;-110;-650;55;55;-120;
          -110;-370;-20;-125;-245;91;-153;34;-80;85;-5;-151;-447;416;-20;-245;-125;-151;416;-447;
          -80;-5;85;91;34;-153;-410;204;446;140;229;351;-450;-372;-198;-280;353;-253;368;-6;242;
          397;195;109;158;-90;20;-236;-321;-71;-48;-312;236;363;-99;385;262;-50;-540;456;-279;181],[3,4,3,4]);

y_ref=matrix([ 8640; 6480; 6480; 11520; 5760.26656797432588; 5039.73343202567412; 4320; 7200; 7200;
               11520; 5039.73343202567412; 5760.26656797432588; 4320; 2160; 2880; 9369.32603294810724;
               4323.73066958946401; 5040.79842187187296; 7200; 2160.00000000000045; 2880;
               12230.6739670518928; 3596.2693304105369; 12239.2015781281261; 4320; 2880; 2160;
               12230.6739670518928; 12239.2015781281261; 3596.2693304105369; 7200; 2880;
               2160.00000000000045; 9369.32603294810724; 5040.79842187187296; 4323.73066958946401;
               11520; 4318.1340241797152; 9361.8659758202848; 12240; 5046.12849930729499;
               7193.87150069270501; 7200; 10079.7334320256741; 10800.2665679743259; 2160;
               2164.52909146133834; 8635.47090853866212; 7923.73066958946401; 7196.80246635918866;
               8641.59812579485151; 7921.06627189730625; 6480.53313594865176; 10801.5994078459589;
               10079.2015781281261; 6482.39782971783188; 7198.66844217947437; 5759.73343202567321;
               9362.39911176893838; 5038.66716012836696; 7196.26933041053599; 13678.4018742051485;
               6483.19753364081134; 5038.93372810269375; 6478.40059215404108; 5039.46686405134824;
               2880.79842187187342; 1441.33155782052563; 9357.60217028216903; 6480.26656797432679;
               8641.33283987163304; 2877.60088823106116; 4320; 4320; 4320; 3600; 8639.20029607702054;
               10800.7997039229795; 12960; 8640; 8640; 3600; 10800.7997039229795; 8639.20029607702054;
               7920; 12960; 10800; 9365.06350946109706; 7196.00276243620829; 8637.60217028216721;
               10800; 720.000000000000455; 7920; 5034.93649053890294; 8643.99723756379171;
               5762.39782971783279; 7920; 10800; 12960; 5034.93649053890294; 5762.39782971783279;
               8643.99723756379171; 10800; 7920; 720.000000000000455; 9365.06350946109706;
               8637.60217028216721; 7196.00276243620829; 11520; 9361.8659758202848; 4318.1340241797152;
               2160; 8635.47090853866212; 2164.52909146133834; 7200; 10800.2665679743259;
               10079.7334320256741; 12240; 7193.87150069270501; 5046.12849930729499;
               7196.26933041053599; 6483.19753364081134; 13678.4018742051485; 6480.26656797432679;
               2877.60088823106116; 8641.33283987163304; 2880.79842187187342; 9357.60217028216903;
               1441.33155782052563; 5038.93372810269375; 5039.46686405134824; 6478.40059215404108;
               7923.73066958946401; 8641.59812579485151; 7196.80246635918866; 5759.73343202567321;
               5038.66716012836696; 9362.39911176893838; 10079.2015781281261; 7198.66844217947437;
               6482.39782971783188; 7921.06627189730625; 10801.5994078459589; 6480.53313594865176],[3,4,3,4]);
y=fft(A);
assert_checktrue(isreal(y));
assert_checkalmostequal(y,y_ref); 
A=matrix([ 2900; 220+%i*40;-260; 220-%i*40; 95+%i*95;-11+%i*172;-35+%i*251;-29+%i*2; 95-%i*95;
           -29-%i*2;-35-%i*251;-11-%i*172;-110-%i*14; 54-%i*261;-235-%i*11;-36+%i*230;-214-%i*88;
           207-%i*88; 36-%i*95; 74-%i*169; 175+%i*33; 151+%i*116; 256-%i*14;-189-%i*307;
           -165+%i*320;-20+%i*104; 90-%i*152; 82-%i*97;-50-%i*83; 9-%i*304;-54+%i*231;-149-%i*114;
           168+%i*194;-4+%i*51;-78-%i*75;-60-%i*16;-165-%i*320; 82+%i*97; 90+%i*152;-20-%i*104;
           168-%i*194;-60+%i*16;-78+%i*75;-4-%i*51;-50+%i*83;-149+%i*114;-54-%i*231; 9+%i*304;
           -110+%i*14;-36-%i*230;-235+%i*11; 54+%i*261; 175-%i*33;-189+%i*307; 256+%i*14;
           151-%i*116;-214+%i*88; 74+%i*169; 36+%i*95; 207+%i*88],[4,3,5]);
y_ref=matrix([ 2996; 3600; 1800; 2396; 1804.08726109815325; 601.420841162336728; 1797.20231832067839;
               2402.0440006453523; 2399.91273890184675; 2998.57915883766327; 2.79768167932161305;
               5401.95599935464725; 2396.96074950014463; 2999.02579525054898; 3601.07865923712325;
               4800.47728151174852; 5402.68357811465103; 5996.71587420499782; 2994.98775825329631;
               4800.7569165971172; 1194.78718041472757; 1801.42138987713292; 597.945126438306488;
               4795.69787130615623; 1806.28063851446973; 2996.33933739403255; 1802.22357633135243;
               2999.61398771896711; 4800.14227629597099; 1194.58106615498582; 4200.9816123952096;
               -1.643335439786938; 3000.6599157117771; 3602.13659702117502; 1207.26152998727684;
               601.910475422587638; 3601.29217048561441; 5398.45474462091079; 4205.6200225335615;
               3606.49125722100416; 5397.78905489267254; 4200.45827894945342; 2396.05617461713109;
               1802.27482470993255; 3000.2119789042963; 5400.98960279924631; 2403.91117288032501;
               1800.15817472797062; 4799.46644149977146; 4206.18012273450677; 591.077741897962369;
               1197.41747354827976; 2398.62992927763071; 1199.93973694330134; 600.335830922918376;
               5401.45253626486101; 1201.09608638827149; 2403.75745404970803; 4798.52079450553538;
               4195.39253641116193],[4,3,5]);
y=fft(A);
assert_checktrue(isreal(y));
assert_checkalmostequal(y,y_ref); 
y=fft(A,"symmetric");
assert_checktrue(isreal(y));
assert_checkalmostequal(y,y_ref);

y=fft(A,"nonsymmetric");
assert_checktrue(~isreal(y));
assert_checkalmostequal(y,y_ref);

//============================================================================================
//=================================fft(A ,isn, sel [,flag]) ==================================
//============================================================================================
//R2C and C2R case ---------------------------------------------------------------------------
//      Multiple 1D transforms
A=[0   1   1
   2  -1  -1
   3   4   4
   5   1  -1];

y_ref = [ 10, 5, 3;
          -3+%i*3,-3+%i*2,-3;
          -4, 5, 7;
          -3-%i*3,-3-%i*2,-3];
y=fft(A,-1,1);
assert_checkalmostequal(y,y_ref);
y=fft(y_ref,1,1);
assert_checktrue(isreal(y));
assert_checkalmostequal(A,y);

y_ref = [ 2.5, 1.25, 0.75;
          -0.75-%i*0.75,-0.75-%i*0.5,-0.75;
          -1, 1.25, 1.75;
          -0.75+%i*0.75,-0.75+%i*0.5,-0.75];
y=fft(A,1,1);
assert_checkalmostequal(y,y_ref);
y=fft(y_ref,-1,1);
assert_checktrue(isreal(y));
assert_checkalmostequal(A,y);

y_ref = [ 2,-1,-1;
          0, 3, 3;
          11,-1,-1;
          5, 5-%i*1.7320508, 5+%i*1.7320508];

y=fft(A,-1,2);
assert_checkalmostequal(y,y_ref);
y=fft(y_ref,1,2);
assert_checktrue(isreal(y));
assert_checkalmostequal(A,y);

y_ref = [ 0.66666666666666663,-0.33333333333333331,-0.33333333333333331;
          0, 1, 1;
          3.66666666666666652,-0.33333333333333326,-0.33333333333333326;
          1.66666666666666652, 1.66666666666666652+%i*0.57735026918962573,..
          1.66666666666666652-%i*0.57735026918962573];
y=fft(A,1,2);
assert_checkalmostequal(y,y_ref);
y=fft(y_ref,-1,2);
assert_checktrue(isreal(y));
assert_checkalmostequal(A,y);

//      Multiple 1D and 2D transforms of ND arrays
Dims=[5 3 4];
A=matrix(1:60,Dims);
Sel=2;
y=fft(A,-1,Sel);
for i=1:Dims(1)
  for j=1:Dims(3)
     ind=list(i,:,j);
    assert_checkalmostequal(y(ind(:)),fft(A(ind(:)),-1));
  end
end

y=fft(y,1,Sel);
assert_checktrue(isreal(y));
for i=1:Dims(1)
  for j=1:Dims(3)
    ind=list(i,:,j);
    assert_checkalmostequal(y(ind(:)),A(ind(:)));
  end
end


Sel=3;
y=fft(A,-1,Sel);
for i=1:Dims(1)
  for j=1:Dims(2)
    ind=list(i,j,:);
    assert_checkalmostequal(y(ind(:)),fft(A(ind(:)),-1));
  end
end
y=fft(y,1,Sel);
assert_checktrue(isreal(y));
for i=1:Dims(1)
  for j=1:Dims(2)
    ind=list(i,j,:);
    assert_checkalmostequal(y(ind(:)),A(ind(:)));
  end
end

Sel=[1 2];
y=fft(A,-1,Sel);
for j=1:Dims(3)
  ind=list(:,:,j);
  assert_checkalmostequal(y(ind(:)),fft(A(ind(:)),-1));
end
y=fft(y,1,Sel);
assert_checktrue(isreal(y));
for j=1:Dims(3)
  ind=list(:,:,j);
  assert_checkalmostequal(y(ind(:)),A(ind(:)));
end

Sel=[1 3];
y=fft(A,-1,Sel);
for j=1:Dims(2)
  ind=list(:,j,:);
  assert_checkalmostequal(y(ind(:)),fft(A(ind(:)),-1));
end
y=fft(y,1,Sel);
assert_checktrue(isreal(y));
for j=1:Dims(2)
  ind=list(:,j,:);
  assert_checkalmostequal(y(ind(:)),A(ind(:)));
end

Dims=[5 3 4 7];
A=matrix(1:prod(Dims),Dims);
Sel=[1 3 4];
y=fft(A,-1,Sel);
for j=1:Dims(2)
  ind=list(:,j,:,:);
  assert_checkalmostequal(y(ind(:)),fft(A(ind(:)),-1));
end

y=fft(y,1,Sel);
assert_checktrue(isreal(y));
for j=1:Dims(2)
  ind=list(:,j,:,:);
  assert_checkalmostequal(y(ind(:)),A(ind(:)));
end

Sel=[2  4];
y=fft(A,-1,Sel);
for i=1:Dims(1)
  for j=1:Dims(3)
    ind=list(i,:,j,:);
    assert_checkalmostequal(y(ind(:)),fft(A(ind(:)),-1));
  end
end

y=fft(y,1,Sel);
assert_checktrue(isreal(y));
for i=1:Dims(1)
  for j=1:Dims(3)
    ind=list(i,:,j,:);
    assert_checkalmostequal(y(ind(:)),A(ind(:)));
  end
end

Sel=3;
y=fft(A,-1,Sel);
for i=1:Dims(1)
  for j=1:Dims(2)
    for k=1:Dims(4)
      ind=list(i,j,:,k);
      assert_checkalmostequal(y(ind(:)),fft(A(ind(:)),-1));
    end
  end
end

y=fft(y,1,Sel);
assert_checktrue(isreal(y));
for i=1:Dims(1)
  for j=1:Dims(2)
    for k=1:Dims(4)
      ind=list(i,j,:,k);
      assert_checkalmostequal(y(ind(:)),A(ind(:)));
    end
  end
end
