
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsewave.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bseplugin.hh>
#include <bse/bseprocedure.hh>
#include <bse/bsewave.hh>
#include <bse/bseeditablesample.hh>
/* --- load-wave --- */
static void
load_wave_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 8 "bsewave.proc"
 {
#line 10 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", "Wave object to store loaded contents",
				 BSE_TYPE_WAVE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file_name", "File Name", "The wave file to read wave chunks from",
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("wave_name", "Wave Name", "The name of the wave to read wave chunks from",
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error type",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 20 "bsewave.proc"
 }
static BseErrorType
#line 20 "bsewave.proc"
load_wave_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 23 "bsewave.proc"
{
#line 24 "bsewave.proc"
  
  BseWave *wave = (BseWave*) bse_value_get_object (in_values++);
  const char *file_name = sfi_value_get_string (in_values++);
  const char *wave_name = sfi_value_get_string (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 29 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave) || !file_name || !wave_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  error = bse_wave_load_wave_file (wave, file_name, wave_name, NULL, NULL, TRUE);
#line 33 "bsewave.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- n-wave-chunks --- */
static void
n_wave_chunks_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 37 "bsewave.proc"
 {
#line 39 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_chunks", "Number of Wave Chunks", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 44 "bsewave.proc"
 }
static BseErrorType
#line 44 "bsewave.proc"
n_wave_chunks_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 47 "bsewave.proc"
{
#line 48 "bsewave.proc"
  
  BseWave *wave = (BseWave*) bse_value_get_object (in_values++);
#line 50 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 53 "bsewave.proc"
  
  sfi_value_set_int (out_values++, wave->n_wchunks);
  return BSE_ERROR_NONE;
}
/* --- use-editable --- */
static void
use_editable_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 57 "bsewave.proc"
 {
#line 59 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("chunk_index", NULL, "Index of chunk to edit",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("esample", NULL, "Editable sample",
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_STANDARD);
}
#line 66 "bsewave.proc"
 }
static BseErrorType
#line 66 "bsewave.proc"
use_editable_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 69 "bsewave.proc"
{
#line 70 "bsewave.proc"
  
  BseWave *wave = (BseWave*) bse_value_get_object (in_values++);
  guint chunk_index = sfi_value_get_int (in_values++);
  BseEditableSample *esample = NULL;
  GslWaveChunk *wchunk = NULL;
#line 75 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;
  wchunk = (GslWaveChunk*) sfi_ring_nth_data (wave->wave_chunks, chunk_index);
  if (wchunk)
    {
      esample = (BseEditableSample*) g_object_new (BSE_TYPE_EDITABLE_SAMPLE, NULL);
      bse_editable_sample_set_wchunk (esample, wchunk);
      bse_item_use (BSE_ITEM (esample));
      g_object_unref (esample);
    }
#line 86 "bsewave.proc"
  
  bse_value_set_object (out_values++, esample);
  return BSE_ERROR_NONE;
}
/* --- chunk-get-osc-freq --- */
static void
chunk_get_osc_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 90 "bsewave.proc"
 {
#line 92 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("chunk_index", "Chunk Index", "Index of chunk",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_real ("osc_freq", NULL, NULL,
			  BSE_KAMMER_FREQUENCY, BSE_MIN_OSC_FREQUENCY, BSE_MAX_OSC_FREQUENCY, 10.0,
			  SFI_PARAM_STANDARD);
}
#line 100 "bsewave.proc"
 }
static BseErrorType
#line 100 "bsewave.proc"
chunk_get_osc_freq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 103 "bsewave.proc"
{
#line 104 "bsewave.proc"
  
  BseWave *wave = (BseWave*) bse_value_get_object (in_values++);
  guint chunk_index = sfi_value_get_int (in_values++);
  GslWaveChunk *wchunk = NULL;
#line 108 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;
  wchunk = (GslWaveChunk*) sfi_ring_nth_data (wave->wave_chunks, chunk_index);
  if (wchunk)
    sfi_value_set_real (out_values++, wchunk->osc_freq);
  return BSE_ERROR_NONE;
}
/* --- chunk-get-mix-freq --- */
static void
chunk_get_mix_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 116 "bsewave.proc"
 {
#line 118 "bsewave.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("chunk_index", "Chunk Index", "Index of chunk",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_real ("mix_freq", NULL, NULL,
#line 123 "bsewave.proc"
			  0, 0, 44100 * 16 , 10.0,
			  SFI_PARAM_STANDARD);
}
#line 126 "bsewave.proc"
 }
static BseErrorType
#line 126 "bsewave.proc"
chunk_get_mix_freq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 129 "bsewave.proc"
{
#line 130 "bsewave.proc"
  
  BseWave *wave = (BseWave*) bse_value_get_object (in_values++);
  guint chunk_index = sfi_value_get_int (in_values++);
  GslWaveChunk *wchunk = NULL;
#line 134 "bsewave.proc"
  
  if (!BSE_IS_WAVE (wave))
    return BSE_ERROR_PROC_PARAM_INVAL;
  wchunk = (GslWaveChunk*) sfi_ring_nth_data (wave->wave_chunks, chunk_index);
  if (wchunk)
    sfi_value_set_real (out_values++, wchunk->mix_freq);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_load_wave__fill_strings (BseExportStrings *es)
{
  es->blurb = "Load sample chunks from a wave file";
  es->file = "/opt/src/beast/bse/bsewave.proc";
  es->line = 9;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_load_wave = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseWave+load-wave", 
    NULL,
    "/Methods/BseWave/General/Load Wave",
    NULL,
    __enode_load_wave__fill_strings,
  },
  0, load_wave_setup, load_wave_exec, 
};
static void
__enode_n_wave_chunks__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get the number of wave chunks of a wave";
  es->file = "/opt/src/beast/bse/bsewave.proc";
  es->line = 38;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_wave_chunks = {
  { (BseExportNode*) &__enode_load_wave, BSE_EXPORT_NODE_PROC,
    "BseWave+n-wave-chunks", 
    NULL,
    "/Methods/BseWave/General/N Wave Chunks",
    NULL,
    __enode_n_wave_chunks__fill_strings,
  },
  0, n_wave_chunks_setup, n_wave_chunks_exec, 
};
static void
__enode_use_editable__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve an editable sample object for a wave chunk.";
  es->file = "/opt/src/beast/bse/bsewave.proc";
  es->line = 58;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_use_editable = {
  { (BseExportNode*) &__enode_n_wave_chunks, BSE_EXPORT_NODE_PROC,
    "BseWave+use-editable", 
    NULL,
    "/Methods/BseWave/General/Use Editable",
    NULL,
    __enode_use_editable__fill_strings,
  },
  0, use_editable_setup, use_editable_exec, 
};
static void
__enode_chunk_get_osc_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve oscillating frequency of a wave chunk.";
  es->file = "/opt/src/beast/bse/bsewave.proc";
  es->line = 91;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_chunk_get_osc_freq = {
  { (BseExportNode*) &__enode_use_editable, BSE_EXPORT_NODE_PROC,
    "BseWave+chunk-get-osc-freq", 
    NULL,
    "/Methods/BseWave/General/Chunk Get Osc Freq",
    NULL,
    __enode_chunk_get_osc_freq__fill_strings,
  },
  0, chunk_get_osc_freq_setup, chunk_get_osc_freq_exec, 
};
static void
__enode_chunk_get_mix_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve mixing frequency of a wave chunk.";
  es->file = "/opt/src/beast/bse/bsewave.proc";
  es->line = 117;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_chunk_get_mix_freq = {
  { (BseExportNode*) &__enode_chunk_get_osc_freq, BSE_EXPORT_NODE_PROC,
    "BseWave+chunk-get-mix-freq", 
    NULL,
    "/Methods/BseWave/General/Chunk Get Mix Freq",
    NULL,
    __enode_chunk_get_mix_freq__fill_strings,
  },
  0, chunk_get_mix_freq_setup, chunk_get_mix_freq_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsewave_genprc_cc (void)
{
  return (BseExportNode*) &__enode_chunk_get_mix_freq;
}

/*
 * Generated data ends here
 */
