/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* $Id: talloc_util.c 182 2006-05-15 20:57:43Z r3mi $
 *
 * "talloc" utilities.
 * This file is part of djmount.
 *
 * (C) Copyright 2005 Rmi Turboult <r3mi@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <config.h>

#include "talloc_util.h"


/******************************************************************************
 * tpr
 *****************************************************************************/
bool
tpr (char** s, const char* fmt, ...)
{
	if (s == NULL)
		return false; // ---------->

	va_list ap;
	va_start (ap, fmt);
	*s = talloc_vasprintf_append (*s, fmt, ap);
	va_end (ap);
	return (*s != NULL);
}





