/*
 * Copyright (C) 2007-2009 KenD00
 * 
 * This file is part of DumpHD.
 * 
 * DumpHD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package dumphd.util;

/**
 * Interface to be used by classes which want to output text messages.
 * 
 * By giving a specific implementation of this interface to a class its output can be easily directed to a specific destination.
 * 
 * @author KenD00
 */
public interface MessagePrinter {

   /**
    * Prints the message.
    * 
    * @param msg The message to print
    */
   public void print(String msg);
   /**
    * Prints the message followed by a newline.
    * 
    * @param msg The message to print
    */
   public void println(String msg);
   /**
    * Prints a newline.
    */
   public void println();

}
