// This program validates and illustrates the use of the ProtoLFSR class

#include "protoLFSR.h"
#include <stdio.h>

int main(int argc, char* argv[])
{   
    ProtoLFSR::Polynomial poly = ProtoLFSR::PN2047;
    
    // This section validates get next/prev _bit_
    ProtoLFSR pn(poly);
    int k;
    for (k = 0; k < 16; k++)
    {
        UINT32 state = pn.GetState();
        printf("bit[%d] = %d (state = 0x%04x)\n", k, pn.GetNextBit(), state);
    }
    printf("\n");
    k -= 2;
    for (; k >= 0; k--)
    {
       printf("mbit[%d] = %d (state = 0x%04x)\n", k, pn.GetPrevBit(), pn.GetState());
    }
    
    
    //return 0;
    
    // This validates Seek() 
    for (k =0 ; k < (int)pn.GetSize(); k++)
        printf("pn[%d] = 0x%02x\n", k, pn.GetNextByte());
    pn.Seek(-3*8);
    k -= 3;
    printf("seek pn[%d] = = 0x%02x\n", k, pn.GetNextByte());
    k += 2;
    pn.Seek(1*8);
    printf("seek pn[%d] = = 0x%02x\n", k, pn.GetNextByte());
    
    
    //return 0;
    // This validates get next/prev _byte_
    
    // Build a sequence starting with state from first "numBits"
    ProtoLFSR txReg(poly, 0x08);
    char syncBuf[txReg.GetSize()];  // overkill buffer size
    
    printf("txReg[-1] = 0x%02x\n", txReg.GetPrevByte());
    
    txReg.FillBuffer(syncBuf, txReg.GetSize());
    
    ProtoLFSR rxReg(poly, 0x12);
    
    int offset = 3;
    fprintf(stderr, "syncing to 0x%02x...\n", (UINT8)syncBuf[offset]);
    if (!rxReg.Sync(syncBuf+offset, txReg.GetSize() - offset))
        printf("SYNC ERROR\n");
    
    
    fprintf(stderr, "synced state = 0x%04x\n", rxReg.GetState());
    for (unsigned int i = 0; i < txReg.GetSize(); i++)
        printf("txReg[%d] = 0x%02x\n", i, (UINT8)syncBuf[i]);
    
    for (int i = (int)txReg.GetSize()-2; i >= -offset; i--)
        printf("txReg[%d] = 0x%02x\n", i, txReg.GetPrevByte());
    
    printf("\n");
    
    printf("rxReg[-1] = 0x%02x\n", rxReg.GetPrevByte());
    printf("rxReg[-2] = 0x%02x\n", rxReg.GetPrevByte());
    rxReg.GetNextByte();
    for (unsigned int i = 0; i < txReg.GetSize(); i++)
        printf("rxReg[%d] = 0x%02x\n", i, rxReg.GetNextByte());
    
    //return 0;
    
    // This validates the m-sequence auto-correlation properties
    // Create reference buffer with all possible shifts of sequence
    unsigned int numBits = ProtoLFSR::GetPolySize(poly);
    const UINT32 LEN = 0x00000001 << numBits;
    
    char refSeq[LEN][LEN >> 3];
    for (unsigned int i = 0; i < LEN; i++)
    {
        ProtoLFSR lfsr(poly);
        lfsr.Seek(i);
        lfsr.FillBuffer(refSeq[i], LEN >> 3);
    }
    
    unsigned int minMask = 0;
    unsigned int mask = 0x0500;
    unsigned int wtMin = 0xffffffff;
            
    for (unsigned int i = 1; i < LEN - 1; i++)
    {
        unsigned int wt = 0;
        for (unsigned int j = 0; j < LEN>>3; j++)
        {
            unsigned char delta = (unsigned char)(refSeq[0][j] ^ refSeq[i][j]);
            wt += ProtoLFSR::GetWeight(delta);
        }
        printf("shift:%d weight:%u\n", i, wt);
        if (wt < wtMin) 
        {
            wtMin = wt;
            minMask = mask;
        }
    }
    
    printf("wtMin = %d (minMask = 0x%04x)\n", wtMin, minMask);
    
    return 0;
}  // end main()
