#!/usr/bin/python3
# -*- coding: utf-8 -*-

#  Copyright © 2011-2015  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys, os, re
sys.path.insert(0, os.getcwd())

from pybiklib import model
model.Model.load_index()
from pybiklib import pluginlib
pluginlib._ = lambda v: '_({!r})'.format(v)
pluginlib.ngettext = lambda s,p,n: 'ngettext({!r}, {!r}, {})'.format(s,p,n).replace('{','{{').replace('}','}}')

try:
    from send_tracebacks import send_dbus_message
except ImportError:
    send_dbus_message = lambda *args: print(*args)
    

def convert(source_filename, target_filename):
    plugin = pluginlib.PluginFileLoader(source_filename)
    source_filename = os.path.abspath(source_filename)
    with open(target_filename, 'wt', encoding='utf-8') as target:
        translation_comment = None
        dstlineno = 0
        srclineno = 0
        for paragraph in plugin.body:
            path, pathitems, srclineno, translation_comment = paragraph['Path']
            if translation_comment is not None:
                if ':' in translation_comment:
                    translation_key, translation_comment = translation_comment.strip('#').strip().split(':', 1)
                    if translation_key:
                        translation_comment = '# ' + translation_comment.strip()
                    else:
                        translation_comment = None
                        send_dbus_message('Warning', 'Empty translation key', source_filename, srclineno)
                else:
                    translation_key = translation_comment.strip('#').strip().split()
                    if translation_key:
                        translation_key = translation_key[0]
                    else:
                        translation_comment = None
                        send_dbus_message('Warning', 'Empty translation key', source_filename, srclineno)
                if ' ' in translation_key:
                    send_dbus_message('Warning', 'Translation key contains whitespace', source_filename, srclineno)
            if pathitems is not None:
                values = []
                for unused, v in pathitems:
                    if v:
                        if translation_comment and translation_key in re.split(r'\W+', v):
                            values.append(translation_comment)
                        values.append(v)
                while dstlineno < srclineno:
                    target.write('\n')
                    dstlineno += 1
                for v in values:
                    target.write(v)
                    target.write('\n')
                    dstlineno += 1
                translation_comment = None
            else:
                translation_comment = None
                continue
    
def main():
    if len(sys.argv) != 2:
        print('usage: {} scriptfile'.format(os.path.basename(sys.argv[0])))
        return 1
    filename = sys.argv[1]
    convert(filename, filename+'.py')
    
if __name__ == '__main__':
    sys.exit(main())


