/* Declarations for connect.
   Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.

   This file is stolen and modified from Wget.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef CONNECT_H
#define CONNECT_H

#define REFDB_PROTOCOL_VERSION 6 /* version of the client-server dialog protocol */

#define REFDB_MIN_CLIENT_PROTOCOL 6 /* the lowest client protocol version the server will talk to */
#define REFDB_MIN_SERVER_PROTOCOL 6 /* the lowest server protocol version the client will talk to */

#define COMMAND_INBUF_LEN 4096 /* length of buffer for client -> server */
#define OUTBUF_LEN 4096 /* length of buffer for server -> client */

#define PROTOCOL_LENGTH 16 /* maximum length of protocol identifier string */

/* the length of the poly-\0 sequence used to terminate a
   client/server message */
#define TERM_LEN 4

/* whether or not to terminate a client/server message */
#define TERM_YES 1
#define TERM_NO 0

/* the length of the status message at the begin of each message */
#define STATUS_LEN 3

/* client/server message structure */
struct refdb_status {
  int n_status;
  char status[STATUS_LEN+1];
  char msg[64];
};

/* Function declarations */

int iread (int fd, char *buf, int len);
int tread (int fd, char *buf, int len);
int iwrite (int fd, const char *buf, int len);
int tiwrite (int fd, const char *buf, int n_term);
int get_trailz(const char* buf, int numbyte);
int send_status(int fd, int n_status, int n_term);
int read_status(int fd);
const char* get_status_msg(int n_status);
const char* get_status_string(int n_status);

#endif /* CONNECT_H */
