An `impl Trait` captured a higher-ranked lifetime, which is not supported.

Currently, `impl Trait` types are only allowed to capture lifetimes from
their parent items, and not from any `for<'a>` binders in scope.

Erroneous code example:

```compile_fail,E0657
trait BorrowInto<'a> {
    type Target;

    fn borrow_into(&'a self) -> Self::Target;
}

impl<'a> BorrowInto<'a> for () {
    type Target = &'a ();

    fn borrow_into(&'a self) -> Self::Target {
        self
    }
}

fn opaque() -> impl for<'a> BorrowInto<'a, Target = impl Sized + 'a> {
    ()
}
```
