/*
 * Decompiled with CFR 0.152.
 */
package app.authkit.test;

import app.authkit.test.AuthTest;
import glguerin.authkit.Authorization;
import glguerin.authkit.Privilege;
import glguerin.authkit.UnauthorizedException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class TestAttach
extends AuthTest {
    public static void main(String[] stringArray) {
        Authorization authorization = AuthTest.makeAuth(null);
        AuthTest.explain("Authorization: " + authorization.getClass());
        String string = System.getProperty("attach", "");
        int n = new TestAttach().performTest(authorization, string, stringArray);
        AuthTest.explain("TestAttach.main(): done...\n");
        System.exit(n);
    }

    public void testAuth(Authorization authorization, String string, String[] stringArray) {
        AuthTest.explain("TestAttach: can't be run this way");
    }

    private int performTest(Authorization authorization, String string, String[] stringArray) {
        try {
            String string2;
            if (string.equals(".")) {
                authorization.attachPrivileged();
            } else if (string.equals("@")) {
                this.resession(authorization, System.in);
            } else if (string.length() != 0) {
                this.resession(authorization, string);
            } else {
                authorization.isAvailable(Privilege.EMPTY);
            }
            int n = 0;
            while (n < stringArray.length) {
                this.obtain(authorization, stringArray[n]);
                ++n;
            }
            this.spewTo(System.err, "-- TestAttach --", authorization, stringArray);
            int n2 = 1;
            while ((string2 = System.getProperty("out." + n2, "")).length() != 0) {
                AuthTest.explain("   writing: " + string2);
                this.spewTo(string2, "-- TestAttach --", authorization, stringArray);
                ++n2;
            }
        }
        catch (UnauthorizedException unauthorizedException) {
            AuthTest.explain(unauthorizedException);
            return 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AuthTest.explain(illegalArgumentException);
            return 1;
        }
        catch (IOException iOException) {
            AuthTest.explain(iOException);
            return 1;
        }
        return 0;
    }

    private void obtain(Authorization authorization, String string) {
        try {
            authorization.authorize(new Privilege(string), false);
        }
        catch (UnauthorizedException unauthorizedException) {
            // empty catch block
        }
    }

    protected void spewTo(String string, String string2, Authorization authorization, String[] stringArray) {
        PrintStream printStream = null;
        try {
            try {
                printStream = new PrintStream(new FileOutputStream(string, true));
                this.spewTo(printStream, string2, authorization, stringArray);
            }
            catch (IOException iOException) {
                AuthTest.explain(iOException);
                Object var8_7 = null;
                if (printStream != null) {
                    printStream.close();
                }
            }
            Object var8_6 = null;
            if (printStream != null) {
                printStream.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (printStream != null) {
                printStream.close();
            }
            throw throwable;
        }
    }

    protected void spewTo(PrintStream printStream, String string, Authorization authorization, String[] stringArray) {
        printStream.println(string);
        printStream.println(".. java.version: " + System.getProperty("java.version", "???"));
        printStream.println("..... java.home: " + System.getProperty("java.home", "???"));
        printStream.println(".... Session-ID: " + authorization.getPublicIdentifier());
        int n = 0;
        while (n < stringArray.length) {
            Privilege privilege = new Privilege(stringArray[n]);
            printStream.println(this.formatPrivilege("..... Privilege: ", privilege, authorization));
            ++n;
        }
        printStream.flush();
    }
}

