use strict;
#use Test::More tests => 34;
use Test::More qw(no_plan);

use English;
use RoPkg::Exceptions;

use warnings;
use strict;

BEGIN {
  use_ok('RoPkg::DB');
  use_ok('RoPkg::Simba');
  use_ok('RoPkg::Simba::Mirror');
}

my ($dbp, $mirror);

$dbp = new RoPkg::DB();

eval {
  $dbp->Add('dbi:mysql:database=mirrors_db;host=localhost',
      'root',
      '',
      'mirrors');
};
ok(
  !ref($@),
  'connect ok'
);

eval {
  $mirror = new RoPkg::Simba::Mirror();
};
ok(
  Exception::Class->caught('Param::Missing'),
  'new() raise exception'
);

eval {
  $mirror = new RoPkg::Simba::Mirror(dbo => '');
};
ok(
  Exception::Class->caught('Param::Missing'),
  'new(dbo => "") raise exception'
);

eval {
  $mirror = new RoPkg::Simba::Mirror(dbo => '', dbo_method => '');
};
ok(
  Exception::Class->caught('Param::Missing'),
  'new(dbo => "", dbo_method => "") raise exception'
);

eval {
  $mirror = new RoPkg::Simba::Mirror(dbo => $dbp);
};
ok(
  Exception::Class->caught('Param::Missing'),
  'new(dbo => $dbp) raise exception',
);

eval {
  $mirror = new RoPkg::Simba::Mirror(dbo => $dbp, dbo_method => 'db_mirrors');
};
ok(
  !ref($@),
  'new(dbo => $dbp, dbo_method => "db_mirrors") should work'
);

eval {
  $mirror->Name('debian');
  $mirror->Description('debian linux');
  $mirror->Add();
};
ok(
  !ref($@),
  '$mirror->Add() works'
);

eval {
  $mirror->Name('debian');
  $mirror->Load();
  $mirror->Delete();
  $mirror->Name('debian');
  $mirror->Description('Debian GNU/Linux');
  $mirror->Add();
};
ok(
  !ref($@),
  '$mirror->Load(),Delete(),Name(),Description(),Add() works'
);

eval {
  $mirror->Load();
  $mirror->SyncSource('ftp.ro.debian.org');
  $mirror->Update();
};
ok(
  !ref($@),
  'Update() works'
);

eval {
  $mirror->Load();
};
ok(
  $mirror->SyncSource eq 'ftp.ro.debian.org',
  'values ok'
);

$mirror->Delete();
