CREATE TABLE ir_configuration (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    language VARCHAR,
    hostname VARCHAR,
    PRIMARY KEY(id)
);

CREATE TABLE ir_model (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    model VARCHAR NOT NULL,
    name VARCHAR,
    info TEXT,
    module VARCHAR,
    PRIMARY KEY(id)
);

CREATE TABLE ir_model_field (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    model INTEGER,
    name VARCHAR NOT NULL,
    relation VARCHAR,
    field_description VARCHAR,
    ttype VARCHAR,
    help TEXT,
    module VARCHAR,
    "access" BOOL,
    PRIMARY KEY(id),
    FOREIGN KEY (model) REFERENCES ir_model(id) ON DELETE CASCADE
);

CREATE TABLE ir_ui_view (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    model VARCHAR NOT NULL,
    "type" VARCHAR,
    data TEXT NOT NULL,
    field_childs VARCHAR,
    priority INTEGER NOT NULL,
    PRIMARY KEY(id)
);

CREATE TABLE ir_ui_menu (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    parent INTEGER,
    name VARCHAR NOT NULL,
    icon VARCHAR,
    PRIMARY KEY (id),
    FOREIGN KEY (parent) REFERENCES ir_ui_menu (id) ON DELETE SET NULL
);

CREATE TABLE ir_translation (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    lang VARCHAR,
    src TEXT,
    name VARCHAR NOT NULL,
    res_id INTEGER,
    value TEXT,
    "type" VARCHAR,
    module VARCHAR,
    fuzzy BOOLEAN NOT NULL,
    PRIMARY KEY(id)
);

CREATE TABLE ir_lang (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    name VARCHAR NOT NULL,
    code VARCHAR NOT NULL,
    translatable BOOLEAN NOT NULL,
    parent VARCHAR,
    active BOOLEAN NOT NULL,
    direction VARCHAR NOT NULL,
    PRIMARY KEY(id)
);

CREATE TABLE res_user (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    name VARCHAR NOT NULL,
    active BOOLEAN NOT NULL,
    login VARCHAR NOT NULL,
    password VARCHAR,
    PRIMARY KEY(id)
);

ALTER TABLE res_user ADD CONSTRAINT res_user_login_key UNIQUE (login);

INSERT INTO res_user (id, login, password, name, active) VALUES (0, 'root', NULL, 'Root', False);

CREATE TABLE res_group (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    name VARCHAR NOT NULL,
    PRIMARY KEY(id)
);

CREATE TABLE "res_user-res_group" (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    "user" INTEGER NOT NULL,
    "group" INTEGER NOT NULL,
    FOREIGN KEY ("user") REFERENCES res_user (id) ON DELETE CASCADE,
    FOREIGN KEY ("group") REFERENCES res_group (id) ON DELETE CASCADE,
    PRIMARY KEY(id)
);

CREATE TABLE ir_module (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    create_uid INTEGER NOT NULL,
    create_date TIMESTAMP WITHOUT TIME ZONE NOT NULL,
    write_date TIMESTAMP WITHOUT TIME ZONE,
    write_uid INTEGER,
    name VARCHAR NOT NULL,
    state VARCHAR,
    PRIMARY KEY(id),
    FOREIGN KEY (create_uid) REFERENCES res_user ON DELETE SET NULL,
    FOREIGN KEY (write_uid) REFERENCES res_user ON DELETE SET NULL
);

ALTER TABLE ir_module ADD CONSTRAINT ir_module_name_uniq UNIQUE (name);

CREATE TABLE ir_module_dependency (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    create_uid INTEGER NOT NULL,
    create_date TIMESTAMP WITHOUT TIME ZONE NOT NULL,
    write_date TIMESTAMP WITHOUT TIME ZONE,
    write_uid INTEGER,
    name VARCHAR,
    module INTEGER,
    PRIMARY KEY(id),
    FOREIGN KEY (create_uid) REFERENCES res_user ON DELETE SET NULL,
    FOREIGN KEY (write_uid) REFERENCES res_user ON DELETE SET NULL,
    FOREIGN KEY (module) REFERENCES ir_module ON DELETE CASCADE
);

CREATE TABLE ir_cache (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY,
    name VARCHAR NOT NULL,
    "timestamp" TIMESTAMP WITHOUT TIME ZONE
);
