/*
 *
 * XASTIR, Amateur Station Tracking and Information Reporting
 * Copyright (C) 1999,2000  Frank Giannandrea
 * Copyright (C) 2000-2023 The Xastir Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Look at the README for more information on the program.
 */


#ifndef __XASTIR_GPS_H
#define __XASTIR_GPS_H

#include "xastir.h"

#define MAX_GPS_STRING 300

extern char gps_sats[4];
extern int  gps_valid;

extern int gps_stop_now;

extern int gps_data_find(char *gps_line_data, int port);

extern void create_garmin_waypoint(long latitude,long longitude,char *call_sign);

int isGGA(char *gps_line_data);
int isRMC(char *gps_line_data);

#endif  // __XASTIR_GPS_H


