/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright © 2025 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Authors:
 *  - Philip Withnall <pwithnall@gnome.org>
 */

#pragma once

#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <libmalcontent/web-filter.h>

G_BEGIN_DECLS

struct _MctWebFilter
{
  /*< private >*/
  int ref_count;

  uid_t user_id;

  MctWebFilterType filter_type;
  GHashTable *block_lists;  /* (element-type utf8 utf8) (nullable) (owned) */
  char **custom_block_list;  /* (nullable) (owned) */
  size_t custom_block_list_len;

  GHashTable *allow_lists;  /* (element-type utf8 utf8) (nullable) (owned) */
  char **custom_allow_list;  /* (nullable) (owned) */
  size_t custom_allow_list_len;

  gboolean force_safe_search;
};

G_END_DECLS
