! (C) Copyright 2005- ECMWF.
! (C) Copyright 2013- Meteo-France.
! 
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation
! nor does it submit to any jurisdiction.
!

MODULE MPI4TO8_S
#ifdef USE_8_BYTE_WORDS

USE EC_PARKIND, ONLY : JPIM
USE MPL_MPIF

IMPLICIT NONE

PRIVATE :: STATUS8
  INTEGER(KIND=8), DIMENSION(MPI_STATUS_SIZE) :: STATUS8

INTERFACE MPI_GET_COUNT8
  MODULE PROCEDURE MPI_GET_COUNT8_I4, MPI_GET_COUNT8_I4_1
END INTERFACE MPI_GET_COUNT8

INTERFACE MPI_WAITALL8
  MODULE PROCEDURE MPI_WAITALL8_I4, MPI_WAITALL8_I4_1
END INTERFACE MPI_WAITALL8

INTERFACE MPI_WAIT8
  MODULE PROCEDURE MPI_WAIT8_I4, MPI_WAIT8_I4_1
END INTERFACE MPI_WAIT8

PUBLIC

CONTAINS

! ---------------------------------------------------------
SUBROUTINE MPI_ABORT8(COMM, ERRORCODE, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM, ERRORCODE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COMM8, ERRORCODE8, IERROR8

  COMM8 = COMM
  ERRORCODE8 = ERRORCODE

  CALL MPI_ABORT(COMM8, ERRORCODE8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_ABORT8

! ---------------------------------------------------------
SUBROUTINE MPI_BARRIER8(COMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COMM8, IERROR8

  COMM8 = COMM

  CALL MPI_BARRIER(COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_BARRIER8

! ---------------------------------------------------------
SUBROUTINE MPI_BUFFER_DETACH8(BUFFER_ADDR, SZ, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    BUFFER_ADDR
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    SZ, IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUFFER_ADDR8
  INTEGER(KIND=8) :: &
    SZ8, IERROR8

  ALLOCATE(BUFFER_ADDR8(SIZE(BUFFER_ADDR)))

  CALL MPI_BUFFER_DETACH(BUFFER_ADDR8, SZ8, IERROR8)

  BUFFER_ADDR = BUFFER_ADDR8
  SZ = SZ8
  IERROR = IERROR8

  DEALLOCATE(BUFFER_ADDR8)

END SUBROUTINE MPI_BUFFER_DETACH8

! ---------------------------------------------------------
SUBROUTINE MPI_BUFFER_ATTACH8(BUFFER_ADDR, SZ, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    BUFFER_ADDR
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SZ
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUFFER_ADDR8
  INTEGER(KIND=8) :: &
    SZ8, IERROR8

  ALLOCATE(BUFFER_ADDR8(SIZE(BUFFER_ADDR)))

  BUFFER_ADDR8 = BUFFER_ADDR
  SZ8 = SZ

  CALL MPI_BUFFER_ATTACH(BUFFER_ADDR8, SZ8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(BUFFER_ADDR8)

END SUBROUTINE MPI_BUFFER_ATTACH8

! ---------------------------------------------------------
SUBROUTINE MPI_CART_COORDS8(COMM, RANK, MAXDIMS, COORDS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM, RANK, MAXDIMS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: COORDS

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: COORDS8
  INTEGER(KIND=8) :: &
    COMM8, RANK8, MAXDIMS8, IERROR8

  ALLOCATE(COORDS8(SIZE(COORDS)))

  COMM8 = COMM
  RANK8 = RANK
  MAXDIMS8 = MAXDIMS

  CALL MPI_CART_COORDS(COMM8, RANK8, MAXDIMS8, COORDS8, IERROR8)

  COORDS = COORDS8
  IERROR = IERROR8

  DEALLOCATE(COORDS8)

END SUBROUTINE MPI_CART_COORDS8

! ---------------------------------------------------------
SUBROUTINE MPI_CART_CREATE8(COMM_OLD, NDIMS, DIMS, PERIODS, REORDER, COMM_CART, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM_OLD, NDIMS, DIMS(:)
  LOGICAL(KIND=JPIM), INTENT(IN) :: &
    PERIODS(:), REORDER
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    COMM_CART, IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DIMS8
  INTEGER(KIND=8) :: &
    COMM_OLD8, NDIMS8, COMM_CART8, IERROR8
  LOGICAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    PERIODS8
  LOGICAL(KIND=8) :: &
    REORDER8

  ALLOCATE(DIMS8(SIZE(DIMS)))
  ALLOCATE(PERIODS8(SIZE(PERIODS)))

  COMM_OLD8 = COMM_OLD
  NDIMS8 = NDIMS
  DIMS8 = DIMS
  PERIODS8 = PERIODS
  REORDER8 = REORDER

  CALL MPI_CART_CREATE(COMM_OLD8, NDIMS8, DIMS8, PERIODS8, REORDER8, COMM_CART8, IERROR8)

  COMM_CART =  COMM_CART8
  IERROR  = IERROR8

  DEALLOCATE(DIMS8)
  DEALLOCATE(PERIODS8)

END SUBROUTINE MPI_CART_CREATE8

! ---------------------------------------------------------
SUBROUTINE MPI_CART_RANK8(COMM, COORDS, RANK, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM
  INTEGER(KIND=JPIM), INTENT(IN), DIMENSION(:) :: COORDS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    RANK, IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: COORDS8
  INTEGER(KIND=8) :: &
    COMM8, RANK8, IERROR8

  ALLOCATE(COORDS8(SIZE(COORDS)))

  COMM8 = COMM
  COORDS8 = COORDS

  CALL MPI_CART_RANK(COMM8, COORDS8, RANK8, IERROR8)

  RANK = RANK8
  IERROR = IERROR8

  DEALLOCATE(COORDS8)

END SUBROUTINE MPI_CART_RANK8

! ---------------------------------------------------------
SUBROUTINE MPI_CART_SUB8(COMM, REMAIN_DIMS, NEWCOMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM
  LOGICAL(KIND=JPIM), INTENT(IN), DIMENSION(:) :: &
    REMAIN_DIMS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    NEWCOMM, IERROR

  INTEGER(KIND=8) :: &
    COMM8, NEWCOMM8, IERROR8
  LOGICAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    REMAIN_DIMS8

  ALLOCATE(REMAIN_DIMS8(SIZE(REMAIN_DIMS)))

  COMM8 = COMM
  REMAIN_DIMS8 = REMAIN_DIMS

  CALL MPI_CART_SUB(COMM8, REMAIN_DIMS8, NEWCOMM8, IERROR8)

  NEWCOMM = NEWCOMM8
  IERROR = IERROR8

  DEALLOCATE(REMAIN_DIMS8)

END SUBROUTINE MPI_CART_SUB8

! ---------------------------------------------------------
SUBROUTINE MPI_COMM_CREATE8(COMM, GROUP, NEWCOMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM, GROUP
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    NEWCOMM, IERROR

  INTEGER(KIND=8) :: &
    COMM8, GROUP8, NEWCOMM8, IERROR8

  COMM8 = COMM
  GROUP8 = GROUP

  CALL MPI_COMM_CREATE(COMM8, GROUP8, NEWCOMM8, IERROR8)

  NEWCOMM = NEWCOMM8
  IERROR = IERROR8

END SUBROUTINE MPI_COMM_CREATE8

! ---------------------------------------------------------
SUBROUTINE MPI_COMM_GROUP8(COMM, GROUP, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    GROUP, IERROR

  INTEGER(KIND=8) :: &
    COMM8, GROUP8, IERROR8

  COMM8 = COMM

  CALL MPI_COMM_GROUP(COMM8, GROUP8, IERROR8)

  GROUP = GROUP8
  IERROR = IERROR8

END SUBROUTINE MPI_COMM_GROUP8

! ---------------------------------------------------------
SUBROUTINE MPI_COMM_RANK8(COMM, RANK, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    RANK, IERROR

  INTEGER(KIND=8) :: &
    COMM8, RANK8, IERROR8

  COMM8 = COMM

  CALL MPI_COMM_RANK(COMM8, RANK8, IERROR8)

  RANK = RANK8
  IERROR = IERROR8

END SUBROUTINE MPI_COMM_RANK8

! ---------------------------------------------------------
SUBROUTINE MPI_COMM_SIZE8(COMM, SIZE, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    SIZE, IERROR

  INTEGER(KIND=8) :: &
    COMM8, SIZE8, IERROR8

  COMM8 = COMM

  CALL MPI_COMM_SIZE(COMM8, SIZE8, IERROR8)

  SIZE = SIZE8
  IERROR = IERROR8

END SUBROUTINE MPI_COMM_SIZE8

! ---------------------------------------------------------
SUBROUTINE MPI_COMM_SPLIT8(COMM, COLOR, KEY, NEWCOMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM, COLOR, KEY
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    NEWCOMM, IERROR

  INTEGER(KIND=8) :: &
    COMM8, COLOR8, KEY8, NEWCOMM8, IERROR8

  COMM8 = COMM
  COLOR8 = COLOR
  KEY8 = KEY

  CALL MPI_COMM_SPLIT(COMM8, COLOR8, KEY8, NEWCOMM8, IERROR8)

  NEWCOMM = NEWCOMM8
  IERROR = IERROR8

END SUBROUTINE MPI_COMM_SPLIT8

! ---------------------------------------------------------
SUBROUTINE MPI_ERROR_STRING8(ERRORCODE, STRING, RESULTLEN, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    ERRORCODE
  CHARACTER(LEN=*), INTENT(OUT) :: &
    STRING
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    RESULTLEN, IERROR

  INTEGER(KIND=8) :: &
    ERRORCODE8, RESULTLEN8, IERROR8

  ERRORCODE8 = ERRORCODE

  CALL MPI_ERROR_STRING(ERRORCODE8, STRING, RESULTLEN8, IERROR8)

  RESULTLEN = RESULTLEN8
  IERROR = IERROR8

END SUBROUTINE MPI_ERROR_STRING8

! ---------------------------------------------------------
SUBROUTINE MPI_FILE_CLOSE8(FH, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    FH8, IERROR8

  FH8 = FH

  CALL MPI_FILE_CLOSE(FH8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_FILE_CLOSE8

! ---------------------------------------------------------
SUBROUTINE MPI_FILE_OPEN8(COMM, FILENAME, AMODE, INFO, FH, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COMM, AMODE, INFO
  CHARACTER(LEN=*), INTENT(IN) :: &
    FILENAME
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    FH, IERROR

  INTEGER(KIND=8) :: &
    COMM8, AMODE8, INFO8, FH8, IERROR8

  COMM8 = COMM
  AMODE8 = AMODE
  INFO8 = INFO

  CALL MPI_FILE_OPEN(COMM8, FILENAME, AMODE8, INFO8, FH8, IERROR8)

  FH = FH8
  IERROR = IERROR8

END SUBROUTINE MPI_FILE_OPEN8

! ---------------------------------------------------------
SUBROUTINE MPI_FINALIZE8(IERROR)

  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    IERROR8

  CALL MPI_FINALIZE(IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_FINALIZE8

! ---------------------------------------------------------
SUBROUTINE MPI_GET_COUNT8_I4(STATUS, DATATYPE, COUNT, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    STATUS(:), DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    COUNT, IERROR

  INTEGER(KIND=8) :: &
    DATATYPE8, COUNT8, IERROR8

  STATUS8 = STATUS
  DATATYPE8 = DATATYPE

  CALL MPI_GET_COUNT(STATUS8, DATATYPE8, COUNT8, IERROR8)

  COUNT = COUNT8
  IERROR = IERROR8

END SUBROUTINE MPI_GET_COUNT8_I4

! ---------------------------------------------------------
SUBROUTINE MPI_GET_COUNT8_I4_1(STATUS, DATATYPE, COUNT, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    STATUS, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    COUNT, IERROR

  INTEGER(KIND=8) :: &
    DATATYPE8, COUNT8, IERROR8, STATUS8

  STATUS8 = STATUS
  DATATYPE8 = DATATYPE

  CALL MPI_GET_COUNT(STATUS8, DATATYPE8, COUNT8, IERROR8)

  COUNT = COUNT8
  IERROR = IERROR8

END SUBROUTINE MPI_GET_COUNT8_I4_1

! ---------------------------------------------------------
SUBROUTINE MPI_GROUP_INCL8(GROUP1, N, RANKS, NEWGROUP, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    GROUP1, N, RANKS(:)
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    NEWGROUP, IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RANKS8
  INTEGER(KIND=8) :: &
    GROUP18, N8, NEWGROUP8, IERROR8

  ALLOCATE(RANKS8(SIZE(RANKS)))

  GROUP18 = GROUP1
  N8 = N
  RANKS8 = RANKS

  CALL MPI_GROUP_INCL(GROUP18, N8, RANKS8, NEWGROUP8, IERROR8)

  NEWGROUP = NEWGROUP8
  IERROR = IERROR8

  DEALLOCATE(RANKS8)

END SUBROUTINE MPI_GROUP_INCL8

! ---------------------------------------------------------
SUBROUTINE MPI_INIT8(IERROR)

  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    IERROR8

  CALL MPI_INIT(IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_INIT8

! ---------------------------------------------------------
SUBROUTINE MPI_INITIALIZED8(FLAG, IERROR)

  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    FLAG
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    FLAG8
  INTEGER(KIND=8) :: &
    IERROR8


  CALL MPI_INITIALIZED(FLAG8, IERROR8)

  FLAG = FLAG8
  IERROR = IERROR8

END SUBROUTINE MPI_INITIALIZED8

! ---------------------------------------------------------
SUBROUTINE MPI_IPROBE8(SOURCE, TAG, COMM, FLAG, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    FLAG
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8) :: &
    SOURCE8, TAG8, COMM8, IERROR8
  INTEGER(KIND=8) :: &
    FLAG8

  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IPROBE(SOURCE8, TAG8, COMM8, FLAG8, STATUS8, IERROR8)

  FLAG = FLAG8
  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_IPROBE8

! ---------------------------------------------------------
SUBROUTINE MPI_PROBE8(SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8) :: &
    SOURCE8, TAG8, COMM8, IERROR8

  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_PROBE(SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_PROBE8

! ---------------------------------------------------------
SUBROUTINE MPI_WAIT8_I4(REQUEST, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(INOUT) :: &
    REQUEST
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8) :: &
    REQUEST8, IERROR8
  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: STATUS8

  ALLOCATE(STATUS8(SIZE(STATUS)))

  REQUEST8 = REQUEST

  CALL MPI_WAIT(REQUEST8, STATUS8, IERROR8)

  REQUEST = REQUEST8
  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(STATUS8)

END SUBROUTINE MPI_WAIT8_I4

! ---------------------------------------------------------
SUBROUTINE MPI_WAIT8_I4_1(REQUEST, STATUS, IERROR)

  INTEGER(KIND=JPIM) :: &
    REQUEST
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS, IERROR

  INTEGER(KIND=8) :: &
    REQUEST8, IERROR8, STATUS8

  REQUEST8 = REQUEST

  CALL MPI_WAIT(REQUEST8, STATUS8, IERROR8)

  REQUEST = REQUEST8
  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_WAIT8_I4_1

! ---------------------------------------------------------
SUBROUTINE MPI_WAITALL8_I4(COUNT, ARRAY_OF_REQUESTS, ARRAY_OF_STATUSES, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(INOUT) :: &
    ARRAY_OF_REQUESTS
  INTEGER(KIND=JPIM), DIMENSION(:,:), INTENT(OUT) :: &
    ARRAY_OF_STATUSES
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    ARRAY_OF_REQUESTS8
  INTEGER(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    ARRAY_OF_STATUSES8
  INTEGER(KIND=8) :: &
    COUNT8, IERROR8

  INTEGER :: N

  COUNT8 = COUNT

  ALLOCATE(ARRAY_OF_REQUESTS8(SIZE(ARRAY_OF_REQUESTS)))
  N = SIZE(ARRAY_OF_STATUSES) / MPI_STATUS_SIZE
  ALLOCATE(ARRAY_OF_STATUSES8(MPI_STATUS_SIZE,N))

  ARRAY_OF_REQUESTS8 = ARRAY_OF_REQUESTS

  CALL MPI_WAITALL(COUNT8, ARRAY_OF_REQUESTS8, ARRAY_OF_STATUSES8, IERROR8)

  ARRAY_OF_REQUESTS = ARRAY_OF_REQUESTS8
  ARRAY_OF_STATUSES = ARRAY_OF_STATUSES8

  DEALLOCATE(ARRAY_OF_REQUESTS8)
  DEALLOCATE(ARRAY_OF_STATUSES8)

  IERROR = IERROR8

END SUBROUTINE MPI_WAITALL8_I4

! ---------------------------------------------------------
SUBROUTINE MPI_WAITALL8_I4_1(COUNT, ARRAY_OF_REQUESTS, ARRAY_OF_STATUSES, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT
  INTEGER(KIND=JPIM) :: &
    ARRAY_OF_REQUESTS
  INTEGER(KIND=JPIM), DIMENSION(:,:), INTENT(OUT) :: &
    ARRAY_OF_STATUSES
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    ARRAY_OF_REQUESTS8
  INTEGER(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    ARRAY_OF_STATUSES8
  INTEGER(KIND=8) :: &
    COUNT8, IERROR8

  INTEGER :: N

  COUNT8 = COUNT

  N = SIZE(ARRAY_OF_STATUSES) / MPI_STATUS_SIZE
  ALLOCATE(ARRAY_OF_STATUSES8(MPI_STATUS_SIZE,N))

  ARRAY_OF_REQUESTS8 = ARRAY_OF_REQUESTS

  CALL MPI_WAITALL(COUNT8, ARRAY_OF_REQUESTS8, ARRAY_OF_STATUSES8, IERROR8)

  ARRAY_OF_REQUESTS = ARRAY_OF_REQUESTS8
  ARRAY_OF_STATUSES = ARRAY_OF_STATUSES8

  DEALLOCATE(ARRAY_OF_STATUSES8)

  IERROR = IERROR8

END SUBROUTINE MPI_WAITALL8_I4_1

#endif
END MODULE MPI4TO8_S
