% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-axis-stack.R
\name{guide_axis_stack}
\alias{guide_axis_stack}
\title{Stacked axis guides}
\usage{
guide_axis_stack(
  first = "axis",
  ...,
  title = waiver(),
  theme = NULL,
  spacing = NULL,
  order = 0,
  position = waiver()
)
}
\arguments{
\item{first}{A position guide given as one of the following:
\itemize{
\item A string, for example \code{"axis"}.
\item A call to a guide function, for example \code{guide_axis()}.
}}

\item{...}{Additional guides to stack given in the same manner as \code{first}.}

\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[=waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[=labs]{labs()}} is used for the title.}

\item{theme}{A \code{\link[=theme]{theme}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide partially overrides, and is combined with, the plot's theme.}

\item{spacing}{A \code{\link[=unit]{unit()}} objects that determines how far separate guides are
spaced apart.}

\item{order}{A positive \code{integer} of length 1 that specifies the order of
this guide among multiple guides. This controls in which order guides are
merged if there are multiple guides for the same position. If 0 (default),
the order is determined by a secret algorithm.}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}
}
\description{
This guide can stack other position guides that represent position scales,
like those created with \link[=scale_x_continuous]{scale_(x|y)_continuous()} and
\link[=scale_x_discrete]{scale_(x|y)_discrete()}.
}
\details{
The \code{first} guide will be placed closest to the panel and any subsequent
guides provided through \code{...} will follow in the given order.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  theme(axis.line = element_line())

# A normal axis first, then a capped axis
p + guides(x = guide_axis_stack("axis", guide_axis(cap = "both")))
}
