% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk.R
\name{ps_fs_stat}
\alias{ps_fs_stat}
\title{File status}
\usage{
ps_fs_stat(paths, follow = TRUE)
}
\arguments{
\item{paths}{Paths to files, directories, devices, etc. They must
exist. They are expanded using \code{\link[base:path.expand]{base::path.expand()}}.}

\item{follow}{Whether to follow symbolic links. If \code{FALSE} it returns
information on the links themselves.}
}
\value{
Data frame with one row for each path in \code{paths}. Columns:
\itemize{
\item \code{path}: Expanded \code{paths}.
\item \code{dev_major}: Major device ID of the device the path resides on.
\item \code{dev_minor}: Minor device ID of the device the path resodes on.
\item \code{inode}: Inode number.
\item \code{mode}: File type and mode (permissions). It is easier to use the
\code{type} and \code{permissions} columns.
\item \code{type}: File type, character. One of
regular file, directory, character device, block device, FIFO, symbolic link, socket.
\item \code{permissions}: Permissions, numeric code in an integer column.
\item \code{nlink}: Number of hard links.
\item \code{uid}: User id of owner.
\item \code{gid}: Group id of owner.
\item \code{rdev_major}: If the path is a device, its major device id,
otherwise \code{NA_integer_}.
\item \code{rdev_minor}: IF the path is a device, its minor device id,
otherwise \code{NA_integer_}.
\item \code{size}: File size in bytes.
\item \code{block_size}: Block size for filesystem I/O.
\item \code{blocks}: Number of 512B blocks allocated.
\item \code{access_time}: Time of last access.
\item \code{modification_time}: Time of last modification.
\item \code{change_time}: Time of last status change.
}
}
\description{
This function is currently not implemented on Windows.
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check() && ps_os_type()[["POSIX"]]) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_fs_stat(c(".", tempdir()))
\dontshow{\}) # examplesIf}
}
