/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.sparql.vocabulary ;

import org.apache.jena.rdf.model.* ;

/**
 * Vocabulary definitions from test-manifest-1_1.ttl 
 * @author Auto-generated by schemagen on 24 May 2012 18:37 
 */
public class TestManifest_11 {

    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>CSV Test</p> */
    public static final Resource CSVResultFormatTest = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#CSVResultFormatTest" );
    
    /** <p>A type of test specifically for syntax testing for SPARQL 1.1.</p> */
    public static final Resource NegativeSyntaxTest11 = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#NegativeSyntaxTest11" );
    
    /** <p>A type of test specifically for syntax testing of SPARQL Update. Syntax tests 
     *  are not required to have an associated result, only an action. Negative syntax 
     *  tests are tests of which the result should be a parser error.</p>
     */
    public static final Resource NegativeUpdateSyntaxTest11 = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#NegativeUpdateSyntaxTest11" );
    
    /** <p>A type of test specifically for syntax testing for SPARQL 1.1.</p> */
    public static final Resource PositiveSyntaxTest11 = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#PositiveSyntaxTest11" );
    
    /** <p>A type of test specifically for syntax testing of SPARQL Update. Syntax tests 
     *  are not required to have an associated result, only an action.</p>
     */
    public static final Resource PositiveUpdateSyntaxTest11 = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#PositiveUpdateSyntaxTest11" );
    
    /** <p>A type of test specifically for query evaluation testing. Query evaluation 
     *  tests are required to have an associated input dataset, a query, and an expected 
     *  output dataset.</p>
     */
    public static final Resource UpdateEvaluationTest = m_model.createResource( "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#UpdateEvaluationTest" );
    }

