/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */

#ifndef DDR4FW
#define DDR4FW

#define PHY_GEN2_MAX_IMAGE_SIZE		32768
#define PHY_GEN2_IMEM_ADDR		0x50000
#define PHY_GEN2_DMEM_ADDR		0x54000

struct ddr4u1d {
	uint8_t  reserved00;
	uint8_t  msg_misc;
	uint16_t pmu_revision;
	uint8_t  pstate;
	uint8_t  pll_bypass_en;
	uint16_t dramfreq;
	uint8_t  dfi_freq_ratio;
	uint8_t  bpznres_val;
	uint8_t  phy_odt_impedance;
	uint8_t  phy_drv_impedance;
	uint8_t  phy_vref;
	uint8_t  dram_type;
	uint8_t  disabled_dbyte;
	uint8_t  enabled_dqs;
	uint8_t  cs_present;
	uint8_t  cs_present_d0;
	uint8_t  cs_present_d1;
	uint8_t  addr_mirror;
	uint8_t  cs_test_fail;
	uint8_t  phy_cfg;
	uint16_t sequence_ctrl;
	uint8_t  hdt_ctrl;
	uint8_t  reserved19[0x1B - 0x19];
	uint8_t  share2dvref_result;
	uint8_t  reserved1c[0x22 - 0x1c];
	uint16_t phy_config_override;
	uint8_t  dfimrlmargin;
	int8_t   cdd_rr_3_2;
	int8_t   cdd_rr_3_1;
	int8_t   cdd_rr_3_0;
	int8_t   cdd_rr_2_3;
	int8_t   cdd_rr_2_1;
	int8_t   cdd_rr_2_0;
	int8_t   cdd_rr_1_3;
	int8_t   cdd_rr_1_2;
	int8_t   cdd_rr_1_0;
	int8_t   cdd_rr_0_3;
	int8_t   cdd_rr_0_2;
	int8_t   cdd_rr_0_1;
	int8_t   cdd_ww_3_2;
	int8_t   cdd_ww_3_1;
	int8_t   cdd_ww_3_0;
	int8_t   cdd_ww_2_3;
	int8_t   cdd_ww_2_1;
	int8_t   cdd_ww_2_0;
	int8_t   cdd_ww_1_3;
	int8_t   cdd_ww_1_2;
	int8_t   cdd_ww_1_0;
	int8_t   cdd_ww_0_3;
	int8_t   cdd_ww_0_2;
	int8_t   cdd_ww_0_1;
	int8_t   cdd_rw_3_3;
	int8_t   cdd_rw_3_2;
	int8_t   cdd_rw_3_1;
	int8_t   cdd_rw_3_0;
	int8_t   cdd_rw_2_3;
	int8_t   cdd_rw_2_2;
	int8_t   cdd_rw_2_1;
	int8_t   cdd_rw_2_0;
	int8_t   cdd_rw_1_3;
	int8_t   cdd_rw_1_2;
	int8_t   cdd_rw_1_1;
	int8_t   cdd_rw_1_0;
	int8_t   cdd_rw_0_3;
	int8_t   cdd_rw_0_2;
	int8_t   cdd_rw_0_1;
	int8_t   cdd_rw_0_0;
	int8_t   cdd_wr_3_3;
	int8_t   cdd_wr_3_2;
	int8_t   cdd_wr_3_1;
	int8_t   cdd_wr_3_0;
	int8_t   cdd_wr_2_3;
	int8_t   cdd_wr_2_2;
	int8_t   cdd_wr_2_1;
	int8_t   cdd_wr_2_0;
	int8_t   cdd_wr_1_3;
	int8_t   cdd_wr_1_2;
	int8_t   cdd_wr_1_1;
	int8_t   cdd_wr_1_0;
	int8_t   cdd_wr_0_3;
	int8_t   cdd_wr_0_2;
	int8_t   cdd_wr_0_1;
	int8_t   cdd_wr_0_0;
	uint8_t  reserved5d;
	uint16_t mr0;
	uint16_t mr1;
	uint16_t mr2;
	uint16_t mr3;
	uint16_t mr4;
	uint16_t mr5;
	uint16_t mr6;
	uint8_t  x16present;
	uint8_t  cs_setup_gddec;
	uint16_t rtt_nom_wr_park0;
	uint16_t rtt_nom_wr_park1;
	uint16_t rtt_nom_wr_park2;
	uint16_t rtt_nom_wr_park3;
	uint16_t rtt_nom_wr_park4;
	uint16_t rtt_nom_wr_park5;
	uint16_t rtt_nom_wr_park6;
	uint16_t rtt_nom_wr_park7;
	uint8_t  acsm_odt_ctrl0;
	uint8_t  acsm_odt_ctrl1;
	uint8_t  acsm_odt_ctrl2;
	uint8_t  acsm_odt_ctrl3;
	uint8_t  acsm_odt_ctrl4;
	uint8_t  acsm_odt_ctrl5;
	uint8_t  acsm_odt_ctrl6;
	uint8_t  acsm_odt_ctrl7;
	uint8_t  vref_dq_r0nib0;
	uint8_t  vref_dq_r0nib1;
	uint8_t  vref_dq_r0nib2;
	uint8_t  vref_dq_r0nib3;
	uint8_t  vref_dq_r0nib4;
	uint8_t  vref_dq_r0nib5;
	uint8_t  vref_dq_r0nib6;
	uint8_t  vref_dq_r0nib7;
	uint8_t  vref_dq_r0nib8;
	uint8_t  vref_dq_r0nib9;
	uint8_t  vref_dq_r0nib10;
	uint8_t  vref_dq_r0nib11;
	uint8_t  vref_dq_r0nib12;
	uint8_t  vref_dq_r0nib13;
	uint8_t  vref_dq_r0nib14;
	uint8_t  vref_dq_r0nib15;
	uint8_t  vref_dq_r0nib16;
	uint8_t  vref_dq_r0nib17;
	uint8_t  vref_dq_r0nib18;
	uint8_t  vref_dq_r0nib19;
	uint8_t  vref_dq_r1nib0;
	uint8_t  vref_dq_r1nib1;
	uint8_t  vref_dq_r1nib2;
	uint8_t  vref_dq_r1nib3;
	uint8_t  vref_dq_r1nib4;
	uint8_t  vref_dq_r1nib5;
	uint8_t  vref_dq_r1nib6;
	uint8_t  vref_dq_r1nib7;
	uint8_t  vref_dq_r1nib8;
	uint8_t  vref_dq_r1nib9;
	uint8_t  vref_dq_r1nib10;
	uint8_t  vref_dq_r1nib11;
	uint8_t  vref_dq_r1nib12;
	uint8_t  vref_dq_r1nib13;
	uint8_t  vref_dq_r1nib14;
	uint8_t  vref_dq_r1nib15;
	uint8_t  vref_dq_r1nib16;
	uint8_t  vref_dq_r1nib17;
	uint8_t  vref_dq_r1nib18;
	uint8_t  vref_dq_r1nib19;
	uint8_t  vref_dq_r2nib0;
	uint8_t  vref_dq_r2nib1;
	uint8_t  vref_dq_r2nib2;
	uint8_t  vref_dq_r2nib3;
	uint8_t  vref_dq_r2nib4;
	uint8_t  vref_dq_r2nib5;
	uint8_t  vref_dq_r2nib6;
	uint8_t  vref_dq_r2nib7;
	uint8_t  vref_dq_r2nib8;
	uint8_t  vref_dq_r2nib9;
	uint8_t  vref_dq_r2nib10;
	uint8_t  vref_dq_r2nib11;
	uint8_t  vref_dq_r2nib12;
	uint8_t  vref_dq_r2nib13;
	uint8_t  vref_dq_r2nib14;
	uint8_t  vref_dq_r2nib15;
	uint8_t  vref_dq_r2nib16;
	uint8_t  vref_dq_r2nib17;
	uint8_t  vref_dq_r2nib18;
	uint8_t  vref_dq_r2nib19;
	uint8_t  vref_dq_r3nib0;
	uint8_t  vref_dq_r3nib1;
	uint8_t  vref_dq_r3nib2;
	uint8_t  vref_dq_r3nib3;
	uint8_t  vref_dq_r3nib4;
	uint8_t  vref_dq_r3nib5;
	uint8_t  vref_dq_r3nib6;
	uint8_t  vref_dq_r3nib7;
	uint8_t  vref_dq_r3nib8;
	uint8_t  vref_dq_r3nib9;
	uint8_t  vref_dq_r3nib10;
	uint8_t  vref_dq_r3nib11;
	uint8_t  vref_dq_r3nib12;
	uint8_t  vref_dq_r3nib13;
	uint8_t  vref_dq_r3nib14;
	uint8_t  vref_dq_r3nib15;
	uint8_t  vref_dq_r3nib16;
	uint8_t  vref_dq_r3nib17;
	uint8_t  vref_dq_r3nib18;
	uint8_t  vref_dq_r3nib19;
	uint8_t  reserved_d6[0x3f6 - 0xd6];
	uint16_t alt_cas_l;
	uint8_t  alt_wcas_l;
	uint8_t  d4misc;
} __packed;

struct ddr4u2d {
	uint8_t  reserved00;
	uint8_t  msg_misc;
	uint16_t pmu_revision;
	uint8_t  pstate;
	uint8_t  pll_bypass_en;
	uint16_t dramfreq;
	uint8_t  dfi_freq_ratio;
	uint8_t  bpznres_val;
	uint8_t  phy_odt_impedance;
	uint8_t  phy_drv_impedance;
	uint8_t  phy_vref;
	uint8_t  dram_type;
	uint8_t  disabled_dbyte;
	uint8_t  enabled_dqs;
	uint8_t  cs_present;
	uint8_t  cs_present_d0;
	uint8_t  cs_present_d1;
	uint8_t  addr_mirror;
	uint8_t  cs_test_fail;
	uint8_t  phy_cfg;
	uint16_t sequence_ctrl;
	uint8_t  hdt_ctrl;
	uint8_t  rx2d_train_opt;
	uint8_t  tx2d_train_opt;
	uint8_t  share2dvref_result;
	uint8_t  delay_weight2d;
	uint8_t  voltage_weight2d;
	uint8_t  reserved1e[0x22 - 0x1e];
	uint16_t phy_config_override;
	uint8_t  dfimrlmargin;
	uint8_t  r0_rx_clk_dly_margin;
	uint8_t  r0_vref_dac_margin;
	uint8_t  r0_tx_dq_dly_margin;
	uint8_t  r0_device_vref_margin;
	uint8_t  reserved29[0x33 - 0x29];
	uint8_t  r1_rx_clk_dly_margin;
	uint8_t  r1_vref_dac_margin;
	uint8_t  r1_tx_dq_dly_margin;
	uint8_t  r1_device_vref_margin;
	uint8_t  reserved37[0x41 - 0x37];
	uint8_t  r2_rx_clk_dly_margin;
	uint8_t  r2_vref_dac_margin;
	uint8_t  r2_tx_dq_dly_margin;
	uint8_t  r2_device_vref_margin;
	uint8_t  reserved45[0x4f - 0x45];
	uint8_t  r3_rx_clk_dly_margin;
	uint8_t  r3_vref_dac_margin;
	uint8_t  r3_tx_dq_dly_margin;
	uint8_t  r3_device_vref_margin;
	uint8_t  reserved53[0x5e - 0x53];
	uint16_t mr0;
	uint16_t mr1;
	uint16_t mr2;
	uint16_t mr3;
	uint16_t mr4;
	uint16_t mr5;
	uint16_t mr6;
	uint8_t  x16present;
	uint8_t  cs_setup_gddec;
	uint16_t rtt_nom_wr_park0;
	uint16_t rtt_nom_wr_park1;
	uint16_t rtt_nom_wr_park2;
	uint16_t rtt_nom_wr_park3;
	uint16_t rtt_nom_wr_park4;
	uint16_t rtt_nom_wr_park5;
	uint16_t rtt_nom_wr_park6;
	uint16_t rtt_nom_wr_park7;
	uint8_t  acsm_odt_ctrl0;
	uint8_t  acsm_odt_ctrl1;
	uint8_t  acsm_odt_ctrl2;
	uint8_t  acsm_odt_ctrl3;
	uint8_t  acsm_odt_ctrl4;
	uint8_t  acsm_odt_ctrl5;
	uint8_t  acsm_odt_ctrl6;
	uint8_t  acsm_odt_ctrl7;
	uint8_t  vref_dq_r0nib0;
	uint8_t  vref_dq_r0nib1;
	uint8_t  vref_dq_r0nib2;
	uint8_t  vref_dq_r0nib3;
	uint8_t  vref_dq_r0nib4;
	uint8_t  vref_dq_r0nib5;
	uint8_t  vref_dq_r0nib6;
	uint8_t  vref_dq_r0nib7;
	uint8_t  vref_dq_r0nib8;
	uint8_t  vref_dq_r0nib9;
	uint8_t  vref_dq_r0nib10;
	uint8_t  vref_dq_r0nib11;
	uint8_t  vref_dq_r0nib12;
	uint8_t  vref_dq_r0nib13;
	uint8_t  vref_dq_r0nib14;
	uint8_t  vref_dq_r0nib15;
	uint8_t  vref_dq_r0nib16;
	uint8_t  vref_dq_r0nib17;
	uint8_t  vref_dq_r0nib18;
	uint8_t  vref_dq_r0nib19;
	uint8_t  vref_dq_r1nib0;
	uint8_t  vref_dq_r1nib1;
	uint8_t  vref_dq_r1nib2;
	uint8_t  vref_dq_r1nib3;
	uint8_t  vref_dq_r1nib4;
	uint8_t  vref_dq_r1nib5;
	uint8_t  vref_dq_r1nib6;
	uint8_t  vref_dq_r1nib7;
	uint8_t  vref_dq_r1nib8;
	uint8_t  vref_dq_r1nib9;
	uint8_t  vref_dq_r1nib10;
	uint8_t  vref_dq_r1nib11;
	uint8_t  vref_dq_r1nib12;
	uint8_t  vref_dq_r1nib13;
	uint8_t  vref_dq_r1nib14;
	uint8_t  vref_dq_r1nib15;
	uint8_t  vref_dq_r1nib16;
	uint8_t  vref_dq_r1nib17;
	uint8_t  vref_dq_r1nib18;
	uint8_t  vref_dq_r1nib19;
	uint8_t  vref_dq_r2nib0;
	uint8_t  vref_dq_r2nib1;
	uint8_t  vref_dq_r2nib2;
	uint8_t  vref_dq_r2nib3;
	uint8_t  vref_dq_r2nib4;
	uint8_t  vref_dq_r2nib5;
	uint8_t  vref_dq_r2nib6;
	uint8_t  vref_dq_r2nib7;
	uint8_t  vref_dq_r2nib8;
	uint8_t  vref_dq_r2nib9;
	uint8_t  vref_dq_r2nib10;
	uint8_t  vref_dq_r2nib11;
	uint8_t  vref_dq_r2nib12;
	uint8_t  vref_dq_r2nib13;
	uint8_t  vref_dq_r2nib14;
	uint8_t  vref_dq_r2nib15;
	uint8_t  vref_dq_r2nib16;
	uint8_t  vref_dq_r2nib17;
	uint8_t  vref_dq_r2nib18;
	uint8_t  vref_dq_r2nib19;
	uint8_t  vref_dq_r3nib0;
	uint8_t  vref_dq_r3nib1;
	uint8_t  vref_dq_r3nib2;
	uint8_t  vref_dq_r3nib3;
	uint8_t  vref_dq_r3nib4;
	uint8_t  vref_dq_r3nib5;
	uint8_t  vref_dq_r3nib6;
	uint8_t  vref_dq_r3nib7;
	uint8_t  vref_dq_r3nib8;
	uint8_t  vref_dq_r3nib9;
	uint8_t  vref_dq_r3nib10;
	uint8_t  vref_dq_r3nib11;
	uint8_t  vref_dq_r3nib12;
	uint8_t  vref_dq_r3nib13;
	uint8_t  vref_dq_r3nib14;
	uint8_t  vref_dq_r3nib15;
	uint8_t  vref_dq_r3nib16;
	uint8_t  vref_dq_r3nib17;
	uint8_t  vref_dq_r3nib18;
	uint8_t  vref_dq_r3nib19;
	uint8_t  reserved_d6[0x3f6 - 0xd6];
	uint16_t alt_cas_l;
	uint8_t  alt_wcas_l;
	uint8_t  d4misc;
} __packed;

struct ddr4r1d {
	uint8_t  reserved00;
	uint8_t  msg_misc;
	uint16_t pmu_revision;
	uint8_t  pstate;
	uint8_t  pll_bypass_en;
	uint16_t dramfreq;
	uint8_t  dfi_freq_ratio;
	uint8_t  bpznres_val;
	uint8_t  phy_odt_impedance;
	uint8_t  phy_drv_impedance;
	uint8_t  phy_vref;
	uint8_t  dram_type;
	uint8_t  disabled_dbyte;
	uint8_t  enabled_dqs;
	uint8_t  cs_present;
	uint8_t  cs_present_d0;
	uint8_t  cs_present_d1;
	uint8_t  addr_mirror;
	uint8_t  cs_test_fail;
	uint8_t  phy_cfg;
	uint16_t sequence_ctrl;
	uint8_t  hdt_ctrl;
	uint8_t  reserved19[0x22 - 0x19];
	uint16_t phy_config_override;
	uint8_t  dfimrlmargin;
	int8_t   cdd_rr_3_2;
	int8_t   cdd_rr_3_1;
	int8_t   cdd_rr_3_0;
	int8_t   cdd_rr_2_3;
	int8_t   cdd_rr_2_1;
	int8_t   cdd_rr_2_0;
	int8_t   cdd_rr_1_3;
	int8_t   cdd_rr_1_2;
	int8_t   cdd_rr_1_0;
	int8_t   cdd_rr_0_3;
	int8_t   cdd_rr_0_2;
	int8_t   cdd_rr_0_1;
	int8_t   cdd_ww_3_2;
	int8_t   cdd_ww_3_1;
	int8_t   cdd_ww_3_0;
	int8_t   cdd_ww_2_3;
	int8_t   cdd_ww_2_1;
	int8_t   cdd_ww_2_0;
	int8_t   cdd_ww_1_3;
	int8_t   cdd_ww_1_2;
	int8_t   cdd_ww_1_0;
	int8_t   cdd_ww_0_3;
	int8_t   cdd_ww_0_2;
	int8_t   cdd_ww_0_1;
	int8_t   cdd_rw_3_3;
	int8_t   cdd_rw_3_2;
	int8_t   cdd_rw_3_1;
	int8_t   cdd_rw_3_0;
	int8_t   cdd_rw_2_3;
	int8_t   cdd_rw_2_2;
	int8_t   cdd_rw_2_1;
	int8_t   cdd_rw_2_0;
	int8_t   cdd_rw_1_3;
	int8_t   cdd_rw_1_2;
	int8_t   cdd_rw_1_1;
	int8_t   cdd_rw_1_0;
	int8_t   cdd_rw_0_3;
	int8_t   cdd_rw_0_2;
	int8_t   cdd_rw_0_1;
	int8_t   cdd_rw_0_0;
	int8_t   cdd_wr_3_3;
	int8_t   cdd_wr_3_2;
	int8_t   cdd_wr_3_1;
	int8_t   cdd_wr_3_0;
	int8_t   cdd_wr_2_3;
	int8_t   cdd_wr_2_2;
	int8_t   cdd_wr_2_1;
	int8_t   cdd_wr_2_0;
	int8_t   cdd_wr_1_3;
	int8_t   cdd_wr_1_2;
	int8_t   cdd_wr_1_1;
	int8_t   cdd_wr_1_0;
	int8_t   cdd_wr_0_3;
	int8_t   cdd_wr_0_2;
	int8_t   cdd_wr_0_1;
	int8_t   cdd_wr_0_0;
	uint8_t  reserved5d;
	uint16_t mr0;
	uint16_t mr1;
	uint16_t mr2;
	uint16_t mr3;
	uint16_t mr4;
	uint16_t mr5;
	uint16_t mr6;
	uint8_t  x16present;
	uint8_t  cs_setup_gddec;
	uint16_t rtt_nom_wr_park0;
	uint16_t rtt_nom_wr_park1;
	uint16_t rtt_nom_wr_park2;
	uint16_t rtt_nom_wr_park3;
	uint16_t rtt_nom_wr_park4;
	uint16_t rtt_nom_wr_park5;
	uint16_t rtt_nom_wr_park6;
	uint16_t rtt_nom_wr_park7;
	uint8_t  acsm_odt_ctrl0;
	uint8_t  acsm_odt_ctrl1;
	uint8_t  acsm_odt_ctrl2;
	uint8_t  acsm_odt_ctrl3;
	uint8_t  acsm_odt_ctrl4;
	uint8_t  acsm_odt_ctrl5;
	uint8_t  acsm_odt_ctrl6;
	uint8_t  acsm_odt_ctrl7;
	uint8_t  vref_dq_r0nib0;
	uint8_t  vref_dq_r0nib1;
	uint8_t  vref_dq_r0nib2;
	uint8_t  vref_dq_r0nib3;
	uint8_t  vref_dq_r0nib4;
	uint8_t  vref_dq_r0nib5;
	uint8_t  vref_dq_r0nib6;
	uint8_t  vref_dq_r0nib7;
	uint8_t  vref_dq_r0nib8;
	uint8_t  vref_dq_r0nib9;
	uint8_t  vref_dq_r0nib10;
	uint8_t  vref_dq_r0nib11;
	uint8_t  vref_dq_r0nib12;
	uint8_t  vref_dq_r0nib13;
	uint8_t  vref_dq_r0nib14;
	uint8_t  vref_dq_r0nib15;
	uint8_t  vref_dq_r0nib16;
	uint8_t  vref_dq_r0nib17;
	uint8_t  vref_dq_r0nib18;
	uint8_t  vref_dq_r0nib19;
	uint8_t  vref_dq_r1nib0;
	uint8_t  vref_dq_r1nib1;
	uint8_t  vref_dq_r1nib2;
	uint8_t  vref_dq_r1nib3;
	uint8_t  vref_dq_r1nib4;
	uint8_t  vref_dq_r1nib5;
	uint8_t  vref_dq_r1nib6;
	uint8_t  vref_dq_r1nib7;
	uint8_t  vref_dq_r1nib8;
	uint8_t  vref_dq_r1nib9;
	uint8_t  vref_dq_r1nib10;
	uint8_t  vref_dq_r1nib11;
	uint8_t  vref_dq_r1nib12;
	uint8_t  vref_dq_r1nib13;
	uint8_t  vref_dq_r1nib14;
	uint8_t  vref_dq_r1nib15;
	uint8_t  vref_dq_r1nib16;
	uint8_t  vref_dq_r1nib17;
	uint8_t  vref_dq_r1nib18;
	uint8_t  vref_dq_r1nib19;
	uint8_t  vref_dq_r2nib0;
	uint8_t  vref_dq_r2nib1;
	uint8_t  vref_dq_r2nib2;
	uint8_t  vref_dq_r2nib3;
	uint8_t  vref_dq_r2nib4;
	uint8_t  vref_dq_r2nib5;
	uint8_t  vref_dq_r2nib6;
	uint8_t  vref_dq_r2nib7;
	uint8_t  vref_dq_r2nib8;
	uint8_t  vref_dq_r2nib9;
	uint8_t  vref_dq_r2nib10;
	uint8_t  vref_dq_r2nib11;
	uint8_t  vref_dq_r2nib12;
	uint8_t  vref_dq_r2nib13;
	uint8_t  vref_dq_r2nib14;
	uint8_t  vref_dq_r2nib15;
	uint8_t  vref_dq_r2nib16;
	uint8_t  vref_dq_r2nib17;
	uint8_t  vref_dq_r2nib18;
	uint8_t  vref_dq_r2nib19;
	uint8_t  vref_dq_r3nib0;
	uint8_t  vref_dq_r3nib1;
	uint8_t  vref_dq_r3nib2;
	uint8_t  vref_dq_r3nib3;
	uint8_t  vref_dq_r3nib4;
	uint8_t  vref_dq_r3nib5;
	uint8_t  vref_dq_r3nib6;
	uint8_t  vref_dq_r3nib7;
	uint8_t  vref_dq_r3nib8;
	uint8_t  vref_dq_r3nib9;
	uint8_t  vref_dq_r3nib10;
	uint8_t  vref_dq_r3nib11;
	uint8_t  vref_dq_r3nib12;
	uint8_t  vref_dq_r3nib13;
	uint8_t  vref_dq_r3nib14;
	uint8_t  vref_dq_r3nib15;
	uint8_t  vref_dq_r3nib16;
	uint8_t  vref_dq_r3nib17;
	uint8_t  vref_dq_r3nib18;
	uint8_t  vref_dq_r3nib19;
	uint8_t  f0rc00_d0;
	uint8_t  f0rc01_d0;
	uint8_t  f0rc02_d0;
	uint8_t  f0rc03_d0;
	uint8_t  f0rc04_d0;
	uint8_t  f0rc05_d0;
	uint8_t  f0rc06_d0;
	uint8_t  f0rc07_d0;
	uint8_t  f0rc08_d0;
	uint8_t  f0rc09_d0;
	uint8_t  f0rc0a_d0;
	uint8_t  f0rc0b_d0;
	uint8_t  f0rc0c_d0;
	uint8_t  f0rc0d_d0;
	uint8_t  f0rc0e_d0;
	uint8_t  f0rc0f_d0;
	uint8_t  f0rc1x_d0;
	uint8_t  f0rc2x_d0;
	uint8_t  f0rc3x_d0;
	uint8_t  f0rc4x_d0;
	uint8_t  f0rc5x_d0;
	uint8_t  f0rc6x_d0;
	uint8_t  f0rc7x_d0;
	uint8_t  f0rc8x_d0;
	uint8_t  f0rc9x_d0;
	uint8_t  f0rcax_d0;
	uint8_t  f0rcbx_d0;
	uint8_t  f1rc00_d0;
	uint8_t  f1rc01_d0;
	uint8_t  f1rc02_d0;
	uint8_t  f1rc03_d0;
	uint8_t  f1rc04_d0;
	uint8_t  f1rc05_d0;
	uint8_t  f1rc06_d0;
	uint8_t  f1rc07_d0;
	uint8_t  f1rc08_d0;
	uint8_t  f1rc09_d0;
	uint8_t  f1rc0a_d0;
	uint8_t  f1rc0b_d0;
	uint8_t  f1rc0c_d0;
	uint8_t  f1rc0d_d0;
	uint8_t  f1rc0e_d0;
	uint8_t  f1rc0f_d0;
	uint8_t  f1rc1x_d0;
	uint8_t  f1rc2x_d0;
	uint8_t  f1rc3x_d0;
	uint8_t  f1rc4x_d0;
	uint8_t  f1rc5x_d0;
	uint8_t  f1rc6x_d0;
	uint8_t  f1rc7x_d0;
	uint8_t  f1rc8x_d0;
	uint8_t  f1rc9x_d0;
	uint8_t  f1rcax_d0;
	uint8_t  f1rcbx_d0;
	uint8_t  f0rc00_d1;
	uint8_t  f0rc01_d1;
	uint8_t  f0rc02_d1;
	uint8_t  f0rc03_d1;
	uint8_t  f0rc04_d1;
	uint8_t  f0rc05_d1;
	uint8_t  f0rc06_d1;
	uint8_t  f0rc07_d1;
	uint8_t  f0rc08_d1;
	uint8_t  f0rc09_d1;
	uint8_t  f0rc0a_d1;
	uint8_t  f0rc0b_d1;
	uint8_t  f0rc0c_d1;
	uint8_t  f0rc0d_d1;
	uint8_t  f0rc0e_d1;
	uint8_t  f0rc0f_d1;
	uint8_t  f0rc1x_d1;
	uint8_t  f0rc2x_d1;
	uint8_t  f0rc3x_d1;
	uint8_t  f0rc4x_d1;
	uint8_t  f0rc5x_d1;
	uint8_t  f0rc6x_d1;
	uint8_t  f0rc7x_d1;
	uint8_t  f0rc8x_d1;
	uint8_t  f0rc9x_d1;
	uint8_t  f0rcax_d1;
	uint8_t  f0rcbx_d1;
	uint8_t  f1rc00_d1;
	uint8_t  f1rc01_d1;
	uint8_t  f1rc02_d1;
	uint8_t  f1rc03_d1;
	uint8_t  f1rc04_d1;
	uint8_t  f1rc05_d1;
	uint8_t  f1rc06_d1;
	uint8_t  f1rc07_d1;
	uint8_t  f1rc08_d1;
	uint8_t  f1rc09_d1;
	uint8_t  f1rc0a_d1;
	uint8_t  f1rc0b_d1;
	uint8_t  f1rc0c_d1;
	uint8_t  f1rc0d_d1;
	uint8_t  f1rc0e_d1;
	uint8_t  f1rc0f_d1;
	uint8_t  f1rc1x_d1;
	uint8_t  f1rc2x_d1;
	uint8_t  f1rc3x_d1;
	uint8_t  f1rc4x_d1;
	uint8_t  f1rc5x_d1;
	uint8_t  f1rc6x_d1;
	uint8_t  f1rc7x_d1;
	uint8_t  f1rc8x_d1;
	uint8_t  f1rc9x_d1;
	uint8_t  f1rcax_d1;
	uint8_t  f1rcbx_d1;
	uint8_t  reserved142[0x3f6 - 0x142];
	uint16_t alt_cas_l;
	uint8_t  alt_wcas_l;
	uint8_t  d4misc;
} __packed;

struct ddr4r2d {
	uint8_t  reserved00;
	uint8_t  msg_misc;
	uint16_t pmu_revision;
	uint8_t  pstate;
	uint8_t  pll_bypass_en;
	uint16_t dramfreq;
	uint8_t  dfi_freq_ratio;
	uint8_t  bpznres_val;
	uint8_t  phy_odt_impedance;
	uint8_t  phy_drv_impedance;
	uint8_t  phy_vref;
	uint8_t  dram_type;
	uint8_t  disabled_dbyte;
	uint8_t  enabled_dqs;
	uint8_t  cs_present;
	uint8_t  cs_present_d0;
	uint8_t  cs_present_d1;
	uint8_t  addr_mirror;
	uint8_t  cs_test_fail;
	uint8_t  phy_cfg;
	uint16_t sequence_ctrl;
	uint8_t  hdt_ctrl;
	uint8_t  rx2d_train_opt;
	uint8_t  tx2d_train_opt;
	uint8_t  share2dvref_result;
	uint8_t  delay_weight2d;
	uint8_t  voltage_weight2d;
	uint8_t  reserved1e[0x22-0x1e];
	uint16_t phy_config_override;
	uint8_t  dfimrlmargin;
	uint8_t  r0_rx_clk_dly_margin;
	uint8_t  r0_vref_dac_margin;
	uint8_t  r0_tx_dq_dly_margin;
	uint8_t  r0_device_vref_margin;
	uint8_t  reserved29[0x33-0x29];
	uint8_t  r1_rx_clk_dly_margin;
	uint8_t  r1_vref_dac_margin;
	uint8_t  r1_tx_dq_dly_margin;
	uint8_t  r1_device_vref_margin;
	uint8_t  reserved37[0x41-0x37];
	uint8_t  r2_rx_clk_dly_margin;
	uint8_t  r2_vref_dac_margin;
	uint8_t  r2_tx_dq_dly_margin;
	uint8_t  r2_device_vref_margin;
	uint8_t  reserved45[0x4f - 0x45];
	uint8_t  r3_rx_clk_dly_margin;
	uint8_t  r3_vref_dac_margin;
	uint8_t  r3_tx_dq_dly_margin;
	uint8_t  r3_device_vref_margin;
	uint8_t  reserved53[0x5e - 0x53];
	uint16_t mr0;
	uint16_t mr1;
	uint16_t mr2;
	uint16_t mr3;
	uint16_t mr4;
	uint16_t mr5;
	uint16_t mr6;
	uint8_t  x16present;
	uint8_t  cs_setup_gddec;
	uint16_t rtt_nom_wr_park0;
	uint16_t rtt_nom_wr_park1;
	uint16_t rtt_nom_wr_park2;
	uint16_t rtt_nom_wr_park3;
	uint16_t rtt_nom_wr_park4;
	uint16_t rtt_nom_wr_park5;
	uint16_t rtt_nom_wr_park6;
	uint16_t rtt_nom_wr_park7;
	uint8_t  acsm_odt_ctrl0;
	uint8_t  acsm_odt_ctrl1;
	uint8_t  acsm_odt_ctrl2;
	uint8_t  acsm_odt_ctrl3;
	uint8_t  acsm_odt_ctrl4;
	uint8_t  acsm_odt_ctrl5;
	uint8_t  acsm_odt_ctrl6;
	uint8_t  acsm_odt_ctrl7;
	uint8_t  vref_dq_r0nib0;
	uint8_t  vref_dq_r0nib1;
	uint8_t  vref_dq_r0nib2;
	uint8_t  vref_dq_r0nib3;
	uint8_t  vref_dq_r0nib4;
	uint8_t  vref_dq_r0nib5;
	uint8_t  vref_dq_r0nib6;
	uint8_t  vref_dq_r0nib7;
	uint8_t  vref_dq_r0nib8;
	uint8_t  vref_dq_r0nib9;
	uint8_t  vref_dq_r0nib10;
	uint8_t  vref_dq_r0nib11;
	uint8_t  vref_dq_r0nib12;
	uint8_t  vref_dq_r0nib13;
	uint8_t  vref_dq_r0nib14;
	uint8_t  vref_dq_r0nib15;
	uint8_t  vref_dq_r0nib16;
	uint8_t  vref_dq_r0nib17;
	uint8_t  vref_dq_r0nib18;
	uint8_t  vref_dq_r0nib19;
	uint8_t  vref_dq_r1nib0;
	uint8_t  vref_dq_r1nib1;
	uint8_t  vref_dq_r1nib2;
	uint8_t  vref_dq_r1nib3;
	uint8_t  vref_dq_r1nib4;
	uint8_t  vref_dq_r1nib5;
	uint8_t  vref_dq_r1nib6;
	uint8_t  vref_dq_r1nib7;
	uint8_t  vref_dq_r1nib8;
	uint8_t  vref_dq_r1nib9;
	uint8_t  vref_dq_r1nib10;
	uint8_t  vref_dq_r1nib11;
	uint8_t  vref_dq_r1nib12;
	uint8_t  vref_dq_r1nib13;
	uint8_t  vref_dq_r1nib14;
	uint8_t  vref_dq_r1nib15;
	uint8_t  vref_dq_r1nib16;
	uint8_t  vref_dq_r1nib17;
	uint8_t  vref_dq_r1nib18;
	uint8_t  vref_dq_r1nib19;
	uint8_t  vref_dq_r2nib0;
	uint8_t  vref_dq_r2nib1;
	uint8_t  vref_dq_r2nib2;
	uint8_t  vref_dq_r2nib3;
	uint8_t  vref_dq_r2nib4;
	uint8_t  vref_dq_r2nib5;
	uint8_t  vref_dq_r2nib6;
	uint8_t  vref_dq_r2nib7;
	uint8_t  vref_dq_r2nib8;
	uint8_t  vref_dq_r2nib9;
	uint8_t  vref_dq_r2nib10;
	uint8_t  vref_dq_r2nib11;
	uint8_t  vref_dq_r2nib12;
	uint8_t  vref_dq_r2nib13;
	uint8_t  vref_dq_r2nib14;
	uint8_t  vref_dq_r2nib15;
	uint8_t  vref_dq_r2nib16;
	uint8_t  vref_dq_r2nib17;
	uint8_t  vref_dq_r2nib18;
	uint8_t  vref_dq_r2nib19;
	uint8_t  vref_dq_r3nib0;
	uint8_t  vref_dq_r3nib1;
	uint8_t  vref_dq_r3nib2;
	uint8_t  vref_dq_r3nib3;
	uint8_t  vref_dq_r3nib4;
	uint8_t  vref_dq_r3nib5;
	uint8_t  vref_dq_r3nib6;
	uint8_t  vref_dq_r3nib7;
	uint8_t  vref_dq_r3nib8;
	uint8_t  vref_dq_r3nib9;
	uint8_t  vref_dq_r3nib10;
	uint8_t  vref_dq_r3nib11;
	uint8_t  vref_dq_r3nib12;
	uint8_t  vref_dq_r3nib13;
	uint8_t  vref_dq_r3nib14;
	uint8_t  vref_dq_r3nib15;
	uint8_t  vref_dq_r3nib16;
	uint8_t  vref_dq_r3nib17;
	uint8_t  vref_dq_r3nib18;
	uint8_t  vref_dq_r3nib19;
	uint8_t  f0rc00_d0;
	uint8_t  f0rc01_d0;
	uint8_t  f0rc02_d0;
	uint8_t  f0rc03_d0;
	uint8_t  f0rc04_d0;
	uint8_t  f0rc05_d0;
	uint8_t  f0rc06_d0;
	uint8_t  f0rc07_d0;
	uint8_t  f0rc08_d0;
	uint8_t  f0rc09_d0;
	uint8_t  f0rc0a_d0;
	uint8_t  f0rc0b_d0;
	uint8_t  f0rc0c_d0;
	uint8_t  f0rc0d_d0;
	uint8_t  f0rc0e_d0;
	uint8_t  f0rc0f_d0;
	uint8_t  f0rc1x_d0;
	uint8_t  f0rc2x_d0;
	uint8_t  f0rc3x_d0;
	uint8_t  f0rc4x_d0;
	uint8_t  f0rc5x_d0;
	uint8_t  f0rc6x_d0;
	uint8_t  f0rc7x_d0;
	uint8_t  f0rc8x_d0;
	uint8_t  f0rc9x_d0;
	uint8_t  f0rcax_d0;
	uint8_t  f0rcbx_d0;
	uint8_t  f1rc00_d0;
	uint8_t  f1rc01_d0;
	uint8_t  f1rc02_d0;
	uint8_t  f1rc03_d0;
	uint8_t  f1rc04_d0;
	uint8_t  f1rc05_d0;
	uint8_t  f1rc06_d0;
	uint8_t  f1rc07_d0;
	uint8_t  f1rc08_d0;
	uint8_t  f1rc09_d0;
	uint8_t  f1rc0a_d0;
	uint8_t  f1rc0b_d0;
	uint8_t  f1rc0c_d0;
	uint8_t  f1rc0d_d0;
	uint8_t  f1rc0e_d0;
	uint8_t  f1rc0f_d0;
	uint8_t  f1rc1x_d0;
	uint8_t  f1rc2x_d0;
	uint8_t  f1rc3x_d0;
	uint8_t  f1rc4x_d0;
	uint8_t  f1rc5x_d0;
	uint8_t  f1rc6x_d0;
	uint8_t  f1rc7x_d0;
	uint8_t  f1rc8x_d0;
	uint8_t  f1rc9x_d0;
	uint8_t  f1rcax_d0;
	uint8_t  f1rcbx_d0;
	uint8_t  f0rc00_d1;
	uint8_t  f0rc01_d1;
	uint8_t  f0rc02_d1;
	uint8_t  f0rc03_d1;
	uint8_t  f0rc04_d1;
	uint8_t  f0rc05_d1;
	uint8_t  f0rc06_d1;
	uint8_t  f0rc07_d1;
	uint8_t  f0rc08_d1;
	uint8_t  f0rc09_d1;
	uint8_t  f0rc0a_d1;
	uint8_t  f0rc0b_d1;
	uint8_t  f0rc0c_d1;
	uint8_t  f0rc0d_d1;
	uint8_t  f0rc0e_d1;
	uint8_t  f0rc0f_d1;
	uint8_t  f0rc1x_d1;
	uint8_t  f0rc2x_d1;
	uint8_t  f0rc3x_d1;
	uint8_t  f0rc4x_d1;
	uint8_t  f0rc5x_d1;
	uint8_t  f0rc6x_d1;
	uint8_t  f0rc7x_d1;
	uint8_t  f0rc8x_d1;
	uint8_t  f0rc9x_d1;
	uint8_t  f0rcax_d1;
	uint8_t  f0rcbx_d1;
	uint8_t  f1rc00_d1;
	uint8_t  f1rc01_d1;
	uint8_t  f1rc02_d1;
	uint8_t  f1rc03_d1;
	uint8_t  f1rc04_d1;
	uint8_t  f1rc05_d1;
	uint8_t  f1rc06_d1;
	uint8_t  f1rc07_d1;
	uint8_t  f1rc08_d1;
	uint8_t  f1rc09_d1;
	uint8_t  f1rc0a_d1;
	uint8_t  f1rc0b_d1;
	uint8_t  f1rc0c_d1;
	uint8_t  f1rc0d_d1;
	uint8_t  f1rc0e_d1;
	uint8_t  f1rc0f_d1;
	uint8_t  f1rc1x_d1;
	uint8_t  f1rc2x_d1;
	uint8_t  f1rc3x_d1;
	uint8_t  f1rc4x_d1;
	uint8_t  f1rc5x_d1;
	uint8_t  f1rc6x_d1;
	uint8_t  f1rc7x_d1;
	uint8_t  f1rc8x_d1;
	uint8_t  f1rc9x_d1;
	uint8_t  f1rcax_d1;
	uint8_t  f1rcbx_d1;
	uint8_t  reserved142[0x3f6 - 0x142];
	uint16_t alt_cas_l;
	uint8_t  alt_wcas_l;
	uint8_t  d4misc;
} __packed;

struct ddr4lr1d {
	uint8_t  reserved00;
	uint8_t  msg_misc;
	uint16_t pmu_revision;
	uint8_t  pstate;
	uint8_t  pll_bypass_en;
	uint16_t dramfreq;
	uint8_t  dfi_freq_ratio;
	uint8_t  bpznres_val;
	uint8_t  phy_odt_impedance;
	uint8_t  phy_drv_impedance;
	uint8_t  phy_vref;
	uint8_t  dram_type;
	uint8_t  disabled_dbyte;
	uint8_t  enabled_dqs;
	uint8_t  cs_present;
	uint8_t  cs_present_d0;
	uint8_t  cs_present_d1;
	uint8_t  addr_mirror;
	uint8_t  cs_test_fail;
	uint8_t  phy_cfg;
	uint16_t sequence_ctrl;
	uint8_t  hdt_ctrl;
	uint8_t  reserved19[0x22 - 0x19];
	uint16_t phy_config_override;
	uint8_t  dfimrlmargin;
	int8_t   cdd_rr_3_2;
	int8_t   cdd_rr_3_1;
	int8_t   cdd_rr_3_0;
	int8_t   cdd_rr_2_3;
	int8_t   cdd_rr_2_1;
	int8_t   cdd_rr_2_0;
	int8_t   cdd_rr_1_3;
	int8_t   cdd_rr_1_2;
	int8_t   cdd_rr_1_0;
	int8_t   cdd_rr_0_3;
	int8_t   cdd_rr_0_2;
	int8_t   cdd_rr_0_1;
	int8_t   cdd_ww_3_2;
	int8_t   cdd_ww_3_1;
	int8_t   cdd_ww_3_0;
	int8_t   cdd_ww_2_3;
	int8_t   cdd_ww_2_1;
	int8_t   cdd_ww_2_0;
	int8_t   cdd_ww_1_3;
	int8_t   cdd_ww_1_2;
	int8_t   cdd_ww_1_0;
	int8_t   cdd_ww_0_3;
	int8_t   cdd_ww_0_2;
	int8_t   cdd_ww_0_1;
	int8_t   cdd_rw_3_3;
	int8_t   cdd_rw_3_2;
	int8_t   cdd_rw_3_1;
	int8_t   cdd_rw_3_0;
	int8_t   cdd_rw_2_3;
	int8_t   cdd_rw_2_2;
	int8_t   cdd_rw_2_1;
	int8_t   cdd_rw_2_0;
	int8_t   cdd_rw_1_3;
	int8_t   cdd_rw_1_2;
	int8_t   cdd_rw_1_1;
	int8_t   cdd_rw_1_0;
	int8_t   cdd_rw_0_3;
	int8_t   cdd_rw_0_2;
	int8_t   cdd_rw_0_1;
	int8_t   cdd_rw_0_0;
	int8_t   cdd_wr_3_3;
	int8_t   cdd_wr_3_2;
	int8_t   cdd_wr_3_1;
	int8_t   cdd_wr_3_0;
	int8_t   cdd_wr_2_3;
	int8_t   cdd_wr_2_2;
	int8_t   cdd_wr_2_1;
	int8_t   cdd_wr_2_0;
	int8_t   cdd_wr_1_3;
	int8_t   cdd_wr_1_2;
	int8_t   cdd_wr_1_1;
	int8_t   cdd_wr_1_0;
	int8_t   cdd_wr_0_3;
	int8_t   cdd_wr_0_2;
	int8_t   cdd_wr_0_1;
	int8_t   cdd_wr_0_0;
	uint8_t  reserved5d;
	uint16_t mr0;
	uint16_t mr1;
	uint16_t mr2;
	uint16_t mr3;
	uint16_t mr4;
	uint16_t mr5;
	uint16_t mr6;
	uint8_t  x16present;
	uint8_t  cs_setup_gddec;
	uint16_t rtt_nom_wr_park0;
	uint16_t rtt_nom_wr_park1;
	uint16_t rtt_nom_wr_park2;
	uint16_t rtt_nom_wr_park3;
	uint16_t rtt_nom_wr_park4;
	uint16_t rtt_nom_wr_park5;
	uint16_t rtt_nom_wr_park6;
	uint16_t rtt_nom_wr_park7;
	uint8_t  acsm_odt_ctrl0;
	uint8_t  acsm_odt_ctrl1;
	uint8_t  acsm_odt_ctrl2;
	uint8_t  acsm_odt_ctrl3;
	uint8_t  acsm_odt_ctrl4;
	uint8_t  acsm_odt_ctrl5;
	uint8_t  acsm_odt_ctrl6;
	uint8_t  acsm_odt_ctrl7;
	uint8_t  vref_dq_r0nib0;
	uint8_t  vref_dq_r0nib1;
	uint8_t  vref_dq_r0nib2;
	uint8_t  vref_dq_r0nib3;
	uint8_t  vref_dq_r0nib4;
	uint8_t  vref_dq_r0nib5;
	uint8_t  vref_dq_r0nib6;
	uint8_t  vref_dq_r0nib7;
	uint8_t  vref_dq_r0nib8;
	uint8_t  vref_dq_r0nib9;
	uint8_t  vref_dq_r0nib10;
	uint8_t  vref_dq_r0nib11;
	uint8_t  vref_dq_r0nib12;
	uint8_t  vref_dq_r0nib13;
	uint8_t  vref_dq_r0nib14;
	uint8_t  vref_dq_r0nib15;
	uint8_t  vref_dq_r0nib16;
	uint8_t  vref_dq_r0nib17;
	uint8_t  vref_dq_r0nib18;
	uint8_t  vref_dq_r0nib19;
	uint8_t  vref_dq_r1nib0;
	uint8_t  vref_dq_r1nib1;
	uint8_t  vref_dq_r1nib2;
	uint8_t  vref_dq_r1nib3;
	uint8_t  vref_dq_r1nib4;
	uint8_t  vref_dq_r1nib5;
	uint8_t  vref_dq_r1nib6;
	uint8_t  vref_dq_r1nib7;
	uint8_t  vref_dq_r1nib8;
	uint8_t  vref_dq_r1nib9;
	uint8_t  vref_dq_r1nib10;
	uint8_t  vref_dq_r1nib11;
	uint8_t  vref_dq_r1nib12;
	uint8_t  vref_dq_r1nib13;
	uint8_t  vref_dq_r1nib14;
	uint8_t  vref_dq_r1nib15;
	uint8_t  vref_dq_r1nib16;
	uint8_t  vref_dq_r1nib17;
	uint8_t  vref_dq_r1nib18;
	uint8_t  vref_dq_r1nib19;
	uint8_t  vref_dq_r2nib0;
	uint8_t  vref_dq_r2nib1;
	uint8_t  vref_dq_r2nib2;
	uint8_t  vref_dq_r2nib3;
	uint8_t  vref_dq_r2nib4;
	uint8_t  vref_dq_r2nib5;
	uint8_t  vref_dq_r2nib6;
	uint8_t  vref_dq_r2nib7;
	uint8_t  vref_dq_r2nib8;
	uint8_t  vref_dq_r2nib9;
	uint8_t  vref_dq_r2nib10;
	uint8_t  vref_dq_r2nib11;
	uint8_t  vref_dq_r2nib12;
	uint8_t  vref_dq_r2nib13;
	uint8_t  vref_dq_r2nib14;
	uint8_t  vref_dq_r2nib15;
	uint8_t  vref_dq_r2nib16;
	uint8_t  vref_dq_r2nib17;
	uint8_t  vref_dq_r2nib18;
	uint8_t  vref_dq_r2nib19;
	uint8_t  vref_dq_r3nib0;
	uint8_t  vref_dq_r3nib1;
	uint8_t  vref_dq_r3nib2;
	uint8_t  vref_dq_r3nib3;
	uint8_t  vref_dq_r3nib4;
	uint8_t  vref_dq_r3nib5;
	uint8_t  vref_dq_r3nib6;
	uint8_t  vref_dq_r3nib7;
	uint8_t  vref_dq_r3nib8;
	uint8_t  vref_dq_r3nib9;
	uint8_t  vref_dq_r3nib10;
	uint8_t  vref_dq_r3nib11;
	uint8_t  vref_dq_r3nib12;
	uint8_t  vref_dq_r3nib13;
	uint8_t  vref_dq_r3nib14;
	uint8_t  vref_dq_r3nib15;
	uint8_t  vref_dq_r3nib16;
	uint8_t  vref_dq_r3nib17;
	uint8_t  vref_dq_r3nib18;
	uint8_t  vref_dq_r3nib19;
	uint8_t  f0rc00_d0;
	uint8_t  f0rc01_d0;
	uint8_t  f0rc02_d0;
	uint8_t  f0rc03_d0;
	uint8_t  f0rc04_d0;
	uint8_t  f0rc05_d0;
	uint8_t  f0rc06_d0;
	uint8_t  f0rc07_d0;
	uint8_t  f0rc08_d0;
	uint8_t  f0rc09_d0;
	uint8_t  f0rc0a_d0;
	uint8_t  f0rc0b_d0;
	uint8_t  f0rc0c_d0;
	uint8_t  f0rc0d_d0;
	uint8_t  f0rc0e_d0;
	uint8_t  f0rc0f_d0;
	uint8_t  f0rc1x_d0;
	uint8_t  f0rc2x_d0;
	uint8_t  f0rc3x_d0;
	uint8_t  f0rc4x_d0;
	uint8_t  f0rc5x_d0;
	uint8_t  f0rc6x_d0;
	uint8_t  f0rc7x_d0;
	uint8_t  f0rc8x_d0;
	uint8_t  f0rc9x_d0;
	uint8_t  f0rcax_d0;
	uint8_t  f0rcbx_d0;
	uint8_t  f1rc00_d0;
	uint8_t  f1rc01_d0;
	uint8_t  f1rc02_d0;
	uint8_t  f1rc03_d0;
	uint8_t  f1rc04_d0;
	uint8_t  f1rc05_d0;
	uint8_t  f1rc06_d0;
	uint8_t  f1rc07_d0;
	uint8_t  f1rc08_d0;
	uint8_t  f1rc09_d0;
	uint8_t  f1rc0a_d0;
	uint8_t  f1rc0b_d0;
	uint8_t  f1rc0c_d0;
	uint8_t  f1rc0d_d0;
	uint8_t  f1rc0e_d0;
	uint8_t  f1rc0f_d0;
	uint8_t  f1rc1x_d0;
	uint8_t  f1rc2x_d0;
	uint8_t  f1rc3x_d0;
	uint8_t  f1rc4x_d0;
	uint8_t  f1rc5x_d0;
	uint8_t  f1rc6x_d0;
	uint8_t  f1rc7x_d0;
	uint8_t  f1rc8x_d0;
	uint8_t  f1rc9x_d0;
	uint8_t  f1rcax_d0;
	uint8_t  f1rcbx_d0;
	uint8_t  f0rc00_d1;
	uint8_t  f0rc01_d1;
	uint8_t  f0rc02_d1;
	uint8_t  f0rc03_d1;
	uint8_t  f0rc04_d1;
	uint8_t  f0rc05_d1;
	uint8_t  f0rc06_d1;
	uint8_t  f0rc07_d1;
	uint8_t  f0rc08_d1;
	uint8_t  f0rc09_d1;
	uint8_t  f0rc0a_d1;
	uint8_t  f0rc0b_d1;
	uint8_t  f0rc0c_d1;
	uint8_t  f0rc0d_d1;
	uint8_t  f0rc0e_d1;
	uint8_t  f0rc0f_d1;
	uint8_t  f0rc1x_d1;
	uint8_t  f0rc2x_d1;
	uint8_t  f0rc3x_d1;
	uint8_t  f0rc4x_d1;
	uint8_t  f0rc5x_d1;
	uint8_t  f0rc6x_d1;
	uint8_t  f0rc7x_d1;
	uint8_t  f0rc8x_d1;
	uint8_t  f0rc9x_d1;
	uint8_t  f0rcax_d1;
	uint8_t  f0rcbx_d1;
	uint8_t  f1rc00_d1;
	uint8_t  f1rc01_d1;
	uint8_t  f1rc02_d1;
	uint8_t  f1rc03_d1;
	uint8_t  f1rc04_d1;
	uint8_t  f1rc05_d1;
	uint8_t  f1rc06_d1;
	uint8_t  f1rc07_d1;
	uint8_t  f1rc08_d1;
	uint8_t  f1rc09_d1;
	uint8_t  f1rc0a_d1;
	uint8_t  f1rc0b_d1;
	uint8_t  f1rc0c_d1;
	uint8_t  f1rc0d_d1;
	uint8_t  f1rc0e_d1;
	uint8_t  f1rc0f_d1;
	uint8_t  f1rc1x_d1;
	uint8_t  f1rc2x_d1;
	uint8_t  f1rc3x_d1;
	uint8_t  f1rc4x_d1;
	uint8_t  f1rc5x_d1;
	uint8_t  f1rc6x_d1;
	uint8_t  f1rc7x_d1;
	uint8_t  f1rc8x_d1;
	uint8_t  f1rc9x_d1;
	uint8_t  f1rcax_d1;
	uint8_t  f1rcbx_d1;
	uint8_t  bc00_d0;
	uint8_t  bc01_d0;
	uint8_t  bc02_d0;
	uint8_t  bc03_d0;
	uint8_t  bc04_d0;
	uint8_t  bc05_d0;
	uint8_t  bc06_d0;
	uint8_t  bc07_d0;
	uint8_t  bc08_d0;
	uint8_t  bc09_d0;
	uint8_t  bc0a_d0;
	uint8_t  bc0b_d0;
	uint8_t  bc0c_d0;
	uint8_t  bc0d_d0;
	uint8_t  bc0e_d0;
	uint8_t  f0bc6x_d0;
	uint8_t  f0bccx_d0;
	uint8_t  f0bcdx_d0;
	uint8_t  f0bcex_d0;
	uint8_t  f0bcfx_d0;
	uint8_t  f1bccx_d0;
	uint8_t  f1bcdx_d0;
	uint8_t  f1bcex_d0;
	uint8_t  f1bcfx_d0;
	uint8_t  f0bc2x_b0_d0;
	uint8_t  f0bc3x_b0_d0;
	uint8_t  f0bc4x_b0_d0;
	uint8_t  f0bc5x_b0_d0;
	uint8_t  f0bc8x_b0_d0;
	uint8_t  f0bc9x_b0_d0;
	uint8_t  f0bcax_b0_d0;
	uint8_t  f0bcbx_b0_d0;
	uint8_t  f1bc2x_b0_d0;
	uint8_t  f1bc3x_b0_d0;
	uint8_t  f1bc4x_b0_d0;
	uint8_t  f1bc5x_b0_d0;
	uint8_t  f1bc8x_b0_d0;
	uint8_t  f1bc9x_b0_d0;
	uint8_t  f1bcax_b0_d0;
	uint8_t  f1bcbx_b0_d0;
	uint8_t  f2bc2x_b0_d0;
	uint8_t  f2bc3x_b0_d0;
	uint8_t  f2bc4x_b0_d0;
	uint8_t  f2bc5x_b0_d0;
	uint8_t  f2bc8x_b0_d0;
	uint8_t  f2bc9x_b0_d0;
	uint8_t  f2bcax_b0_d0;
	uint8_t  f2bcbx_b0_d0;
	uint8_t  f3bc2x_b0_d0;
	uint8_t  f3bc3x_b0_d0;
	uint8_t  f3bc4x_b0_d0;
	uint8_t  f3bc5x_b0_d0;
	uint8_t  f3bc8x_b0_d0;
	uint8_t  f3bc9x_b0_d0;
	uint8_t  f3bcax_b0_d0;
	uint8_t  f3bcbx_b0_d0;
	uint8_t  f0bc2x_b1_d0;
	uint8_t  f0bc3x_b1_d0;
	uint8_t  f0bc4x_b1_d0;
	uint8_t  f0bc5x_b1_d0;
	uint8_t  f0bc8x_b1_d0;
	uint8_t  f0bc9x_b1_d0;
	uint8_t  f0bcax_b1_d0;
	uint8_t  f0bcbx_b1_d0;
	uint8_t  f1bc2x_b1_d0;
	uint8_t  f1bc3x_b1_d0;
	uint8_t  f1bc4x_b1_d0;
	uint8_t  f1bc5x_b1_d0;
	uint8_t  f1bc8x_b1_d0;
	uint8_t  f1bc9x_b1_d0;
	uint8_t  f1bcax_b1_d0;
	uint8_t  f1bcbx_b1_d0;
	uint8_t  f2bc2x_b1_d0;
	uint8_t  f2bc3x_b1_d0;
	uint8_t  f2bc4x_b1_d0;
	uint8_t  f2bc5x_b1_d0;
	uint8_t  f2bc8x_b1_d0;
	uint8_t  f2bc9x_b1_d0;
	uint8_t  f2bcax_b1_d0;
	uint8_t  f2bcbx_b1_d0;
	uint8_t  f3bc2x_b1_d0;
	uint8_t  f3bc3x_b1_d0;
	uint8_t  f3bc4x_b1_d0;
	uint8_t  f3bc5x_b1_d0;
	uint8_t  f3bc8x_b1_d0;
	uint8_t  f3bc9x_b1_d0;
	uint8_t  f3bcax_b1_d0;
	uint8_t  f3bcbx_b1_d0;
	uint8_t  f0bc2x_b2_d0;
	uint8_t  f0bc3x_b2_d0;
	uint8_t  f0bc4x_b2_d0;
	uint8_t  f0bc5x_b2_d0;
	uint8_t  f0bc8x_b2_d0;
	uint8_t  f0bc9x_b2_d0;
	uint8_t  f0bcax_b2_d0;
	uint8_t  f0bcbx_b2_d0;
	uint8_t  f1bc2x_b2_d0;
	uint8_t  f1bc3x_b2_d0;
	uint8_t  f1bc4x_b2_d0;
	uint8_t  f1bc5x_b2_d0;
	uint8_t  f1bc8x_b2_d0;
	uint8_t  f1bc9x_b2_d0;
	uint8_t  f1bcax_b2_d0;
	uint8_t  f1bcbx_b2_d0;
	uint8_t  f2bc2x_b2_d0;
	uint8_t  f2bc3x_b2_d0;
	uint8_t  f2bc4x_b2_d0;
	uint8_t  f2bc5x_b2_d0;
	uint8_t  f2bc8x_b2_d0;
	uint8_t  f2bc9x_b2_d0;
	uint8_t  f2bcax_b2_d0;
	uint8_t  f2bcbx_b2_d0;
	uint8_t  f3bc2x_b2_d0;
	uint8_t  f3bc3x_b2_d0;
	uint8_t  f3bc4x_b2_d0;
	uint8_t  f3bc5x_b2_d0;
	uint8_t  f3bc8x_b2_d0;
	uint8_t  f3bc9x_b2_d0;
	uint8_t  f3bcax_b2_d0;
	uint8_t  f3bcbx_b2_d0;
	uint8_t  f0bc2x_b3_d0;
	uint8_t  f0bc3x_b3_d0;
	uint8_t  f0bc4x_b3_d0;
	uint8_t  f0bc5x_b3_d0;
	uint8_t  f0bc8x_b3_d0;
	uint8_t  f0bc9x_b3_d0;
	uint8_t  f0bcax_b3_d0;
	uint8_t  f0bcbx_b3_d0;
	uint8_t  f1bc2x_b3_d0;
	uint8_t  f1bc3x_b3_d0;
	uint8_t  f1bc4x_b3_d0;
	uint8_t  f1bc5x_b3_d0;
	uint8_t  f1bc8x_b3_d0;
	uint8_t  f1bc9x_b3_d0;
	uint8_t  f1bcax_b3_d0;
	uint8_t  f1bcbx_b3_d0;
	uint8_t  f2bc2x_b3_d0;
	uint8_t  f2bc3x_b3_d0;
	uint8_t  f2bc4x_b3_d0;
	uint8_t  f2bc5x_b3_d0;
	uint8_t  f2bc8x_b3_d0;
	uint8_t  f2bc9x_b3_d0;
	uint8_t  f2bcax_b3_d0;
	uint8_t  f2bcbx_b3_d0;
	uint8_t  f3bc2x_b3_d0;
	uint8_t  f3bc3x_b3_d0;
	uint8_t  f3bc4x_b3_d0;
	uint8_t  f3bc5x_b3_d0;
	uint8_t  f3bc8x_b3_d0;
	uint8_t  f3bc9x_b3_d0;
	uint8_t  f3bcax_b3_d0;
	uint8_t  f3bcbx_b3_d0;
	uint8_t  f0bc2x_b4_d0;
	uint8_t  f0bc3x_b4_d0;
	uint8_t  f0bc4x_b4_d0;
	uint8_t  f0bc5x_b4_d0;
	uint8_t  f0bc8x_b4_d0;
	uint8_t  f0bc9x_b4_d0;
	uint8_t  f0bcax_b4_d0;
	uint8_t  f0bcbx_b4_d0;
	uint8_t  f1bc2x_b4_d0;
	uint8_t  f1bc3x_b4_d0;
	uint8_t  f1bc4x_b4_d0;
	uint8_t  f1bc5x_b4_d0;
	uint8_t  f1bc8x_b4_d0;
	uint8_t  f1bc9x_b4_d0;
	uint8_t  f1bcax_b4_d0;
	uint8_t  f1bcbx_b4_d0;
	uint8_t  f2bc2x_b4_d0;
	uint8_t  f2bc3x_b4_d0;
	uint8_t  f2bc4x_b4_d0;
	uint8_t  f2bc5x_b4_d0;
	uint8_t  f2bc8x_b4_d0;
	uint8_t  f2bc9x_b4_d0;
	uint8_t  f2bcax_b4_d0;
	uint8_t  f2bcbx_b4_d0;
	uint8_t  f3bc2x_b4_d0;
	uint8_t  f3bc3x_b4_d0;
	uint8_t  f3bc4x_b4_d0;
	uint8_t  f3bc5x_b4_d0;
	uint8_t  f3bc8x_b4_d0;
	uint8_t  f3bc9x_b4_d0;
	uint8_t  f3bcax_b4_d0;
	uint8_t  f3bcbx_b4_d0;
	uint8_t  f0bc2x_b5_d0;
	uint8_t  f0bc3x_b5_d0;
	uint8_t  f0bc4x_b5_d0;
	uint8_t  f0bc5x_b5_d0;
	uint8_t  f0bc8x_b5_d0;
	uint8_t  f0bc9x_b5_d0;
	uint8_t  f0bcax_b5_d0;
	uint8_t  f0bcbx_b5_d0;
	uint8_t  f1bc2x_b5_d0;
	uint8_t  f1bc3x_b5_d0;
	uint8_t  f1bc4x_b5_d0;
	uint8_t  f1bc5x_b5_d0;
	uint8_t  f1bc8x_b5_d0;
	uint8_t  f1bc9x_b5_d0;
	uint8_t  f1bcax_b5_d0;
	uint8_t  f1bcbx_b5_d0;
	uint8_t  f2bc2x_b5_d0;
	uint8_t  f2bc3x_b5_d0;
	uint8_t  f2bc4x_b5_d0;
	uint8_t  f2bc5x_b5_d0;
	uint8_t  f2bc8x_b5_d0;
	uint8_t  f2bc9x_b5_d0;
	uint8_t  f2bcax_b5_d0;
	uint8_t  f2bcbx_b5_d0;
	uint8_t  f3bc2x_b5_d0;
	uint8_t  f3bc3x_b5_d0;
	uint8_t  f3bc4x_b5_d0;
	uint8_t  f3bc5x_b5_d0;
	uint8_t  f3bc8x_b5_d0;
	uint8_t  f3bc9x_b5_d0;
	uint8_t  f3bcax_b5_d0;
	uint8_t  f3bcbx_b5_d0;
	uint8_t  f0bc2x_b6_d0;
	uint8_t  f0bc3x_b6_d0;
	uint8_t  f0bc4x_b6_d0;
	uint8_t  f0bc5x_b6_d0;
	uint8_t  f0bc8x_b6_d0;
	uint8_t  f0bc9x_b6_d0;
	uint8_t  f0bcax_b6_d0;
	uint8_t  f0bcbx_b6_d0;
	uint8_t  f1bc2x_b6_d0;
	uint8_t  f1bc3x_b6_d0;
	uint8_t  f1bc4x_b6_d0;
	uint8_t  f1bc5x_b6_d0;
	uint8_t  f1bc8x_b6_d0;
	uint8_t  f1bc9x_b6_d0;
	uint8_t  f1bcax_b6_d0;
	uint8_t  f1bcbx_b6_d0;
	uint8_t  f2bc2x_b6_d0;
	uint8_t  f2bc3x_b6_d0;
	uint8_t  f2bc4x_b6_d0;
	uint8_t  f2bc5x_b6_d0;
	uint8_t  f2bc8x_b6_d0;
	uint8_t  f2bc9x_b6_d0;
	uint8_t  f2bcax_b6_d0;
	uint8_t  f2bcbx_b6_d0;
	uint8_t  f3bc2x_b6_d0;
	uint8_t  f3bc3x_b6_d0;
	uint8_t  f3bc4x_b6_d0;
	uint8_t  f3bc5x_b6_d0;
	uint8_t  f3bc8x_b6_d0;
	uint8_t  f3bc9x_b6_d0;
	uint8_t  f3bcax_b6_d0;
	uint8_t  f3bcbx_b6_d0;
	uint8_t  f0bc2x_b7_d0;
	uint8_t  f0bc3x_b7_d0;
	uint8_t  f0bc4x_b7_d0;
	uint8_t  f0bc5x_b7_d0;
	uint8_t  f0bc8x_b7_d0;
	uint8_t  f0bc9x_b7_d0;
	uint8_t  f0bcax_b7_d0;
	uint8_t  f0bcbx_b7_d0;
	uint8_t  f1bc2x_b7_d0;
	uint8_t  f1bc3x_b7_d0;
	uint8_t  f1bc4x_b7_d0;
	uint8_t  f1bc5x_b7_d0;
	uint8_t  f1bc8x_b7_d0;
	uint8_t  f1bc9x_b7_d0;
	uint8_t  f1bcax_b7_d0;
	uint8_t  f1bcbx_b7_d0;
	uint8_t  f2bc2x_b7_d0;
	uint8_t  f2bc3x_b7_d0;
	uint8_t  f2bc4x_b7_d0;
	uint8_t  f2bc5x_b7_d0;
	uint8_t  f2bc8x_b7_d0;
	uint8_t  f2bc9x_b7_d0;
	uint8_t  f2bcax_b7_d0;
	uint8_t  f2bcbx_b7_d0;
	uint8_t  f3bc2x_b7_d0;
	uint8_t  f3bc3x_b7_d0;
	uint8_t  f3bc4x_b7_d0;
	uint8_t  f3bc5x_b7_d0;
	uint8_t  f3bc8x_b7_d0;
	uint8_t  f3bc9x_b7_d0;
	uint8_t  f3bcax_b7_d0;
	uint8_t  f3bcbx_b7_d0;
	uint8_t  f0bc2x_b8_d0;
	uint8_t  f0bc3x_b8_d0;
	uint8_t  f0bc4x_b8_d0;
	uint8_t  f0bc5x_b8_d0;
	uint8_t  f0bc8x_b8_d0;
	uint8_t  f0bc9x_b8_d0;
	uint8_t  f0bcax_b8_d0;
	uint8_t  f0bcbx_b8_d0;
	uint8_t  f1bc2x_b8_d0;
	uint8_t  f1bc3x_b8_d0;
	uint8_t  f1bc4x_b8_d0;
	uint8_t  f1bc5x_b8_d0;
	uint8_t  f1bc8x_b8_d0;
	uint8_t  f1bc9x_b8_d0;
	uint8_t  f1bcax_b8_d0;
	uint8_t  f1bcbx_b8_d0;
	uint8_t  f2bc2x_b8_d0;
	uint8_t  f2bc3x_b8_d0;
	uint8_t  f2bc4x_b8_d0;
	uint8_t  f2bc5x_b8_d0;
	uint8_t  f2bc8x_b8_d0;
	uint8_t  f2bc9x_b8_d0;
	uint8_t  f2bcax_b8_d0;
	uint8_t  f2bcbx_b8_d0;
	uint8_t  f3bc2x_b8_d0;
	uint8_t  f3bc3x_b8_d0;
	uint8_t  f3bc4x_b8_d0;
	uint8_t  f3bc5x_b8_d0;
	uint8_t  f3bc8x_b8_d0;
	uint8_t  f3bc9x_b8_d0;
	uint8_t  f3bcax_b8_d0;
	uint8_t  f3bcbx_b8_d0;
	uint8_t  f5bc5x_d0;
	uint8_t  f5bc6x_d0;
	uint8_t  f4bc8x_d0;
	uint8_t  f4bc9x_d0;
	uint8_t  f4bcax_d0;
	uint8_t  f4bcbx_d0;
	uint8_t  f4bccx_d0;
	uint8_t  f4bcdx_d0;
	uint8_t  f4bcex_d0;
	uint8_t  f4bcfx_d0;
	uint8_t  f5bc8x_d0;
	uint8_t  f5bc9x_d0;
	uint8_t  f5bcax_d0;
	uint8_t  f5bcbx_d0;
	uint8_t  f5bccx_d0;
	uint8_t  f5bcdx_d0;
	uint8_t  f5bcex_d0;
	uint8_t  f5bcfx_d0;
	uint8_t  f6bc8x_d0;
	uint8_t  f6bc9x_d0;
	uint8_t  f6bcax_d0;
	uint8_t  f6bcbx_d0;
	uint8_t  f6bccx_d0;
	uint8_t  f6bcdx_d0;
	uint8_t  f6bcex_d0;
	uint8_t  f6bcfx_d0;
	uint8_t  f7bc8x_d0;
	uint8_t  f7bc9x_d0;
	uint8_t  f7bcax_d0;
	uint8_t  f7bcbx_d0;
	uint8_t  f7bccx_d0;
	uint8_t  f7bcdx_d0;
	uint8_t  f7bcex_d0;
	uint8_t  f7bcfx_d0;
	uint8_t  bc00_d1;
	uint8_t  bc01_d1;
	uint8_t  bc02_d1;
	uint8_t  bc03_d1;
	uint8_t  bc04_d1;
	uint8_t  bc05_d1;
	uint8_t  bc06_d1;
	uint8_t  bc07_d1;
	uint8_t  bc08_d1;
	uint8_t  bc09_d1;
	uint8_t  bc0a_d1;
	uint8_t  bc0b_d1;
	uint8_t  bc0c_d1;
	uint8_t  bc0d_d1;
	uint8_t  bc0e_d1;
	uint8_t  f0bc6x_d1;
	uint8_t  f0bccx_d1;
	uint8_t  f0bcdx_d1;
	uint8_t  f0bcex_d1;
	uint8_t  f0bcfx_d1;
	uint8_t  f1bccx_d1;
	uint8_t  f1bcdx_d1;
	uint8_t  f1bcex_d1;
	uint8_t  f1bcfx_d1;
	uint8_t  f0bc2x_b0_d1;
	uint8_t  f0bc3x_b0_d1;
	uint8_t  f0bc4x_b0_d1;
	uint8_t  f0bc5x_b0_d1;
	uint8_t  f0bc8x_b0_d1;
	uint8_t  f0bc9x_b0_d1;
	uint8_t  f0bcax_b0_d1;
	uint8_t  f0bcbx_b0_d1;
	uint8_t  f1bc2x_b0_d1;
	uint8_t  f1bc3x_b0_d1;
	uint8_t  f1bc4x_b0_d1;
	uint8_t  f1bc5x_b0_d1;
	uint8_t  f1bc8x_b0_d1;
	uint8_t  f1bc9x_b0_d1;
	uint8_t  f1bcax_b0_d1;
	uint8_t  f1bcbx_b0_d1;
	uint8_t  f2bc2x_b0_d1;
	uint8_t  f2bc3x_b0_d1;
	uint8_t  f2bc4x_b0_d1;
	uint8_t  f2bc5x_b0_d1;
	uint8_t  f2bc8x_b0_d1;
	uint8_t  f2bc9x_b0_d1;
	uint8_t  f2bcax_b0_d1;
	uint8_t  f2bcbx_b0_d1;
	uint8_t  f3bc2x_b0_d1;
	uint8_t  f3bc3x_b0_d1;
	uint8_t  f3bc4x_b0_d1;
	uint8_t  f3bc5x_b0_d1;
	uint8_t  f3bc8x_b0_d1;
	uint8_t  f3bc9x_b0_d1;
	uint8_t  f3bcax_b0_d1;
	uint8_t  f3bcbx_b0_d1;
	uint8_t  f0bc2x_b1_d1;
	uint8_t  f0bc3x_b1_d1;
	uint8_t  f0bc4x_b1_d1;
	uint8_t  f0bc5x_b1_d1;
	uint8_t  f0bc8x_b1_d1;
	uint8_t  f0bc9x_b1_d1;
	uint8_t  f0bcax_b1_d1;
	uint8_t  f0bcbx_b1_d1;
	uint8_t  f1bc2x_b1_d1;
	uint8_t  f1bc3x_b1_d1;
	uint8_t  f1bc4x_b1_d1;
	uint8_t  f1bc5x_b1_d1;
	uint8_t  f1bc8x_b1_d1;
	uint8_t  f1bc9x_b1_d1;
	uint8_t  f1bcax_b1_d1;
	uint8_t  f1bcbx_b1_d1;
	uint8_t  f2bc2x_b1_d1;
	uint8_t  f2bc3x_b1_d1;
	uint8_t  f2bc4x_b1_d1;
	uint8_t  f2bc5x_b1_d1;
	uint8_t  f2bc8x_b1_d1;
	uint8_t  f2bc9x_b1_d1;
	uint8_t  f2bcax_b1_d1;
	uint8_t  f2bcbx_b1_d1;
	uint8_t  f3bc2x_b1_d1;
	uint8_t  f3bc3x_b1_d1;
	uint8_t  f3bc4x_b1_d1;
	uint8_t  f3bc5x_b1_d1;
	uint8_t  f3bc8x_b1_d1;
	uint8_t  f3bc9x_b1_d1;
	uint8_t  f3bcax_b1_d1;
	uint8_t  f3bcbx_b1_d1;
	uint8_t  f0bc2x_b2_d1;
	uint8_t  f0bc3x_b2_d1;
	uint8_t  f0bc4x_b2_d1;
	uint8_t  f0bc5x_b2_d1;
	uint8_t  f0bc8x_b2_d1;
	uint8_t  f0bc9x_b2_d1;
	uint8_t  f0bcax_b2_d1;
	uint8_t  f0bcbx_b2_d1;
	uint8_t  f1bc2x_b2_d1;
	uint8_t  f1bc3x_b2_d1;
	uint8_t  f1bc4x_b2_d1;
	uint8_t  f1bc5x_b2_d1;
	uint8_t  f1bc8x_b2_d1;
	uint8_t  f1bc9x_b2_d1;
	uint8_t  f1bcax_b2_d1;
	uint8_t  f1bcbx_b2_d1;
	uint8_t  f2bc2x_b2_d1;
	uint8_t  f2bc3x_b2_d1;
	uint8_t  f2bc4x_b2_d1;
	uint8_t  f2bc5x_b2_d1;
	uint8_t  f2bc8x_b2_d1;
	uint8_t  f2bc9x_b2_d1;
	uint8_t  f2bcax_b2_d1;
	uint8_t  f2bcbx_b2_d1;
	uint8_t  f3bc2x_b2_d1;
	uint8_t  f3bc3x_b2_d1;
	uint8_t  f3bc4x_b2_d1;
	uint8_t  f3bc5x_b2_d1;
	uint8_t  f3bc8x_b2_d1;
	uint8_t  f3bc9x_b2_d1;
	uint8_t  f3bcax_b2_d1;
	uint8_t  f3bcbx_b2_d1;
	uint8_t  f0bc2x_b3_d1;
	uint8_t  f0bc3x_b3_d1;
	uint8_t  f0bc4x_b3_d1;
	uint8_t  f0bc5x_b3_d1;
	uint8_t  f0bc8x_b3_d1;
	uint8_t  f0bc9x_b3_d1;
	uint8_t  f0bcax_b3_d1;
	uint8_t  f0bcbx_b3_d1;
	uint8_t  f1bc2x_b3_d1;
	uint8_t  f1bc3x_b3_d1;
	uint8_t  f1bc4x_b3_d1;
	uint8_t  f1bc5x_b3_d1;
	uint8_t  f1bc8x_b3_d1;
	uint8_t  f1bc9x_b3_d1;
	uint8_t  f1bcax_b3_d1;
	uint8_t  f1bcbx_b3_d1;
	uint8_t  f2bc2x_b3_d1;
	uint8_t  f2bc3x_b3_d1;
	uint8_t  f2bc4x_b3_d1;
	uint8_t  f2bc5x_b3_d1;
	uint8_t  f2bc8x_b3_d1;
	uint8_t  f2bc9x_b3_d1;
	uint8_t  f2bcax_b3_d1;
	uint8_t  f2bcbx_b3_d1;
	uint8_t  f3bc2x_b3_d1;
	uint8_t  f3bc3x_b3_d1;
	uint8_t  f3bc4x_b3_d1;
	uint8_t  f3bc5x_b3_d1;
	uint8_t  f3bc8x_b3_d1;
	uint8_t  f3bc9x_b3_d1;
	uint8_t  f3bcax_b3_d1;
	uint8_t  f3bcbx_b3_d1;
	uint8_t  f0bc2x_b4_d1;
	uint8_t  f0bc3x_b4_d1;
	uint8_t  f0bc4x_b4_d1;
	uint8_t  f0bc5x_b4_d1;
	uint8_t  f0bc8x_b4_d1;
	uint8_t  f0bc9x_b4_d1;
	uint8_t  f0bcax_b4_d1;
	uint8_t  f0bcbx_b4_d1;
	uint8_t  f1bc2x_b4_d1;
	uint8_t  f1bc3x_b4_d1;
	uint8_t  f1bc4x_b4_d1;
	uint8_t  f1bc5x_b4_d1;
	uint8_t  f1bc8x_b4_d1;
	uint8_t  f1bc9x_b4_d1;
	uint8_t  f1bcax_b4_d1;
	uint8_t  f1bcbx_b4_d1;
	uint8_t  f2bc2x_b4_d1;
	uint8_t  f2bc3x_b4_d1;
	uint8_t  f2bc4x_b4_d1;
	uint8_t  f2bc5x_b4_d1;
	uint8_t  f2bc8x_b4_d1;
	uint8_t  f2bc9x_b4_d1;
	uint8_t  f2bcax_b4_d1;
	uint8_t  f2bcbx_b4_d1;
	uint8_t  f3bc2x_b4_d1;
	uint8_t  f3bc3x_b4_d1;
	uint8_t  f3bc4x_b4_d1;
	uint8_t  f3bc5x_b4_d1;
	uint8_t  f3bc8x_b4_d1;
	uint8_t  f3bc9x_b4_d1;
	uint8_t  f3bcax_b4_d1;
	uint8_t  f3bcbx_b4_d1;
	uint8_t  f0bc2x_b5_d1;
	uint8_t  f0bc3x_b5_d1;
	uint8_t  f0bc4x_b5_d1;
	uint8_t  f0bc5x_b5_d1;
	uint8_t  f0bc8x_b5_d1;
	uint8_t  f0bc9x_b5_d1;
	uint8_t  f0bcax_b5_d1;
	uint8_t  f0bcbx_b5_d1;
	uint8_t  f1bc2x_b5_d1;
	uint8_t  f1bc3x_b5_d1;
	uint8_t  f1bc4x_b5_d1;
	uint8_t  f1bc5x_b5_d1;
	uint8_t  f1bc8x_b5_d1;
	uint8_t  f1bc9x_b5_d1;
	uint8_t  f1bcax_b5_d1;
	uint8_t  f1bcbx_b5_d1;
	uint8_t  f2bc2x_b5_d1;
	uint8_t  f2bc3x_b5_d1;
	uint8_t  f2bc4x_b5_d1;
	uint8_t  f2bc5x_b5_d1;
	uint8_t  f2bc8x_b5_d1;
	uint8_t  f2bc9x_b5_d1;
	uint8_t  f2bcax_b5_d1;
	uint8_t  f2bcbx_b5_d1;
	uint8_t  f3bc2x_b5_d1;
	uint8_t  f3bc3x_b5_d1;
	uint8_t  f3bc4x_b5_d1;
	uint8_t  f3bc5x_b5_d1;
	uint8_t  f3bc8x_b5_d1;
	uint8_t  f3bc9x_b5_d1;
	uint8_t  f3bcax_b5_d1;
	uint8_t  f3bcbx_b5_d1;
	uint8_t  f0bc2x_b6_d1;
	uint8_t  f0bc3x_b6_d1;
	uint8_t  f0bc4x_b6_d1;
	uint8_t  f0bc5x_b6_d1;
	uint8_t  f0bc8x_b6_d1;
	uint8_t  f0bc9x_b6_d1;
	uint8_t  f0bcax_b6_d1;
	uint8_t  f0bcbx_b6_d1;
	uint8_t  f1bc2x_b6_d1;
	uint8_t  f1bc3x_b6_d1;
	uint8_t  f1bc4x_b6_d1;
	uint8_t  f1bc5x_b6_d1;
	uint8_t  f1bc8x_b6_d1;
	uint8_t  f1bc9x_b6_d1;
	uint8_t  f1bcax_b6_d1;
	uint8_t  f1bcbx_b6_d1;
	uint8_t  f2bc2x_b6_d1;
	uint8_t  f2bc3x_b6_d1;
	uint8_t  f2bc4x_b6_d1;
	uint8_t  f2bc5x_b6_d1;
	uint8_t  f2bc8x_b6_d1;
	uint8_t  f2bc9x_b6_d1;
	uint8_t  f2bcax_b6_d1;
	uint8_t  f2bcbx_b6_d1;
	uint8_t  f3bc2x_b6_d1;
	uint8_t  f3bc3x_b6_d1;
	uint8_t  f3bc4x_b6_d1;
	uint8_t  f3bc5x_b6_d1;
	uint8_t  f3bc8x_b6_d1;
	uint8_t  f3bc9x_b6_d1;
	uint8_t  f3bcax_b6_d1;
	uint8_t  f3bcbx_b6_d1;
	uint8_t  f0bc2x_b7_d1;
	uint8_t  f0bc3x_b7_d1;
	uint8_t  f0bc4x_b7_d1;
	uint8_t  f0bc5x_b7_d1;
	uint8_t  f0bc8x_b7_d1;
	uint8_t  f0bc9x_b7_d1;
	uint8_t  f0bcax_b7_d1;
	uint8_t  f0bcbx_b7_d1;
	uint8_t  f1bc2x_b7_d1;
	uint8_t  f1bc3x_b7_d1;
	uint8_t  f1bc4x_b7_d1;
	uint8_t  f1bc5x_b7_d1;
	uint8_t  f1bc8x_b7_d1;
	uint8_t  f1bc9x_b7_d1;
	uint8_t  f1bcax_b7_d1;
	uint8_t  f1bcbx_b7_d1;
	uint8_t  f2bc2x_b7_d1;
	uint8_t  f2bc3x_b7_d1;
	uint8_t  f2bc4x_b7_d1;
	uint8_t  f2bc5x_b7_d1;
	uint8_t  f2bc8x_b7_d1;
	uint8_t  f2bc9x_b7_d1;
	uint8_t  f2bcax_b7_d1;
	uint8_t  f2bcbx_b7_d1;
	uint8_t  f3bc2x_b7_d1;
	uint8_t  f3bc3x_b7_d1;
	uint8_t  f3bc4x_b7_d1;
	uint8_t  f3bc5x_b7_d1;
	uint8_t  f3bc8x_b7_d1;
	uint8_t  f3bc9x_b7_d1;
	uint8_t  f3bcax_b7_d1;
	uint8_t  f3bcbx_b7_d1;
	uint8_t  f0bc2x_b8_d1;
	uint8_t  f0bc3x_b8_d1;
	uint8_t  f0bc4x_b8_d1;
	uint8_t  f0bc5x_b8_d1;
	uint8_t  f0bc8x_b8_d1;
	uint8_t  f0bc9x_b8_d1;
	uint8_t  f0bcax_b8_d1;
	uint8_t  f0bcbx_b8_d1;
	uint8_t  f1bc2x_b8_d1;
	uint8_t  f1bc3x_b8_d1;
	uint8_t  f1bc4x_b8_d1;
	uint8_t  f1bc5x_b8_d1;
	uint8_t  f1bc8x_b8_d1;
	uint8_t  f1bc9x_b8_d1;
	uint8_t  f1bcax_b8_d1;
	uint8_t  f1bcbx_b8_d1;
	uint8_t  f2bc2x_b8_d1;
	uint8_t  f2bc3x_b8_d1;
	uint8_t  f2bc4x_b8_d1;
	uint8_t  f2bc5x_b8_d1;
	uint8_t  f2bc8x_b8_d1;
	uint8_t  f2bc9x_b8_d1;
	uint8_t  f2bcax_b8_d1;
	uint8_t  f2bcbx_b8_d1;
	uint8_t  f3bc2x_b8_d1;
	uint8_t  f3bc3x_b8_d1;
	uint8_t  f3bc4x_b8_d1;
	uint8_t  f3bc5x_b8_d1;
	uint8_t  f3bc8x_b8_d1;
	uint8_t  f3bc9x_b8_d1;
	uint8_t  f3bcax_b8_d1;
	uint8_t  f3bcbx_b8_d1;
	uint8_t  f5bc5x_d1;
	uint8_t  f5bc6x_d1;
	uint8_t  f4bc8x_d1;
	uint8_t  f4bc9x_d1;
	uint8_t  f4bcax_d1;
	uint8_t  f4bcbx_d1;
	uint8_t  f4bccx_d1;
	uint8_t  f4bcdx_d1;
	uint8_t  f4bcex_d1;
	uint8_t  f4bcfx_d1;
	uint8_t  f5bc8x_d1;
	uint8_t  f5bc9x_d1;
	uint8_t  f5bcax_d1;
	uint8_t  f5bcbx_d1;
	uint8_t  f5bccx_d1;
	uint8_t  f5bcdx_d1;
	uint8_t  f5bcex_d1;
	uint8_t  f5bcfx_d1;
	uint8_t  f6bc8x_d1;
	uint8_t  f6bc9x_d1;
	uint8_t  f6bcax_d1;
	uint8_t  f6bcbx_d1;
	uint8_t  f6bccx_d1;
	uint8_t  f6bcdx_d1;
	uint8_t  f6bcex_d1;
	uint8_t  f6bcfx_d1;
	uint8_t  f7bc8x_d1;
	uint8_t  f7bc9x_d1;
	uint8_t  f7bcax_d1;
	uint8_t  f7bcbx_d1;
	uint8_t  f7bccx_d1;
	uint8_t  f7bcdx_d1;
	uint8_t  f7bcex_d1;
	uint8_t  f7bcfx_d1;
	uint16_t alt_cas_l;
	uint8_t  alt_wcas_l;
	uint8_t  d4misc;
} __packed;

struct ddr4lr2d {
	uint8_t  reserved00;
	uint8_t  msg_misc;
	uint16_t pmu_revision;
	uint8_t  pstate;
	uint8_t  pll_bypass_en;
	uint16_t dramfreq;
	uint8_t  dfi_freq_ratio;
	uint8_t  bpznres_val;
	uint8_t  phy_odt_impedance;
	uint8_t  phy_drv_impedance;
	uint8_t  phy_vref;
	uint8_t  dram_type;
	uint8_t  disabled_dbyte;
	uint8_t  enabled_dqs;
	uint8_t  cs_present;
	uint8_t  cs_present_d0;
	uint8_t  cs_present_d1;
	uint8_t  addr_mirror;
	uint8_t  cs_test_fail;
	uint8_t  phy_cfg;
	uint16_t sequence_ctrl;
	uint8_t  hdt_ctrl;
	uint8_t  rx2d_train_opt;
	uint8_t  tx2d_train_opt;
	uint8_t  share2dvref_result;
	uint8_t  delay_weight2d;
	uint8_t  voltage_weight2d;
	uint8_t  reserved1e[0x22 - 0x1e];
	uint16_t phy_config_override;
	uint8_t  dfimrlmargin;
	uint8_t  r0_rx_clk_dly_margin;
	uint8_t  r0_vref_dac_margin;
	uint8_t  r0_tx_dq_dly_margin;
	uint8_t  r0_device_vref_margin;
	uint8_t  reserved29[0x33 - 0x29];
	uint8_t  r1_rx_clk_dly_margin;
	uint8_t  r1_vref_dac_margin;
	uint8_t  r1_tx_dq_dly_margin;
	uint8_t  r1_device_vref_margin;
	uint8_t  reserved37[0x41 - 0x37];
	uint8_t  r2_rx_clk_dly_margin;
	uint8_t  r2_vref_dac_margin;
	uint8_t  r2_tx_dq_dly_margin;
	uint8_t  r2_device_vref_margin;
	uint8_t  reserved45[0x4f - 0x45];
	uint8_t  r3_rx_clk_dly_margin;
	uint8_t  r3_vref_dac_margin;
	uint8_t  r3_tx_dq_dly_margin;
	uint8_t  r3_device_vref_margin;
	uint8_t  reserved53[0x5e - 0x53];
	uint16_t mr0;
	uint16_t mr1;
	uint16_t mr2;
	uint16_t mr3;
	uint16_t mr4;
	uint16_t mr5;
	uint16_t mr6;
	uint8_t  x16present;
	uint8_t  cs_setup_gddec;
	uint16_t rtt_nom_wr_park0;
	uint16_t rtt_nom_wr_park1;
	uint16_t rtt_nom_wr_park2;
	uint16_t rtt_nom_wr_park3;
	uint16_t rtt_nom_wr_park4;
	uint16_t rtt_nom_wr_park5;
	uint16_t rtt_nom_wr_park6;
	uint16_t rtt_nom_wr_park7;
	uint8_t  acsm_odt_ctrl0;
	uint8_t  acsm_odt_ctrl1;
	uint8_t  acsm_odt_ctrl2;
	uint8_t  acsm_odt_ctrl3;
	uint8_t  acsm_odt_ctrl4;
	uint8_t  acsm_odt_ctrl5;
	uint8_t  acsm_odt_ctrl6;
	uint8_t  acsm_odt_ctrl7;
	uint8_t  vref_dq_r0nib0;
	uint8_t  vref_dq_r0nib1;
	uint8_t  vref_dq_r0nib2;
	uint8_t  vref_dq_r0nib3;
	uint8_t  vref_dq_r0nib4;
	uint8_t  vref_dq_r0nib5;
	uint8_t  vref_dq_r0nib6;
	uint8_t  vref_dq_r0nib7;
	uint8_t  vref_dq_r0nib8;
	uint8_t  vref_dq_r0nib9;
	uint8_t  vref_dq_r0nib10;
	uint8_t  vref_dq_r0nib11;
	uint8_t  vref_dq_r0nib12;
	uint8_t  vref_dq_r0nib13;
	uint8_t  vref_dq_r0nib14;
	uint8_t  vref_dq_r0nib15;
	uint8_t  vref_dq_r0nib16;
	uint8_t  vref_dq_r0nib17;
	uint8_t  vref_dq_r0nib18;
	uint8_t  vref_dq_r0nib19;
	uint8_t  vref_dq_r1nib0;
	uint8_t  vref_dq_r1nib1;
	uint8_t  vref_dq_r1nib2;
	uint8_t  vref_dq_r1nib3;
	uint8_t  vref_dq_r1nib4;
	uint8_t  vref_dq_r1nib5;
	uint8_t  vref_dq_r1nib6;
	uint8_t  vref_dq_r1nib7;
	uint8_t  vref_dq_r1nib8;
	uint8_t  vref_dq_r1nib9;
	uint8_t  vref_dq_r1nib10;
	uint8_t  vref_dq_r1nib11;
	uint8_t  vref_dq_r1nib12;
	uint8_t  vref_dq_r1nib13;
	uint8_t  vref_dq_r1nib14;
	uint8_t  vref_dq_r1nib15;
	uint8_t  vref_dq_r1nib16;
	uint8_t  vref_dq_r1nib17;
	uint8_t  vref_dq_r1nib18;
	uint8_t  vref_dq_r1nib19;
	uint8_t  vref_dq_r2nib0;
	uint8_t  vref_dq_r2nib1;
	uint8_t  vref_dq_r2nib2;
	uint8_t  vref_dq_r2nib3;
	uint8_t  vref_dq_r2nib4;
	uint8_t  vref_dq_r2nib5;
	uint8_t  vref_dq_r2nib6;
	uint8_t  vref_dq_r2nib7;
	uint8_t  vref_dq_r2nib8;
	uint8_t  vref_dq_r2nib9;
	uint8_t  vref_dq_r2nib10;
	uint8_t  vref_dq_r2nib11;
	uint8_t  vref_dq_r2nib12;
	uint8_t  vref_dq_r2nib13;
	uint8_t  vref_dq_r2nib14;
	uint8_t  vref_dq_r2nib15;
	uint8_t  vref_dq_r2nib16;
	uint8_t  vref_dq_r2nib17;
	uint8_t  vref_dq_r2nib18;
	uint8_t  vref_dq_r2nib19;
	uint8_t  vref_dq_r3nib0;
	uint8_t  vref_dq_r3nib1;
	uint8_t  vref_dq_r3nib2;
	uint8_t  vref_dq_r3nib3;
	uint8_t  vref_dq_r3nib4;
	uint8_t  vref_dq_r3nib5;
	uint8_t  vref_dq_r3nib6;
	uint8_t  vref_dq_r3nib7;
	uint8_t  vref_dq_r3nib8;
	uint8_t  vref_dq_r3nib9;
	uint8_t  vref_dq_r3nib10;
	uint8_t  vref_dq_r3nib11;
	uint8_t  vref_dq_r3nib12;
	uint8_t  vref_dq_r3nib13;
	uint8_t  vref_dq_r3nib14;
	uint8_t  vref_dq_r3nib15;
	uint8_t  vref_dq_r3nib16;
	uint8_t  vref_dq_r3nib17;
	uint8_t  vref_dq_r3nib18;
	uint8_t  vref_dq_r3nib19;
	uint8_t  f0rc00_d0;
	uint8_t  f0rc01_d0;
	uint8_t  f0rc02_d0;
	uint8_t  f0rc03_d0;
	uint8_t  f0rc04_d0;
	uint8_t  f0rc05_d0;
	uint8_t  f0rc06_d0;
	uint8_t  f0rc07_d0;
	uint8_t  f0rc08_d0;
	uint8_t  f0rc09_d0;
	uint8_t  f0rc0a_d0;
	uint8_t  f0rc0b_d0;
	uint8_t  f0rc0c_d0;
	uint8_t  f0rc0d_d0;
	uint8_t  f0rc0e_d0;
	uint8_t  f0rc0f_d0;
	uint8_t  f0rc1x_d0;
	uint8_t  f0rc2x_d0;
	uint8_t  f0rc3x_d0;
	uint8_t  f0rc4x_d0;
	uint8_t  f0rc5x_d0;
	uint8_t  f0rc6x_d0;
	uint8_t  f0rc7x_d0;
	uint8_t  f0rc8x_d0;
	uint8_t  f0rc9x_d0;
	uint8_t  f0rcax_d0;
	uint8_t  f0rcbx_d0;
	uint8_t  f1rc00_d0;
	uint8_t  f1rc01_d0;
	uint8_t  f1rc02_d0;
	uint8_t  f1rc03_d0;
	uint8_t  f1rc04_d0;
	uint8_t  f1rc05_d0;
	uint8_t  f1rc06_d0;
	uint8_t  f1rc07_d0;
	uint8_t  f1rc08_d0;
	uint8_t  f1rc09_d0;
	uint8_t  f1rc0a_d0;
	uint8_t  f1rc0b_d0;
	uint8_t  f1rc0c_d0;
	uint8_t  f1rc0d_d0;
	uint8_t  f1rc0e_d0;
	uint8_t  f1rc0f_d0;
	uint8_t  f1rc1x_d0;
	uint8_t  f1rc2x_d0;
	uint8_t  f1rc3x_d0;
	uint8_t  f1rc4x_d0;
	uint8_t  f1rc5x_d0;
	uint8_t  f1rc6x_d0;
	uint8_t  f1rc7x_d0;
	uint8_t  f1rc8x_d0;
	uint8_t  f1rc9x_d0;
	uint8_t  f1rcax_d0;
	uint8_t  f1rcbx_d0;
	uint8_t  f0rc00_d1;
	uint8_t  f0rc01_d1;
	uint8_t  f0rc02_d1;
	uint8_t  f0rc03_d1;
	uint8_t  f0rc04_d1;
	uint8_t  f0rc05_d1;
	uint8_t  f0rc06_d1;
	uint8_t  f0rc07_d1;
	uint8_t  f0rc08_d1;
	uint8_t  f0rc09_d1;
	uint8_t  f0rc0a_d1;
	uint8_t  f0rc0b_d1;
	uint8_t  f0rc0c_d1;
	uint8_t  f0rc0d_d1;
	uint8_t  f0rc0e_d1;
	uint8_t  f0rc0f_d1;
	uint8_t  f0rc1x_d1;
	uint8_t  f0rc2x_d1;
	uint8_t  f0rc3x_d1;
	uint8_t  f0rc4x_d1;
	uint8_t  f0rc5x_d1;
	uint8_t  f0rc6x_d1;
	uint8_t  f0rc7x_d1;
	uint8_t  f0rc8x_d1;
	uint8_t  f0rc9x_d1;
	uint8_t  f0rcax_d1;
	uint8_t  f0rcbx_d1;
	uint8_t  f1rc00_d1;
	uint8_t  f1rc01_d1;
	uint8_t  f1rc02_d1;
	uint8_t  f1rc03_d1;
	uint8_t  f1rc04_d1;
	uint8_t  f1rc05_d1;
	uint8_t  f1rc06_d1;
	uint8_t  f1rc07_d1;
	uint8_t  f1rc08_d1;
	uint8_t  f1rc09_d1;
	uint8_t  f1rc0a_d1;
	uint8_t  f1rc0b_d1;
	uint8_t  f1rc0c_d1;
	uint8_t  f1rc0d_d1;
	uint8_t  f1rc0e_d1;
	uint8_t  f1rc0f_d1;
	uint8_t  f1rc1x_d1;
	uint8_t  f1rc2x_d1;
	uint8_t  f1rc3x_d1;
	uint8_t  f1rc4x_d1;
	uint8_t  f1rc5x_d1;
	uint8_t  f1rc6x_d1;
	uint8_t  f1rc7x_d1;
	uint8_t  f1rc8x_d1;
	uint8_t  f1rc9x_d1;
	uint8_t  f1rcax_d1;
	uint8_t  f1rcbx_d1;
	uint8_t  bc00_d0;
	uint8_t  bc01_d0;
	uint8_t  bc02_d0;
	uint8_t  bc03_d0;
	uint8_t  bc04_d0;
	uint8_t  bc05_d0;
	uint8_t  bc06_d0;
	uint8_t  bc07_d0;
	uint8_t  bc08_d0;
	uint8_t  bc09_d0;
	uint8_t  bc0a_d0;
	uint8_t  bc0b_d0;
	uint8_t  bc0c_d0;
	uint8_t  bc0d_d0;
	uint8_t  bc0e_d0;
	uint8_t  f0bc6x_d0;
	uint8_t  f0bccx_d0;
	uint8_t  f0bcdx_d0;
	uint8_t  f0bcex_d0;
	uint8_t  f0bcfx_d0;
	uint8_t  f1bccx_d0;
	uint8_t  f1bcdx_d0;
	uint8_t  f1bcex_d0;
	uint8_t  f1bcfx_d0;
	uint8_t  f0bc2x_b0_d0;
	uint8_t  f0bc3x_b0_d0;
	uint8_t  f0bc4x_b0_d0;
	uint8_t  f0bc5x_b0_d0;
	uint8_t  f0bc8x_b0_d0;
	uint8_t  f0bc9x_b0_d0;
	uint8_t  f0bcax_b0_d0;
	uint8_t  f0bcbx_b0_d0;
	uint8_t  f1bc2x_b0_d0;
	uint8_t  f1bc3x_b0_d0;
	uint8_t  f1bc4x_b0_d0;
	uint8_t  f1bc5x_b0_d0;
	uint8_t  f1bc8x_b0_d0;
	uint8_t  f1bc9x_b0_d0;
	uint8_t  f1bcax_b0_d0;
	uint8_t  f1bcbx_b0_d0;
	uint8_t  f2bc2x_b0_d0;
	uint8_t  f2bc3x_b0_d0;
	uint8_t  f2bc4x_b0_d0;
	uint8_t  f2bc5x_b0_d0;
	uint8_t  f2bc8x_b0_d0;
	uint8_t  f2bc9x_b0_d0;
	uint8_t  f2bcax_b0_d0;
	uint8_t  f2bcbx_b0_d0;
	uint8_t  f3bc2x_b0_d0;
	uint8_t  f3bc3x_b0_d0;
	uint8_t  f3bc4x_b0_d0;
	uint8_t  f3bc5x_b0_d0;
	uint8_t  f3bc8x_b0_d0;
	uint8_t  f3bc9x_b0_d0;
	uint8_t  f3bcax_b0_d0;
	uint8_t  f3bcbx_b0_d0;
	uint8_t  f0bc2x_b1_d0;
	uint8_t  f0bc3x_b1_d0;
	uint8_t  f0bc4x_b1_d0;
	uint8_t  f0bc5x_b1_d0;
	uint8_t  f0bc8x_b1_d0;
	uint8_t  f0bc9x_b1_d0;
	uint8_t  f0bcax_b1_d0;
	uint8_t  f0bcbx_b1_d0;
	uint8_t  f1bc2x_b1_d0;
	uint8_t  f1bc3x_b1_d0;
	uint8_t  f1bc4x_b1_d0;
	uint8_t  f1bc5x_b1_d0;
	uint8_t  f1bc8x_b1_d0;
	uint8_t  f1bc9x_b1_d0;
	uint8_t  f1bcax_b1_d0;
	uint8_t  f1bcbx_b1_d0;
	uint8_t  f2bc2x_b1_d0;
	uint8_t  f2bc3x_b1_d0;
	uint8_t  f2bc4x_b1_d0;
	uint8_t  f2bc5x_b1_d0;
	uint8_t  f2bc8x_b1_d0;
	uint8_t  f2bc9x_b1_d0;
	uint8_t  f2bcax_b1_d0;
	uint8_t  f2bcbx_b1_d0;
	uint8_t  f3bc2x_b1_d0;
	uint8_t  f3bc3x_b1_d0;
	uint8_t  f3bc4x_b1_d0;
	uint8_t  f3bc5x_b1_d0;
	uint8_t  f3bc8x_b1_d0;
	uint8_t  f3bc9x_b1_d0;
	uint8_t  f3bcax_b1_d0;
	uint8_t  f3bcbx_b1_d0;
	uint8_t  f0bc2x_b2_d0;
	uint8_t  f0bc3x_b2_d0;
	uint8_t  f0bc4x_b2_d0;
	uint8_t  f0bc5x_b2_d0;
	uint8_t  f0bc8x_b2_d0;
	uint8_t  f0bc9x_b2_d0;
	uint8_t  f0bcax_b2_d0;
	uint8_t  f0bcbx_b2_d0;
	uint8_t  f1bc2x_b2_d0;
	uint8_t  f1bc3x_b2_d0;
	uint8_t  f1bc4x_b2_d0;
	uint8_t  f1bc5x_b2_d0;
	uint8_t  f1bc8x_b2_d0;
	uint8_t  f1bc9x_b2_d0;
	uint8_t  f1bcax_b2_d0;
	uint8_t  f1bcbx_b2_d0;
	uint8_t  f2bc2x_b2_d0;
	uint8_t  f2bc3x_b2_d0;
	uint8_t  f2bc4x_b2_d0;
	uint8_t  f2bc5x_b2_d0;
	uint8_t  f2bc8x_b2_d0;
	uint8_t  f2bc9x_b2_d0;
	uint8_t  f2bcax_b2_d0;
	uint8_t  f2bcbx_b2_d0;
	uint8_t  f3bc2x_b2_d0;
	uint8_t  f3bc3x_b2_d0;
	uint8_t  f3bc4x_b2_d0;
	uint8_t  f3bc5x_b2_d0;
	uint8_t  f3bc8x_b2_d0;
	uint8_t  f3bc9x_b2_d0;
	uint8_t  f3bcax_b2_d0;
	uint8_t  f3bcbx_b2_d0;
	uint8_t  f0bc2x_b3_d0;
	uint8_t  f0bc3x_b3_d0;
	uint8_t  f0bc4x_b3_d0;
	uint8_t  f0bc5x_b3_d0;
	uint8_t  f0bc8x_b3_d0;
	uint8_t  f0bc9x_b3_d0;
	uint8_t  f0bcax_b3_d0;
	uint8_t  f0bcbx_b3_d0;
	uint8_t  f1bc2x_b3_d0;
	uint8_t  f1bc3x_b3_d0;
	uint8_t  f1bc4x_b3_d0;
	uint8_t  f1bc5x_b3_d0;
	uint8_t  f1bc8x_b3_d0;
	uint8_t  f1bc9x_b3_d0;
	uint8_t  f1bcax_b3_d0;
	uint8_t  f1bcbx_b3_d0;
	uint8_t  f2bc2x_b3_d0;
	uint8_t  f2bc3x_b3_d0;
	uint8_t  f2bc4x_b3_d0;
	uint8_t  f2bc5x_b3_d0;
	uint8_t  f2bc8x_b3_d0;
	uint8_t  f2bc9x_b3_d0;
	uint8_t  f2bcax_b3_d0;
	uint8_t  f2bcbx_b3_d0;
	uint8_t  f3bc2x_b3_d0;
	uint8_t  f3bc3x_b3_d0;
	uint8_t  f3bc4x_b3_d0;
	uint8_t  f3bc5x_b3_d0;
	uint8_t  f3bc8x_b3_d0;
	uint8_t  f3bc9x_b3_d0;
	uint8_t  f3bcax_b3_d0;
	uint8_t  f3bcbx_b3_d0;
	uint8_t  f0bc2x_b4_d0;
	uint8_t  f0bc3x_b4_d0;
	uint8_t  f0bc4x_b4_d0;
	uint8_t  f0bc5x_b4_d0;
	uint8_t  f0bc8x_b4_d0;
	uint8_t  f0bc9x_b4_d0;
	uint8_t  f0bcax_b4_d0;
	uint8_t  f0bcbx_b4_d0;
	uint8_t  f1bc2x_b4_d0;
	uint8_t  f1bc3x_b4_d0;
	uint8_t  f1bc4x_b4_d0;
	uint8_t  f1bc5x_b4_d0;
	uint8_t  f1bc8x_b4_d0;
	uint8_t  f1bc9x_b4_d0;
	uint8_t  f1bcax_b4_d0;
	uint8_t  f1bcbx_b4_d0;
	uint8_t  f2bc2x_b4_d0;
	uint8_t  f2bc3x_b4_d0;
	uint8_t  f2bc4x_b4_d0;
	uint8_t  f2bc5x_b4_d0;
	uint8_t  f2bc8x_b4_d0;
	uint8_t  f2bc9x_b4_d0;
	uint8_t  f2bcax_b4_d0;
	uint8_t  f2bcbx_b4_d0;
	uint8_t  f3bc2x_b4_d0;
	uint8_t  f3bc3x_b4_d0;
	uint8_t  f3bc4x_b4_d0;
	uint8_t  f3bc5x_b4_d0;
	uint8_t  f3bc8x_b4_d0;
	uint8_t  f3bc9x_b4_d0;
	uint8_t  f3bcax_b4_d0;
	uint8_t  f3bcbx_b4_d0;
	uint8_t  f0bc2x_b5_d0;
	uint8_t  f0bc3x_b5_d0;
	uint8_t  f0bc4x_b5_d0;
	uint8_t  f0bc5x_b5_d0;
	uint8_t  f0bc8x_b5_d0;
	uint8_t  f0bc9x_b5_d0;
	uint8_t  f0bcax_b5_d0;
	uint8_t  f0bcbx_b5_d0;
	uint8_t  f1bc2x_b5_d0;
	uint8_t  f1bc3x_b5_d0;
	uint8_t  f1bc4x_b5_d0;
	uint8_t  f1bc5x_b5_d0;
	uint8_t  f1bc8x_b5_d0;
	uint8_t  f1bc9x_b5_d0;
	uint8_t  f1bcax_b5_d0;
	uint8_t  f1bcbx_b5_d0;
	uint8_t  f2bc2x_b5_d0;
	uint8_t  f2bc3x_b5_d0;
	uint8_t  f2bc4x_b5_d0;
	uint8_t  f2bc5x_b5_d0;
	uint8_t  f2bc8x_b5_d0;
	uint8_t  f2bc9x_b5_d0;
	uint8_t  f2bcax_b5_d0;
	uint8_t  f2bcbx_b5_d0;
	uint8_t  f3bc2x_b5_d0;
	uint8_t  f3bc3x_b5_d0;
	uint8_t  f3bc4x_b5_d0;
	uint8_t  f3bc5x_b5_d0;
	uint8_t  f3bc8x_b5_d0;
	uint8_t  f3bc9x_b5_d0;
	uint8_t  f3bcax_b5_d0;
	uint8_t  f3bcbx_b5_d0;
	uint8_t  f0bc2x_b6_d0;
	uint8_t  f0bc3x_b6_d0;
	uint8_t  f0bc4x_b6_d0;
	uint8_t  f0bc5x_b6_d0;
	uint8_t  f0bc8x_b6_d0;
	uint8_t  f0bc9x_b6_d0;
	uint8_t  f0bcax_b6_d0;
	uint8_t  f0bcbx_b6_d0;
	uint8_t  f1bc2x_b6_d0;
	uint8_t  f1bc3x_b6_d0;
	uint8_t  f1bc4x_b6_d0;
	uint8_t  f1bc5x_b6_d0;
	uint8_t  f1bc8x_b6_d0;
	uint8_t  f1bc9x_b6_d0;
	uint8_t  f1bcax_b6_d0;
	uint8_t  f1bcbx_b6_d0;
	uint8_t  f2bc2x_b6_d0;
	uint8_t  f2bc3x_b6_d0;
	uint8_t  f2bc4x_b6_d0;
	uint8_t  f2bc5x_b6_d0;
	uint8_t  f2bc8x_b6_d0;
	uint8_t  f2bc9x_b6_d0;
	uint8_t  f2bcax_b6_d0;
	uint8_t  f2bcbx_b6_d0;
	uint8_t  f3bc2x_b6_d0;
	uint8_t  f3bc3x_b6_d0;
	uint8_t  f3bc4x_b6_d0;
	uint8_t  f3bc5x_b6_d0;
	uint8_t  f3bc8x_b6_d0;
	uint8_t  f3bc9x_b6_d0;
	uint8_t  f3bcax_b6_d0;
	uint8_t  f3bcbx_b6_d0;
	uint8_t  f0bc2x_b7_d0;
	uint8_t  f0bc3x_b7_d0;
	uint8_t  f0bc4x_b7_d0;
	uint8_t  f0bc5x_b7_d0;
	uint8_t  f0bc8x_b7_d0;
	uint8_t  f0bc9x_b7_d0;
	uint8_t  f0bcax_b7_d0;
	uint8_t  f0bcbx_b7_d0;
	uint8_t  f1bc2x_b7_d0;
	uint8_t  f1bc3x_b7_d0;
	uint8_t  f1bc4x_b7_d0;
	uint8_t  f1bc5x_b7_d0;
	uint8_t  f1bc8x_b7_d0;
	uint8_t  f1bc9x_b7_d0;
	uint8_t  f1bcax_b7_d0;
	uint8_t  f1bcbx_b7_d0;
	uint8_t  f2bc2x_b7_d0;
	uint8_t  f2bc3x_b7_d0;
	uint8_t  f2bc4x_b7_d0;
	uint8_t  f2bc5x_b7_d0;
	uint8_t  f2bc8x_b7_d0;
	uint8_t  f2bc9x_b7_d0;
	uint8_t  f2bcax_b7_d0;
	uint8_t  f2bcbx_b7_d0;
	uint8_t  f3bc2x_b7_d0;
	uint8_t  f3bc3x_b7_d0;
	uint8_t  f3bc4x_b7_d0;
	uint8_t  f3bc5x_b7_d0;
	uint8_t  f3bc8x_b7_d0;
	uint8_t  f3bc9x_b7_d0;
	uint8_t  f3bcax_b7_d0;
	uint8_t  f3bcbx_b7_d0;
	uint8_t  f0bc2x_b8_d0;
	uint8_t  f0bc3x_b8_d0;
	uint8_t  f0bc4x_b8_d0;
	uint8_t  f0bc5x_b8_d0;
	uint8_t  f0bc8x_b8_d0;
	uint8_t  f0bc9x_b8_d0;
	uint8_t  f0bcax_b8_d0;
	uint8_t  f0bcbx_b8_d0;
	uint8_t  f1bc2x_b8_d0;
	uint8_t  f1bc3x_b8_d0;
	uint8_t  f1bc4x_b8_d0;
	uint8_t  f1bc5x_b8_d0;
	uint8_t  f1bc8x_b8_d0;
	uint8_t  f1bc9x_b8_d0;
	uint8_t  f1bcax_b8_d0;
	uint8_t  f1bcbx_b8_d0;
	uint8_t  f2bc2x_b8_d0;
	uint8_t  f2bc3x_b8_d0;
	uint8_t  f2bc4x_b8_d0;
	uint8_t  f2bc5x_b8_d0;
	uint8_t  f2bc8x_b8_d0;
	uint8_t  f2bc9x_b8_d0;
	uint8_t  f2bcax_b8_d0;
	uint8_t  f2bcbx_b8_d0;
	uint8_t  f3bc2x_b8_d0;
	uint8_t  f3bc3x_b8_d0;
	uint8_t  f3bc4x_b8_d0;
	uint8_t  f3bc5x_b8_d0;
	uint8_t  f3bc8x_b8_d0;
	uint8_t  f3bc9x_b8_d0;
	uint8_t  f3bcax_b8_d0;
	uint8_t  f3bcbx_b8_d0;
	uint8_t  f5bc5x_d0;
	uint8_t  f5bc6x_d0;
	uint8_t  f4bc8x_d0;
	uint8_t  f4bc9x_d0;
	uint8_t  f4bcax_d0;
	uint8_t  f4bcbx_d0;
	uint8_t  f4bccx_d0;
	uint8_t  f4bcdx_d0;
	uint8_t  f4bcex_d0;
	uint8_t  f4bcfx_d0;
	uint8_t  f5bc8x_d0;
	uint8_t  f5bc9x_d0;
	uint8_t  f5bcax_d0;
	uint8_t  f5bcbx_d0;
	uint8_t  f5bccx_d0;
	uint8_t  f5bcdx_d0;
	uint8_t  f5bcex_d0;
	uint8_t  f5bcfx_d0;
	uint8_t  f6bc8x_d0;
	uint8_t  f6bc9x_d0;
	uint8_t  f6bcax_d0;
	uint8_t  f6bcbx_d0;
	uint8_t  f6bccx_d0;
	uint8_t  f6bcdx_d0;
	uint8_t  f6bcex_d0;
	uint8_t  f6bcfx_d0;
	uint8_t  f7bc8x_d0;
	uint8_t  f7bc9x_d0;
	uint8_t  f7bcax_d0;
	uint8_t  f7bcbx_d0;
	uint8_t  f7bccx_d0;
	uint8_t  f7bcdx_d0;
	uint8_t  f7bcex_d0;
	uint8_t  f7bcfx_d0;
	uint8_t  bc00_d1;
	uint8_t  bc01_d1;
	uint8_t  bc02_d1;
	uint8_t  bc03_d1;
	uint8_t  bc04_d1;
	uint8_t  bc05_d1;
	uint8_t  bc06_d1;
	uint8_t  bc07_d1;
	uint8_t  bc08_d1;
	uint8_t  bc09_d1;
	uint8_t  bc0a_d1;
	uint8_t  bc0b_d1;
	uint8_t  bc0c_d1;
	uint8_t  bc0d_d1;
	uint8_t  bc0e_d1;
	uint8_t  f0bc6x_d1;
	uint8_t  f0bccx_d1;
	uint8_t  f0bcdx_d1;
	uint8_t  f0bcex_d1;
	uint8_t  f0bcfx_d1;
	uint8_t  f1bccx_d1;
	uint8_t  f1bcdx_d1;
	uint8_t  f1bcex_d1;
	uint8_t  f1bcfx_d1;
	uint8_t  f0bc2x_b0_d1;
	uint8_t  f0bc3x_b0_d1;
	uint8_t  f0bc4x_b0_d1;
	uint8_t  f0bc5x_b0_d1;
	uint8_t  f0bc8x_b0_d1;
	uint8_t  f0bc9x_b0_d1;
	uint8_t  f0bcax_b0_d1;
	uint8_t  f0bcbx_b0_d1;
	uint8_t  f1bc2x_b0_d1;
	uint8_t  f1bc3x_b0_d1;
	uint8_t  f1bc4x_b0_d1;
	uint8_t  f1bc5x_b0_d1;
	uint8_t  f1bc8x_b0_d1;
	uint8_t  f1bc9x_b0_d1;
	uint8_t  f1bcax_b0_d1;
	uint8_t  f1bcbx_b0_d1;
	uint8_t  f2bc2x_b0_d1;
	uint8_t  f2bc3x_b0_d1;
	uint8_t  f2bc4x_b0_d1;
	uint8_t  f2bc5x_b0_d1;
	uint8_t  f2bc8x_b0_d1;
	uint8_t  f2bc9x_b0_d1;
	uint8_t  f2bcax_b0_d1;
	uint8_t  f2bcbx_b0_d1;
	uint8_t  f3bc2x_b0_d1;
	uint8_t  f3bc3x_b0_d1;
	uint8_t  f3bc4x_b0_d1;
	uint8_t  f3bc5x_b0_d1;
	uint8_t  f3bc8x_b0_d1;
	uint8_t  f3bc9x_b0_d1;
	uint8_t  f3bcax_b0_d1;
	uint8_t  f3bcbx_b0_d1;
	uint8_t  f0bc2x_b1_d1;
	uint8_t  f0bc3x_b1_d1;
	uint8_t  f0bc4x_b1_d1;
	uint8_t  f0bc5x_b1_d1;
	uint8_t  f0bc8x_b1_d1;
	uint8_t  f0bc9x_b1_d1;
	uint8_t  f0bcax_b1_d1;
	uint8_t  f0bcbx_b1_d1;
	uint8_t  f1bc2x_b1_d1;
	uint8_t  f1bc3x_b1_d1;
	uint8_t  f1bc4x_b1_d1;
	uint8_t  f1bc5x_b1_d1;
	uint8_t  f1bc8x_b1_d1;
	uint8_t  f1bc9x_b1_d1;
	uint8_t  f1bcax_b1_d1;
	uint8_t  f1bcbx_b1_d1;
	uint8_t  f2bc2x_b1_d1;
	uint8_t  f2bc3x_b1_d1;
	uint8_t  f2bc4x_b1_d1;
	uint8_t  f2bc5x_b1_d1;
	uint8_t  f2bc8x_b1_d1;
	uint8_t  f2bc9x_b1_d1;
	uint8_t  f2bcax_b1_d1;
	uint8_t  f2bcbx_b1_d1;
	uint8_t  f3bc2x_b1_d1;
	uint8_t  f3bc3x_b1_d1;
	uint8_t  f3bc4x_b1_d1;
	uint8_t  f3bc5x_b1_d1;
	uint8_t  f3bc8x_b1_d1;
	uint8_t  f3bc9x_b1_d1;
	uint8_t  f3bcax_b1_d1;
	uint8_t  f3bcbx_b1_d1;
	uint8_t  f0bc2x_b2_d1;
	uint8_t  f0bc3x_b2_d1;
	uint8_t  f0bc4x_b2_d1;
	uint8_t  f0bc5x_b2_d1;
	uint8_t  f0bc8x_b2_d1;
	uint8_t  f0bc9x_b2_d1;
	uint8_t  f0bcax_b2_d1;
	uint8_t  f0bcbx_b2_d1;
	uint8_t  f1bc2x_b2_d1;
	uint8_t  f1bc3x_b2_d1;
	uint8_t  f1bc4x_b2_d1;
	uint8_t  f1bc5x_b2_d1;
	uint8_t  f1bc8x_b2_d1;
	uint8_t  f1bc9x_b2_d1;
	uint8_t  f1bcax_b2_d1;
	uint8_t  f1bcbx_b2_d1;
	uint8_t  f2bc2x_b2_d1;
	uint8_t  f2bc3x_b2_d1;
	uint8_t  f2bc4x_b2_d1;
	uint8_t  f2bc5x_b2_d1;
	uint8_t  f2bc8x_b2_d1;
	uint8_t  f2bc9x_b2_d1;
	uint8_t  f2bcax_b2_d1;
	uint8_t  f2bcbx_b2_d1;
	uint8_t  f3bc2x_b2_d1;
	uint8_t  f3bc3x_b2_d1;
	uint8_t  f3bc4x_b2_d1;
	uint8_t  f3bc5x_b2_d1;
	uint8_t  f3bc8x_b2_d1;
	uint8_t  f3bc9x_b2_d1;
	uint8_t  f3bcax_b2_d1;
	uint8_t  f3bcbx_b2_d1;
	uint8_t  f0bc2x_b3_d1;
	uint8_t  f0bc3x_b3_d1;
	uint8_t  f0bc4x_b3_d1;
	uint8_t  f0bc5x_b3_d1;
	uint8_t  f0bc8x_b3_d1;
	uint8_t  f0bc9x_b3_d1;
	uint8_t  f0bcax_b3_d1;
	uint8_t  f0bcbx_b3_d1;
	uint8_t  f1bc2x_b3_d1;
	uint8_t  f1bc3x_b3_d1;
	uint8_t  f1bc4x_b3_d1;
	uint8_t  f1bc5x_b3_d1;
	uint8_t  f1bc8x_b3_d1;
	uint8_t  f1bc9x_b3_d1;
	uint8_t  f1bcax_b3_d1;
	uint8_t  f1bcbx_b3_d1;
	uint8_t  f2bc2x_b3_d1;
	uint8_t  f2bc3x_b3_d1;
	uint8_t  f2bc4x_b3_d1;
	uint8_t  f2bc5x_b3_d1;
	uint8_t  f2bc8x_b3_d1;
	uint8_t  f2bc9x_b3_d1;
	uint8_t  f2bcax_b3_d1;
	uint8_t  f2bcbx_b3_d1;
	uint8_t  f3bc2x_b3_d1;
	uint8_t  f3bc3x_b3_d1;
	uint8_t  f3bc4x_b3_d1;
	uint8_t  f3bc5x_b3_d1;
	uint8_t  f3bc8x_b3_d1;
	uint8_t  f3bc9x_b3_d1;
	uint8_t  f3bcax_b3_d1;
	uint8_t  f3bcbx_b3_d1;
	uint8_t  f0bc2x_b4_d1;
	uint8_t  f0bc3x_b4_d1;
	uint8_t  f0bc4x_b4_d1;
	uint8_t  f0bc5x_b4_d1;
	uint8_t  f0bc8x_b4_d1;
	uint8_t  f0bc9x_b4_d1;
	uint8_t  f0bcax_b4_d1;
	uint8_t  f0bcbx_b4_d1;
	uint8_t  f1bc2x_b4_d1;
	uint8_t  f1bc3x_b4_d1;
	uint8_t  f1bc4x_b4_d1;
	uint8_t  f1bc5x_b4_d1;
	uint8_t  f1bc8x_b4_d1;
	uint8_t  f1bc9x_b4_d1;
	uint8_t  f1bcax_b4_d1;
	uint8_t  f1bcbx_b4_d1;
	uint8_t  f2bc2x_b4_d1;
	uint8_t  f2bc3x_b4_d1;
	uint8_t  f2bc4x_b4_d1;
	uint8_t  f2bc5x_b4_d1;
	uint8_t  f2bc8x_b4_d1;
	uint8_t  f2bc9x_b4_d1;
	uint8_t  f2bcax_b4_d1;
	uint8_t  f2bcbx_b4_d1;
	uint8_t  f3bc2x_b4_d1;
	uint8_t  f3bc3x_b4_d1;
	uint8_t  f3bc4x_b4_d1;
	uint8_t  f3bc5x_b4_d1;
	uint8_t  f3bc8x_b4_d1;
	uint8_t  f3bc9x_b4_d1;
	uint8_t  f3bcax_b4_d1;
	uint8_t  f3bcbx_b4_d1;
	uint8_t  f0bc2x_b5_d1;
	uint8_t  f0bc3x_b5_d1;
	uint8_t  f0bc4x_b5_d1;
	uint8_t  f0bc5x_b5_d1;
	uint8_t  f0bc8x_b5_d1;
	uint8_t  f0bc9x_b5_d1;
	uint8_t  f0bcax_b5_d1;
	uint8_t  f0bcbx_b5_d1;
	uint8_t  f1bc2x_b5_d1;
	uint8_t  f1bc3x_b5_d1;
	uint8_t  f1bc4x_b5_d1;
	uint8_t  f1bc5x_b5_d1;
	uint8_t  f1bc8x_b5_d1;
	uint8_t  f1bc9x_b5_d1;
	uint8_t  f1bcax_b5_d1;
	uint8_t  f1bcbx_b5_d1;
	uint8_t  f2bc2x_b5_d1;
	uint8_t  f2bc3x_b5_d1;
	uint8_t  f2bc4x_b5_d1;
	uint8_t  f2bc5x_b5_d1;
	uint8_t  f2bc8x_b5_d1;
	uint8_t  f2bc9x_b5_d1;
	uint8_t  f2bcax_b5_d1;
	uint8_t  f2bcbx_b5_d1;
	uint8_t  f3bc2x_b5_d1;
	uint8_t  f3bc3x_b5_d1;
	uint8_t  f3bc4x_b5_d1;
	uint8_t  f3bc5x_b5_d1;
	uint8_t  f3bc8x_b5_d1;
	uint8_t  f3bc9x_b5_d1;
	uint8_t  f3bcax_b5_d1;
	uint8_t  f3bcbx_b5_d1;
	uint8_t  f0bc2x_b6_d1;
	uint8_t  f0bc3x_b6_d1;
	uint8_t  f0bc4x_b6_d1;
	uint8_t  f0bc5x_b6_d1;
	uint8_t  f0bc8x_b6_d1;
	uint8_t  f0bc9x_b6_d1;
	uint8_t  f0bcax_b6_d1;
	uint8_t  f0bcbx_b6_d1;
	uint8_t  f1bc2x_b6_d1;
	uint8_t  f1bc3x_b6_d1;
	uint8_t  f1bc4x_b6_d1;
	uint8_t  f1bc5x_b6_d1;
	uint8_t  f1bc8x_b6_d1;
	uint8_t  f1bc9x_b6_d1;
	uint8_t  f1bcax_b6_d1;
	uint8_t  f1bcbx_b6_d1;
	uint8_t  f2bc2x_b6_d1;
	uint8_t  f2bc3x_b6_d1;
	uint8_t  f2bc4x_b6_d1;
	uint8_t  f2bc5x_b6_d1;
	uint8_t  f2bc8x_b6_d1;
	uint8_t  f2bc9x_b6_d1;
	uint8_t  f2bcax_b6_d1;
	uint8_t  f2bcbx_b6_d1;
	uint8_t  f3bc2x_b6_d1;
	uint8_t  f3bc3x_b6_d1;
	uint8_t  f3bc4x_b6_d1;
	uint8_t  f3bc5x_b6_d1;
	uint8_t  f3bc8x_b6_d1;
	uint8_t  f3bc9x_b6_d1;
	uint8_t  f3bcax_b6_d1;
	uint8_t  f3bcbx_b6_d1;
	uint8_t  f0bc2x_b7_d1;
	uint8_t  f0bc3x_b7_d1;
	uint8_t  f0bc4x_b7_d1;
	uint8_t  f0bc5x_b7_d1;
	uint8_t  f0bc8x_b7_d1;
	uint8_t  f0bc9x_b7_d1;
	uint8_t  f0bcax_b7_d1;
	uint8_t  f0bcbx_b7_d1;
	uint8_t  f1bc2x_b7_d1;
	uint8_t  f1bc3x_b7_d1;
	uint8_t  f1bc4x_b7_d1;
	uint8_t  f1bc5x_b7_d1;
	uint8_t  f1bc8x_b7_d1;
	uint8_t  f1bc9x_b7_d1;
	uint8_t  f1bcax_b7_d1;
	uint8_t  f1bcbx_b7_d1;
	uint8_t  f2bc2x_b7_d1;
	uint8_t  f2bc3x_b7_d1;
	uint8_t  f2bc4x_b7_d1;
	uint8_t  f2bc5x_b7_d1;
	uint8_t  f2bc8x_b7_d1;
	uint8_t  f2bc9x_b7_d1;
	uint8_t  f2bcax_b7_d1;
	uint8_t  f2bcbx_b7_d1;
	uint8_t  f3bc2x_b7_d1;
	uint8_t  f3bc3x_b7_d1;
	uint8_t  f3bc4x_b7_d1;
	uint8_t  f3bc5x_b7_d1;
	uint8_t  f3bc8x_b7_d1;
	uint8_t  f3bc9x_b7_d1;
	uint8_t  f3bcax_b7_d1;
	uint8_t  f3bcbx_b7_d1;
	uint8_t  f0bc2x_b8_d1;
	uint8_t  f0bc3x_b8_d1;
	uint8_t  f0bc4x_b8_d1;
	uint8_t  f0bc5x_b8_d1;
	uint8_t  f0bc8x_b8_d1;
	uint8_t  f0bc9x_b8_d1;
	uint8_t  f0bcax_b8_d1;
	uint8_t  f0bcbx_b8_d1;
	uint8_t  f1bc2x_b8_d1;
	uint8_t  f1bc3x_b8_d1;
	uint8_t  f1bc4x_b8_d1;
	uint8_t  f1bc5x_b8_d1;
	uint8_t  f1bc8x_b8_d1;
	uint8_t  f1bc9x_b8_d1;
	uint8_t  f1bcax_b8_d1;
	uint8_t  f1bcbx_b8_d1;
	uint8_t  f2bc2x_b8_d1;
	uint8_t  f2bc3x_b8_d1;
	uint8_t  f2bc4x_b8_d1;
	uint8_t  f2bc5x_b8_d1;
	uint8_t  f2bc8x_b8_d1;
	uint8_t  f2bc9x_b8_d1;
	uint8_t  f2bcax_b8_d1;
	uint8_t  f2bcbx_b8_d1;
	uint8_t  f3bc2x_b8_d1;
	uint8_t  f3bc3x_b8_d1;
	uint8_t  f3bc4x_b8_d1;
	uint8_t  f3bc5x_b8_d1;
	uint8_t  f3bc8x_b8_d1;
	uint8_t  f3bc9x_b8_d1;
	uint8_t  f3bcax_b8_d1;
	uint8_t  f3bcbx_b8_d1;
	uint8_t  f5bc5x_d1;
	uint8_t  f5bc6x_d1;
	uint8_t  f4bc8x_d1;
	uint8_t  f4bc9x_d1;
	uint8_t  f4bcax_d1;
	uint8_t  f4bcbx_d1;
	uint8_t  f4bccx_d1;
	uint8_t  f4bcdx_d1;
	uint8_t  f4bcex_d1;
	uint8_t  f4bcfx_d1;
	uint8_t  f5bc8x_d1;
	uint8_t  f5bc9x_d1;
	uint8_t  f5bcax_d1;
	uint8_t  f5bcbx_d1;
	uint8_t  f5bccx_d1;
	uint8_t  f5bcdx_d1;
	uint8_t  f5bcex_d1;
	uint8_t  f5bcfx_d1;
	uint8_t  f6bc8x_d1;
	uint8_t  f6bc9x_d1;
	uint8_t  f6bcax_d1;
	uint8_t  f6bcbx_d1;
	uint8_t  f6bccx_d1;
	uint8_t  f6bcdx_d1;
	uint8_t  f6bcex_d1;
	uint8_t  f6bcfx_d1;
	uint8_t  f7bc8x_d1;
	uint8_t  f7bc9x_d1;
	uint8_t  f7bcax_d1;
	uint8_t  f7bcbx_d1;
	uint8_t  f7bccx_d1;
	uint8_t  f7bcdx_d1;
	uint8_t  f7bcex_d1;
	uint8_t  f7bcfx_d1;
	uint16_t alt_cas_l;
	uint8_t  alt_wcas_l;
	uint8_t  d4misc;
} __packed;
#endif
