/* bz-popup-overlay.h
 *
 * Copyright 2026 Eva M
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define BZ_TYPE_POPUP_OVERLAY (bz_popup_overlay_get_type ())
G_DECLARE_FINAL_TYPE (BzPopupOverlay, bz_popup_overlay, BZ, POPUP_OVERLAY, GtkWidget)

BzPopupOverlay *
bz_popup_overlay_new (void);

GtkWidget *
bz_popup_overlay_get_child (BzPopupOverlay *self);

void
bz_popup_overlay_set_child (BzPopupOverlay *self,
                            GtkWidget      *child);

void
bz_popup_overlay_push (BzPopupOverlay *self,
                       GtkWidget      *widget,
                       GtkWidget      *source);

void
bz_popup_present (GtkWidget *popup,
                  GtkWidget *source);

G_END_DECLS

/* End of bz-popup-overlay.h */
