/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Utility classes for the <a href="https://commons.apache.org/bcel/">Apache Byte Code Engineering Library (BCEL)</a>, namely:
 * <ul>
 * <li>Collection classes for JavaClass objects</li>
 * <li>A converter for class files to HTML</li>
 * <li>A tool to find instructions patterns via regular expressions</li>
 * <li>A class to find classes as defined in the CLASSPATH</li>
 * <li>A class loader that allows to create classes at run time</li>
 * </ul>
 */
package org.apache.bcel.util;
