// SPDX-License-Identifier: BSD-3-Clause
/* Copyright (c) 2022, Linaro Limited */

#include <sys/mman.h>
#include <err.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "debugcc.h"

static struct gcc_mux gcc = {
	.mux = {
		.phys = 0x100000,
		.size = 0xb0000,

		.measure = measure_gcc,

		.enable_reg = 0x62000,
		.enable_mask = BIT(16),

		.mux_reg = 0x62000,
		.mux_mask = 0x3ff,

		.div_reg = 0x62000,
		.div_mask = 0xf,
		.div_val = 4,
	},

	.xo_div4_reg = 0x43008,
	.debug_ctl_reg = 0x62004,
	.debug_status_reg = 0x62008,
};

static struct debug_mux mm_cc = {
	.phys = 0xc8c0000,
	.size = 0x40000,
	.block_name = "mm",

	.measure = measure_leaf,
	.parent = &gcc.mux,
	.parent_mux_val = 0x22,

	.enable_reg = 0x900,
	.enable_mask = BIT(16),

	.mux_reg = 0x900,
	.mux_mask = 0x3ff,
};

static struct debug_mux gpu_cc = {
	.phys = 0x5065000,
	.size = 0x9000,
	.block_name = "gpu",

	.measure = measure_leaf,
	.parent = &gcc.mux,
	.parent_mux_val = 0x13d,

	.enable_reg = 0x120,
	.enable_mask = BIT(16),

	.mux_reg = 0x120,
	.mux_mask = 0x3ff,
};

static struct measure_clk msm8998_clocks[] = {
	// { "debug_cpu_clk", &gcc.mux, 0xc0 },

	{ "snoc_clk", &gcc.mux, 0x0 },
	{ "cnoc_clk", &gcc.mux, 0xe },
	{ "bimc_clk", &gcc.mux, 0xa9 },
	{ "ddrss_gcc_dbg_clk", &gcc.mux, 0x14e },
	{ "gcc_mmss_sys_noc_axi_clk", &gcc.mux, 0x1f },
	{ "gcc_mmss_noc_cfg_ahb_clk", &gcc.mux, 0x20 },
	{ "gcc_usb30_master_clk", &gcc.mux, 0x3e },
	{ "gcc_usb30_sleep_clk", &gcc.mux, 0x3f },
	{ "gcc_usb30_mock_utmi_clk", &gcc.mux, 0x40 },
	{ "gcc_usb3_phy_aux_clk", &gcc.mux, 0x41 },
	{ "gcc_usb3_phy_pipe_clk", &gcc.mux, 0x42 },
	{ "gcc_sdcc2_apps_clk", &gcc.mux, 0x46 },
	{ "gcc_sdcc2_ahb_clk", &gcc.mux, 0x47 },
	{ "gcc_sdcc4_apps_clk", &gcc.mux, 0x48 },
	{ "gcc_sdcc4_ahb_clk", &gcc.mux, 0x49 },
	{ "gcc_blsp1_ahb_clk", &gcc.mux, 0x4a },
	{ "gcc_blsp1_qup1_spi_apps_clk", &gcc.mux, 0x4c },
	{ "gcc_blsp1_qup1_i2c_apps_clk", &gcc.mux, 0x4d },
	{ "gcc_blsp1_uart1_apps_clk", &gcc.mux, 0x4e },
	{ "gcc_blsp1_qup2_spi_apps_clk", &gcc.mux, 0x50 },
	{ "gcc_blsp1_qup2_i2c_apps_clk", &gcc.mux, 0x51 },
	{ "gcc_blsp1_uart2_apps_clk", &gcc.mux, 0x52 },
	{ "gcc_blsp1_qup3_spi_apps_clk", &gcc.mux, 0x54 },
	{ "gcc_blsp1_qup3_i2c_apps_clk", &gcc.mux, 0x55 },
	{ "gcc_blsp1_uart3_apps_clk", &gcc.mux, 0x56 },
	{ "gcc_blsp1_qup4_spi_apps_clk", &gcc.mux, 0x58 },
	{ "gcc_blsp1_qup4_i2c_apps_clk", &gcc.mux, 0x59 },
	{ "gcc_blsp1_qup5_spi_apps_clk", &gcc.mux, 0x5a },
	{ "gcc_blsp1_qup5_i2c_apps_clk", &gcc.mux, 0x5b },
	{ "gcc_blsp1_qup6_spi_apps_clk", &gcc.mux, 0x5c },
	{ "gcc_blsp1_qup6_i2c_apps_clk", &gcc.mux, 0x5d },
	{ "gcc_blsp2_ahb_clk", &gcc.mux, 0x5e },
	{ "gcc_blsp2_qup1_spi_apps_clk", &gcc.mux, 0x60 },
	{ "gcc_blsp2_qup1_i2c_apps_clk", &gcc.mux, 0x61 },
	{ "gcc_blsp2_uart1_apps_clk", &gcc.mux, 0x62 },
	{ "gcc_blsp2_qup2_spi_apps_clk", &gcc.mux, 0x64 },
	{ "gcc_blsp2_qup2_i2c_apps_clk", &gcc.mux, 0x65 },
	{ "gcc_blsp2_uart2_apps_clk", &gcc.mux, 0x66 },
	{ "gcc_blsp2_qup3_spi_apps_clk", &gcc.mux, 0x68 },
	{ "gcc_blsp2_qup3_i2c_apps_clk", &gcc.mux, 0x69 },
	{ "gcc_blsp2_uart3_apps_clk", &gcc.mux, 0x6a },
	{ "gcc_blsp2_qup4_spi_apps_clk", &gcc.mux, 0x6c },
	{ "gcc_blsp2_qup4_i2c_apps_clk", &gcc.mux, 0x6d },
	{ "gcc_blsp2_qup5_spi_apps_clk", &gcc.mux, 0x6e },
	{ "gcc_blsp2_qup5_i2c_apps_clk", &gcc.mux, 0x6f },
	{ "gcc_blsp2_qup6_spi_apps_clk", &gcc.mux, 0x70 },
	{ "gcc_blsp2_qup6_i2c_apps_clk", &gcc.mux, 0x71 },
	{ "gcc_pdm_ahb_clk", &gcc.mux, 0x72 },
	{ "gcc_pdm2_clk", &gcc.mux, 0x74},
	{ "gcc_prng_ahb_clk", &gcc.mux, 0x75 },
	{ "gcc_tsif_ahb_clk", &gcc.mux, 0x76 },
	{ "gcc_tsif_ref_clk", &gcc.mux, 0x77 },
	{ "gcc_boot_rom_ahb_clk", &gcc.mux, 0x7a },
	{ "ce1_clk", &gcc.mux, 0x97 },
	{ "gcc_ce1_axi_m_clk", &gcc.mux, 0x98 },
	{ "gcc_ce1_ahb_m_clk", &gcc.mux, 0x99 },
	{ "measure_only_bimc_hmss_axi_clk", &gcc.mux, 0xbb },
	{ "gcc_bimc_gfx_clk", &gcc.mux, 0xac },
	{ "gcc_hmss_rbcpr_clk", &gcc.mux, 0xbc },
	{ "gcc_gp1_clk", &gcc.mux, 0xdf },
	{ "gcc_gp2_clk", &gcc.mux, 0xe0 },
	{ "gcc_gp3_clk", &gcc.mux, 0xe1 },
	{ "gcc_pcie_0_slv_axi_clk", &gcc.mux, 0xe2 },
	{ "gcc_pcie_0_mstr_axi_clk", &gcc.mux, 0xe3 },
	{ "gcc_pcie_0_cfg_ahb_clk", &gcc.mux, 0xe4 },
	{ "gcc_pcie_0_aux_clk", &gcc.mux, 0xe5 },
	{ "gcc_pcie_0_pipe_clk", &gcc.mux, 0xe6 },
	{ "gcc_pcie_phy_aux_clk", &gcc.mux, 0xe8 },
	{ "gcc_ufs_axi_clk", &gcc.mux, 0xea },
	{ "gcc_ufs_ahb_clk", &gcc.mux, 0xeb },
	{ "gcc_ufs_tx_symbol_0_clk", &gcc.mux, 0xec },
	{ "gcc_ufs_rx_symbol_0_clk", &gcc.mux, 0xed },
	{ "gcc_ufs_rx_symbol_1_clk", &gcc.mux, 0x162 },
	{ "gcc_ufs_unipro_core_clk", &gcc.mux, 0xf0 },
	{ "gcc_ufs_ice_core_clk", &gcc.mux, 0xf1 },
	{ "gcc_dcc_ahb_clk", &gcc.mux, 0x119 },
	{ "ipa_clk", &gcc.mux, 0x11b },
	{ "gcc_mss_cfg_ahb_clk", &gcc.mux, 0x11f },
	{ "gcc_mss_q6_bimc_axi_clk", &gcc.mux, 0x124 },
	{ "gcc_mss_mnoc_bimc_axi_clk", &gcc.mux, 0x120 },
	{ "gcc_mss_snoc_axi_clk", &gcc.mux, 0x123 },
	{ "gcc_gpu_cfg_ahb_clk", &gcc.mux, 0x13b },
	{ "gcc_gpu_bimc_gfx_clk", &gcc.mux, 0x13f },
	{ "gcc_qspi_ahb_clk", &gcc.mux, 0x156 },
	{ "gcc_qspi_ref_clk", &gcc.mux, 0x157 },

	{ "mmss_mnoc_ahb_clk", &mm_cc, 0x1 },
	{ "mmss_misc_ahb_clk", &mm_cc, 0x3 },
	{ "mmss_vmem_maxi_clk", &mm_cc, 0x9 },
	{ "mmss_vmem_ahb_clk", &mm_cc, 0xa },
	{ "mmss_bimc_smmu_ahb_clk", &mm_cc, 0xc },
	{ "mmss_bimc_smmu_axi_clk", &mm_cc, 0xd },
	{ "mmss_video_core_clk", &mm_cc, 0xe },
	{ "mmss_video_axi_clk", &mm_cc, 0xf },
	{ "mmss_video_maxi_clk", &mm_cc, 0x10 },
	{ "mmss_video_ahb_clk", &mm_cc, 0x11 },
	{ "mmss_mdss_rot_clk", &mm_cc, 0x12 },
	{ "mmss_snoc_dvm_axi_clk", &mm_cc, 0x13 },
	{ "mmss_mdss_mdp_clk", &mm_cc, 0x14 },
	{ "mmss_mdss_mdp_lut_clk", &mm_cc, 0x15 },
	{ "mmss_mdss_pclk0_clk", &mm_cc, 0x16 },
	{ "mmss_mdss_pclk1_clk", &mm_cc, 0x17 },
	{ "mmss_mdss_extpclk_clk", &mm_cc, 0x18 },
	{ "mmss_video_subcore0_clk", &mm_cc, 0x1a },
	{ "mmss_video_subcore1_clk", &mm_cc, 0x1b },
	{ "mmss_mdss_vsync_clk", &mm_cc, 0x1c },
	{ "mmss_mdss_hdmi_clk", &mm_cc, 0x1d },
	{ "mmss_mdss_byte0_clk", &mm_cc, 0x1e },
	{ "mmss_mdss_byte1_clk", &mm_cc, 0x1f },
	{ "mmss_mdss_esc0_clk", &mm_cc, 0x20 },
	{ "mmss_mdss_esc1_clk", &mm_cc, 0x21 },
	{ "mmss_mdss_ahb_clk", &mm_cc, 0x22 },
	{ "mmss_mdss_hdmi_dp_ahb_clk", &mm_cc, 0x23 },
	{ "mmss_mdss_axi_clk", &mm_cc, 0x24 },
	{ "mmss_camss_top_ahb_clk", &mm_cc, 0x25 },
	{ "mmss_camss_micro_ahb_clk", &mm_cc, 0x26 },
	{ "mmss_camss_gp0_clk", &mm_cc, 0x27 },
	{ "mmss_camss_gp1_clk", &mm_cc, 0x28 },
	{ "mmss_camss_mclk0_clk", &mm_cc, 0x29 },
	{ "mmss_camss_mclk1_clk", &mm_cc, 0x2a },
	{ "mmss_camss_mclk2_clk", &mm_cc, 0x2b },
	{ "mmss_camss_mclk3_clk", &mm_cc, 0x2c },
	{ "mmss_camss_cci_clk", &mm_cc, 0x2d },
	{ "mmss_camss_cci_ahb_clk", &mm_cc, 0x2e },
	{ "mmss_camss_csi0phytimer_clk", &mm_cc, 0x2f },
	{ "mmss_camss_csi1phytimer_clk", &mm_cc, 0x30 },
	{ "mmss_camss_csi2phytimer_clk", &mm_cc, 0x31 },
	{ "mmss_camss_jpeg0_clk", &mm_cc, 0x32 },
	{ "mmss_camss_ispif_ahb_clk", &mm_cc, 0x33 },
	{ "mmss_camss_jpeg_ahb_clk", &mm_cc, 0x35 },
	{ "mmss_camss_jpeg_axi_clk", &mm_cc, 0x36 },
	{ "mmss_camss_ahb_clk", &mm_cc, 0x37 },
	{ "mmss_camss_vfe0_clk", &mm_cc, 0x38 },
	{ "mmss_camss_vfe1_clk", &mm_cc, 0x39 },
	{ "mmss_camss_cpp_clk", &mm_cc, 0x3a },
	{ "mmss_camss_cpp_ahb_clk", &mm_cc, 0x3b },
	{ "mmss_camss_csi_vfe0_clk", &mm_cc, 0x3f },
	{ "mmss_camss_csi_vfe1_clk", &mm_cc, 0x40 },
	{ "mmss_camss_csi0_clk", &mm_cc, 0x41 },
	{ "mmss_camss_csi0_ahb_clk", &mm_cc, 0x42 },
	{ "mmss_camss_csiphy0_clk", &mm_cc, 0x43 },
	{ "mmss_camss_csi0rdi_clk", &mm_cc, 0x44 },
	{ "mmss_camss_csi0pix_clk", &mm_cc, 0x45 },
	{ "mmss_camss_csi1_clk", &mm_cc, 0x46 },
	{ "mmss_camss_csi1_ahb_clk", &mm_cc, 0x47 },
	{ "mmss_camss_csi1rdi_clk", &mm_cc, 0x49 },
	{ "mmss_camss_csi1pix_clk", &mm_cc, 0x4a },
	{ "mmss_camss_csi2_clk", &mm_cc, 0x4b },
	{ "mmss_camss_csi2_ahb_clk", &mm_cc, 0x4c },
	{ "mmss_camss_csi2rdi_clk", &mm_cc, 0x4e },
	{ "mmss_camss_csi2pix_clk", &mm_cc, 0x4f },
	{ "mmss_camss_csi3_clk", &mm_cc, 0x50 },
	{ "mmss_camss_csi3_ahb_clk", &mm_cc, 0x51 },
	{ "mmss_camss_csi3rdi_clk", &mm_cc, 0x53 },
	{ "mmss_camss_csi3pix_clk", &mm_cc, 0x54 },
	{ "mmss_mnoc_maxi_clk", &mm_cc, 0x70 },
	{ "mmss_camss_vfe0_stream_clk", &mm_cc, 0x71 },
	{ "mmss_camss_vfe1_stream_clk", &mm_cc, 0x72 },
	{ "mmss_camss_cpp_vbif_ahb_clk", &mm_cc, 0x73 },
	{ "mmss_misc_cxo_clk", &mm_cc, 0x77 },
	{ "mmss_camss_cpp_axi_clk", &mm_cc, 0x7a },
	{ "mmss_camss_csiphy1_clk", &mm_cc, 0x85 },
	{ "mmss_camss_vfe0_ahb_clk", &mm_cc, 0x86 },
	{ "mmss_camss_vfe1_ahb_clk", &mm_cc, 0x87 },
	{ "mmss_camss_csiphy2_clk", &mm_cc, 0x88 },
	{ "mmss_fd_core_clk", &mm_cc, 0x89 },
	{ "mmss_fd_core_uar_clk", &mm_cc, 0x8a },
	{ "mmss_fd_ahb_clk", &mm_cc, 0x8c },
	{ "mmss_camss_cphy_csid0_clk", &mm_cc, 0x8d },
	{ "mmss_camss_cphy_csid1_clk", &mm_cc, 0x8e },
	{ "mmss_camss_cphy_csid2_clk", &mm_cc, 0x8f },
	{ "mmss_camss_cphy_csid3_clk", &mm_cc, 0x90 },
	{ "mmss_mdss_dp_link_clk", &mm_cc, 0x98 },
	{ "mmss_mdss_dp_link_intf_clk", &mm_cc, 0x99 },
	{ "mmss_mdss_dp_crypto_clk", &mm_cc, 0x9a },
	{ "mmss_mdss_dp_pixel_clk", &mm_cc, 0x9b },
	{ "mmss_mdss_dp_aux_clk", &mm_cc, 0x9c },
	{ "mmss_mdss_dp_gtc_clk", &mm_cc, 0x9d },
	{ "mmss_mdss_byte0_intf_clk", &mm_cc, 0xad },
	{ "mmss_mdss_byte1_intf_clk", &mm_cc, 0xae },

	{ "gpucc_rbcpr_clk", &gpu_cc, 0x3 },
	{ "gpucc_rbbmtimer_clk", &gpu_cc, 0x5 },
	{ "gpucc_gfx3d_isense_clk", &gpu_cc, 0xa },
	{}
};

struct debugcc_platform msm8998_debugcc = {
	"msm8998",
	msm8998_clocks,
};
