# ANUPQ, chapter 4
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("anupq02.tst");

# doc/non-interact.xml:112-134
gap> LoadPackage("anupq");; # does nothing if ANUPQ is already loaded
gap> # First we get a p-quotient of a free group of rank 2
gap> F := FreeGroup("a", "b");; a := F.1;; b := F.2;;
gap> Pq( F : Prime := 2, ClassBound := 3 ); 
<pc group of size 1024 with 10 generators>
gap> # Now let us get a p-quotient of an fp group
gap> G := F / [a^4, b^4];
<fp group on the generators [ a, b ]>
gap> Pq( G : Prime := 2, ClassBound := 3 ); 
<pc group of size 256 with 8 generators>
gap> # Now let's get a different p-quotient of the same group
gap> Pq( G : Prime := 2, ClassBound := 3, Exponent := 4 ); 
<pc group of size 128 with 7 generators>
gap> # Now we'll get a p-quotient of another fp group
gap> # which we will redo using the `Relators' option
gap> R := [ a^25, Comm(Comm(b, a), a), b^5 ];
[ a^25, a^-1*b^-1*a*b*a^-1*b^-1*a^-1*b*a^2, b^5 ]
gap> H := F / R;
<fp group on the generators [ a, b ]>
gap> Pq( H : Prime := 5, ClassBound := 5, Metabelian );
<pc group of size 78125 with 7 generators>

# doc/non-interact.xml:146-160
gap> F := FreeGroup("a", "b");;
gap> # `F' was defined for `Relators'. We use the same strings that GAP uses
gap> # for printing the free group generators. It is *not* necessary to
gap> # predefine: a := F.1; etc. (as it was above).
gap> rels := [ "a^25", "[b, a, a]", "b^5" ];
[ "a^25", "[b, a, a]", "b^5" ]
gap> R := PqGAPRelators(F, rels);
[ a^25, a^-1*b^-1*a*b*a^-1*b^-1*a^-1*b*a^2, b^5 ]
gap> H := F / R;
<fp group on the generators [ a, b ]>
gap> Pq( H : Prime := 5, ClassBound := 5, Metabelian, 
>            Relators := rels );
<pc group of size 78125 with 7 generators>

# doc/non-interact.xml:165-172
gap> F := FreeGroup("a", "b");;
gap> rels := [ "a^25", "[b, a, a]", "b^5" ];
[ "a^25", "[b, a, a]", "b^5" ]
gap> Pq( F : Prime := 5, ClassBound := 5, Metabelian, 
>            Relators := rels );
<pc group of size 78125 with 7 generators>

# doc/non-interact.xml:181-184
gap> Pq( H, rec( Prime := 5, ClassBound := 5, Metabelian := true ) );
<pc group of size 78125 with 7 generators>

# doc/non-interact.xml:190-193
gap> Pq( H, "Prime", 5, "ClassBound", 5, "Metabelian" );
<pc group of size 78125 with 7 generators>

# doc/non-interact.xml:212-225
gap> F := FreeGroup(2);
<free group on the generators [ f1, f2 ]>
gap> Burnside5 := x->x^5;
function( x ) ... end
gap> Engel3 := function( x,y ) return PqLeftNormComm( [x,y,y,y] ); end;
function( x, y ) ... end
gap> Pq( F : Prime := 5, Identities := [ Burnside5, Engel3 ] );
#I  Class 1 with 2 generators.
#I  Class 2 with 3 generators.
#I  Class 3 with 5 generators.
#I  Class 3 with 5 generators.
<pc group of size 3125 with 5 generators>

# doc/non-interact.xml:256-263
gap> F := FreeGroup (2, "F");
<free group on the generators [ F1, F2 ]>
gap> phi := PqEpimorphism( F : Prime := 5, ClassBound := 2 );
[ F1, F2 ] -> [ f1, f2 ]
gap> Image( phi );
<pc group of size 3125 with 5 generators>

# doc/non-interact.xml:306-337
gap> F := FreeGroup("a", "b");; a := F.1;; b := F.2;;
gap> PqPCover( F : Prime := 2, ClassBound := 3 );
<pc group of size 262144 with 18 generators>
gap> 
gap> # Now let's get a p-cover of a p-quotient of an fp group
gap> G := F / [a^4, b^4];
<fp group on the generators [ a, b ]>
gap> PqPCover( G : Prime := 2, ClassBound := 3 );
<pc group of size 16384 with 14 generators>
gap> 
gap> # Now let's get a p-cover of a different p-quotient of the same group
gap> PqPCover( G : Prime := 2, ClassBound := 3, Exponent := 4 );
<pc group of size 8192 with 13 generators>
gap> 
gap> # Now we'll get a p-cover of a p-quotient of another fp group
gap> # which we will redo using the `Relators' option
gap> R := [ a^25, Comm(Comm(b, a), a), b^5 ];
[ a^25, a^-1*b^-1*a*b*a^-1*b^-1*a^-1*b*a^2, b^5 ]
gap> H := F / R;
<fp group on the generators [ a, b ]>
gap> PqPCover( H : Prime := 5, ClassBound := 5, Metabelian );
<pc group of size 48828125 with 11 generators>
gap> 
gap> # Now we redo the previous example using the `Relators' option
gap> F := FreeGroup("a", "b");;
gap> rels := [ "a^25", "[b, a, a]", "b^5" ];
[ "a^25", "[b, a, a]", "b^5" ]
gap> PqPCover( F : Prime := 5, ClassBound := 5, Metabelian, 
>                  Relators := rels );
<pc group of size 48828125 with 11 generators>

# doc/non-interact.xml:434-462
gap> F := FreeGroup( "a", "b" );; a := F.1;; b := F.2;;
gap> G := F / [a^25, Comm(Comm(b, a), a), b^5];
<fp group on the generators [ a, b ]>
gap> S := StandardPresentation( G : Prime := 5, ClassBound := 10 );
<fp group on the generators [ f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, 
  f12, f13, f14, f15, f16, f17, f18, f19, f20, f21, f22, f23, f24, f25, f26 ]>
gap> IsPcGroup( S );
false
gap> # if we need to compute with S we should convert it to a pc group
gap> Spc := PcGroupFpGroup( S );
<pc group of size 1490116119384765625 with 26 generators>
gap> 
gap> H := F / [ a^625, Comm(Comm(Comm(Comm(b, a), a), a), a)/Comm(b, a)^5,
>               Comm(Comm(b, a), b), b^625 ];;
gap> StandardPresentation( H : Prime := 5, ClassBound := 15, Metabelian );
<fp group on the generators [ f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, 
  f12, f13, f14, f15, f16, f17, f18, f19, f20 ]>
gap> 
gap> F4 := FreeGroup( "a", "b", "c", "d" );;
gap> a := F4.1;; b := F4.2;; c := F4.3;; d := F4.4;;
gap> G4 := F4 / [ b^4, b^2 / Comm(Comm (b, a), a), d^16,
>                 a^16 / (c * d), b^8 / (d * c^4) ];
<fp group on the generators [ a, b, c, d ]>
gap> K := Pq( G4 : Prime := 2, ClassBound := 1 );
<pc group of size 4 with 2 generators>
gap> StandardPresentation( G4 : pQuotient := K, ClassBound := 14 );
<fp group with 53 generators>

# doc/non-interact.xml:491-521
gap> F := FreeGroup(6, "F");
<free group on the generators [ F1, F2, F3, F4, F5, F6 ]>
gap> # For printing GAP uses the symbols F1, ... for the generators of F
gap> x := F.1;; y := F.2;; z := F.3;; w := F.4;; a := F.5;; b := F.6;;
gap> R := [x^3 / w, y^3 / w * a^2 * b^2, w^3 / b,
>          Comm (y, x) / z, Comm (z, x), Comm (z, y) / a, z^3 ];;
gap> Q := F / R;
<fp group on the generators [ F1, F2, F3, F4, F5, F6 ]>
gap> # For printing GAP also uses the symbols F1, ... for the generators of Q
gap> # (the same as used for F) ... but the gen'rs of Q and F are different:
gap> GeneratorsOfGroup(F) = GeneratorsOfGroup(Q);
false
gap> G := Pq( Q : Prime := 3, ClassBound := 3 );
<pc group of size 729 with 6 generators>
gap> phi := EpimorphismStandardPresentation( Q : Prime := 3,
>                                                ClassBound := 3 );
[ F1, F2, F3, F4, F5, F6 ] -> [ f1*f2^2*f3*f4^2*f5^2, f1*f2*f3*f5, f3^2, 
  f4*f6^2, f5, f6 ]
gap> Source(phi); # This is the group Q (GAP uses F1, ... for gen'r symbols)
<fp group of size infinity on the generators [ F1, F2, F3, F4, F5, F6 ]>
gap> Range(phi);  # This is the group G (GAP uses f1, ... for gen'r symbols)
<fp group on the generators [ f1, f2, f3, f4, f5, f6 ]>
gap> AssignGeneratorVariables(G);
#I  Assigned the global variables [ f1, f2, f3, f4, f5, f6 ]
gap> # Just to see that the images of [F1, ..., F6] do generate G
gap> Group([ f1*f2^2*f3, f1*f2*f3*f4*f5^2*f6^2, f3^2, f4, f5, f6 ]) = G;
true
gap> Size( Image(phi) );
729

# doc/non-interact.xml:545-562
gap> G := Group( (1,2,3,4), (1,3) );
Group([ (1,2,3,4), (1,3) ])
gap> P1 := Image( IsomorphismPcGroup( G ) );
Group([ f1, f2, f3 ])
gap> P2 := ElementaryAbelianGroup( 8 );
<pc group of size 8 with 3 generators>
gap> IsIsomorphicPGroup( P1, P2 );
false
gap> P3 := QuaternionGroup( 8 );
<pc group of size 8 with 3 generators>
gap> IsIsomorphicPGroup( P1, P3 );
false
gap> P4 := DihedralGroup( 8 );
<pc group of size 8 with 3 generators>
gap> IsIsomorphicPGroup( P1, P4 );
true

# doc/non-interact.xml:674-692
gap> F := FreeGroup( "a", "b" );; a := F.1;; b := F.2;;
gap> G := PcGroupFpGroup( F / [ a^2, b^2, Comm(b, a) ] );
<pc group of size 4 with 2 generators>
gap> des := PqDescendants( G : OrderBound := 6, ClassBound := 5 );;
gap> Length(des);
83
gap> List(des, Size); 
[ 8, 8, 8, 16, 16, 16, 32, 16, 16, 16, 16, 16, 32, 32, 64, 64, 32, 32, 32, 
  32, 32, 32, 32, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 32, 32, 32, 32, 
  64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 32, 32, 32, 32, 32, 64, 64, 64, 
  64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 
  64, 64, 64, 64, 64, 64, 64 ]
gap> List(des, d -> Length( PCentralSeries( d, 2 ) ) - 1 );
[ 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
  4, 4, 4, 5, 5, 5, 5, 5 ]

# doc/non-interact.xml:697-713
gap> F := FreeGroup( 2, "g" );
<free group on the generators [ g1, g2 ]>
gap> G := PcGroupFpGroup( F / [ F.1^3, F.2^3, Comm(F.1, F.2) ] );
<pc group of size 9 with 2 generators>
gap> des := PqDescendants( G : OrderBound := 3, ClassBound := 2,
>                              CapableDescendants );
[ <pc group of size 27 with 3 generators>, 
  <pc group of size 27 with 3 generators> ]
gap> List(des, d -> Length( PCentralSeries( d, 3 ) ) - 1 );
[ 2, 2 ]
gap> # For comparison let us now compute all proper descendants
gap> PqDescendants( G : OrderBound := 3, ClassBound := 2);
[ <pc group of size 27 with 3 generators>, 
  <pc group of size 27 with 3 generators>, 
  <pc group of size 27 with 3 generators> ]

# doc/non-interact.xml:719-734
gap> F := FreeGroup( 2, "g" );;
gap> G := PcGroupFpGroup( F / [ F.1^5, F.2^5, Comm(F.2, F.1) ] );
<pc group of size 25 with 2 generators>
gap> des := PqDescendants( G : Metabelian, ClassBound := 3,
>                              Exponent := 5, CapableDescendants );
[ <pc group of size 125 with 3 generators>, 
  <pc group of size 625 with 4 generators>, 
  <pc group of size 3125 with 5 generators> ]
gap> List(des, d -> Length( PCentralSeries( d, 5 ) ) - 1 );
[ 2, 3, 3 ]
gap> List(des, d -> Length( DerivedSeries( d ) ) );
[ 3, 3, 3 ]
gap> List(des, d -> Maximum( List( d, Order ) ) );
[ 5, 5, 5 ]

# doc/non-interact.xml:762-784
gap> Q := Pq( FreeGroup(2) : Prime := 3, ClassBound := 1 );
<pc group of size 9 with 2 generators>
gap> des := PqDescendants( Q : StepSize := 1 );
[ <pc group of size 27 with 3 generators>, 
  <pc group of size 27 with 3 generators>, 
  <pc group of size 27 with 3 generators> ]
gap> S := PqSupplementInnerAutomorphisms( des[3] );
rec( agAutos := [  ], agOrder := [ 3, 2, 2, 2 ], 
  glAutos := [ Pcgs([ f1, f2, f3 ]) -> [ f1*f2^2, f2, f3 ], 
      Pcgs([ f1, f2, f3 ]) -> [ f1^2, f2, f3^2 ], 
      Pcgs([ f1, f2, f3 ]) -> [ f1^2, f2, f3^2 ] ] )
gap> A := AutomorphismGroupPGroup( des[3] );
rec( 
  agAutos := [ Pcgs([ f1, f2, f3 ]) -> [ f1^2, f2, f3^2 ], 
      Pcgs([ f1, f2, f3 ]) -> [ f1*f2^2, f2, f3 ], 
      Pcgs([ f1, f2, f3 ]) -> [ f1*f3, f2, f3 ], 
      Pcgs([ f1, f2, f3 ]) -> [ f1, f2*f3, f3 ] ], agOrder := [ 2, 3, 3, 3 ], 
  glAutos := [  ], glOper := [  ], glOrder := 1, 
  group := <pc group of size 27 with 3 generators>, 
  one := IdentityMapping( <pc group of size 27 with 3 generators> ), 
  size := 54 )

#
gap> STOP_TEST("anupq02.tst", 1);
