% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merList.R
\name{ranef.merModList}
\alias{ranef.merModList}
\title{Extract random-effects estimates for a merModList}
\usage{
\method{ranef}{merModList}(object, ...)
}
\arguments{
\item{object}{a \code{\link{merModList}} list fitted models with random effects}

\item{...}{some methods for these generic functions
    require additional arguments.}
}
\value{
a named, numeric vector of random-effects estimates.
}
\description{
Extract random-effects estimates for a merModList
}
\details{
Extract the estimates of the random-effects parameters from a list of
fitted \code{\link[lme4]{merMod}} models. Takes the mean of the individual \code{ranef}
objects for each of the component models in the \code{\link{merModList}}.
}
\examples{
\donttest{
sim_list <- replicate(n = 10,
        expr = sleepstudy[sample(row.names(sleepstudy), 180),],
        simplify=FALSE)
fml <- "Reaction ~ Days + (Days | Subject)"
mod <- lmerModList(fml, data = sim_list)
ranef(mod)
}
}
