/*
 * ABOUTME: Shared infrastructure for TXT-like DNS resource records.
 * ABOUTME: Provides parsing, formatting, and wire format generation for character-string based RR types.
 *
 * Part of DNS zone file validator `validns`.
 *
 * Copyright 2025 OARC, Inc.
 * Copyright 2011-2025 Anton Berezin <tobez@tobez.org>
 * Modified BSD license.
 * (See LICENSE file in the distribution.)
 *
 */
#ifndef _TXTLIKE_H
#define _TXTLIKE_H 1

#include "rr.h"

/*
 * Parse a TXT-like record (one or more character-strings).
 *
 * @param name - record name
 * @param ttl - TTL value
 * @param type - RR type number
 * @param s - text to parse (modified)
 * @param type_name - type name for error messages (e.g., "TXT", "SPF", "WALLET")
 * @return parsed record or NULL on error
 */
struct rr *txtlike_parse(char *name, long ttl, int type, char *s, const char *type_name);

/*
 * Format a TXT-like record for human consumption.
 * Uses struct rr_txtlike.
 *
 * @param rrv - pointer to struct rr (cast to rr_txtlike internally)
 * @return human-readable string (temp memory)
 */
char *txtlike_human(struct rr *rrv);

/*
 * Generate wire format for a TXT-like record.
 * Uses struct rr_txtlike.
 *
 * @param rrv - pointer to struct rr (cast to rr_txtlike internally)
 * @return binary wire data
 */
struct binary_data txtlike_wirerdata(struct rr *rrv);

#endif /* _TXTLIKE_H */
