/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2025 Advanced Micro Devices, Inc.
 */

#ifndef _ISP4_HW_REG_H_
#define _ISP4_HW_REG_H_

#include <linux/io.h>
#include <linux/types.h>

#define ISP_SOFT_RESET			0x62000
#define ISP_SYS_INT0_EN			0x62010
#define ISP_SYS_INT0_STATUS		0x62014
#define ISP_SYS_INT0_ACK		0x62018
#define ISP_CCPU_CNTL			0x62054
#define ISP_STATUS			0x62058
#define ISP_LOG_RB_BASE_LO0		0x62148
#define ISP_LOG_RB_BASE_HI0		0x6214c
#define ISP_LOG_RB_SIZE0		0x62150
#define ISP_LOG_RB_RPTR0		0x62154
#define ISP_LOG_RB_WPTR0		0x62158
#define ISP_RB_BASE_LO1			0x62170
#define ISP_RB_BASE_HI1			0x62174
#define ISP_RB_SIZE1			0x62178
#define ISP_RB_RPTR1			0x6217c
#define ISP_RB_WPTR1			0x62180
#define ISP_RB_BASE_LO2			0x62184
#define ISP_RB_BASE_HI2			0x62188
#define ISP_RB_SIZE2			0x6218c
#define ISP_RB_RPTR2			0x62190
#define ISP_RB_WPTR2			0x62194
#define ISP_RB_BASE_LO3			0x62198
#define ISP_RB_BASE_HI3			0x6219c
#define ISP_RB_SIZE3			0x621a0
#define ISP_RB_RPTR3			0x621a4
#define ISP_RB_WPTR3			0x621a8
#define ISP_RB_BASE_LO4			0x621ac
#define ISP_RB_BASE_HI4			0x621b0
#define ISP_RB_SIZE4			0x621b4
#define ISP_RB_RPTR4			0x621b8
#define ISP_RB_WPTR4			0x621bc
#define ISP_RB_BASE_LO5			0x621c0
#define ISP_RB_BASE_HI5			0x621c4
#define ISP_RB_SIZE5			0x621c8
#define ISP_RB_RPTR5			0x621cc
#define ISP_RB_WPTR5			0x621d0
#define ISP_RB_BASE_LO6			0x621d4
#define ISP_RB_BASE_HI6			0x621d8
#define ISP_RB_SIZE6			0x621dc
#define ISP_RB_RPTR6			0x621e0
#define ISP_RB_WPTR6			0x621e4
#define ISP_RB_BASE_LO7			0x621e8
#define ISP_RB_BASE_HI7			0x621ec
#define ISP_RB_SIZE7			0x621f0
#define ISP_RB_RPTR7			0x621f4
#define ISP_RB_WPTR7			0x621f8
#define ISP_RB_BASE_LO8			0x621fc
#define ISP_RB_BASE_HI8			0x62200
#define ISP_RB_SIZE8			0x62204
#define ISP_RB_RPTR8			0x62208
#define ISP_RB_WPTR8			0x6220c
#define ISP_RB_BASE_LO9			0x62210
#define ISP_RB_BASE_HI9			0x62214
#define ISP_RB_SIZE9			0x62218
#define ISP_RB_RPTR9			0x6221c
#define ISP_RB_WPTR9			0x62220
#define ISP_RB_BASE_LO10		0x62224
#define ISP_RB_BASE_HI10		0x62228
#define ISP_RB_SIZE10			0x6222c
#define ISP_RB_RPTR10			0x62230
#define ISP_RB_WPTR10			0x62234
#define ISP_RB_BASE_LO11		0x62238
#define ISP_RB_BASE_HI11		0x6223c
#define ISP_RB_SIZE11			0x62240
#define ISP_RB_RPTR11			0x62244
#define ISP_RB_WPTR11			0x62248
#define ISP_RB_BASE_LO12		0x6224c
#define ISP_RB_BASE_HI12		0x62250
#define ISP_RB_SIZE12			0x62254
#define ISP_RB_RPTR12			0x62258
#define ISP_RB_WPTR12			0x6225c

#define ISP_POWER_STATUS		0x60000

/* ISP_SOFT_RESET */
#define ISP_SOFT_RESET__CCPU_SOFT_RESET_MASK			0x00000001UL

/* ISP_CCPU_CNTL */
#define ISP_CCPU_CNTL__CCPU_HOST_SOFT_RST_MASK			0x00040000UL

/* ISP_STATUS */
#define ISP_STATUS__CCPU_REPORT_MASK				0x000000feUL

/* ISP_SYS_INT0_STATUS */
#define ISP_SYS_INT0_STATUS__SYS_INT_RINGBUFFER_WPT9_INT_MASK	0x00010000UL
#define ISP_SYS_INT0_STATUS__SYS_INT_RINGBUFFER_WPT10_INT_MASK	0x00040000UL
#define ISP_SYS_INT0_STATUS__SYS_INT_RINGBUFFER_WPT11_INT_MASK	0x00100000UL
#define ISP_SYS_INT0_STATUS__SYS_INT_RINGBUFFER_WPT12_INT_MASK	0x00400000UL

/* ISP_SYS_INT0_EN */
#define ISP_SYS_INT0_EN__SYS_INT_RINGBUFFER_WPT9_EN_MASK	0x00010000UL
#define ISP_SYS_INT0_EN__SYS_INT_RINGBUFFER_WPT10_EN_MASK	0x00040000UL
#define ISP_SYS_INT0_EN__SYS_INT_RINGBUFFER_WPT11_EN_MASK	0x00100000UL
#define ISP_SYS_INT0_EN__SYS_INT_RINGBUFFER_WPT12_EN_MASK	0x00400000UL

/* ISP_SYS_INT0_ACK */
#define ISP_SYS_INT0_ACK__SYS_INT_RINGBUFFER_WPT9_ACK_MASK	0x00010000UL
#define ISP_SYS_INT0_ACK__SYS_INT_RINGBUFFER_WPT10_ACK_MASK	0x00040000UL
#define ISP_SYS_INT0_ACK__SYS_INT_RINGBUFFER_WPT11_ACK_MASK	0x00100000UL
#define ISP_SYS_INT0_ACK__SYS_INT_RINGBUFFER_WPT12_ACK_MASK	0x00400000UL

/* Helper functions for reading isp registers */
static inline u32 isp4hw_rreg(void __iomem *base, u32 reg)
{
	return readl(base + reg);
}

/* Helper functions for writing isp registers */
static inline void isp4hw_wreg(void __iomem *base, u32 reg, u32 val)
{
	return writel(val, base + reg);
}

#endif
