// This file was generated by go generate; DO NOT EDIT

package currency

import "golang.org/x/text/internal/tag"

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "28"

const (
	xxx = 282
	xts = 280
	usd = 249
	eur = 92
	jpy = 131
	gbp = 97
	chf = 60
	aud = 19
	nzd = 190
	cad = 57
	sek = 217
	nok = 188
	dkk = 80
	xag = 263
	xau = 264
	xpt = 277
	xpd = 275
	brl = 46
	cny = 66
	inr = 123
	rub = 208
	hkd = 112
	idr = 118
	krw = 139
	mxn = 176
	pln = 199
	sar = 211
	thb = 232
	try = 241
	twd = 243
	zar = 290
)

// currency holds an alphabetically sorted list of canonical 3-letter currency
// identifiers. Each identifier is followed by a byte of type currencyInfo,
// defined in gen_common.go.
var currency tag.Index = "" + // Size: 1196 bytes
	"\x00\x00\x00\x00ADP\x09AED\x00AFA\x00AFN\x09ALK\x00ALL\x09AMD\x09ANG\x00" +
	"AOA\x00AOK\x00AON\x00AOR\x00ARA\x00ARL\x00ARM\x00ARP\x00ARS\x00ATS\x00AU" +
	"D\x00AWG\x00AZM\x00AZN\x00BAD\x00BAM\x00BAN\x00BBD\x00BDT\x00BEC\x00BEF" +
	"\x00BEL\x00BGL\x00BGM\x00BGN\x00BGO\x00BHD\x1bBIF\x09BMD\x00BND\x00BOB" +
	"\x00BOL\x00BOP\x00BOV\x00BRB\x00BRC\x00BRE\x00BRL\x00BRN\x00BRR\x00BRZ" +
	"\x00BSD\x00BTN\x00BUK\x00BWP\x00BYB\x00BYR\x09BZD\x00CAD(CDF\x00CHE\x00C" +
	"HF(CHW\x00CLE\x00CLF$CLP\x09CNX\x00CNY\x00COP\x09COU\x00CRC\x09CSD\x00CS" +
	"K\x00CUC\x00CUP\x00CVE\x00CYP\x00CZK\x08DDM\x00DEM\x00DJF\x09DKK\x00DOP" +
	"\x00DZD\x00ECS\x00ECV\x00EEK\x00EGP\x00ERN\x00ESA\x00ESB\x00ESP\x09ETB" +
	"\x00EUR\x00FIM\x00FJD\x00FKP\x00FRF\x00GBP\x00GEK\x00GEL\x00GHC\x00GHS" +
	"\x00GIP\x00GMD\x00GNF\x09GNS\x00GQE\x00GRD\x00GTQ\x00GWE\x00GWP\x00GYD" +
	"\x09HKD\x00HNL\x00HRD\x00HRK\x00HTG\x00HUF\x08IDR\x09IEP\x00ILP\x00ILR" +
	"\x00ILS\x00INR\x00IQD\x09IRR\x09ISJ\x00ISK\x09ITL\x09JMD\x00JOD\x1bJPY" +
	"\x09KES\x00KGS\x00KHR\x00KMF\x09KPW\x09KRH\x00KRO\x00KRW\x09KWD\x1bKYD" +
	"\x00KZT\x00LAK\x09LBP\x09LKR\x00LRD\x00LSL\x00LTL\x00LTT\x00LUC\x00LUF" +
	"\x09LUL\x00LVL\x00LVR\x00LYD\x1bMAD\x00MAF\x00MCF\x00MDC\x00MDL\x00MGA" +
	"\x09MGF\x09MKD\x00MKN\x00MLF\x00MMK\x09MNT\x09MOP\x00MRO\x09MTL\x00MTP" +
	"\x00MUR\x09MVP\x00MVR\x00MWK\x00MXN\x00MXP\x00MXV\x00MYR\x00MZE\x00MZM" +
	"\x00MZN\x00NAD\x00NGN\x00NIC\x00NIO\x00NLG\x00NOK\x00NPR\x00NZD\x00OMR" +
	"\x1bPAB\x00PEI\x00PEN\x00PES\x00PGK\x00PHP\x00PKR\x09PLN\x00PLZ\x00PTE" +
	"\x00PYG\x09QAR\x00RHD\x00ROL\x00RON\x00RSD\x09RUB\x00RUR\x00RWF\x09SAR" +
	"\x00SBD\x00SCR\x00SDD\x00SDG\x00SDP\x00SEK\x00SGD\x00SHP\x00SIT\x00SKK" +
	"\x00SLL\x09SOS\x09SRD\x00SRG\x00SSP\x00STD\x09SUR\x00SVC\x00SYP\x09SZL" +
	"\x00THB\x00TJR\x00TJS\x00TMM\x09TMT\x00TND\x1bTOP\x00TPE\x00TRL\x09TRY" +
	"\x00TTD\x00TWD\x08TZS\x09UAH\x00UAK\x00UGS\x00UGX\x09USD\x00USN\x00USS" +
	"\x00UYI\x09UYP\x00UYU\x00UZS\x09VEB\x00VEF\x00VND\x09VNN\x00VUV\x09WST" +
	"\x00XAF\x09XAG\x00XAU\x00XBA\x00XBB\x00XBC\x00XBD\x00XCD\x00XDR\x00XEU" +
	"\x00XFO\x00XFU\x00XOF\x09XPD\x00XPF\x09XPT\x00XRE\x00XSU\x00XTS\x00XUA" +
	"\x00XXX\x00YDD\x00YER\x09YUD\x00YUM\x00YUN\x00YUR\x00ZAL\x00ZAR\x00ZMK" +
	"\x09ZMW\x00ZRN\x00ZRZ\x00ZWD\x09ZWL\x00ZWR\x00\xff\xff\xff\xff"

const numCurrencies = 297

type toCurrency struct {
	region uint16
	code   uint16
}

var regionToCurrency = []toCurrency{ // 255 elements
	0:   {region: 0x4143, code: 0xdb},
	1:   {region: 0x4144, code: 0x5c},
	2:   {region: 0x4145, code: 0x2},
	3:   {region: 0x4146, code: 0x4},
	4:   {region: 0x4147, code: 0x10d},
	5:   {region: 0x4149, code: 0x10d},
	6:   {region: 0x414c, code: 0x6},
	7:   {region: 0x414d, code: 0x7},
	8:   {region: 0x414f, code: 0x9},
	9:   {region: 0x4152, code: 0x11},
	10:  {region: 0x4153, code: 0xf9},
	11:  {region: 0x4154, code: 0x5c},
	12:  {region: 0x4155, code: 0x13},
	13:  {region: 0x4157, code: 0x14},
	14:  {region: 0x4158, code: 0x5c},
	15:  {region: 0x415a, code: 0x16},
	16:  {region: 0x4241, code: 0x18},
	17:  {region: 0x4242, code: 0x1a},
	18:  {region: 0x4244, code: 0x1b},
	19:  {region: 0x4245, code: 0x5c},
	20:  {region: 0x4246, code: 0x112},
	21:  {region: 0x4247, code: 0x21},
	22:  {region: 0x4248, code: 0x23},
	23:  {region: 0x4249, code: 0x24},
	24:  {region: 0x424a, code: 0x112},
	25:  {region: 0x424c, code: 0x5c},
	26:  {region: 0x424d, code: 0x25},
	27:  {region: 0x424e, code: 0x26},
	28:  {region: 0x424f, code: 0x27},
	29:  {region: 0x4251, code: 0xf9},
	30:  {region: 0x4252, code: 0x2e},
	31:  {region: 0x4253, code: 0x32},
	32:  {region: 0x4254, code: 0x33},
	33:  {region: 0x4256, code: 0xbc},
	34:  {region: 0x4257, code: 0x35},
	35:  {region: 0x4259, code: 0x37},
	36:  {region: 0x425a, code: 0x38},
	37:  {region: 0x4341, code: 0x39},
	38:  {region: 0x4343, code: 0x13},
	39:  {region: 0x4344, code: 0x3a},
	40:  {region: 0x4346, code: 0x106},
	41:  {region: 0x4347, code: 0x106},
	42:  {region: 0x4348, code: 0x3c},
	43:  {region: 0x4349, code: 0x112},
	44:  {region: 0x434b, code: 0xbe},
	45:  {region: 0x434c, code: 0x40},
	46:  {region: 0x434d, code: 0x106},
	47:  {region: 0x434e, code: 0x42},
	48:  {region: 0x434f, code: 0x43},
	49:  {region: 0x4352, code: 0x45},
	50:  {region: 0x4355, code: 0x49},
	51:  {region: 0x4356, code: 0x4a},
	52:  {region: 0x4357, code: 0x8},
	53:  {region: 0x4358, code: 0x13},
	54:  {region: 0x4359, code: 0x5c},
	55:  {region: 0x435a, code: 0x4c},
	56:  {region: 0x4445, code: 0x5c},
	57:  {region: 0x4447, code: 0xf9},
	58:  {region: 0x444a, code: 0x4f},
	59:  {region: 0x444b, code: 0x50},
	60:  {region: 0x444d, code: 0x10d},
	61:  {region: 0x444f, code: 0x51},
	62:  {region: 0x445a, code: 0x52},
	63:  {region: 0x4541, code: 0x5c},
	64:  {region: 0x4543, code: 0xf9},
	65:  {region: 0x4545, code: 0x5c},
	66:  {region: 0x4547, code: 0x56},
	67:  {region: 0x4548, code: 0x9c},
	68:  {region: 0x4552, code: 0x57},
	69:  {region: 0x4553, code: 0x5c},
	70:  {region: 0x4554, code: 0x5b},
	71:  {region: 0x4555, code: 0x5c},
	72:  {region: 0x4649, code: 0x5c},
	73:  {region: 0x464a, code: 0x5e},
	74:  {region: 0x464b, code: 0x5f},
	75:  {region: 0x464d, code: 0xf9},
	76:  {region: 0x464f, code: 0x50},
	77:  {region: 0x4652, code: 0x5c},
	78:  {region: 0x4741, code: 0x106},
	79:  {region: 0x4742, code: 0x61},
	80:  {region: 0x4744, code: 0x10d},
	81:  {region: 0x4745, code: 0x63},
	82:  {region: 0x4746, code: 0x5c},
	83:  {region: 0x4747, code: 0x61},
	84:  {region: 0x4748, code: 0x65},
	85:  {region: 0x4749, code: 0x66},
	86:  {region: 0x474c, code: 0x50},
	87:  {region: 0x474d, code: 0x67},
	88:  {region: 0x474e, code: 0x68},
	89:  {region: 0x4750, code: 0x5c},
	90:  {region: 0x4751, code: 0x106},
	91:  {region: 0x4752, code: 0x5c},
	92:  {region: 0x4753, code: 0x61},
	93:  {region: 0x4754, code: 0x6c},
	94:  {region: 0x4755, code: 0xf9},
	95:  {region: 0x4757, code: 0x112},
	96:  {region: 0x4759, code: 0x6f},
	97:  {region: 0x484b, code: 0x70},
	98:  {region: 0x484d, code: 0x13},
	99:  {region: 0x484e, code: 0x71},
	100: {region: 0x4852, code: 0x73},
	101: {region: 0x4854, code: 0x74},
	102: {region: 0x4855, code: 0x75},
	103: {region: 0x4943, code: 0x5c},
	104: {region: 0x4944, code: 0x76},
	105: {region: 0x4945, code: 0x5c},
	106: {region: 0x494c, code: 0x7a},
	107: {region: 0x494d, code: 0x61},
	108: {region: 0x494e, code: 0x7b},
	109: {region: 0x494f, code: 0xf9},
	110: {region: 0x4951, code: 0x7c},
	111: {region: 0x4952, code: 0x7d},
	112: {region: 0x4953, code: 0x7f},
	113: {region: 0x4954, code: 0x5c},
	114: {region: 0x4a45, code: 0x61},
	115: {region: 0x4a4d, code: 0x81},
	116: {region: 0x4a4f, code: 0x82},
	117: {region: 0x4a50, code: 0x83},
	118: {region: 0x4b45, code: 0x84},
	119: {region: 0x4b47, code: 0x85},
	120: {region: 0x4b48, code: 0x86},
	121: {region: 0x4b49, code: 0x13},
	122: {region: 0x4b4d, code: 0x87},
	123: {region: 0x4b4e, code: 0x10d},
	124: {region: 0x4b50, code: 0x88},
	125: {region: 0x4b52, code: 0x8b},
	126: {region: 0x4b57, code: 0x8c},
	127: {region: 0x4b59, code: 0x8d},
	128: {region: 0x4b5a, code: 0x8e},
	129: {region: 0x4c41, code: 0x8f},
	130: {region: 0x4c42, code: 0x90},
	131: {region: 0x4c43, code: 0x10d},
	132: {region: 0x4c49, code: 0x3c},
	133: {region: 0x4c4b, code: 0x91},
	134: {region: 0x4c52, code: 0x92},
	135: {region: 0x4c53, code: 0x122},
	136: {region: 0x4c54, code: 0x5c},
	137: {region: 0x4c55, code: 0x5c},
	138: {region: 0x4c56, code: 0x5c},
	139: {region: 0x4c59, code: 0x9b},
	140: {region: 0x4d41, code: 0x9c},
	141: {region: 0x4d43, code: 0x5c},
	142: {region: 0x4d44, code: 0xa0},
	143: {region: 0x4d45, code: 0x5c},
	144: {region: 0x4d46, code: 0x5c},
	145: {region: 0x4d47, code: 0xa1},
	146: {region: 0x4d48, code: 0xf9},
	147: {region: 0x4d4b, code: 0xa3},
	148: {region: 0x4d4c, code: 0x112},
	149: {region: 0x4d4d, code: 0xa6},
	150: {region: 0x4d4e, code: 0xa7},
	151: {region: 0x4d4f, code: 0xa8},
	152: {region: 0x4d50, code: 0xf9},
	153: {region: 0x4d51, code: 0x5c},
	154: {region: 0x4d52, code: 0xa9},
	155: {region: 0x4d53, code: 0x10d},
	156: {region: 0x4d54, code: 0x5c},
	157: {region: 0x4d55, code: 0xac},
	158: {region: 0x4d56, code: 0xae},
	159: {region: 0x4d57, code: 0xaf},
	160: {region: 0x4d58, code: 0xb0},
	161: {region: 0x4d59, code: 0xb3},
	162: {region: 0x4d5a, code: 0xb6},
	163: {region: 0x4e41, code: 0xb7},
	164: {region: 0x4e43, code: 0x114},
	165: {region: 0x4e45, code: 0x112},
	166: {region: 0x4e46, code: 0x13},
	167: {region: 0x4e47, code: 0xb8},
	168: {region: 0x4e49, code: 0xba},
	169: {region: 0x4e4c, code: 0x5c},
	170: {region: 0x4e4f, code: 0xbc},
	171: {region: 0x4e50, code: 0xbd},
	172: {region: 0x4e52, code: 0x13},
	173: {region: 0x4e55, code: 0xbe},
	174: {region: 0x4e5a, code: 0xbe},
	175: {region: 0x4f4d, code: 0xbf},
	176: {region: 0x5041, code: 0xc0},
	177: {region: 0x5045, code: 0xc2},
	178: {region: 0x5046, code: 0x114},
	179: {region: 0x5047, code: 0xc4},
	180: {region: 0x5048, code: 0xc5},
	181: {region: 0x504b, code: 0xc6},
	182: {region: 0x504c, code: 0xc7},
	183: {region: 0x504d, code: 0x5c},
	184: {region: 0x504e, code: 0xbe},
	185: {region: 0x5052, code: 0xf9},
	186: {region: 0x5053, code: 0x7a},
	187: {region: 0x5054, code: 0x5c},
	188: {region: 0x5057, code: 0xf9},
	189: {region: 0x5059, code: 0xca},
	190: {region: 0x5141, code: 0xcb},
	191: {region: 0x5245, code: 0x5c},
	192: {region: 0x524f, code: 0xce},
	193: {region: 0x5253, code: 0xcf},
	194: {region: 0x5255, code: 0xd0},
	195: {region: 0x5257, code: 0xd2},
	196: {region: 0x5341, code: 0xd3},
	197: {region: 0x5342, code: 0xd4},
	198: {region: 0x5343, code: 0xd5},
	199: {region: 0x5344, code: 0xd7},
	200: {region: 0x5345, code: 0xd9},
	201: {region: 0x5347, code: 0xda},
	202: {region: 0x5348, code: 0xdb},
	203: {region: 0x5349, code: 0x5c},
	204: {region: 0x534a, code: 0xbc},
	205: {region: 0x534b, code: 0x5c},
	206: {region: 0x534c, code: 0xde},
	207: {region: 0x534d, code: 0x5c},
	208: {region: 0x534e, code: 0x112},
	209: {region: 0x534f, code: 0xdf},
	210: {region: 0x5352, code: 0xe0},
	211: {region: 0x5353, code: 0xe2},
	212: {region: 0x5354, code: 0xe3},
	213: {region: 0x5356, code: 0xf9},
	214: {region: 0x5358, code: 0x8},
	215: {region: 0x5359, code: 0xe6},
	216: {region: 0x535a, code: 0xe7},
	217: {region: 0x5441, code: 0x61},
	218: {region: 0x5443, code: 0xf9},
	219: {region: 0x5444, code: 0x106},
	220: {region: 0x5446, code: 0x5c},
	221: {region: 0x5447, code: 0x112},
	222: {region: 0x5448, code: 0xe8},
	223: {region: 0x544a, code: 0xea},
	224: {region: 0x544b, code: 0xbe},
	225: {region: 0x544c, code: 0xf9},
	226: {region: 0x544d, code: 0xec},
	227: {region: 0x544e, code: 0xed},
	228: {region: 0x544f, code: 0xee},
	229: {region: 0x5452, code: 0xf1},
	230: {region: 0x5454, code: 0xf2},
	231: {region: 0x5456, code: 0x13},
	232: {region: 0x5457, code: 0xf3},
	233: {region: 0x545a, code: 0xf4},
	234: {region: 0x5541, code: 0xf5},
	235: {region: 0x5547, code: 0xf8},
	236: {region: 0x554d, code: 0xf9},
	237: {region: 0x5553, code: 0xf9},
	238: {region: 0x5559, code: 0xfe},
	239: {region: 0x555a, code: 0xff},
	240: {region: 0x5641, code: 0x5c},
	241: {region: 0x5643, code: 0x10d},
	242: {region: 0x5645, code: 0x101},
	243: {region: 0x5647, code: 0xf9},
	244: {region: 0x5649, code: 0xf9},
	245: {region: 0x564e, code: 0x102},
	246: {region: 0x5655, code: 0x104},
	247: {region: 0x5746, code: 0x114},
	248: {region: 0x5753, code: 0x105},
	249: {region: 0x584b, code: 0x5c},
	250: {region: 0x5945, code: 0x11c},
	251: {region: 0x5954, code: 0x5c},
	252: {region: 0x5a41, code: 0x122},
	253: {region: 0x5a4d, code: 0x124},
	254: {region: 0x5a57, code: 0xf9},
} // Size: 1044 bytes

type regionInfo struct {
	region uint16
	code   uint16
	from   uint32
	to     uint32
}

var regionData = []regionInfo{ // 492 elements
	0:   {region: 0x4143, code: 0xdb, from: 0xf7021, to: 0x0},
	1:   {region: 0x4144, code: 0x5c, from: 0xf9e21, to: 0x0},
	2:   {region: 0x4144, code: 0x5a, from: 0xea221, to: 0xfa45c},
	3:   {region: 0x4144, code: 0x60, from: 0xf5021, to: 0xfa451},
	4:   {region: 0x4144, code: 0x1, from: 0xf2021, to: 0xfa39f},
	5:   {region: 0x4145, code: 0x2, from: 0xf6ab3, to: 0x0},
	6:   {region: 0x4146, code: 0x4, from: 0xfa547, to: 0x0},
	7:   {region: 0x4146, code: 0x3, from: 0xf0e6e, to: 0xfa59f},
	8:   {region: 0x4147, code: 0x10d, from: 0xf5b46, to: 0x0},
	9:   {region: 0x4149, code: 0x10d, from: 0xf5b46, to: 0x0},
	10:  {region: 0x414c, code: 0x6, from: 0xf5b10, to: 0x0},
	11:  {region: 0x414c, code: 0x5, from: 0xf3561, to: 0xf5b10},
	12:  {region: 0x414d, code: 0x7, from: 0xf9376, to: 0x0},
	13:  {region: 0x414d, code: 0xd1, from: 0xf8f99, to: 0xf9376},
	14:  {region: 0x414d, code: 0xe4, from: 0xf5221, to: 0xf8f99},
	15:  {region: 0x414f, code: 0x9, from: 0xf9f8d, to: 0x0},
	16:  {region: 0x414f, code: 0xc, from: 0xf96e1, to: 0xfa041},
	17:  {region: 0x414f, code: 0xb, from: 0xf8d39, to: 0xfa041},
	18:  {region: 0x414f, code: 0xa, from: 0xf7228, to: 0xf8e61},
	19:  {region: 0x4151, code: 0x811a, from: 0x0, to: 0x0},
	20:  {region: 0x4152, code: 0x11, from: 0xf9021, to: 0x0},
	21:  {region: 0x4152, code: 0xd, from: 0xf82ce, to: 0xf9021},
	22:  {region: 0x4152, code: 0x10, from: 0xf7ec1, to: 0xf82ce},
	23:  {region: 0x4152, code: 0xe, from: 0xf6421, to: 0xf7ec1},
	24:  {region: 0x4152, code: 0xf, from: 0xeb365, to: 0xf6421},
	25:  {region: 0x4153, code: 0xf9, from: 0xee0f0, to: 0x0},
	26:  {region: 0x4154, code: 0x5c, from: 0xf9e21, to: 0x0},
	27:  {region: 0x4154, code: 0x12, from: 0xf3784, to: 0xfa45c},
	28:  {region: 0x4155, code: 0x13, from: 0xf5c4e, to: 0x0},
	29:  {region: 0x4157, code: 0x14, from: 0xf8421, to: 0x0},
	30:  {region: 0x4157, code: 0x8, from: 0xf28aa, to: 0xf8421},
	31:  {region: 0x4158, code: 0x5c, from: 0xf9e21, to: 0x0},
	32:  {region: 0x415a, code: 0x16, from: 0xfac21, to: 0x0},
	33:  {region: 0x415a, code: 0x15, from: 0xf9376, to: 0xfad9f},
	34:  {region: 0x415a, code: 0xd1, from: 0xf8f99, to: 0xf9421},
	35:  {region: 0x415a, code: 0xe4, from: 0xf5221, to: 0xf8f99},
	36:  {region: 0x4241, code: 0x18, from: 0xf9621, to: 0x0},
	37:  {region: 0x4241, code: 0x19, from: 0xf950f, to: 0xf9ae1},
	38:  {region: 0x4241, code: 0x17, from: 0xf90e1, to: 0xf950f},
	39:  {region: 0x4241, code: 0x120, from: 0xf90e1, to: 0xf9341},
	40:  {region: 0x4241, code: 0x11f, from: 0xf8c21, to: 0xf90e1},
	41:  {region: 0x4241, code: 0x11d, from: 0xf5c21, to: 0xf8c21},
	42:  {region: 0x4242, code: 0x1a, from: 0xf6b83, to: 0x0},
	43:  {region: 0x4242, code: 0x10d, from: 0xf5b46, to: 0xf6b83},
	44:  {region: 0x4244, code: 0x1b, from: 0xf6821, to: 0x0},
	45:  {region: 0x4244, code: 0xc6, from: 0xf3881, to: 0xf6821},
	46:  {region: 0x4244, code: 0x7b, from: 0xe5711, to: 0xf3881},
	47:  {region: 0x4245, code: 0x5c, from: 0xf9e21, to: 0x0},
	48:  {region: 0x4245, code: 0x1d, from: 0xe4e47, to: 0xfa45c},
	49:  {region: 0x4245, code: 0xbb, from: 0xe318f, to: 0xe4e47},
	50:  {region: 0x4245, code: 0x801e, from: 0xf6421, to: 0xf8c65},
	51:  {region: 0x4245, code: 0x801c, from: 0xf6421, to: 0xf8c65},
	52:  {region: 0x4246, code: 0x112, from: 0xf8104, to: 0x0},
	53:  {region: 0x4247, code: 0x21, from: 0xf9ee5, to: 0x0},
	54:  {region: 0x4247, code: 0x1f, from: 0xf5421, to: 0xf9ee5},
	55:  {region: 0x4247, code: 0x20, from: 0xf40ac, to: 0xf5421},
	56:  {region: 0x4247, code: 0x22, from: 0xeaee8, to: 0xf40ac},
	57:  {region: 0x4248, code: 0x23, from: 0xf5b50, to: 0x0},
	58:  {region: 0x4249, code: 0x24, from: 0xf58b3, to: 0x0},
	59:  {region: 0x424a, code: 0x112, from: 0xf6f7e, to: 0x0},
	60:  {region: 0x424c, code: 0x5c, from: 0xf9e21, to: 0x0},
	61:  {region: 0x424c, code: 0x60, from: 0xf5021, to: 0xfa451},
	62:  {region: 0x424d, code: 0x25, from: 0xf6446, to: 0x0},
	63:  {region: 0x424e, code: 0x26, from: 0xf5ecc, to: 0x0},
	64:  {region: 0x424e, code: 0xb3, from: 0xf5730, to: 0xf5ecc},
	65:  {region: 0x424f, code: 0x27, from: 0xf8621, to: 0x0},
	66:  {region: 0x424f, code: 0x29, from: 0xf5621, to: 0xf859f},
	67:  {region: 0x424f, code: 0x28, from: 0xe8ed7, to: 0xf5621},
	68:  {region: 0x424f, code: 0x802a, from: 0x0, to: 0x0},
	69:  {region: 0x4251, code: 0xf9, from: 0xfb621, to: 0x0},
	70:  {region: 0x4251, code: 0x8, from: 0xfb54a, to: 0xfb621},
	71:  {region: 0x4252, code: 0x2e, from: 0xf94e1, to: 0x0},
	72:  {region: 0x4252, code: 0x30, from: 0xf9301, to: 0xf94e1},
	73:  {region: 0x4252, code: 0x2d, from: 0xf8c70, to: 0xf9301},
	74:  {region: 0x4252, code: 0x2f, from: 0xf8a2f, to: 0xf8c70},
	75:  {region: 0x4252, code: 0x2c, from: 0xf845c, to: 0xf8a2f},
	76:  {region: 0x4252, code: 0x2b, from: 0xf5e4d, to: 0xf845c},
	77:  {region: 0x4252, code: 0x31, from: 0xf2d61, to: 0xf5e4d},
	78:  {region: 0x4253, code: 0x32, from: 0xf5cb9, to: 0x0},
	79:  {region: 0x4254, code: 0x33, from: 0xf6c90, to: 0x0},
	80:  {region: 0x4254, code: 0x7b, from: 0xee621, to: 0x0},
	81:  {region: 0x4255, code: 0x34, from: 0xf40e1, to: 0xf8ad2},
	82:  {region: 0x4256, code: 0xbc, from: 0xee2c7, to: 0x0},
	83:  {region: 0x4257, code: 0x35, from: 0xf7117, to: 0x0},
	84:  {region: 0x4257, code: 0x122, from: 0xf524e, to: 0xf7117},
	85:  {region: 0x4259, code: 0x37, from: 0xfa021, to: 0x0},
	86:  {region: 0x4259, code: 0x36, from: 0xf9501, to: 0xfa19f},
	87:  {region: 0x4259, code: 0xd1, from: 0xf8f99, to: 0xf9568},
	88:  {region: 0x4259, code: 0xe4, from: 0xf5221, to: 0xf8f99},
	89:  {region: 0x425a, code: 0x38, from: 0xf6c21, to: 0x0},
	90:  {region: 0x4341, code: 0x39, from: 0xe8421, to: 0x0},
	91:  {region: 0x4343, code: 0x13, from: 0xf5c4e, to: 0x0},
	92:  {region: 0x4344, code: 0x3a, from: 0xf9ce1, to: 0x0},
	93:  {region: 0x4344, code: 0x125, from: 0xf9361, to: 0xf9ce1},
	94:  {region: 0x4344, code: 0x126, from: 0xf675b, to: 0xf9361},
	95:  {region: 0x4346, code: 0x106, from: 0xf9221, to: 0x0},
	96:  {region: 0x4347, code: 0x106, from: 0xf9221, to: 0x0},
	97:  {region: 0x4348, code: 0x3c, from: 0xe0e71, to: 0x0},
	98:  {region: 0x4348, code: 0x803b, from: 0x0, to: 0x0},
	99:  {region: 0x4348, code: 0x803d, from: 0x0, to: 0x0},
	100: {region: 0x4349, code: 0x112, from: 0xf4d84, to: 0x0},
	101: {region: 0x434b, code: 0xbe, from: 0xf5eea, to: 0x0},
	102: {region: 0x434c, code: 0x40, from: 0xf6f3d, to: 0x0},
	103: {region: 0x434c, code: 0x3e, from: 0xf5021, to: 0xf6f3d},
	104: {region: 0x434c, code: 0x803f, from: 0x0, to: 0x0},
	105: {region: 0x434d, code: 0x106, from: 0xf6a81, to: 0x0},
	106: {region: 0x434e, code: 0x42, from: 0xf4261, to: 0x0},
	107: {region: 0x434e, code: 0x8041, from: 0xf7621, to: 0xf9d9f},
	108: {region: 0x434f, code: 0x43, from: 0xee221, to: 0x0},
	109: {region: 0x434f, code: 0x8044, from: 0x0, to: 0x0},
	110: {region: 0x4350, code: 0x811a, from: 0x0, to: 0x0},
	111: {region: 0x4352, code: 0x45, from: 0xed15a, to: 0x0},
	112: {region: 0x4353, code: 0x46, from: 0xfa4af, to: 0xfacc3},
	113: {region: 0x4353, code: 0x5c, from: 0xfa644, to: 0xfacc3},
	114: {region: 0x4353, code: 0x11e, from: 0xf9438, to: 0xfa4af},
	115: {region: 0x4355, code: 0x49, from: 0xe8621, to: 0x0},
	116: {region: 0x4355, code: 0x48, from: 0xf9421, to: 0x0},
	117: {region: 0x4355, code: 0xf9, from: 0xed621, to: 0xf4e21},
	118: {region: 0x4356, code: 0x4a, from: 0xef421, to: 0x0},
	119: {region: 0x4356, code: 0xc9, from: 0xeeeb6, to: 0xf6ee5},
	120: {region: 0x4357, code: 0x8, from: 0xfb54a, to: 0x0},
	121: {region: 0x4358, code: 0x13, from: 0xf5c4e, to: 0x0},
	122: {region: 0x4359, code: 0x5c, from: 0xfb021, to: 0x0},
	123: {region: 0x4359, code: 0x4b, from: 0xef52a, to: 0xfb03f},
	124: {region: 0x435a, code: 0x4c, from: 0xf9221, to: 0x0},
	125: {region: 0x435a, code: 0x47, from: 0xf42c1, to: 0xf9261},
	126: {region: 0x4444, code: 0x4d, from: 0xf38f4, to: 0xf8d42},
	127: {region: 0x4445, code: 0x5c, from: 0xf9e21, to: 0x0},
	128: {region: 0x4445, code: 0x4e, from: 0xf38d4, to: 0xfa45c},
	129: {region: 0x4447, code: 0xf9, from: 0xf5b68, to: 0x0},
	130: {region: 0x444a, code: 0x4f, from: 0xf72db, to: 0x0},
	131: {region: 0x444b, code: 0x50, from: 0xea2bb, to: 0x0},
	132: {region: 0x444d, code: 0x10d, from: 0xf5b46, to: 0x0},
	133: {region: 0x444f, code: 0x51, from: 0xf3741, to: 0x0},
	134: {region: 0x444f, code: 0xf9, from: 0xee2d5, to: 0xf3741},
	135: {region: 0x445a, code: 0x52, from: 0xf5881, to: 0x0},
	136: {region: 0x4541, code: 0x5c, from: 0xf9e21, to: 0x0},
	137: {region: 0x4543, code: 0xf9, from: 0xfa142, to: 0x0},
	138: {region: 0x4543, code: 0x53, from: 0xeb881, to: 0xfa142},
	139: {region: 0x4543, code: 0x8054, from: 0xf92b7, to: 0xfa029},
	140: {region: 0x4545, code: 0x5c, from: 0xfb621, to: 0x0},
	141: {region: 0x4545, code: 0x55, from: 0xf90d5, to: 0xfb59f},
	142: {region: 0x4545, code: 0xe4, from: 0xf5221, to: 0xf90d4},
	143: {region: 0x4547, code: 0x56, from: 0xebb6e, to: 0x0},
	144: {region: 0x4548, code: 0x9c, from: 0xf705a, to: 0x0},
	145: {region: 0x4552, code: 0x57, from: 0xf9b68, to: 0x0},
	146: {region: 0x4552, code: 0x5b, from: 0xf92b8, to: 0xf9b68},
	147: {region: 0x4553, code: 0x5c, from: 0xf9e21, to: 0x0},
	148: {region: 0x4553, code: 0x5a, from: 0xe9953, to: 0xfa45c},
	149: {region: 0x4553, code: 0x8058, from: 0xf7421, to: 0xf7b9f},
	150: {region: 0x4553, code: 0x8059, from: 0xf6e21, to: 0xf959f},
	151: {region: 0x4554, code: 0x5b, from: 0xf712f, to: 0x0},
	152: {region: 0x4555, code: 0x5c, from: 0xf9e21, to: 0x0},
	153: {region: 0x4555, code: 0x810f, from: 0xf7621, to: 0xf9d9f},
	154: {region: 0x4649, code: 0x5c, from: 0xf9e21, to: 0x0},
	155: {region: 0x4649, code: 0x5d, from: 0xf5621, to: 0xfa45c},
	156: {region: 0x464a, code: 0x5e, from: 0xf622d, to: 0x0},
	157: {region: 0x464b, code: 0x5f, from: 0xeda21, to: 0x0},
	158: {region: 0x464d, code: 0xf9, from: 0xf3021, to: 0x0},
	159: {region: 0x464d, code: 0x83, from: 0xef543, to: 0xf3021},
	160: {region: 0x464f, code: 0x50, from: 0xf3821, to: 0x0},
	161: {region: 0x4652, code: 0x5c, from: 0xf9e21, to: 0x0},
	162: {region: 0x4652, code: 0x60, from: 0xf5021, to: 0xfa451},
	163: {region: 0x4741, code: 0x106, from: 0xf9221, to: 0x0},
	164: {region: 0x4742, code: 0x61, from: 0xd3cfb, to: 0x0},
	165: {region: 0x4744, code: 0x10d, from: 0xf5e5b, to: 0x0},
	166: {region: 0x4745, code: 0x63, from: 0xf9737, to: 0x0},
	167: {region: 0x4745, code: 0x62, from: 0xf9285, to: 0xf9739},
	168: {region: 0x4745, code: 0xd1, from: 0xf8f99, to: 0xf92cb},
	169: {region: 0x4745, code: 0xe4, from: 0xf5221, to: 0xf8f99},
	170: {region: 0x4746, code: 0x5c, from: 0xf9e21, to: 0x0},
	171: {region: 0x4746, code: 0x60, from: 0xf5021, to: 0xfa451},
	172: {region: 0x4747, code: 0x61, from: 0xe4c21, to: 0x0},
	173: {region: 0x4748, code: 0x65, from: 0xfaee3, to: 0x0},
	174: {region: 0x4748, code: 0x64, from: 0xf7669, to: 0xfaf9f},
	175: {region: 0x4749, code: 0x66, from: 0xd6221, to: 0x0},
	176: {region: 0x474c, code: 0x50, from: 0xea2bb, to: 0x0},
	177: {region: 0x474d, code: 0x67, from: 0xf66e1, to: 0x0},
	178: {region: 0x474e, code: 0x68, from: 0xf8426, to: 0x0},
	179: {region: 0x474e, code: 0x69, from: 0xf6942, to: 0xf8426},
	180: {region: 0x4750, code: 0x5c, from: 0xf9e21, to: 0x0},
	181: {region: 0x4750, code: 0x60, from: 0xf5021, to: 0xfa451},
	182: {region: 0x4751, code: 0x106, from: 0xf9221, to: 0x0},
	183: {region: 0x4751, code: 0x6a, from: 0xf6ee7, to: 0xf84c1},
	184: {region: 0x4752, code: 0x5c, from: 0xfa221, to: 0x0},
	185: {region: 0x4752, code: 0x6b, from: 0xf44a1, to: 0xfa45c},
	186: {region: 0x4753, code: 0x61, from: 0xee821, to: 0x0},
	187: {region: 0x4754, code: 0x6c, from: 0xf0abb, to: 0x0},
	188: {region: 0x4755, code: 0xf9, from: 0xf3115, to: 0x0},
	189: {region: 0x4757, code: 0x112, from: 0xf9a7f, to: 0x0},
	190: {region: 0x4757, code: 0x6e, from: 0xf705c, to: 0xf9a7f},
	191: {region: 0x4757, code: 0x6d, from: 0xef421, to: 0xf705c},
	192: {region: 0x4759, code: 0x6f, from: 0xf5cba, to: 0x0},
	193: {region: 0x484b, code: 0x70, from: 0xece42, to: 0x0},
	194: {region: 0x484d, code: 0x13, from: 0xf5e50, to: 0x0},
	195: {region: 0x484e, code: 0x71, from: 0xf0c83, to: 0x0},
	196: {region: 0x4852, code: 0x73, from: 0xf94be, to: 0x0},
	197: {region: 0x4852, code: 0x72, from: 0xf8f97, to: 0xf9621},
	198: {region: 0x4852, code: 0x11f, from: 0xf8c21, to: 0xf8f97},
	199: {region: 0x4852, code: 0x11d, from: 0xf5c21, to: 0xf8c21},
	200: {region: 0x4854, code: 0x74, from: 0xea11a, to: 0x0},
	201: {region: 0x4854, code: 0xf9, from: 0xef621, to: 0x0},
	202: {region: 0x4855, code: 0x75, from: 0xf34f7, to: 0x0},
	203: {region: 0x4943, code: 0x5c, from: 0xf9e21, to: 0x0},
	204: {region: 0x4944, code: 0x76, from: 0xf5b8d, to: 0x0},
	205: {region: 0x4945, code: 0x5c, from: 0xf9e21, to: 0x0},
	206: {region: 0x4945, code: 0x77, from: 0xf0421, to: 0xfa449},
	207: {region: 0x4945, code: 0x61, from: 0xe1021, to: 0xf0421},
	208: {region: 0x494c, code: 0x7a, from: 0xf8324, to: 0x0},
	209: {region: 0x494c, code: 0x79, from: 0xf7856, to: 0xf8324},
	210: {region: 0x494c, code: 0x78, from: 0xf3910, to: 0xf7856},
	211: {region: 0x494d, code: 0x61, from: 0xe6023, to: 0x0},
	212: {region: 0x494e, code: 0x7b, from: 0xe5711, to: 0x0},
	213: {region: 0x494f, code: 0xf9, from: 0xf5b68, to: 0x0},
	214: {region: 0x4951, code: 0x7c, from: 0xf1693, to: 0x0},
	215: {region: 0x4951, code: 0x56, from: 0xf016b, to: 0xf1693},
	216: {region: 0x4951, code: 0x7b, from: 0xf016b, to: 0xf1693},
	217: {region: 0x4952, code: 0x7d, from: 0xf18ad, to: 0x0},
	218: {region: 0x4953, code: 0x7f, from: 0xf7a21, to: 0x0},
	219: {region: 0x4953, code: 0x7e, from: 0xefd81, to: 0xf7a21},
	220: {region: 0x4953, code: 0x50, from: 0xea2bb, to: 0xefd81},
	221: {region: 0x4954, code: 0x5c, from: 0xf9e21, to: 0x0},
	222: {region: 0x4954, code: 0x80, from: 0xe8d18, to: 0xfa45c},
	223: {region: 0x4a45, code: 0x61, from: 0xe5a21, to: 0x0},
	224: {region: 0x4a4d, code: 0x81, from: 0xf6328, to: 0x0},
	225: {region: 0x4a4f, code: 0x82, from: 0xf3ce1, to: 0x0},
	226: {region: 0x4a50, code: 0x83, from: 0xe9ec1, to: 0x0},
	227: {region: 0x4b45, code: 0x84, from: 0xf5d2e, to: 0x0},
	228: {region: 0x4b47, code: 0x85, from: 0xf92aa, to: 0x0},
	229: {region: 0x4b47, code: 0xd1, from: 0xf8f99, to: 0xf92aa},
	230: {region: 0x4b47, code: 0xe4, from: 0xf5221, to: 0xf8f99},
	231: {region: 0x4b48, code: 0x86, from: 0xf7874, to: 0x0},
	232: {region: 0x4b49, code: 0x13, from: 0xf5c4e, to: 0x0},
	233: {region: 0x4b4d, code: 0x87, from: 0xf6ee6, to: 0x0},
	234: {region: 0x4b4e, code: 0x10d, from: 0xf5b46, to: 0x0},
	235: {region: 0x4b50, code: 0x88, from: 0xf4e91, to: 0x0},
	236: {region: 0x4b52, code: 0x8b, from: 0xf54ca, to: 0x0},
	237: {region: 0x4b52, code: 0x89, from: 0xf424f, to: 0xf54ca},
	238: {region: 0x4b52, code: 0x8a, from: 0xf330f, to: 0xf424f},
	239: {region: 0x4b57, code: 0x8c, from: 0xf5281, to: 0x0},
	240: {region: 0x4b59, code: 0x8d, from: 0xf6621, to: 0x0},
	241: {region: 0x4b59, code: 0x81, from: 0xf6328, to: 0xf6621},
	242: {region: 0x4b5a, code: 0x8e, from: 0xf9365, to: 0x0},
	243: {region: 0x4c41, code: 0x8f, from: 0xf778a, to: 0x0},
	244: {region: 0x4c42, code: 0x90, from: 0xf3842, to: 0x0},
	245: {region: 0x4c43, code: 0x10d, from: 0xf5b46, to: 0x0},
	246: {region: 0x4c49, code: 0x3c, from: 0xf0241, to: 0x0},
	247: {region: 0x4c4b, code: 0x91, from: 0xf74b6, to: 0x0},
	248: {region: 0x4c52, code: 0x92, from: 0xf3021, to: 0x0},
	249: {region: 0x4c53, code: 0x122, from: 0xf524e, to: 0x0},
	250: {region: 0x4c53, code: 0x93, from: 0xf7836, to: 0x0},
	251: {region: 0x4c54, code: 0x5c, from: 0xfbe21, to: 0x0},
	252: {region: 0x4c54, code: 0x94, from: 0xf92d9, to: 0xfbd9f},
	253: {region: 0x4c54, code: 0x95, from: 0xf9141, to: 0xf92d9},
	254: {region: 0x4c54, code: 0xe4, from: 0xf5221, to: 0xf9141},
	255: {region: 0x4c55, code: 0x5c, from: 0xf9e21, to: 0x0},
	256: {region: 0x4c55, code: 0x97, from: 0xf3124, to: 0xfa45c},
	257: {region: 0x4c55, code: 0x8096, from: 0xf6421, to: 0xf8c65},
	258: {region: 0x4c55, code: 0x8098, from: 0xf6421, to: 0xf8c65},
	259: {region: 0x4c56, code: 0x5c, from: 0xfbc21, to: 0x0},
	260: {region: 0x4c56, code: 0x99, from: 0xf92dc, to: 0xfbb9f},
	261: {region: 0x4c56, code: 0x9a, from: 0xf90a7, to: 0xf9351},
	262: {region: 0x4c56, code: 0xe4, from: 0xf5221, to: 0xf90f4},
	263: {region: 0x4c59, code: 0x9b, from: 0xf6721, to: 0x0},
	264: {region: 0x4d41, code: 0x9c, from: 0xf4f51, to: 0x0},
	265: {region: 0x4d41, code: 0x9d, from: 0xeb221, to: 0xf4f51},
	266: {region: 0x4d43, code: 0x5c, from: 0xf9e21, to: 0x0},
	267: {region: 0x4d43, code: 0x60, from: 0xf5021, to: 0xfa451},
	268: {region: 0x4d43, code: 0x9e, from: 0xf5021, to: 0xfa451},
	269: {region: 0x4d44, code: 0xa0, from: 0xf937d, to: 0x0},
	270: {region: 0x4d44, code: 0x9f, from: 0xf90c1, to: 0xf937d},
	271: {region: 0x4d45, code: 0x5c, from: 0xfa421, to: 0x0},
	272: {region: 0x4d45, code: 0x4e, from: 0xf9f42, to: 0xfa4af},
	273: {region: 0x4d45, code: 0x11e, from: 0xf9438, to: 0xfa4af},
	274: {region: 0x4d46, code: 0x5c, from: 0xf9e21, to: 0x0},
	275: {region: 0x4d46, code: 0x60, from: 0xf5021, to: 0xfa451},
	276: {region: 0x4d47, code: 0xa1, from: 0xf7f61, to: 0x0},
	277: {region: 0x4d47, code: 0xa2, from: 0xf56e1, to: 0xfa99f},
	278: {region: 0x4d48, code: 0xf9, from: 0xf3021, to: 0x0},
	279: {region: 0x4d4b, code: 0xa3, from: 0xf92b4, to: 0x0},
	280: {region: 0x4d4b, code: 0xa4, from: 0xf909a, to: 0xf92b4},
	281: {region: 0x4d4c, code: 0x112, from: 0xf80c1, to: 0x0},
	282: {region: 0x4d4c, code: 0xa5, from: 0xf54e2, to: 0xf811f},
	283: {region: 0x4d4c, code: 0x112, from: 0xf4d78, to: 0xf54e2},
	284: {region: 0x4d4d, code: 0xa6, from: 0xf8ad2, to: 0x0},
	285: {region: 0x4d4d, code: 0x34, from: 0xf40e1, to: 0xf8ad2},
	286: {region: 0x4d4e, code: 0xa7, from: 0xef661, to: 0x0},
	287: {region: 0x4d4f, code: 0xa8, from: 0xeda21, to: 0x0},
	288: {region: 0x4d50, code: 0xf9, from: 0xf3021, to: 0x0},
	289: {region: 0x4d51, code: 0x5c, from: 0xf9e21, to: 0x0},
	290: {region: 0x4d51, code: 0x60, from: 0xf5021, to: 0xfa451},
	291: {region: 0x4d52, code: 0xa9, from: 0xf6add, to: 0x0},
	292: {region: 0x4d52, code: 0x112, from: 0xf4d7c, to: 0xf6add},
	293: {region: 0x4d53, code: 0x10d, from: 0xf5e5b, to: 0x0},
	294: {region: 0x4d54, code: 0x5c, from: 0xfb021, to: 0x0},
	295: {region: 0x4d54, code: 0xaa, from: 0xf60c7, to: 0xfb03f},
	296: {region: 0x4d54, code: 0xab, from: 0xef50d, to: 0xf60c7},
	297: {region: 0x4d55, code: 0xac, from: 0xf1c81, to: 0x0},
	298: {region: 0x4d56, code: 0xae, from: 0xf7ae1, to: 0x0},
	299: {region: 0x4d57, code: 0xaf, from: 0xf664f, to: 0x0},
	300: {region: 0x4d58, code: 0xb0, from: 0xf9221, to: 0x0},
	301: {region: 0x4d58, code: 0xb1, from: 0xe3c21, to: 0xf919f},
	302: {region: 0x4d58, code: 0x80b2, from: 0x0, to: 0x0},
	303: {region: 0x4d59, code: 0xb3, from: 0xf5730, to: 0x0},
	304: {region: 0x4d5a, code: 0xb6, from: 0xface1, to: 0x0},
	305: {region: 0x4d5a, code: 0xb5, from: 0xf78d0, to: 0xfad9f},
	306: {region: 0x4d5a, code: 0xb4, from: 0xf6ed9, to: 0xf78d0},
	307: {region: 0x4e41, code: 0xb7, from: 0xf9221, to: 0x0},
	308: {region: 0x4e41, code: 0x122, from: 0xf524e, to: 0x0},
	309: {region: 0x4e43, code: 0x114, from: 0xf8221, to: 0x0},
	310: {region: 0x4e45, code: 0x112, from: 0xf4d93, to: 0x0},
	311: {region: 0x4e46, code: 0x13, from: 0xf5c4e, to: 0x0},
	312: {region: 0x4e47, code: 0xb8, from: 0xf6a21, to: 0x0},
	313: {region: 0x4e49, code: 0xba, from: 0xf8e9e, to: 0x0},
	314: {region: 0x4e49, code: 0xb9, from: 0xf884f, to: 0xf8e9e},
	315: {region: 0x4e4c, code: 0x5c, from: 0xf9e21, to: 0x0},
	316: {region: 0x4e4c, code: 0xbb, from: 0xe2a21, to: 0xfa45c},
	317: {region: 0x4e4f, code: 0xbc, from: 0xee2c7, to: 0x0},
	318: {region: 0x4e4f, code: 0xd9, from: 0xea2bb, to: 0xee2c7},
	319: {region: 0x4e50, code: 0xbd, from: 0xf1a21, to: 0x0},
	320: {region: 0x4e50, code: 0x7b, from: 0xe9c21, to: 0xf5d51},
	321: {region: 0x4e52, code: 0x13, from: 0xf5c4e, to: 0x0},
	322: {region: 0x4e55, code: 0xbe, from: 0xf5eea, to: 0x0},
	323: {region: 0x4e5a, code: 0xbe, from: 0xf5eea, to: 0x0},
	324: {region: 0x4f4d, code: 0xbf, from: 0xf696b, to: 0x0},
	325: {region: 0x5041, code: 0xc0, from: 0xedf64, to: 0x0},
	326: {region: 0x5041, code: 0xf9, from: 0xedf72, to: 0x0},
	327: {region: 0x5045, code: 0xc2, from: 0xf8ee1, to: 0x0},
	328: {region: 0x5045, code: 0xc1, from: 0xf8241, to: 0xf8ee1},
	329: {region: 0x5045, code: 0xc3, from: 0xe8e4e, to: 0xf8241},
	330: {region: 0x5046, code: 0x114, from: 0xf339a, to: 0x0},
	331: {region: 0x5047, code: 0xc4, from: 0xf6f30, to: 0x0},
	332: {region: 0x5047, code: 0x13, from: 0xf5c4e, to: 0xf6f30},
	333: {region: 0x5048, code: 0xc5, from: 0xf34e4, to: 0x0},
	334: {region: 0x504b, code: 0xc6, from: 0xf3881, to: 0x0},
	335: {region: 0x504b, code: 0x7b, from: 0xe5711, to: 0xf370f},
	336: {region: 0x504c, code: 0xc7, from: 0xf9621, to: 0x0},
	337: {region: 0x504c, code: 0xc8, from: 0xf3d5c, to: 0xf959f},
	338: {region: 0x504d, code: 0x5c, from: 0xf9e21, to: 0x0},
	339: {region: 0x504d, code: 0x60, from: 0xf6995, to: 0xfa451},
	340: {region: 0x504e, code: 0xbe, from: 0xf622d, to: 0x0},
	341: {region: 0x5052, code: 0xf9, from: 0xed58a, to: 0x0},
	342: {region: 0x5052, code: 0x5a, from: 0xe1021, to: 0xed58a},
	343: {region: 0x5053, code: 0x7a, from: 0xf8324, to: 0x0},
	344: {region: 0x5053, code: 0x82, from: 0xf984c, to: 0x0},
	345: {region: 0x5053, code: 0x78, from: 0xf5ec1, to: 0xf7856},
	346: {region: 0x5053, code: 0x82, from: 0xf3ce1, to: 0xf5ec1},
	347: {region: 0x5054, code: 0x5c, from: 0xf9e21, to: 0x0},
	348: {region: 0x5054, code: 0xc9, from: 0xeeeb6, to: 0xfa45c},
	349: {region: 0x5057, code: 0xf9, from: 0xf3021, to: 0x0},
	350: {region: 0x5059, code: 0xca, from: 0xf2f61, to: 0x0},
	351: {region: 0x5141, code: 0xcb, from: 0xf6ab3, to: 0x0},
	352: {region: 0x5245, code: 0x5c, from: 0xf9e21, to: 0x0},
	353: {region: 0x5245, code: 0x60, from: 0xf6e21, to: 0xfa451},
	354: {region: 0x524f, code: 0xce, from: 0xfaae1, to: 0x0},
	355: {region: 0x524f, code: 0xcd, from: 0xf403c, to: 0xfad9f},
	356: {region: 0x5253, code: 0xcf, from: 0xfad59, to: 0x0},
	357: {region: 0x5253, code: 0x46, from: 0xfa4af, to: 0xfad59},
	358: {region: 0x5253, code: 0x11e, from: 0xf9438, to: 0xfa4af},
	359: {region: 0x5255, code: 0xd0, from: 0xf9e21, to: 0x0},
	360: {region: 0x5255, code: 0xd1, from: 0xf8f99, to: 0xf9d9f},
	361: {region: 0x5257, code: 0xd2, from: 0xf58b3, to: 0x0},
	362: {region: 0x5341, code: 0xd3, from: 0xf4156, to: 0x0},
	363: {region: 0x5342, code: 0xd4, from: 0xf7358, to: 0x0},
	364: {region: 0x5342, code: 0x13, from: 0xf5c4e, to: 0xf74de},
	365: {region: 0x5343, code: 0xd5, from: 0xedf61, to: 0x0},
	366: {region: 0x5344, code: 0xd7, from: 0xfae2a, to: 0x0},
	367: {region: 0x5344, code: 0xd6, from: 0xf90c8, to: 0xfaede},
	368: {region: 0x5344, code: 0xd8, from: 0xf4a88, to: 0xf9cc1},
	369: {region: 0x5344, code: 0x56, from: 0xec233, to: 0xf4c21},
	370: {region: 0x5344, code: 0x61, from: 0xec233, to: 0xf4c21},
	371: {region: 0x5345, code: 0xd9, from: 0xea2bb, to: 0x0},
	372: {region: 0x5347, code: 0xda, from: 0xf5ecc, to: 0x0},
	373: {region: 0x5347, code: 0xb3, from: 0xf5730, to: 0xf5ecc},
	374: {region: 0x5348, code: 0xdb, from: 0xefa4f, to: 0x0},
	375: {region: 0x5349, code: 0x5c, from: 0xfae21, to: 0x0},
	376: {region: 0x5349, code: 0xdc, from: 0xf9147, to: 0xfae2e},
	377: {region: 0x534a, code: 0xbc, from: 0xee2c7, to: 0x0},
	378: {region: 0x534b, code: 0x5c, from: 0xfb221, to: 0x0},
	379: {region: 0x534b, code: 0xdd, from: 0xf919f, to: 0xfb221},
	380: {region: 0x534b, code: 0x47, from: 0xf42c1, to: 0xf919f},
	381: {region: 0x534c, code: 0xde, from: 0xf5904, to: 0x0},
	382: {region: 0x534c, code: 0x61, from: 0xe217e, to: 0xf5c44},
	383: {region: 0x534d, code: 0x5c, from: 0xf9e21, to: 0x0},
	384: {region: 0x534d, code: 0x80, from: 0xe9397, to: 0xfa25c},
	385: {region: 0x534e, code: 0x112, from: 0xf4e84, to: 0x0},
	386: {region: 0x534f, code: 0xdf, from: 0xf50e1, to: 0x0},
	387: {region: 0x5352, code: 0xe0, from: 0xfa821, to: 0x0},
	388: {region: 0x5352, code: 0xe1, from: 0xf28aa, to: 0xfa79f},
	389: {region: 0x5352, code: 0xbb, from: 0xe2f74, to: 0xf28aa},
	390: {region: 0x5353, code: 0xe2, from: 0xfb6f2, to: 0x0},
	391: {region: 0x5353, code: 0xd7, from: 0xfae2a, to: 0xfb721},
	392: {region: 0x5354, code: 0xe3, from: 0xf7328, to: 0x0},
	393: {region: 0x5355, code: 0xe4, from: 0xf5221, to: 0xf8f99},
	394: {region: 0x5356, code: 0xf9, from: 0xfa221, to: 0x0},
	395: {region: 0x5356, code: 0xe5, from: 0xeff6b, to: 0xfa221},
	396: {region: 0x5358, code: 0x8, from: 0xfb54a, to: 0x0},
	397: {region: 0x5359, code: 0xe6, from: 0xf3821, to: 0x0},
	398: {region: 0x535a, code: 0xe7, from: 0xf6d26, to: 0x0},
	399: {region: 0x5441, code: 0x61, from: 0xf242c, to: 0x0},
	400: {region: 0x5443, code: 0xf9, from: 0xf6328, to: 0x0},
	401: {region: 0x5444, code: 0x106, from: 0xf9221, to: 0x0},
	402: {region: 0x5446, code: 0x5c, from: 0xf9e21, to: 0x0},
	403: {region: 0x5446, code: 0x60, from: 0xf4e21, to: 0xfa451},
	404: {region: 0x5447, code: 0x112, from: 0xf4d7c, to: 0x0},
	405: {region: 0x5448, code: 0xe8, from: 0xf108f, to: 0x0},
	406: {region: 0x544a, code: 0xea, from: 0xfa15a, to: 0x0},
	407: {region: 0x544a, code: 0xe9, from: 0xf96aa, to: 0xfa159},
	408: {region: 0x544a, code: 0xd1, from: 0xf8f99, to: 0xf96aa},
	409: {region: 0x544b, code: 0xbe, from: 0xf5eea, to: 0x0},
	410: {region: 0x544c, code: 0xf9, from: 0xf9f54, to: 0x0},
	411: {region: 0x544c, code: 0xef, from: 0xf4e22, to: 0xfa4b4},
	412: {region: 0x544c, code: 0x76, from: 0xf6f87, to: 0xfa4b4},
	413: {region: 0x544d, code: 0xec, from: 0xfb221, to: 0x0},
	414: {region: 0x544d, code: 0xeb, from: 0xf9361, to: 0xfb221},
	415: {region: 0x544d, code: 0xd1, from: 0xf8f99, to: 0xf9361},
	416: {region: 0x544d, code: 0xe4, from: 0xf5221, to: 0xf8f99},
	417: {region: 0x544e, code: 0xed, from: 0xf4d61, to: 0x0},
	418: {region: 0x544f, code: 0xee, from: 0xf5c4e, to: 0x0},
	419: {region: 0x5450, code: 0xef, from: 0xf4e22, to: 0xfa4b4},
	420: {region: 0x5450, code: 0x76, from: 0xf6f87, to: 0xfa4b4},
	421: {region: 0x5452, code: 0xf1, from: 0xfaa21, to: 0x0},
	422: {region: 0x5452, code: 0xf0, from: 0xf0561, to: 0xfab9f},
	423: {region: 0x5454, code: 0xf2, from: 0xf5821, to: 0x0},
	424: {region: 0x5456, code: 0x13, from: 0xf5c4e, to: 0x0},
	425: {region: 0x5457, code: 0xf3, from: 0xf3acf, to: 0x0},
	426: {region: 0x545a, code: 0xf4, from: 0xf5cce, to: 0x0},
	427: {region: 0x5541, code: 0xf5, from: 0xf9922, to: 0x0},
	428: {region: 0x5541, code: 0xf6, from: 0xf916d, to: 0xf9351},
	429: {region: 0x5541, code: 0xd1, from: 0xf8f99, to: 0xf916d},
	430: {region: 0x5541, code: 0xe4, from: 0xf5221, to: 0xf8f99},
	431: {region: 0x5547, code: 0xf8, from: 0xf86af, to: 0x0},
	432: {region: 0x5547, code: 0xf7, from: 0xf5d0f, to: 0xf86af},
	433: {region: 0x554d, code: 0xf9, from: 0xf3021, to: 0x0},
	434: {region: 0x5553, code: 0xf9, from: 0xe0021, to: 0x0},
	435: {region: 0x5553, code: 0x80fa, from: 0x0, to: 0x0},
	436: {region: 0x5553, code: 0x80fb, from: 0x0, to: 0xfbc61},
	437: {region: 0x5559, code: 0xfe, from: 0xf9261, to: 0x0},
	438: {region: 0x5559, code: 0xfd, from: 0xf6ee1, to: 0xf9261},
	439: {region: 0x5559, code: 0x80fc, from: 0x0, to: 0x0},
	440: {region: 0x555a, code: 0xff, from: 0xf94e1, to: 0x0},
	441: {region: 0x5641, code: 0x5c, from: 0xf9e21, to: 0x0},
	442: {region: 0x5641, code: 0x80, from: 0xe9d53, to: 0xfa45c},
	443: {region: 0x5643, code: 0x10d, from: 0xf5b46, to: 0x0},
	444: {region: 0x5645, code: 0x101, from: 0xfb021, to: 0x0},
	445: {region: 0x5645, code: 0x100, from: 0xe9eab, to: 0xfb0de},
	446: {region: 0x5647, code: 0xf9, from: 0xe5221, to: 0x0},
	447: {region: 0x5647, code: 0x61, from: 0xe5221, to: 0xf4e21},
	448: {region: 0x5649, code: 0xf9, from: 0xe5a21, to: 0x0},
	449: {region: 0x564e, code: 0x102, from: 0xf832e, to: 0x0},
	450: {region: 0x564e, code: 0x103, from: 0xf74a3, to: 0xf832e},
	451: {region: 0x5655, code: 0x104, from: 0xf7a21, to: 0x0},
	452: {region: 0x5746, code: 0x114, from: 0xf52fe, to: 0x0},
	453: {region: 0x5753, code: 0x105, from: 0xf5eea, to: 0x0},
	454: {region: 0x584b, code: 0x5c, from: 0xfa421, to: 0x0},
	455: {region: 0x584b, code: 0x4e, from: 0xf9f21, to: 0xfa469},
	456: {region: 0x584b, code: 0x11e, from: 0xf9438, to: 0xf9f3e},
	457: {region: 0x5944, code: 0x11b, from: 0xf5a81, to: 0xf9821},
	458: {region: 0x5945, code: 0x11c, from: 0xf8cb6, to: 0x0},
	459: {region: 0x5954, code: 0x5c, from: 0xf9e21, to: 0x0},
	460: {region: 0x5954, code: 0x60, from: 0xf7057, to: 0xfa451},
	461: {region: 0x5954, code: 0x87, from: 0xf6e21, to: 0xf7057},
	462: {region: 0x5955, code: 0x11e, from: 0xf9438, to: 0xfa4af},
	463: {region: 0x5955, code: 0x11f, from: 0xf8c21, to: 0xf90f8},
	464: {region: 0x5955, code: 0x11d, from: 0xf5c21, to: 0xf8c21},
	465: {region: 0x5a41, code: 0x122, from: 0xf524e, to: 0x0},
	466: {region: 0x5a41, code: 0x8121, from: 0xf8321, to: 0xf966d},
	467: {region: 0x5a4d, code: 0x124, from: 0xfba21, to: 0x0},
	468: {region: 0x5a4d, code: 0x123, from: 0xf6030, to: 0xfba21},
	469: {region: 0x5a52, code: 0x125, from: 0xf9361, to: 0xf9cff},
	470: {region: 0x5a52, code: 0x126, from: 0xf675b, to: 0xf9361},
	471: {region: 0x5a57, code: 0xf9, from: 0xfb28c, to: 0x0},
	472: {region: 0x5a57, code: 0x128, from: 0xfb242, to: 0xfb28c},
	473: {region: 0x5a57, code: 0x129, from: 0xfb101, to: 0xfb242},
	474: {region: 0x5a57, code: 0x127, from: 0xf7892, to: 0xfb101},
	475: {region: 0x5a57, code: 0xcc, from: 0xf6451, to: 0xf7892},
	476: {region: 0x5a5a, code: 0x8107, from: 0x0, to: 0x0},
	477: {region: 0x5a5a, code: 0x8108, from: 0x0, to: 0x0},
	478: {region: 0x5a5a, code: 0x8109, from: 0x0, to: 0x0},
	479: {region: 0x5a5a, code: 0x810a, from: 0x0, to: 0x0},
	480: {region: 0x5a5a, code: 0x810b, from: 0x0, to: 0x0},
	481: {region: 0x5a5a, code: 0x810c, from: 0x0, to: 0x0},
	482: {region: 0x5a5a, code: 0x810e, from: 0x0, to: 0x0},
	483: {region: 0x5a5a, code: 0x8110, from: 0xf1421, to: 0xfa681},
	484: {region: 0x5a5a, code: 0x8111, from: 0x0, to: 0xfbb7e},
	485: {region: 0x5a5a, code: 0x8113, from: 0x0, to: 0x0},
	486: {region: 0x5a5a, code: 0x8115, from: 0x0, to: 0x0},
	487: {region: 0x5a5a, code: 0x8116, from: 0x0, to: 0xf9f7e},
	488: {region: 0x5a5a, code: 0x8117, from: 0x0, to: 0x0},
	489: {region: 0x5a5a, code: 0x8118, from: 0x0, to: 0x0},
	490: {region: 0x5a5a, code: 0x8119, from: 0x0, to: 0x0},
	491: {region: 0x5a5a, code: 0x811a, from: 0x0, to: 0x0},
} // Size: 5928 bytes

// symbols holds symbol data of the form <n> <str>, where n is the length of
// the symbol string str.
var symbols string = "" + // Size: 1462 bytes
	"\x00\x02Kz\x01$\x02A$\x02KM\x03৳\x02Bs\x02R$\x01P\x03р.\x03CA$\x04CN¥" +
	"\x02¥\x03₡\x03Kč\x02kr\x03E£\x03₧\x03€\x02£\x02FG\x01Q\x03HK$\x01L\x02kn" +
	"\x02Ft\x02Rp\x03₪\x03₹\x04JP¥\x03៛\x02CF\x03₩\x03₸\x03₭\x03L£\x02Rs\x02L" +
	"t\x02Ls\x02Ar\x01K\x03₮\x03MX$\x02RM\x03₦\x02C$\x03NZ$\x03₱\x03zł\x03₲" +
	"\x03₽\x02RF\x02Db\x03฿\x02T$\x03₺\x03NT$\x03₴\x03US$\x03₫\x04FCFA\x03EC$" +
	"\x03CFA\x04CFPF\x01R\x02ZK\x05GH₵\x03AU$\x06ብር\x03***\x09د.إ.\u200f\x03A" +
	"R$\x03BB$\x09د.ب.\u200f\x03BM$\x03BN$\x03BS$\x03BZ$\x03CL$\x03CO$\x03CU$" +
	"\x03DO$\x09د.ج.\u200f\x09ج.م.\u200f\x03FJ$\x04UK£\x03GY$\x08ر.إن.\x09د.ع" +
	".\u200f\x06ر.إ.\x03JM$\x09د.أ.\u200f\x0cف.ج.ق.\u200f\x09د.ك.\u200f\x03KY" +
	"$\x09ل.ل.\u200f\x09د.ل.\u200f\x09د.م.\u200f\x09أ.م.\u200f\x09ر.ع.\u200f" +
	"\x06ر.ب.\x09ر.ق.\u200f\x09ر.س.\u200f\x03SB$\x09د.س.\u200f\x06ج.س.\x03SR$" +
	"\x09ج.ج.س.\x09ل.س.\u200f\x09د.ت.\u200f\x06ل.ت.\x03TT$\x03UY$\x09ر.ي." +
	"\u200f\x03Fdj\x03Nfk\x01S\x04GB£\x03TSh\x03₼\x03S£\x04Bds$\x03BD$\x02B$" +
	"\x04CUC$\x03$MN\x03RD$\x04FK£\x02G$\x04Íkr\x02J$\x03CI$\x02L$\x02N$\x07р" +
	"уб.\x03SI$\x02S$\x02$U\x05лв.\x06щ.д.\x02$A\x03$CA\x04£ E\x05£ RU\x04$ " +
	"HK\x03£L\x04$ ZN\x03$ T\x04$ SU\x04din.\x04КМ\x04Кч\x04зл\x07дин.\x04Тл" +
	"\x01F\x03USh\x04Kčs\x03ECU\x02TK\x03kr.\x03Ksh\x03öS\x03BGK\x03BGJ\x04Cu" +
	"b$\x02DM\x04Fl£\x04F.G.\x02FC\x04F.Rw\x03Nu.\x05KR₩\x05TH฿\x06Δρχ\x02Tk" +
	"\x02$b\x02Kr\x05ل.ل\x02Gs\x03CFP\x03FBu\x01D\x04MOP$\x02MK\x02SR\x02Le" +
	"\x04NAf.\x01E\x02VT\x03WS$\x03BsF\x02Af\x03Naf\x02$a\x04Afl.\x02Br\x02TL" +
	"\x03B/.\x03S/.\x03Gs.\x03Bs.\x02؋\x04¥CN\x03$HK\x08ریال\x03$MX\x03$NZ" +
	"\x03$EC\x02UM\x02mk\x03$AR\x03$AU\x02FB\x03$BM\x03$BN\x03$BS\x03$BZ\x03$" +
	"CL\x03$CO\x04£CY\x03£E\x03$FJ\x04£FK\x04£GB\x04£GI\x04£IE\x04£IL\x05₤IT" +
	"\x04£LB\x04£MT\x03$NA\x02$C\x03$RH\x02FR\x03$SB\x03$SG\x03$SR\x03$TT\x03" +
	"$US\x03$UY\x04FCFP\x02Kw\x05$\u00a0AU\x05$\u00a0HK\x05$\u00a0NZ\x05$" +
	"\u00a0SG\x05$\u00a0US\x02DA\x01G\x02LS\x02DT\x02$R\x04¥JP\x03$NT\x07રૂ." +
	"\x06ל״י\x03₨\x02֏\x03NKr\x03元\x03￥\x03\u200b\x04БД\x05КД$\x02LE\x02Kn" +
	"\x06сом\x02zl\x02rb\x03MTn\x06ден\x12ဒေါ်လာ\x12စီအာစီ\x0cनेरू\x02ر\x04Es" +
	"c.\x06\u200bPTE\x04XXXX\x06ТМТ\x03Dkr\x03Skr\x03Nkr\x07රු.\x0fසිෆ්එ\x03N" +
	"IS\x05Lekë\x03den\x05[BGN]\x05[BYR]\x06руб\x02r.\x03rub\x03BR$\x03Ekr" +
	"\x04EG£\x03Ikr\x03Rs.\x04AUD$\x04NZD$\x07крб.\x05soʻm\x06сўм\x03ILS\x03￦" +
	"\x02P.\x03Zł"

type curToIndex struct {
	cur uint16
	idx uint16
}

var normalLangIndex = []uint16{ // 743 elements
	// Entry 0 - 3F
	0x0000, 0x0014, 0x0014, 0x0014, 0x0017, 0x0018, 0x0018, 0x0018,
	0x0018, 0x0019, 0x0019, 0x001c, 0x001c, 0x0038, 0x0038, 0x0038,
	0x0038, 0x0039, 0x0039, 0x0039, 0x0039, 0x003a, 0x003a, 0x003a,
	0x003a, 0x003a, 0x003a, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b,
	0x003b, 0x003b, 0x003b, 0x003b, 0x003c, 0x003e, 0x003e, 0x003e,
	0x003e, 0x003e, 0x003e, 0x003e, 0x003f, 0x003f, 0x0042, 0x0042,
	0x0044, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x004c,
	0x004c, 0x004d, 0x004d, 0x004e, 0x004e, 0x005f, 0x005f, 0x005f,
	// Entry 40 - 7F
	0x005f, 0x005f, 0x0061, 0x0061, 0x0061, 0x0062, 0x0062, 0x0063,
	0x0071, 0x0071, 0x0071, 0x0071, 0x0082, 0x0088, 0x0088, 0x0088,
	0x0088, 0x0091, 0x0091, 0x0091, 0x0092, 0x0092, 0x0093, 0x0093,
	0x0094, 0x0094, 0x0095, 0x0095, 0x0095, 0x0095, 0x0095, 0x009c,
	0x009c, 0x009d, 0x009d, 0x009f, 0x009f, 0x00a3, 0x00a3, 0x00a3,
	0x00a4, 0x00a4, 0x00ac, 0x00ac, 0x00ac, 0x00ad, 0x00ad, 0x00ae,
	0x00af, 0x00af, 0x00af, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
	0x00b4, 0x00b4, 0x00ba, 0x00ba, 0x00bb, 0x00bb, 0x00be, 0x00be,
	// Entry 80 - BF
	0x00be, 0x00c1, 0x00c1, 0x00c1, 0x00c3, 0x00c5, 0x00c5, 0x00c6,
	0x00c7, 0x00c7, 0x00c7, 0x00dc, 0x00dd, 0x00dd, 0x00de, 0x00df,
	0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e4, 0x00e5, 0x00e5,
	0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00e7, 0x00e8, 0x00e9, 0x00e9,
	0x00ea, 0x00ec, 0x00ec, 0x00ec, 0x00ed, 0x00ed, 0x00ee, 0x00f0,
	0x00f1, 0x00f1, 0x00f2, 0x00f2, 0x00f2, 0x00f2, 0x00f2, 0x00f2,
	0x00f2, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 0x00f8,
	0x00f9, 0x00fa, 0x00fb, 0x00fb, 0x00fc, 0x00fc, 0x00fd, 0x00fe,
	// Entry C0 - FF
	0x00ff, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104, 0x0104, 0x0105,
	0x0106, 0x0107, 0x0108, 0x0109, 0x010a, 0x010b, 0x010b, 0x010b,
	0x010c, 0x010d, 0x010e, 0x010e, 0x010f, 0x0110, 0x0112, 0x0112,
	0x0113, 0x0115, 0x0116, 0x0117, 0x0117, 0x0118, 0x0119, 0x011a,
	0x011b, 0x011c, 0x011d, 0x011d, 0x011d, 0x011e, 0x011e, 0x011e,
	0x011f, 0x0120, 0x0121, 0x0122, 0x0122, 0x0122, 0x0122, 0x0134,
	0x0134, 0x0139, 0x013b, 0x013c, 0x013e, 0x0140, 0x0141, 0x0143,
	0x0145, 0x0145, 0x0146, 0x0146, 0x0147, 0x0148, 0x0149, 0x0149,
	// Entry 100 - 13F
	0x0152, 0x0153, 0x0154, 0x0155, 0x0156, 0x0157, 0x0158, 0x0159,
	0x015b, 0x015d, 0x015e, 0x0163, 0x0163, 0x0165, 0x0165, 0x0165,
	0x0165, 0x0170, 0x0170, 0x0170, 0x0170, 0x0170, 0x0171, 0x0172,
	0x0172, 0x0183, 0x0183, 0x0187, 0x0187, 0x0188, 0x0189, 0x0189,
	0x01af, 0x01af, 0x01af, 0x01b0, 0x01b0, 0x01b0, 0x01d0, 0x01d1,
	0x01d1, 0x01d1, 0x01d1, 0x01d1, 0x01d1, 0x01d2, 0x01d3, 0x01d3,
	0x01d3, 0x01d3, 0x01d4, 0x01d4, 0x01d4, 0x01d5, 0x01d6, 0x01d8,
	0x01d8, 0x01d8, 0x01d8, 0x01d9, 0x01d9, 0x01d9, 0x01da, 0x01db,
	// Entry 140 - 17F
	0x01db, 0x01db, 0x01db, 0x01db, 0x01db, 0x01dc, 0x01dd, 0x01dd,
	0x01de, 0x01de, 0x01de, 0x01df, 0x01e0, 0x01e0, 0x01e0, 0x01e0,
	0x01e0, 0x01e6, 0x01e6, 0x01e9, 0x01e9, 0x01eb, 0x01eb, 0x01f5,
	0x01f5, 0x01f8, 0x01f8, 0x01f8, 0x01f8, 0x01f9, 0x01f9, 0x01f9,
	0x01fa, 0x01fa, 0x01fa, 0x01fa, 0x01fb, 0x01fc, 0x01fc, 0x01fc,
	0x01fd, 0x01fd, 0x0200, 0x0200, 0x0202, 0x0202, 0x0214, 0x0215,
	0x0215, 0x021a, 0x021a, 0x022c, 0x022c, 0x022f, 0x022f, 0x0233,
	0x0233, 0x0234, 0x0234, 0x0235, 0x0235, 0x0241, 0x0241, 0x0248,
	// Entry 180 - 1BF
	0x0248, 0x0248, 0x0248, 0x0248, 0x024d, 0x024d, 0x024d, 0x024d,
	0x024d, 0x024e, 0x024e, 0x024e, 0x0257, 0x0257, 0x0258, 0x0258,
	0x0258, 0x0259, 0x0259, 0x0259, 0x025a, 0x025a, 0x025d, 0x025d,
	0x025d, 0x025d, 0x025e, 0x025e, 0x0264, 0x0264, 0x0264, 0x0264,
	0x0265, 0x0265, 0x0266, 0x0266, 0x0269, 0x0269, 0x026b, 0x026b,
	0x026d, 0x026d, 0x026d, 0x026d, 0x026d, 0x026d, 0x026d, 0x026e,
	0x026e, 0x026e, 0x026e, 0x026e, 0x026e, 0x026e, 0x026e, 0x026e,
	0x027d, 0x027d, 0x027e, 0x027e, 0x0283, 0x0283, 0x0284, 0x0284,
	// Entry 1C0 - 1FF
	0x0285, 0x0285, 0x0286, 0x0287, 0x0287, 0x0287, 0x0287, 0x0289,
	0x0289, 0x0289, 0x0289, 0x0289, 0x029c, 0x029c, 0x029d, 0x029d,
	0x029e, 0x029e, 0x029f, 0x029f, 0x02a4, 0x02a4, 0x02a5, 0x02a5,
	0x02a6, 0x02a7, 0x02a7, 0x02a8, 0x02a8, 0x02a9, 0x02a9, 0x02aa,
	0x02aa, 0x02aa, 0x02aa, 0x02b6, 0x02b6, 0x02b9, 0x02b9, 0x02bc,
	0x02bc, 0x02be, 0x02be, 0x02c2, 0x02c3, 0x02c3, 0x02c4, 0x02c4,
	0x02c4, 0x02c4, 0x02c4, 0x02c7, 0x02c7, 0x02c8, 0x02c8, 0x02c8,
	0x02c9, 0x02c9, 0x02db, 0x02db, 0x02db, 0x02db, 0x02db, 0x02dd,
	// Entry 200 - 23F
	0x02dd, 0x02dd, 0x02e3, 0x02e4, 0x02e4, 0x02e5, 0x02e6, 0x02e6,
	0x02e7, 0x02e8, 0x02e8, 0x02e8, 0x02e9, 0x02e9, 0x02e9, 0x02e9,
	0x02e9, 0x02e9, 0x02e9, 0x02e9, 0x02eb, 0x02eb, 0x02eb, 0x02ec,
	0x02ec, 0x02ed, 0x02ed, 0x02ee, 0x02ee, 0x02ee, 0x02ef, 0x02ef,
	0x02f0, 0x02f1, 0x02f2, 0x02f2, 0x02f2, 0x02f2, 0x02f2, 0x0301,
	0x0301, 0x0301, 0x0301, 0x0302, 0x0302, 0x0305, 0x0306, 0x0306,
	0x0308, 0x0308, 0x0309, 0x030a, 0x030b, 0x030c, 0x030c, 0x030d,
	0x030f, 0x0311, 0x0311, 0x0311, 0x0311, 0x0312, 0x0312, 0x0323,
	// Entry 240 - 27F
	0x0324, 0x0324, 0x0325, 0x0325, 0x032d, 0x032f, 0x0330, 0x0331,
	0x0332, 0x0332, 0x0332, 0x0333, 0x0333, 0x0334, 0x0334, 0x0335,
	0x0335, 0x0336, 0x0336, 0x0337, 0x0337, 0x0337, 0x033b, 0x033b,
	0x033b, 0x033d, 0x033e, 0x033e, 0x033e, 0x033e, 0x033e, 0x033e,
	0x033e, 0x033e, 0x033e, 0x033e, 0x033e, 0x0341, 0x0341, 0x034f,
	0x034f, 0x0353, 0x0353, 0x0353, 0x0353, 0x0353, 0x0353, 0x0353,
	0x0353, 0x0353, 0x0353, 0x0354, 0x0355, 0x0356, 0x0357, 0x0357,
	0x0359, 0x0359, 0x035a, 0x035a, 0x0362, 0x0362, 0x0362, 0x0362,
	// Entry 280 - 2BF
	0x0362, 0x0362, 0x036a, 0x036a, 0x036a, 0x036a, 0x036a, 0x036a,
	0x036a, 0x036a, 0x0381, 0x0381, 0x0381, 0x0381, 0x0384, 0x0385,
	0x0385, 0x0385, 0x0386, 0x0386, 0x0389, 0x0389, 0x038a, 0x038c,
	0x038f, 0x0391, 0x0391, 0x0392, 0x0393, 0x0393, 0x0395, 0x0395,
	0x0396, 0x0397, 0x0397, 0x0397, 0x0399, 0x0399, 0x0399, 0x039c,
	0x039c, 0x03a1, 0x03a1, 0x03a1, 0x03a1, 0x03a1, 0x03a1, 0x03a1,
	0x03a1, 0x03a3, 0x03a3, 0x03b6, 0x03b6, 0x03b9, 0x03ba, 0x03ba,
	0x03bb, 0x03bc, 0x03bc, 0x03be, 0x03be, 0x03be, 0x03be, 0x03bf,
	// Entry 2C0 - 2FF
	0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c0, 0x03c2, 0x03c2, 0x03c2,
	0x03c2, 0x03c3, 0x03c3, 0x03c3, 0x03c5, 0x03c5, 0x03c5, 0x03c5,
	0x03c6, 0x03c6, 0x03c6, 0x03c6, 0x03c6, 0x03c6, 0x03c7, 0x03c7,
	0x03c7, 0x03c7, 0x03c7, 0x03cb, 0x03cb, 0x03cb, 0x03cc, 0x03ce,
	0x03d0, 0x03d4, 0x03d6, 0x03d7, 0x03d7, 0x03d9, 0x03d9,
} // Size: 1510 bytes

var normalSymIndex = []curToIndex{ // 985 elements
	0:   {cur: 0x13, idx: 0x6},
	1:   {cur: 0x2e, idx: 0x13},
	2:   {cur: 0x39, idx: 0x1c},
	3:   {cur: 0x42, idx: 0x20},
	4:   {cur: 0x5c, idx: 0x3b},
	5:   {cur: 0x61, idx: 0x3f},
	6:   {cur: 0x70, idx: 0x47},
	7:   {cur: 0x7a, idx: 0x56},
	8:   {cur: 0x7b, idx: 0x5a},
	9:   {cur: 0x83, idx: 0x5e},
	10:  {cur: 0x8b, idx: 0x6a},
	11:  {cur: 0xb0, idx: 0x8c},
	12:  {cur: 0xbe, idx: 0x9a},
	13:  {cur: 0xf3, idx: 0xbf},
	14:  {cur: 0xf9, idx: 0xc7},
	15:  {cur: 0x102, idx: 0xcb},
	16:  {cur: 0x106, idx: 0xcf},
	17:  {cur: 0x10d, idx: 0xd4},
	18:  {cur: 0x112, idx: 0xd8},
	19:  {cur: 0x114, idx: 0xdc},
	20:  {cur: 0xb0, idx: 0x0},
	21:  {cur: 0xe8, idx: 0xb4},
	22:  {cur: 0x122, idx: 0xe1},
	23:  {cur: 0xb7, idx: 0x4},
	24:  {cur: 0x65, idx: 0xe6},
	25:  {cur: 0x13, idx: 0xec},
	26:  {cur: 0x5b, idx: 0xf0},
	27:  {cur: 0xe8, idx: 0xb4},
	28:  {cur: 0x0, idx: 0xf7},
	29:  {cur: 0x2, idx: 0xfb},
	30:  {cur: 0x13, idx: 0xec},
	31:  {cur: 0x23, idx: 0x10d},
	32:  {cur: 0x52, idx: 0x137},
	33:  {cur: 0x56, idx: 0x141},
	34:  {cur: 0x76, idx: 0x158},
	35:  {cur: 0x7c, idx: 0x161},
	36:  {cur: 0x7d, idx: 0x16b},
	37:  {cur: 0x82, idx: 0x176},
	38:  {cur: 0x87, idx: 0x180},
	39:  {cur: 0x8c, idx: 0x18d},
	40:  {cur: 0x90, idx: 0x19b},
	41:  {cur: 0x9b, idx: 0x1a5},
	42:  {cur: 0x9c, idx: 0x1af},
	43:  {cur: 0xa9, idx: 0x1b9},
	44:  {cur: 0xbf, idx: 0x1c3},
	45:  {cur: 0xc6, idx: 0x1cd},
	46:  {cur: 0xcb, idx: 0x1d4},
	47:  {cur: 0xd3, idx: 0x1de},
	48:  {cur: 0xd6, idx: 0x1ec},
	49:  {cur: 0xd7, idx: 0x1f6},
	50:  {cur: 0xe2, idx: 0x201},
	51:  {cur: 0xe6, idx: 0x20b},
	52:  {cur: 0xe8, idx: 0xb4},
	53:  {cur: 0xed, idx: 0x215},
	54:  {cur: 0xf1, idx: 0x21f},
	55:  {cur: 0x11c, idx: 0x22e},
	56:  {cur: 0x4f, idx: 0x238},
	57:  {cur: 0x57, idx: 0x23c},
	58:  {cur: 0xd7, idx: 0x0},
	59:  {cur: 0xdf, idx: 0x240},
	60:  {cur: 0x61, idx: 0x242},
	61:  {cur: 0xe2, idx: 0x3f},
	62:  {cur: 0xf4, idx: 0x247},
	63:  {cur: 0x83, idx: 0x25},
	64:  {cur: 0xe8, idx: 0xb4},
	65:  {cur: 0xf9, idx: 0x4},
	66:  {cur: 0x16, idx: 0x24b},
	67:  {cur: 0xe8, idx: 0xb4},
	68:  {cur: 0x16, idx: 0x24b},
	69:  {cur: 0x2e, idx: 0x0},
	70:  {cur: 0x37, idx: 0x18},
	71:  {cur: 0x39, idx: 0x0},
	72:  {cur: 0x83, idx: 0x25},
	73:  {cur: 0xbe, idx: 0x0},
	74:  {cur: 0xd0, idx: 0xaa},
	75:  {cur: 0xf9, idx: 0x4},
	76:  {cur: 0x124, idx: 0x86},
	77:  {cur: 0xf4, idx: 0x247},
	78:  {cur: 0x13, idx: 0x0},
	79:  {cur: 0x21, idx: 0x298},
	80:  {cur: 0x2e, idx: 0x0},
	81:  {cur: 0x39, idx: 0x0},
	82:  {cur: 0x42, idx: 0x0},
	83:  {cur: 0x61, idx: 0x0},
	84:  {cur: 0x70, idx: 0x0},
	85:  {cur: 0x7a, idx: 0x0},
	86:  {cur: 0x7b, idx: 0x0},
	87:  {cur: 0x83, idx: 0x0},
	88:  {cur: 0x8b, idx: 0x0},
	89:  {cur: 0xb0, idx: 0x0},
	90:  {cur: 0xbe, idx: 0x0},
	91:  {cur: 0xf3, idx: 0x0},
	92:  {cur: 0xf9, idx: 0x29e},
	93:  {cur: 0x102, idx: 0x0},
	94:  {cur: 0x10d, idx: 0x0},
	95:  {cur: 0x1b, idx: 0xc},
	96:  {cur: 0xe8, idx: 0xb4},
	97:  {cur: 0x42, idx: 0x25},
	98:  {cur: 0x42, idx: 0x20},
	99:  {cur: 0x13, idx: 0x2a5},
	100: {cur: 0x2e, idx: 0x0},
	101: {cur: 0x39, idx: 0x2a8},
	102: {cur: 0x42, idx: 0x0},
	103: {cur: 0x61, idx: 0x2b1},
	104: {cur: 0x70, idx: 0x2b7},
	105: {cur: 0x7a, idx: 0x0},
	106: {cur: 0x83, idx: 0x0},
	107: {cur: 0x8b, idx: 0x0},
	108: {cur: 0xbe, idx: 0x2c0},
	109: {cur: 0xf3, idx: 0x0},
	110: {cur: 0xf9, idx: 0x2c9},
	111: {cur: 0x102, idx: 0x0},
	112: {cur: 0x10d, idx: 0x0},
	113: {cur: 0x13, idx: 0x0},
	114: {cur: 0x18, idx: 0x9},
	115: {cur: 0x2e, idx: 0x0},
	116: {cur: 0x39, idx: 0x0},
	117: {cur: 0x42, idx: 0x0},
	118: {cur: 0x61, idx: 0x0},
	119: {cur: 0x70, idx: 0x0},
	120: {cur: 0x73, idx: 0x4d},
	121: {cur: 0x7a, idx: 0x0},
	122: {cur: 0x83, idx: 0x25},
	123: {cur: 0xb0, idx: 0x0},
	124: {cur: 0xbe, idx: 0x0},
	125: {cur: 0xcf, idx: 0x2ce},
	126: {cur: 0xe8, idx: 0xb4},
	127: {cur: 0xf9, idx: 0x0},
	128: {cur: 0x10d, idx: 0x0},
	129: {cur: 0x114, idx: 0x0},
	130: {cur: 0x18, idx: 0x2d3},
	131: {cur: 0x4c, idx: 0x2d8},
	132: {cur: 0x83, idx: 0x25},
	133: {cur: 0xc7, idx: 0x2dd},
	134: {cur: 0xcf, idx: 0x2e2},
	135: {cur: 0xf1, idx: 0x2ea},
	136: {cur: 0x13, idx: 0xec},
	137: {cur: 0x2e, idx: 0x0},
	138: {cur: 0x39, idx: 0x0},
	139: {cur: 0x42, idx: 0x25},
	140: {cur: 0x5a, idx: 0x37},
	141: {cur: 0xb0, idx: 0x0},
	142: {cur: 0xe8, idx: 0xb4},
	143: {cur: 0xf9, idx: 0x0},
	144: {cur: 0x10d, idx: 0x0},
	145: {cur: 0x60, idx: 0x2ef},
	146: {cur: 0xd0, idx: 0xaa},
	147: {cur: 0xf8, idx: 0x2f1},
	148: {cur: 0xf9, idx: 0x4},
	149: {cur: 0x13, idx: 0xec},
	150: {cur: 0x47, idx: 0x2f5},
	151: {cur: 0x4c, idx: 0x2c},
	152: {cur: 0x7a, idx: 0x0},
	153: {cur: 0x7b, idx: 0x0},
	154: {cur: 0x102, idx: 0x0},
	155: {cur: 0x10f, idx: 0x2fa},
	156: {cur: 0xd0, idx: 0xaa},
	157: {cur: 0x8b, idx: 0x0},
	158: {cur: 0xe8, idx: 0xb4},
	159: {cur: 0x13, idx: 0xec},
	160: {cur: 0x50, idx: 0x301},
	161: {cur: 0xe8, idx: 0xb4},
	162: {cur: 0xf9, idx: 0x4},
	163: {cur: 0x84, idx: 0x305},
	164: {cur: 0x12, idx: 0x309},
	165: {cur: 0x13, idx: 0xec},
	166: {cur: 0x20, idx: 0x30d},
	167: {cur: 0x22, idx: 0x311},
	168: {cur: 0x4e, idx: 0x31a},
	169: {cur: 0x83, idx: 0x25},
	170: {cur: 0xe8, idx: 0xb4},
	171: {cur: 0xf9, idx: 0x4},
	172: {cur: 0x5c, idx: 0x0},
	173: {cur: 0x5c, idx: 0x0},
	174: {cur: 0x97, idx: 0x2ef},
	175: {cur: 0x13, idx: 0x0},
	176: {cur: 0x83, idx: 0x25},
	177: {cur: 0xc7, idx: 0xa2},
	178: {cur: 0xe8, idx: 0xb4},
	179: {cur: 0xf9, idx: 0x4},
	180: {cur: 0x13, idx: 0xec},
	181: {cur: 0x33, idx: 0x32f},
	182: {cur: 0x7a, idx: 0x0},
	183: {cur: 0x8b, idx: 0x333},
	184: {cur: 0xe8, idx: 0x339},
	185: {cur: 0x106, idx: 0x0},
	186: {cur: 0x84, idx: 0x305},
	187: {cur: 0x13, idx: 0xec},
	188: {cur: 0x65, idx: 0xe6},
	189: {cur: 0xe8, idx: 0xb4},
	190: {cur: 0x6b, idx: 0x33f},
	191: {cur: 0xe8, idx: 0xb4},
	192: {cur: 0xf9, idx: 0x4},
	193: {cur: 0x83, idx: 0x25},
	194: {cur: 0xf9, idx: 0x4},
	195: {cur: 0x83, idx: 0x5e},
	196: {cur: 0xf9, idx: 0xc7},
	197: {cur: 0x10d, idx: 0x4},
	198: {cur: 0x10d, idx: 0x4},
	199: {cur: 0x13, idx: 0x4},
	200: {cur: 0x2e, idx: 0x0},
	201: {cur: 0x39, idx: 0x0},
	202: {cur: 0x42, idx: 0x0},
	203: {cur: 0x5c, idx: 0x0},
	204: {cur: 0x61, idx: 0x0},
	205: {cur: 0x70, idx: 0x0},
	206: {cur: 0x7a, idx: 0x0},
	207: {cur: 0x7b, idx: 0x0},
	208: {cur: 0x83, idx: 0x0},
	209: {cur: 0x8b, idx: 0x0},
	210: {cur: 0xb0, idx: 0x0},
	211: {cur: 0xbe, idx: 0x0},
	212: {cur: 0xd5, idx: 0x7a},
	213: {cur: 0xf3, idx: 0x0},
	214: {cur: 0xf9, idx: 0x0},
	215: {cur: 0x102, idx: 0x0},
	216: {cur: 0x106, idx: 0x0},
	217: {cur: 0x10d, idx: 0x0},
	218: {cur: 0x112, idx: 0x0},
	219: {cur: 0x114, idx: 0x358},
	220: {cur: 0x1a, idx: 0x4},
	221: {cur: 0x24, idx: 0x35c},
	222: {cur: 0x25, idx: 0x4},
	223: {cur: 0x32, idx: 0x4},
	224: {cur: 0x35, idx: 0x16},
	225: {cur: 0x38, idx: 0x4},
	226: {cur: 0x39, idx: 0x4},
	227: {cur: 0x13, idx: 0x4},
	228: {cur: 0xbe, idx: 0x4},
	229: {cur: 0x13, idx: 0x4},
	230: {cur: 0x50, idx: 0x301},
	231: {cur: 0x10d, idx: 0x4},
	232: {cur: 0x57, idx: 0x23c},
	233: {cur: 0x5e, idx: 0x4},
	234: {cur: 0x5f, idx: 0x3f},
	235: {cur: 0x61, idx: 0x242},
	236: {cur: 0x10d, idx: 0x4},
	237: {cur: 0x65, idx: 0xe6},
	238: {cur: 0x61, idx: 0x242},
	239: {cur: 0x66, idx: 0x3f},
	240: {cur: 0x67, idx: 0x360},
	241: {cur: 0x6f, idx: 0x4},
	242: {cur: 0x81, idx: 0x4},
	243: {cur: 0x84, idx: 0x305},
	244: {cur: 0x13, idx: 0x4},
	245: {cur: 0x10d, idx: 0x4},
	246: {cur: 0x8d, idx: 0x4},
	247: {cur: 0x10d, idx: 0x4},
	248: {cur: 0x92, idx: 0x4},
	249: {cur: 0x122, idx: 0xe1},
	250: {cur: 0xa1, idx: 0x83},
	251: {cur: 0xa8, idx: 0x362},
	252: {cur: 0x10d, idx: 0x4},
	253: {cur: 0x61, idx: 0x242},
	254: {cur: 0xac, idx: 0x7a},
	255: {cur: 0xaf, idx: 0x367},
	256: {cur: 0xb3, idx: 0x90},
	257: {cur: 0xb7, idx: 0x4},
	258: {cur: 0x13, idx: 0x4},
	259: {cur: 0xb8, idx: 0x93},
	260: {cur: 0x13, idx: 0x4},
	261: {cur: 0xbe, idx: 0x4},
	262: {cur: 0xbe, idx: 0x4},
	263: {cur: 0xc4, idx: 0x86},
	264: {cur: 0xc5, idx: 0x9e},
	265: {cur: 0xc6, idx: 0x7a},
	266: {cur: 0xbe, idx: 0x4},
	267: {cur: 0xd2, idx: 0xae},
	268: {cur: 0xd4, idx: 0x4},
	269: {cur: 0xd5, idx: 0x36a},
	270: {cur: 0xd9, idx: 0x30},
	271: {cur: 0xda, idx: 0x4},
	272: {cur: 0x61, idx: 0x242},
	273: {cur: 0xdb, idx: 0x3f},
	274: {cur: 0xde, idx: 0x36d},
	275: {cur: 0x61, idx: 0x242},
	276: {cur: 0xe2, idx: 0x3f},
	277: {cur: 0x8, idx: 0x370},
	278: {cur: 0xe7, idx: 0x375},
	279: {cur: 0xbe, idx: 0x4},
	280: {cur: 0xee, idx: 0xb8},
	281: {cur: 0xf2, idx: 0x4},
	282: {cur: 0x13, idx: 0x4},
	283: {cur: 0xf4, idx: 0x247},
	284: {cur: 0xf8, idx: 0x2f1},
	285: {cur: 0x10d, idx: 0x4},
	286: {cur: 0x104, idx: 0x377},
	287: {cur: 0x105, idx: 0x37a},
	288: {cur: 0x122, idx: 0xe1},
	289: {cur: 0x124, idx: 0x86},
	290: {cur: 0x13, idx: 0x0},
	291: {cur: 0x2e, idx: 0x0},
	292: {cur: 0x42, idx: 0x0},
	293: {cur: 0x5a, idx: 0x37},
	294: {cur: 0x61, idx: 0x0},
	295: {cur: 0x70, idx: 0x0},
	296: {cur: 0x7a, idx: 0x0},
	297: {cur: 0x7b, idx: 0x0},
	298: {cur: 0x83, idx: 0x0},
	299: {cur: 0x8b, idx: 0x0},
	300: {cur: 0xb0, idx: 0x0},
	301: {cur: 0xbe, idx: 0x0},
	302: {cur: 0xe8, idx: 0xb4},
	303: {cur: 0xf3, idx: 0x0},
	304: {cur: 0xf9, idx: 0x4},
	305: {cur: 0x106, idx: 0x0},
	306: {cur: 0x10d, idx: 0x0},
	307: {cur: 0x112, idx: 0x0},
	308: {cur: 0x39, idx: 0x0},
	309: {cur: 0x5c, idx: 0x0},
	310: {cur: 0xe8, idx: 0x0},
	311: {cur: 0xf9, idx: 0x0},
	312: {cur: 0x102, idx: 0x0},
	313: {cur: 0x11, idx: 0x4},
	314: {cur: 0xf9, idx: 0xc7},
	315: {cur: 0x27, idx: 0x10},
	316: {cur: 0x40, idx: 0x4},
	317: {cur: 0xf9, idx: 0xc7},
	318: {cur: 0x43, idx: 0x4},
	319: {cur: 0xf9, idx: 0xc7},
	320: {cur: 0x45, idx: 0x28},
	321: {cur: 0x49, idx: 0x4},
	322: {cur: 0xf9, idx: 0xc7},
	323: {cur: 0x51, idx: 0x268},
	324: {cur: 0xf9, idx: 0xc7},
	325: {cur: 0xf9, idx: 0x4},
	326: {cur: 0x106, idx: 0xcf},
	327: {cur: 0x6c, idx: 0x45},
	328: {cur: 0x71, idx: 0x4b},
	329: {cur: 0x4, idx: 0x382},
	330: {cur: 0x8, idx: 0x385},
	331: {cur: 0x9, idx: 0x1},
	332: {cur: 0x11, idx: 0x389},
	333: {cur: 0x13, idx: 0xec},
	334: {cur: 0x14, idx: 0x38c},
	335: {cur: 0x42, idx: 0x20},
	336: {cur: 0xb0, idx: 0x4},
	337: {cur: 0x114, idx: 0x0},
	338: {cur: 0xba, idx: 0x97},
	339: {cur: 0xc0, idx: 0x397},
	340: {cur: 0xc2, idx: 0x39b},
	341: {cur: 0xc5, idx: 0x9e},
	342: {cur: 0xf9, idx: 0x4},
	343: {cur: 0xca, idx: 0x39f},
	344: {cur: 0xf9, idx: 0x4},
	345: {cur: 0x83, idx: 0x25},
	346: {cur: 0xf9, idx: 0x4},
	347: {cur: 0xf9, idx: 0xc7},
	348: {cur: 0xfe, idx: 0x4},
	349: {cur: 0x101, idx: 0x3a3},
	350: {cur: 0x13, idx: 0xec},
	351: {cur: 0x55, idx: 0x30},
	352: {cur: 0x83, idx: 0x25},
	353: {cur: 0xe8, idx: 0xb4},
	354: {cur: 0xf9, idx: 0x4},
	355: {cur: 0x5a, idx: 0x37},
	356: {cur: 0xe8, idx: 0xb4},
	357: {cur: 0x4, idx: 0x3a7},
	358: {cur: 0x39, idx: 0x2a8},
	359: {cur: 0x42, idx: 0x3aa},
	360: {cur: 0x70, idx: 0x3af},
	361: {cur: 0x7d, idx: 0x3b3},
	362: {cur: 0x83, idx: 0x25},
	363: {cur: 0xb0, idx: 0x3bc},
	364: {cur: 0xbe, idx: 0x3c0},
	365: {cur: 0xe8, idx: 0xb4},
	366: {cur: 0xf9, idx: 0x4},
	367: {cur: 0x10d, idx: 0x3c4},
	368: {cur: 0x68, idx: 0x42},
	369: {cur: 0xa9, idx: 0x3c8},
	370: {cur: 0x13, idx: 0x0},
	371: {cur: 0x2e, idx: 0x0},
	372: {cur: 0x39, idx: 0x0},
	373: {cur: 0x42, idx: 0x0},
	374: {cur: 0x5d, idx: 0x3cb},
	375: {cur: 0x70, idx: 0x0},
	376: {cur: 0x7a, idx: 0x0},
	377: {cur: 0x7b, idx: 0x0},
	378: {cur: 0x83, idx: 0x25},
	379: {cur: 0x8b, idx: 0x0},
	380: {cur: 0xb0, idx: 0x0},
	381: {cur: 0xbe, idx: 0x0},
	382: {cur: 0xf3, idx: 0x0},
	383: {cur: 0xf9, idx: 0x4},
	384: {cur: 0x102, idx: 0x0},
	385: {cur: 0x10d, idx: 0x0},
	386: {cur: 0x114, idx: 0x0},
	387: {cur: 0x83, idx: 0x25},
	388: {cur: 0xc5, idx: 0x9e},
	389: {cur: 0xe8, idx: 0xb4},
	390: {cur: 0xf9, idx: 0x4},
	391: {cur: 0x50, idx: 0x30},
	392: {cur: 0x50, idx: 0x301},
	393: {cur: 0x11, idx: 0x3ce},
	394: {cur: 0x13, idx: 0x3d2},
	395: {cur: 0x1d, idx: 0x3d6},
	396: {cur: 0x25, idx: 0x3d9},
	397: {cur: 0x26, idx: 0x3dd},
	398: {cur: 0x32, idx: 0x3e1},
	399: {cur: 0x38, idx: 0x3e5},
	400: {cur: 0x39, idx: 0x2a8},
	401: {cur: 0x40, idx: 0x3e9},
	402: {cur: 0x42, idx: 0x0},
	403: {cur: 0x43, idx: 0x3ed},
	404: {cur: 0x4b, idx: 0x3f1},
	405: {cur: 0x5e, idx: 0x3fa},
	406: {cur: 0x5f, idx: 0x3fe},
	407: {cur: 0x60, idx: 0x2ef},
	408: {cur: 0x61, idx: 0x403},
	409: {cur: 0x66, idx: 0x408},
	410: {cur: 0x70, idx: 0x0},
	411: {cur: 0x77, idx: 0x40d},
	412: {cur: 0x78, idx: 0x412},
	413: {cur: 0x80, idx: 0x417},
	414: {cur: 0x83, idx: 0x0},
	415: {cur: 0x90, idx: 0x41d},
	416: {cur: 0xab, idx: 0x422},
	417: {cur: 0xb0, idx: 0x3bc},
	418: {cur: 0xb7, idx: 0x427},
	419: {cur: 0xbe, idx: 0x3c0},
	420: {cur: 0xcc, idx: 0x42e},
	421: {cur: 0xd4, idx: 0x435},
	422: {cur: 0xda, idx: 0x439},
	423: {cur: 0xe0, idx: 0x43d},
	424: {cur: 0xf2, idx: 0x441},
	425: {cur: 0xf3, idx: 0x0},
	426: {cur: 0xf9, idx: 0x445},
	427: {cur: 0xfe, idx: 0x449},
	428: {cur: 0x105, idx: 0x37a},
	429: {cur: 0x10d, idx: 0x0},
	430: {cur: 0x114, idx: 0x44d},
	431: {cur: 0x24, idx: 0x35c},
	432: {cur: 0x11, idx: 0x0},
	433: {cur: 0x13, idx: 0x455},
	434: {cur: 0x25, idx: 0x0},
	435: {cur: 0x26, idx: 0x0},
	436: {cur: 0x32, idx: 0x0},
	437: {cur: 0x38, idx: 0x0},
	438: {cur: 0x39, idx: 0x4},
	439: {cur: 0x40, idx: 0x0},
	440: {cur: 0x42, idx: 0x20},
	441: {cur: 0x43, idx: 0x0},
	442: {cur: 0x5e, idx: 0x0},
	443: {cur: 0x5f, idx: 0x0},
	444: {cur: 0x61, idx: 0x3f},
	445: {cur: 0x66, idx: 0x0},
	446: {cur: 0x70, idx: 0x45b},
	447: {cur: 0x7a, idx: 0x0},
	448: {cur: 0x83, idx: 0x25},
	449: {cur: 0x8b, idx: 0x0},
	450: {cur: 0x90, idx: 0x0},
	451: {cur: 0xb0, idx: 0x0},
	452: {cur: 0xb7, idx: 0x0},
	453: {cur: 0xbe, idx: 0x461},
	454: {cur: 0xd4, idx: 0x0},
	455: {cur: 0xda, idx: 0x467},
	456: {cur: 0xe0, idx: 0x0},
	457: {cur: 0xf2, idx: 0x0},
	458: {cur: 0xf9, idx: 0x46d},
	459: {cur: 0xfe, idx: 0x0},
	460: {cur: 0x102, idx: 0x0},
	461: {cur: 0x106, idx: 0x0},
	462: {cur: 0x112, idx: 0x0},
	463: {cur: 0x114, idx: 0x0},
	464: {cur: 0x3a, idx: 0x327},
	465: {cur: 0x4f, idx: 0x238},
	466: {cur: 0x52, idx: 0x473},
	467: {cur: 0x68, idx: 0x42},
	468: {cur: 0x74, idx: 0x476},
	469: {cur: 0x87, idx: 0x67},
	470: {cur: 0x60, idx: 0x0},
	471: {cur: 0x97, idx: 0x2ef},
	472: {cur: 0xa1, idx: 0x83},
	473: {cur: 0xa9, idx: 0x3c8},
	474: {cur: 0xac, idx: 0x7a},
	475: {cur: 0xd2, idx: 0xae},
	476: {cur: 0xd5, idx: 0x36a},
	477: {cur: 0xe6, idx: 0x478},
	478: {cur: 0xed, idx: 0x47b},
	479: {cur: 0x104, idx: 0x377},
	480: {cur: 0x13, idx: 0xec},
	481: {cur: 0x39, idx: 0x97},
	482: {cur: 0x5e, idx: 0x14b},
	483: {cur: 0xd4, idx: 0x28e},
	484: {cur: 0xe8, idx: 0xb4},
	485: {cur: 0x114, idx: 0x0},
	486: {cur: 0x83, idx: 0x25},
	487: {cur: 0xe8, idx: 0xb4},
	488: {cur: 0xf9, idx: 0x4},
	489: {cur: 0xe8, idx: 0xb4},
	490: {cur: 0xf9, idx: 0x4},
	491: {cur: 0x13, idx: 0x2a5},
	492: {cur: 0x2e, idx: 0x47e},
	493: {cur: 0x39, idx: 0x2a8},
	494: {cur: 0x5a, idx: 0x37},
	495: {cur: 0x70, idx: 0x3af},
	496: {cur: 0x83, idx: 0x481},
	497: {cur: 0xb0, idx: 0x3bc},
	498: {cur: 0xe8, idx: 0xb4},
	499: {cur: 0xf3, idx: 0x486},
	500: {cur: 0xf9, idx: 0x4},
	501: {cur: 0x12, idx: 0x309},
	502: {cur: 0x83, idx: 0x25},
	503: {cur: 0xf9, idx: 0x4},
	504: {cur: 0xe8, idx: 0xb4},
	505: {cur: 0x84, idx: 0x305},
	506: {cur: 0xb8, idx: 0x93},
	507: {cur: 0x65, idx: 0xe6},
	508: {cur: 0xf9, idx: 0x4},
	509: {cur: 0x78, idx: 0x492},
	510: {cur: 0xe8, idx: 0xb4},
	511: {cur: 0xf9, idx: 0x4},
	512: {cur: 0xe8, idx: 0xb4},
	513: {cur: 0xf9, idx: 0x4},
	514: {cur: 0x13, idx: 0x0},
	515: {cur: 0x2e, idx: 0x0},
	516: {cur: 0x39, idx: 0x0},
	517: {cur: 0x42, idx: 0x0},
	518: {cur: 0x5c, idx: 0x0},
	519: {cur: 0x61, idx: 0x0},
	520: {cur: 0x70, idx: 0x0},
	521: {cur: 0x7a, idx: 0x0},
	522: {cur: 0x7b, idx: 0x0},
	523: {cur: 0x83, idx: 0x0},
	524: {cur: 0x8b, idx: 0x0},
	525: {cur: 0xb0, idx: 0x0},
	526: {cur: 0xbe, idx: 0x0},
	527: {cur: 0xf3, idx: 0x0},
	528: {cur: 0xf9, idx: 0x0},
	529: {cur: 0x102, idx: 0x0},
	530: {cur: 0x10d, idx: 0x0},
	531: {cur: 0x114, idx: 0x0},
	532: {cur: 0x18, idx: 0x9},
	533: {cur: 0x13, idx: 0x0},
	534: {cur: 0x83, idx: 0x25},
	535: {cur: 0xc7, idx: 0xa2},
	536: {cur: 0xe8, idx: 0xb4},
	537: {cur: 0xf9, idx: 0x4},
	538: {cur: 0x13, idx: 0x0},
	539: {cur: 0x2e, idx: 0x0},
	540: {cur: 0x39, idx: 0x0},
	541: {cur: 0x42, idx: 0x0},
	542: {cur: 0x5c, idx: 0x0},
	543: {cur: 0x61, idx: 0x0},
	544: {cur: 0x70, idx: 0x0},
	545: {cur: 0x75, idx: 0x50},
	546: {cur: 0x7a, idx: 0x0},
	547: {cur: 0x7b, idx: 0x0},
	548: {cur: 0x83, idx: 0x25},
	549: {cur: 0x8b, idx: 0x0},
	550: {cur: 0xb0, idx: 0x0},
	551: {cur: 0xbe, idx: 0x0},
	552: {cur: 0xf3, idx: 0x0},
	553: {cur: 0xf9, idx: 0x0},
	554: {cur: 0x102, idx: 0x0},
	555: {cur: 0x10d, idx: 0x0},
	556: {cur: 0x7, idx: 0x49d},
	557: {cur: 0xe8, idx: 0xb4},
	558: {cur: 0xf9, idx: 0x4},
	559: {cur: 0x13, idx: 0xec},
	560: {cur: 0x76, idx: 0x53},
	561: {cur: 0x7b, idx: 0x7a},
	562: {cur: 0xe8, idx: 0xb4},
	563: {cur: 0xb8, idx: 0x93},
	564: {cur: 0x42, idx: 0x25},
	565: {cur: 0x13, idx: 0x0},
	566: {cur: 0x2e, idx: 0x0},
	567: {cur: 0x39, idx: 0x0},
	568: {cur: 0x5c, idx: 0x0},
	569: {cur: 0x61, idx: 0x0},
	570: {cur: 0x7b, idx: 0x0},
	571: {cur: 0x8b, idx: 0x0},
	572: {cur: 0xb0, idx: 0x0},
	573: {cur: 0xbe, idx: 0x0},
	574: {cur: 0xf3, idx: 0x0},
	575: {cur: 0xf9, idx: 0x0},
	576: {cur: 0x102, idx: 0x0},
	577: {cur: 0x2e, idx: 0x0},
	578: {cur: 0x70, idx: 0x0},
	579: {cur: 0x83, idx: 0x0},
	580: {cur: 0x8b, idx: 0x0},
	581: {cur: 0xb0, idx: 0x0},
	582: {cur: 0xe8, idx: 0xb4},
	583: {cur: 0xf3, idx: 0x0},
	584: {cur: 0x13, idx: 0xec},
	585: {cur: 0x42, idx: 0x4a4},
	586: {cur: 0x83, idx: 0x4a8},
	587: {cur: 0xe8, idx: 0xb4},
	588: {cur: 0xf9, idx: 0x4},
	589: {cur: 0xf4, idx: 0x247},
	590: {cur: 0x13, idx: 0x0},
	591: {cur: 0x42, idx: 0x0},
	592: {cur: 0x70, idx: 0x0},
	593: {cur: 0x7a, idx: 0x0},
	594: {cur: 0x7b, idx: 0x0},
	595: {cur: 0x83, idx: 0x0},
	596: {cur: 0x8b, idx: 0x0},
	597: {cur: 0xbe, idx: 0x0},
	598: {cur: 0x102, idx: 0x0},
	599: {cur: 0x52, idx: 0x473},
	600: {cur: 0x84, idx: 0x305},
	601: {cur: 0xf4, idx: 0x247},
	602: {cur: 0x13, idx: 0xec},
	603: {cur: 0x4a, idx: 0x4ac},
	604: {cur: 0xe8, idx: 0xb4},
	605: {cur: 0x84, idx: 0x305},
	606: {cur: 0x25, idx: 0x4b0},
	607: {cur: 0x39, idx: 0x4b5},
	608: {cur: 0x8e, idx: 0x6e},
	609: {cur: 0xd0, idx: 0xaa},
	610: {cur: 0xe8, idx: 0xb4},
	611: {cur: 0xf9, idx: 0x4},
	612: {cur: 0x50, idx: 0x301},
	613: {cur: 0x84, idx: 0x305},
	614: {cur: 0x86, idx: 0x63},
	615: {cur: 0xe8, idx: 0xb4},
	616: {cur: 0xf9, idx: 0x4},
	617: {cur: 0xe8, idx: 0xb4},
	618: {cur: 0xf9, idx: 0x4},
	619: {cur: 0x13, idx: 0xec},
	620: {cur: 0xe8, idx: 0xb4},
	621: {cur: 0xf4, idx: 0x247},
	622: {cur: 0x13, idx: 0x0},
	623: {cur: 0x2e, idx: 0x0},
	624: {cur: 0x39, idx: 0x0},
	625: {cur: 0x61, idx: 0x0},
	626: {cur: 0x70, idx: 0x0},
	627: {cur: 0x7a, idx: 0x0},
	628: {cur: 0x7b, idx: 0x0},
	629: {cur: 0x85, idx: 0x4c1},
	630: {cur: 0x8b, idx: 0x0},
	631: {cur: 0xb0, idx: 0x0},
	632: {cur: 0xbe, idx: 0x0},
	633: {cur: 0xe8, idx: 0xb4},
	634: {cur: 0xf3, idx: 0x0},
	635: {cur: 0xf9, idx: 0x0},
	636: {cur: 0x10d, idx: 0x0},
	637: {cur: 0xf4, idx: 0x247},
	638: {cur: 0x12, idx: 0x309},
	639: {cur: 0x13, idx: 0xec},
	640: {cur: 0x83, idx: 0x25},
	641: {cur: 0xe8, idx: 0xb4},
	642: {cur: 0xf9, idx: 0x4},
	643: {cur: 0xf8, idx: 0x2f1},
	644: {cur: 0xf9, idx: 0x4},
	645: {cur: 0x3a, idx: 0x327},
	646: {cur: 0x9, idx: 0x1},
	647: {cur: 0x8f, idx: 0x72},
	648: {cur: 0xe8, idx: 0xb4},
	649: {cur: 0x13, idx: 0x0},
	650: {cur: 0x2e, idx: 0x0},
	651: {cur: 0x39, idx: 0x0},
	652: {cur: 0x42, idx: 0x0},
	653: {cur: 0x61, idx: 0x0},
	654: {cur: 0x70, idx: 0x0},
	655: {cur: 0x7a, idx: 0x0},
	656: {cur: 0x7b, idx: 0x0},
	657: {cur: 0x83, idx: 0x0},
	658: {cur: 0x8b, idx: 0x0},
	659: {cur: 0xb0, idx: 0x0},
	660: {cur: 0xbe, idx: 0x0},
	661: {cur: 0xf3, idx: 0x0},
	662: {cur: 0xf9, idx: 0x0},
	663: {cur: 0x102, idx: 0x0},
	664: {cur: 0x106, idx: 0x0},
	665: {cur: 0x10d, idx: 0x0},
	666: {cur: 0x112, idx: 0x0},
	667: {cur: 0x114, idx: 0x0},
	668: {cur: 0x3a, idx: 0x327},
	669: {cur: 0x84, idx: 0x305},
	670: {cur: 0x84, idx: 0x305},
	671: {cur: 0x13, idx: 0xec},
	672: {cur: 0x83, idx: 0x25},
	673: {cur: 0x99, idx: 0x80},
	674: {cur: 0xe8, idx: 0xb4},
	675: {cur: 0xf9, idx: 0x4},
	676: {cur: 0x84, idx: 0x305},
	677: {cur: 0xf4, idx: 0x247},
	678: {cur: 0x84, idx: 0x305},
	679: {cur: 0xac, idx: 0x7a},
	680: {cur: 0xa1, idx: 0x83},
	681: {cur: 0xb6, idx: 0x4ce},
	682: {cur: 0x13, idx: 0x0},
	683: {cur: 0x42, idx: 0x0},
	684: {cur: 0x61, idx: 0x0},
	685: {cur: 0x70, idx: 0x0},
	686: {cur: 0x7a, idx: 0x0},
	687: {cur: 0x7b, idx: 0x0},
	688: {cur: 0x83, idx: 0x0},
	689: {cur: 0x8b, idx: 0x0},
	690: {cur: 0xa3, idx: 0x4d2},
	691: {cur: 0xbe, idx: 0x0},
	692: {cur: 0xf3, idx: 0x0},
	693: {cur: 0x102, idx: 0x0},
	694: {cur: 0x83, idx: 0x25},
	695: {cur: 0xe8, idx: 0xb4},
	696: {cur: 0xf9, idx: 0x4},
	697: {cur: 0xa7, idx: 0x88},
	698: {cur: 0xe8, idx: 0xb4},
	699: {cur: 0xf9, idx: 0x4},
	700: {cur: 0xe8, idx: 0xb4},
	701: {cur: 0xf9, idx: 0x4},
	702: {cur: 0x39, idx: 0x0},
	703: {cur: 0xb0, idx: 0x0},
	704: {cur: 0xb3, idx: 0x90},
	705: {cur: 0xf9, idx: 0x0},
	706: {cur: 0x26, idx: 0x4},
	707: {cur: 0xda, idx: 0x4},
	708: {cur: 0x45, idx: 0x4ec},
	709: {cur: 0xa6, idx: 0x86},
	710: {cur: 0xe8, idx: 0xb4},
	711: {cur: 0xf9, idx: 0x4},
	712: {cur: 0xb7, idx: 0x4},
	713: {cur: 0x13, idx: 0x0},
	714: {cur: 0x2e, idx: 0x0},
	715: {cur: 0x39, idx: 0x0},
	716: {cur: 0x42, idx: 0x0},
	717: {cur: 0x70, idx: 0x0},
	718: {cur: 0x7a, idx: 0x0},
	719: {cur: 0x7b, idx: 0x0},
	720: {cur: 0x83, idx: 0x0},
	721: {cur: 0x8b, idx: 0x0},
	722: {cur: 0xb0, idx: 0x0},
	723: {cur: 0xbc, idx: 0x30},
	724: {cur: 0xbe, idx: 0x0},
	725: {cur: 0xf3, idx: 0x0},
	726: {cur: 0xf9, idx: 0x0},
	727: {cur: 0x102, idx: 0x0},
	728: {cur: 0x106, idx: 0x0},
	729: {cur: 0x10d, idx: 0x0},
	730: {cur: 0x114, idx: 0x0},
	731: {cur: 0xbd, idx: 0x4ff},
	732: {cur: 0xe8, idx: 0xb4},
	733: {cur: 0x13, idx: 0xec},
	734: {cur: 0x39, idx: 0x97},
	735: {cur: 0x5e, idx: 0x14b},
	736: {cur: 0xd4, idx: 0x28e},
	737: {cur: 0xe8, idx: 0xb4},
	738: {cur: 0x114, idx: 0x0},
	739: {cur: 0x14, idx: 0x38c},
	740: {cur: 0xf9, idx: 0x4},
	741: {cur: 0x8, idx: 0x370},
	742: {cur: 0xe0, idx: 0x4},
	743: {cur: 0x8, idx: 0x370},
	744: {cur: 0xbc, idx: 0x30},
	745: {cur: 0x61, idx: 0x242},
	746: {cur: 0xe2, idx: 0x3f},
	747: {cur: 0xf8, idx: 0x2f1},
	748: {cur: 0x5b, idx: 0x391},
	749: {cur: 0x84, idx: 0x305},
	750: {cur: 0xf9, idx: 0x4},
	751: {cur: 0xd0, idx: 0xaa},
	752: {cur: 0xe8, idx: 0xb4},
	753: {cur: 0xc6, idx: 0x50c},
	754: {cur: 0x13, idx: 0x0},
	755: {cur: 0x39, idx: 0x0},
	756: {cur: 0x42, idx: 0x0},
	757: {cur: 0x61, idx: 0x0},
	758: {cur: 0x70, idx: 0x0},
	759: {cur: 0x7a, idx: 0x0},
	760: {cur: 0x7b, idx: 0x0},
	761: {cur: 0x83, idx: 0x0},
	762: {cur: 0x8b, idx: 0x0},
	763: {cur: 0xb0, idx: 0x0},
	764: {cur: 0xbe, idx: 0x0},
	765: {cur: 0xc7, idx: 0xa2},
	766: {cur: 0xf3, idx: 0x0},
	767: {cur: 0xf9, idx: 0x0},
	768: {cur: 0x102, idx: 0x0},
	769: {cur: 0x4, idx: 0x3a7},
	770: {cur: 0x13, idx: 0xec},
	771: {cur: 0xc9, idx: 0x50f},
	772: {cur: 0xe8, idx: 0xb4},
	773: {cur: 0x9, idx: 0x1},
	774: {cur: 0x4a, idx: 0x4ac},
	775: {cur: 0xc9, idx: 0x514},
	776: {cur: 0xa8, idx: 0x362},
	777: {cur: 0xb6, idx: 0x4ce},
	778: {cur: 0xc9, idx: 0x4ac},
	779: {cur: 0xe3, idx: 0xb1},
	780: {cur: 0xc2, idx: 0x39b},
	781: {cur: 0x27, idx: 0x10},
	782: {cur: 0xc2, idx: 0x0},
	783: {cur: 0xc2, idx: 0x0},
	784: {cur: 0xf9, idx: 0x4},
	785: {cur: 0x24, idx: 0x35c},
	786: {cur: 0x13, idx: 0x0},
	787: {cur: 0x2e, idx: 0x0},
	788: {cur: 0x39, idx: 0x0},
	789: {cur: 0x42, idx: 0x0},
	790: {cur: 0x5c, idx: 0x0},
	791: {cur: 0x61, idx: 0x0},
	792: {cur: 0x70, idx: 0x0},
	793: {cur: 0x7a, idx: 0x0},
	794: {cur: 0x7b, idx: 0x0},
	795: {cur: 0x83, idx: 0x0},
	796: {cur: 0x8b, idx: 0x0},
	797: {cur: 0xb0, idx: 0x0},
	798: {cur: 0xbe, idx: 0x0},
	799: {cur: 0xf3, idx: 0x0},
	800: {cur: 0xf9, idx: 0x0},
	801: {cur: 0x102, idx: 0x0},
	802: {cur: 0x10d, idx: 0x0},
	803: {cur: 0xa0, idx: 0x4b},
	804: {cur: 0xf4, idx: 0x247},
	805: {cur: 0x0, idx: 0x51b},
	806: {cur: 0x83, idx: 0x25},
	807: {cur: 0xd0, idx: 0xaa},
	808: {cur: 0xd1, idx: 0x18},
	809: {cur: 0xe8, idx: 0xb4},
	810: {cur: 0xec, idx: 0x520},
	811: {cur: 0xf5, idx: 0xc3},
	812: {cur: 0xf9, idx: 0x4},
	813: {cur: 0x37, idx: 0x18},
	814: {cur: 0xd1, idx: 0x0},
	815: {cur: 0x85, idx: 0x4c1},
	816: {cur: 0x8e, idx: 0x6e},
	817: {cur: 0xa0, idx: 0x4b},
	818: {cur: 0xd2, idx: 0xae},
	819: {cur: 0xf4, idx: 0x247},
	820: {cur: 0xd0, idx: 0xaa},
	821: {cur: 0x84, idx: 0x305},
	822: {cur: 0xf4, idx: 0x247},
	823: {cur: 0x50, idx: 0x527},
	824: {cur: 0xbc, idx: 0x30},
	825: {cur: 0xd9, idx: 0x52b},
	826: {cur: 0xe8, idx: 0xb4},
	827: {cur: 0xbc, idx: 0x52f},
	828: {cur: 0xd9, idx: 0x30},
	829: {cur: 0xb6, idx: 0x4ce},
	830: {cur: 0x91, idx: 0x533},
	831: {cur: 0xe8, idx: 0xb4},
	832: {cur: 0x112, idx: 0x53b},
	833: {cur: 0x13, idx: 0x0},
	834: {cur: 0x2e, idx: 0x0},
	835: {cur: 0x39, idx: 0x0},
	836: {cur: 0x42, idx: 0x0},
	837: {cur: 0x61, idx: 0x0},
	838: {cur: 0x70, idx: 0x0},
	839: {cur: 0x7a, idx: 0x54b},
	840: {cur: 0x7b, idx: 0x0},
	841: {cur: 0x83, idx: 0x0},
	842: {cur: 0x8b, idx: 0x0},
	843: {cur: 0xbe, idx: 0x0},
	844: {cur: 0xf3, idx: 0x0},
	845: {cur: 0xf9, idx: 0x0},
	846: {cur: 0x102, idx: 0x0},
	847: {cur: 0x39, idx: 0x0},
	848: {cur: 0x83, idx: 0x25},
	849: {cur: 0xe8, idx: 0xb4},
	850: {cur: 0xf9, idx: 0x4},
	851: {cur: 0xdf, idx: 0x240},
	852: {cur: 0x4f, idx: 0x238},
	853: {cur: 0x5b, idx: 0x391},
	854: {cur: 0x84, idx: 0x305},
	855: {cur: 0x6, idx: 0x54f},
	856: {cur: 0xe8, idx: 0xb4},
	857: {cur: 0xa3, idx: 0x555},
	858: {cur: 0x13, idx: 0x0},
	859: {cur: 0x18, idx: 0x2d3},
	860: {cur: 0x21, idx: 0x559},
	861: {cur: 0x37, idx: 0x55f},
	862: {cur: 0x83, idx: 0x25},
	863: {cur: 0x8b, idx: 0x0},
	864: {cur: 0xbe, idx: 0x0},
	865: {cur: 0x102, idx: 0x0},
	866: {cur: 0x13, idx: 0x0},
	867: {cur: 0x18, idx: 0x9},
	868: {cur: 0x21, idx: 0x559},
	869: {cur: 0x37, idx: 0x55f},
	870: {cur: 0x83, idx: 0x25},
	871: {cur: 0x8b, idx: 0x0},
	872: {cur: 0xbe, idx: 0x0},
	873: {cur: 0x102, idx: 0x0},
	874: {cur: 0x13, idx: 0x0},
	875: {cur: 0x1a, idx: 0x253},
	876: {cur: 0x25, idx: 0x117},
	877: {cur: 0x2e, idx: 0x573},
	878: {cur: 0x32, idx: 0x11f},
	879: {cur: 0x38, idx: 0x123},
	880: {cur: 0x42, idx: 0x0},
	881: {cur: 0x50, idx: 0x527},
	882: {cur: 0x51, idx: 0x268},
	883: {cur: 0x55, idx: 0x577},
	884: {cur: 0x56, idx: 0x57b},
	885: {cur: 0x61, idx: 0x0},
	886: {cur: 0x70, idx: 0x0},
	887: {cur: 0x7b, idx: 0x0},
	888: {cur: 0x7f, idx: 0x580},
	889: {cur: 0x81, idx: 0x172},
	890: {cur: 0x83, idx: 0x0},
	891: {cur: 0x8b, idx: 0x0},
	892: {cur: 0xbc, idx: 0x52f},
	893: {cur: 0xbe, idx: 0x0},
	894: {cur: 0xd9, idx: 0x30},
	895: {cur: 0xf3, idx: 0x0},
	896: {cur: 0x102, idx: 0x0},
	897: {cur: 0x84, idx: 0x305},
	898: {cur: 0xe8, idx: 0xb4},
	899: {cur: 0xf4, idx: 0x247},
	900: {cur: 0x3a, idx: 0x327},
	901: {cur: 0xf8, idx: 0x2f1},
	902: {cur: 0x83, idx: 0x25},
	903: {cur: 0xe8, idx: 0xb4},
	904: {cur: 0xf9, idx: 0x4},
	905: {cur: 0x91, idx: 0x584},
	906: {cur: 0xb3, idx: 0x90},
	907: {cur: 0xda, idx: 0x292},
	908: {cur: 0xb3, idx: 0x90},
	909: {cur: 0xda, idx: 0x4},
	910: {cur: 0xf9, idx: 0xc7},
	911: {cur: 0xe8, idx: 0xb4},
	912: {cur: 0xf9, idx: 0x4},
	913: {cur: 0xf8, idx: 0x2f1},
	914: {cur: 0x84, idx: 0x305},
	915: {cur: 0x13, idx: 0xec},
	916: {cur: 0x83, idx: 0x25},
	917: {cur: 0x5b, idx: 0x391},
	918: {cur: 0x57, idx: 0x23c},
	919: {cur: 0x5c, idx: 0x0},
	920: {cur: 0x61, idx: 0x0},
	921: {cur: 0x13, idx: 0x588},
	922: {cur: 0xbe, idx: 0x58d},
	923: {cur: 0xee, idx: 0xb8},
	924: {cur: 0x13, idx: 0xec},
	925: {cur: 0x83, idx: 0x25},
	926: {cur: 0xe8, idx: 0xb4},
	927: {cur: 0xf1, idx: 0xbb},
	928: {cur: 0xf9, idx: 0x4},
	929: {cur: 0x42, idx: 0x4a8},
	930: {cur: 0xf9, idx: 0x4},
	931: {cur: 0x13, idx: 0x0},
	932: {cur: 0x2e, idx: 0x0},
	933: {cur: 0x39, idx: 0x0},
	934: {cur: 0x42, idx: 0x0},
	935: {cur: 0x5c, idx: 0x0},
	936: {cur: 0x61, idx: 0x0},
	937: {cur: 0x70, idx: 0x0},
	938: {cur: 0x7a, idx: 0x0},
	939: {cur: 0x7b, idx: 0x0},
	940: {cur: 0x83, idx: 0x25},
	941: {cur: 0x8b, idx: 0x0},
	942: {cur: 0xb0, idx: 0x0},
	943: {cur: 0xbe, idx: 0x0},
	944: {cur: 0xf3, idx: 0x0},
	945: {cur: 0xf5, idx: 0xc3},
	946: {cur: 0xf6, idx: 0x592},
	947: {cur: 0xf9, idx: 0x0},
	948: {cur: 0x102, idx: 0x0},
	949: {cur: 0x10d, idx: 0x0},
	950: {cur: 0xc6, idx: 0x7a},
	951: {cur: 0xe8, idx: 0xb4},
	952: {cur: 0xf9, idx: 0x4},
	953: {cur: 0xc6, idx: 0x0},
	954: {cur: 0xff, idx: 0x59a},
	955: {cur: 0x4, idx: 0x3a7},
	956: {cur: 0xe8, idx: 0xb4},
	957: {cur: 0xff, idx: 0x5a0},
	958: {cur: 0x92, idx: 0x4},
	959: {cur: 0x92, idx: 0x4},
	960: {cur: 0x13, idx: 0xec},
	961: {cur: 0xe8, idx: 0xb4},
	962: {cur: 0xf4, idx: 0x247},
	963: {cur: 0x83, idx: 0x25},
	964: {cur: 0xf9, idx: 0x4},
	965: {cur: 0xf8, idx: 0x2f1},
	966: {cur: 0xb8, idx: 0x93},
	967: {cur: 0x13, idx: 0xec},
	968: {cur: 0x42, idx: 0x4a8},
	969: {cur: 0x79, idx: 0x5a7},
	970: {cur: 0x8b, idx: 0x5ab},
	971: {cur: 0x42, idx: 0x20},
	972: {cur: 0x42, idx: 0x20},
	973: {cur: 0xa8, idx: 0x362},
	974: {cur: 0x42, idx: 0x20},
	975: {cur: 0xda, idx: 0x4},
	976: {cur: 0x13, idx: 0xec},
	977: {cur: 0x83, idx: 0x25},
	978: {cur: 0x8b, idx: 0x5ab},
	979: {cur: 0xf3, idx: 0x4},
	980: {cur: 0x8b, idx: 0x6a},
	981: {cur: 0xf3, idx: 0xbf},
	982: {cur: 0xa8, idx: 0x362},
	983: {cur: 0xe8, idx: 0xb4},
	984: {cur: 0x122, idx: 0xe1},
} // Size: 3964 bytes

var narrowLangIndex = []uint16{ // 743 elements
	// Entry 0 - 3F
	0x0000, 0x0060, 0x0060, 0x0060, 0x0061, 0x0061, 0x0061, 0x0061,
	0x0061, 0x0061, 0x0061, 0x0062, 0x0062, 0x007f, 0x007f, 0x0080,
	0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
	0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
	0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
	0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0089, 0x0089,
	0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x00a4,
	0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00d3, 0x00d3, 0x00d3,
	// Entry 40 - 7F
	0x00d3, 0x00d3, 0x00d4, 0x00d4, 0x00d4, 0x00d4, 0x00d4, 0x00d4,
	0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
	0x00d8, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2,
	0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e3,
	0x00e3, 0x00e3, 0x00e3, 0x00e9, 0x00e9, 0x00ee, 0x00ee, 0x00ee,
	0x00ee, 0x00ee, 0x00f6, 0x00f6, 0x00f6, 0x00f7, 0x00f7, 0x00f7,
	0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
	0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
	// Entry 80 - BF
	0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
	0x00f7, 0x00f7, 0x00f7, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	// Entry C0 - FF
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0102,
	0x0102, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
	0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
	// Entry 100 - 13F
	0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
	0x0108, 0x0108, 0x0109, 0x010a, 0x010a, 0x010b, 0x010b, 0x010b,
	0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b,
	0x010b, 0x010d, 0x010d, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e,
	0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	// Entry 140 - 17F
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0119, 0x0119, 0x011a, 0x011a, 0x011c,
	0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011e, 0x011e, 0x011e,
	0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e,
	0x011e, 0x011e, 0x011f, 0x011f, 0x0122, 0x0122, 0x0123, 0x0123,
	0x0123, 0x0123, 0x0123, 0x0124, 0x0124, 0x0125, 0x0125, 0x0126,
	0x0126, 0x0126, 0x0126, 0x0126, 0x0126, 0x0127, 0x0127, 0x012d,
	// Entry 180 - 1BF
	0x012d, 0x012d, 0x012d, 0x012d, 0x0130, 0x0130, 0x0130, 0x0130,
	0x0130, 0x0130, 0x0130, 0x0130, 0x0131, 0x0131, 0x0131, 0x0131,
	0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131,
	0x0131, 0x0131, 0x0131, 0x0131, 0x0132, 0x0132, 0x0132, 0x0132,
	0x0132, 0x0132, 0x0132, 0x0132, 0x0133, 0x0133, 0x0134, 0x0134,
	0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135,
	0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135,
	0x0140, 0x0140, 0x0140, 0x0140, 0x0141, 0x0141, 0x0141, 0x0141,
	// Entry 1C0 - 1FF
	0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0142,
	0x0142, 0x0142, 0x0142, 0x0142, 0x014d, 0x014d, 0x014d, 0x014d,
	0x014d, 0x014d, 0x014d, 0x014d, 0x014e, 0x014e, 0x014e, 0x014e,
	0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e,
	0x014e, 0x014e, 0x014e, 0x014f, 0x014f, 0x0150, 0x0150, 0x0151,
	0x0151, 0x0152, 0x0152, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153,
	0x0153, 0x0153, 0x0153, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
	0x0154, 0x0154, 0x0155, 0x0155, 0x0155, 0x0155, 0x0155, 0x0155,
	// Entry 200 - 23F
	0x0155, 0x0155, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156,
	0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156,
	0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156,
	0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156,
	0x0156, 0x0157, 0x0157, 0x0157, 0x0157, 0x0157, 0x0157, 0x0158,
	0x0158, 0x0158, 0x0158, 0x0158, 0x0158, 0x0159, 0x0159, 0x0159,
	0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159,
	0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x015a,
	// Entry 240 - 27F
	0x015a, 0x015a, 0x015a, 0x015a, 0x015b, 0x015b, 0x015b, 0x015b,
	0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b,
	0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b,
	0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b,
	0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015d, 0x015d, 0x015e,
	0x015e, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f,
	0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f,
	0x015f, 0x015f, 0x015f, 0x015f, 0x0161, 0x0161, 0x0161, 0x0161,
	// Entry 280 - 2BF
	0x0161, 0x0161, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
	0x0164, 0x0164, 0x0166, 0x0166, 0x0166, 0x0166, 0x0167, 0x0167,
	0x0167, 0x0167, 0x0167, 0x0167, 0x0168, 0x0168, 0x0168, 0x0168,
	0x0168, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x016a, 0x016a,
	0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a,
	0x016a, 0x016b, 0x016b, 0x016b, 0x016b, 0x016b, 0x016b, 0x016b,
	0x016b, 0x016b, 0x016b, 0x016c, 0x016c, 0x016d, 0x016d, 0x016d,
	0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d,
	// Entry 2C0 - 2FF
	0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016e, 0x016e, 0x016e,
	0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e,
	0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e,
	0x016e, 0x016e, 0x016e, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
	0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x0177, 0x0177,
} // Size: 1510 bytes

var narrowSymIndex = []curToIndex{ // 375 elements
	0:   {cur: 0x9, idx: 0x1},
	1:   {cur: 0x11, idx: 0x4},
	2:   {cur: 0x13, idx: 0x4},
	3:   {cur: 0x18, idx: 0x9},
	4:   {cur: 0x1a, idx: 0x4},
	5:   {cur: 0x1b, idx: 0xc},
	6:   {cur: 0x25, idx: 0x4},
	7:   {cur: 0x26, idx: 0x4},
	8:   {cur: 0x27, idx: 0x10},
	9:   {cur: 0x2e, idx: 0x13},
	10:  {cur: 0x32, idx: 0x4},
	11:  {cur: 0x35, idx: 0x16},
	12:  {cur: 0x37, idx: 0x18},
	13:  {cur: 0x38, idx: 0x4},
	14:  {cur: 0x39, idx: 0x4},
	15:  {cur: 0x40, idx: 0x4},
	16:  {cur: 0x42, idx: 0x25},
	17:  {cur: 0x43, idx: 0x4},
	18:  {cur: 0x45, idx: 0x28},
	19:  {cur: 0x48, idx: 0x4},
	20:  {cur: 0x49, idx: 0x4},
	21:  {cur: 0x4c, idx: 0x2c},
	22:  {cur: 0x50, idx: 0x30},
	23:  {cur: 0x51, idx: 0x4},
	24:  {cur: 0x56, idx: 0x33},
	25:  {cur: 0x5a, idx: 0x37},
	26:  {cur: 0x5c, idx: 0x3b},
	27:  {cur: 0x5e, idx: 0x4},
	28:  {cur: 0x5f, idx: 0x3f},
	29:  {cur: 0x61, idx: 0x3f},
	30:  {cur: 0x66, idx: 0x3f},
	31:  {cur: 0x68, idx: 0x42},
	32:  {cur: 0x6c, idx: 0x45},
	33:  {cur: 0x6f, idx: 0x4},
	34:  {cur: 0x70, idx: 0x4},
	35:  {cur: 0x71, idx: 0x4b},
	36:  {cur: 0x73, idx: 0x4d},
	37:  {cur: 0x75, idx: 0x50},
	38:  {cur: 0x76, idx: 0x53},
	39:  {cur: 0x7a, idx: 0x56},
	40:  {cur: 0x7b, idx: 0x5a},
	41:  {cur: 0x7f, idx: 0x30},
	42:  {cur: 0x81, idx: 0x4},
	43:  {cur: 0x83, idx: 0x25},
	44:  {cur: 0x86, idx: 0x63},
	45:  {cur: 0x87, idx: 0x67},
	46:  {cur: 0x88, idx: 0x6a},
	47:  {cur: 0x8b, idx: 0x6a},
	48:  {cur: 0x8d, idx: 0x4},
	49:  {cur: 0x8e, idx: 0x6e},
	50:  {cur: 0x8f, idx: 0x72},
	51:  {cur: 0x90, idx: 0x76},
	52:  {cur: 0x91, idx: 0x7a},
	53:  {cur: 0x92, idx: 0x4},
	54:  {cur: 0x94, idx: 0x7d},
	55:  {cur: 0x99, idx: 0x80},
	56:  {cur: 0xa1, idx: 0x83},
	57:  {cur: 0xa6, idx: 0x86},
	58:  {cur: 0xa7, idx: 0x88},
	59:  {cur: 0xac, idx: 0x7a},
	60:  {cur: 0xb0, idx: 0x4},
	61:  {cur: 0xb3, idx: 0x90},
	62:  {cur: 0xb7, idx: 0x4},
	63:  {cur: 0xb8, idx: 0x93},
	64:  {cur: 0xba, idx: 0x97},
	65:  {cur: 0xbc, idx: 0x30},
	66:  {cur: 0xbd, idx: 0x7a},
	67:  {cur: 0xbe, idx: 0x4},
	68:  {cur: 0xc5, idx: 0x9e},
	69:  {cur: 0xc6, idx: 0x7a},
	70:  {cur: 0xc7, idx: 0xa2},
	71:  {cur: 0xca, idx: 0xa6},
	72:  {cur: 0xd0, idx: 0xaa},
	73:  {cur: 0xd1, idx: 0x18},
	74:  {cur: 0xd2, idx: 0xae},
	75:  {cur: 0xd4, idx: 0x4},
	76:  {cur: 0xd9, idx: 0x30},
	77:  {cur: 0xda, idx: 0x4},
	78:  {cur: 0xdb, idx: 0x3f},
	79:  {cur: 0xe0, idx: 0x4},
	80:  {cur: 0xe2, idx: 0x3f},
	81:  {cur: 0xe3, idx: 0xb1},
	82:  {cur: 0xe6, idx: 0x3f},
	83:  {cur: 0xe8, idx: 0xb4},
	84:  {cur: 0xee, idx: 0xb8},
	85:  {cur: 0xf1, idx: 0xbb},
	86:  {cur: 0xf2, idx: 0x4},
	87:  {cur: 0xf3, idx: 0x4},
	88:  {cur: 0xf5, idx: 0xc3},
	89:  {cur: 0xf9, idx: 0x4},
	90:  {cur: 0xfe, idx: 0x4},
	91:  {cur: 0x101, idx: 0x10},
	92:  {cur: 0x102, idx: 0xcb},
	93:  {cur: 0x10d, idx: 0x4},
	94:  {cur: 0x122, idx: 0xe1},
	95:  {cur: 0x124, idx: 0xe3},
	96:  {cur: 0xf3, idx: 0xbf},
	97:  {cur: 0xf3, idx: 0xbf},
	98:  {cur: 0x11, idx: 0x105},
	99:  {cur: 0x13, idx: 0xec},
	100: {cur: 0x1a, idx: 0x109},
	101: {cur: 0x25, idx: 0x117},
	102: {cur: 0x26, idx: 0x11b},
	103: {cur: 0x32, idx: 0x11f},
	104: {cur: 0x38, idx: 0x123},
	105: {cur: 0x39, idx: 0x1c},
	106: {cur: 0x40, idx: 0x127},
	107: {cur: 0x42, idx: 0x20},
	108: {cur: 0x43, idx: 0x12b},
	109: {cur: 0x49, idx: 0x12f},
	110: {cur: 0x51, idx: 0x133},
	111: {cur: 0x5e, idx: 0x14b},
	112: {cur: 0x61, idx: 0x14f},
	113: {cur: 0x6f, idx: 0x154},
	114: {cur: 0x70, idx: 0x47},
	115: {cur: 0x81, idx: 0x172},
	116: {cur: 0x83, idx: 0x5e},
	117: {cur: 0x8d, idx: 0x197},
	118: {cur: 0xb0, idx: 0x8c},
	119: {cur: 0xbe, idx: 0x9a},
	120: {cur: 0xd4, idx: 0x1e8},
	121: {cur: 0xe0, idx: 0x1fd},
	122: {cur: 0xe2, idx: 0x201},
	123: {cur: 0xf2, idx: 0x226},
	124: {cur: 0xf3, idx: 0xbf},
	125: {cur: 0xf9, idx: 0xc7},
	126: {cur: 0xfe, idx: 0x22a},
	127: {cur: 0x26, idx: 0x4},
	128: {cur: 0x37, idx: 0x0},
	129: {cur: 0x50, idx: 0x0},
	130: {cur: 0x73, idx: 0x0},
	131: {cur: 0x7f, idx: 0x0},
	132: {cur: 0xbc, idx: 0x0},
	133: {cur: 0xc7, idx: 0x0},
	134: {cur: 0xd1, idx: 0x0},
	135: {cur: 0xd9, idx: 0x0},
	136: {cur: 0xf3, idx: 0xbf},
	137: {cur: 0xe6, idx: 0x24f},
	138: {cur: 0xf3, idx: 0xbf},
	139: {cur: 0x13, idx: 0x6},
	140: {cur: 0x1a, idx: 0x253},
	141: {cur: 0x25, idx: 0x258},
	142: {cur: 0x32, idx: 0x25c},
	143: {cur: 0x38, idx: 0x123},
	144: {cur: 0x39, idx: 0x1c},
	145: {cur: 0x48, idx: 0x25f},
	146: {cur: 0x49, idx: 0x264},
	147: {cur: 0x51, idx: 0x268},
	148: {cur: 0x5e, idx: 0x14b},
	149: {cur: 0x5f, idx: 0x26c},
	150: {cur: 0x6f, idx: 0x271},
	151: {cur: 0x7f, idx: 0x274},
	152: {cur: 0x81, idx: 0x279},
	153: {cur: 0x8d, idx: 0x27c},
	154: {cur: 0x92, idx: 0x280},
	155: {cur: 0xb0, idx: 0x8c},
	156: {cur: 0xb7, idx: 0x283},
	157: {cur: 0xbe, idx: 0x9a},
	158: {cur: 0xd0, idx: 0x286},
	159: {cur: 0xd4, idx: 0x28e},
	160: {cur: 0xda, idx: 0x292},
	161: {cur: 0xf2, idx: 0x226},
	162: {cur: 0xfe, idx: 0x295},
	163: {cur: 0x10d, idx: 0xd4},
	164: {cur: 0x11, idx: 0x0},
	165: {cur: 0x13, idx: 0x0},
	166: {cur: 0x1a, idx: 0x0},
	167: {cur: 0x1b, idx: 0x0},
	168: {cur: 0x25, idx: 0x0},
	169: {cur: 0x26, idx: 0x0},
	170: {cur: 0x2e, idx: 0x0},
	171: {cur: 0x32, idx: 0x0},
	172: {cur: 0x37, idx: 0x0},
	173: {cur: 0x38, idx: 0x0},
	174: {cur: 0x39, idx: 0x0},
	175: {cur: 0x40, idx: 0x0},
	176: {cur: 0x42, idx: 0x0},
	177: {cur: 0x43, idx: 0x0},
	178: {cur: 0x45, idx: 0x0},
	179: {cur: 0x49, idx: 0x0},
	180: {cur: 0x51, idx: 0x0},
	181: {cur: 0x5e, idx: 0x0},
	182: {cur: 0x66, idx: 0x0},
	183: {cur: 0x6f, idx: 0x0},
	184: {cur: 0x70, idx: 0x0},
	185: {cur: 0x7a, idx: 0x0},
	186: {cur: 0x7b, idx: 0x0},
	187: {cur: 0x81, idx: 0x0},
	188: {cur: 0x86, idx: 0x0},
	189: {cur: 0x8b, idx: 0x0},
	190: {cur: 0x8d, idx: 0x0},
	191: {cur: 0x8e, idx: 0x0},
	192: {cur: 0x8f, idx: 0x0},
	193: {cur: 0x92, idx: 0x0},
	194: {cur: 0xa7, idx: 0x0},
	195: {cur: 0xb0, idx: 0x0},
	196: {cur: 0xb7, idx: 0x0},
	197: {cur: 0xb8, idx: 0x0},
	198: {cur: 0xbe, idx: 0x0},
	199: {cur: 0xc5, idx: 0x0},
	200: {cur: 0xca, idx: 0x0},
	201: {cur: 0xd4, idx: 0x0},
	202: {cur: 0xda, idx: 0x0},
	203: {cur: 0xe0, idx: 0x0},
	204: {cur: 0xe2, idx: 0x0},
	205: {cur: 0xf1, idx: 0x0},
	206: {cur: 0xf2, idx: 0x0},
	207: {cur: 0xf3, idx: 0x0},
	208: {cur: 0xf5, idx: 0x0},
	209: {cur: 0xfe, idx: 0x0},
	210: {cur: 0x102, idx: 0x0},
	211: {cur: 0xf3, idx: 0xbf},
	212: {cur: 0x56, idx: 0x2ac},
	213: {cur: 0x90, idx: 0x2bc},
	214: {cur: 0xee, idx: 0x2c5},
	215: {cur: 0xf3, idx: 0xbf},
	216: {cur: 0x9, idx: 0x0},
	217: {cur: 0x27, idx: 0x0},
	218: {cur: 0x50, idx: 0x0},
	219: {cur: 0x6c, idx: 0x0},
	220: {cur: 0x71, idx: 0x0},
	221: {cur: 0x7f, idx: 0x0},
	222: {cur: 0xbc, idx: 0x0},
	223: {cur: 0xd9, idx: 0x0},
	224: {cur: 0xe3, idx: 0x0},
	225: {cur: 0x101, idx: 0x0},
	226: {cur: 0xf3, idx: 0xbf},
	227: {cur: 0x1b, idx: 0x2fe},
	228: {cur: 0x35, idx: 0x0},
	229: {cur: 0x70, idx: 0x47},
	230: {cur: 0xf3, idx: 0xbf},
	231: {cur: 0x122, idx: 0x0},
	232: {cur: 0x124, idx: 0x0},
	233: {cur: 0x50, idx: 0x301},
	234: {cur: 0x7f, idx: 0x301},
	235: {cur: 0xbc, idx: 0x301},
	236: {cur: 0xd9, idx: 0x301},
	237: {cur: 0xf3, idx: 0xbf},
	238: {cur: 0x48, idx: 0x315},
	239: {cur: 0x5f, idx: 0x31d},
	240: {cur: 0x68, idx: 0x322},
	241: {cur: 0x87, idx: 0x327},
	242: {cur: 0xd2, idx: 0x32a},
	243: {cur: 0xe6, idx: 0x0},
	244: {cur: 0xf3, idx: 0xbf},
	245: {cur: 0x124, idx: 0x86},
	246: {cur: 0x5c, idx: 0x0},
	247: {cur: 0x1b, idx: 0x346},
	248: {cur: 0x27, idx: 0x349},
	249: {cur: 0x49, idx: 0x9e},
	250: {cur: 0x56, idx: 0x3f},
	251: {cur: 0x7f, idx: 0x34c},
	252: {cur: 0x90, idx: 0x34f},
	253: {cur: 0xca, idx: 0x355},
	254: {cur: 0xd9, idx: 0x34c},
	255: {cur: 0xfe, idx: 0x295},
	256: {cur: 0x56, idx: 0x0},
	257: {cur: 0xf3, idx: 0xbf},
	258: {cur: 0x56, idx: 0x33},
	259: {cur: 0x101, idx: 0x37e},
	260: {cur: 0x11, idx: 0x389},
	261: {cur: 0x37, idx: 0x391},
	262: {cur: 0x51, idx: 0x268},
	263: {cur: 0xf1, idx: 0x394},
	264: {cur: 0x101, idx: 0x3a3},
	265: {cur: 0xf3, idx: 0xbf},
	266: {cur: 0xf3, idx: 0xbf},
	267: {cur: 0xf3, idx: 0xbf},
	268: {cur: 0xfe, idx: 0x295},
	269: {cur: 0xf3, idx: 0xbf},
	270: {cur: 0x56, idx: 0x3f6},
	271: {cur: 0x87, idx: 0x327},
	272: {cur: 0x90, idx: 0x2bc},
	273: {cur: 0xba, idx: 0x42b},
	274: {cur: 0xd2, idx: 0x432},
	275: {cur: 0xf3, idx: 0xbf},
	276: {cur: 0x124, idx: 0x452},
	277: {cur: 0x87, idx: 0x67},
	278: {cur: 0xba, idx: 0x97},
	279: {cur: 0x124, idx: 0xe3},
	280: {cur: 0xf3, idx: 0xbf},
	281: {cur: 0xf3, idx: 0xbf},
	282: {cur: 0x2e, idx: 0x47e},
	283: {cur: 0xf3, idx: 0xbf},
	284: {cur: 0xac, idx: 0x48a},
	285: {cur: 0xf3, idx: 0xbf},
	286: {cur: 0xf3, idx: 0xbf},
	287: {cur: 0xac, idx: 0x499},
	288: {cur: 0xc6, idx: 0x499},
	289: {cur: 0xf3, idx: 0xbf},
	290: {cur: 0xf3, idx: 0xbf},
	291: {cur: 0xf3, idx: 0xbf},
	292: {cur: 0xf3, idx: 0xbf},
	293: {cur: 0xf3, idx: 0xbf},
	294: {cur: 0xf3, idx: 0xbf},
	295: {cur: 0x27, idx: 0x349},
	296: {cur: 0x37, idx: 0x391},
	297: {cur: 0x48, idx: 0x25f},
	298: {cur: 0x56, idx: 0x3f6},
	299: {cur: 0xbc, idx: 0x4a0},
	300: {cur: 0xf3, idx: 0xbf},
	301: {cur: 0x42, idx: 0x4a8},
	302: {cur: 0x83, idx: 0x4a8},
	303: {cur: 0xf3, idx: 0xbf},
	304: {cur: 0xf3, idx: 0xbf},
	305: {cur: 0xf3, idx: 0xbf},
	306: {cur: 0xf3, idx: 0xbf},
	307: {cur: 0xf3, idx: 0xbf},
	308: {cur: 0xf3, idx: 0xbf},
	309: {cur: 0x25, idx: 0x258},
	310: {cur: 0x32, idx: 0x25c},
	311: {cur: 0x38, idx: 0x123},
	312: {cur: 0x39, idx: 0x97},
	313: {cur: 0x51, idx: 0x268},
	314: {cur: 0x56, idx: 0x4bb},
	315: {cur: 0x70, idx: 0x47},
	316: {cur: 0x73, idx: 0x4be},
	317: {cur: 0x81, idx: 0x279},
	318: {cur: 0xf2, idx: 0x226},
	319: {cur: 0xf3, idx: 0xbf},
	320: {cur: 0xf3, idx: 0xbf},
	321: {cur: 0xf3, idx: 0xbf},
	322: {cur: 0x1b, idx: 0x0},
	323: {cur: 0x37, idx: 0x391},
	324: {cur: 0x7a, idx: 0x0},
	325: {cur: 0x7b, idx: 0x0},
	326: {cur: 0x86, idx: 0x0},
	327: {cur: 0x8f, idx: 0x0},
	328: {cur: 0xa7, idx: 0x0},
	329: {cur: 0xc7, idx: 0x4c8},
	330: {cur: 0xca, idx: 0x355},
	331: {cur: 0xd0, idx: 0x4cb},
	332: {cur: 0x102, idx: 0x0},
	333: {cur: 0xf3, idx: 0xbf},
	334: {cur: 0xf3, idx: 0xbf},
	335: {cur: 0xf3, idx: 0xbf},
	336: {cur: 0xf3, idx: 0xbf},
	337: {cur: 0xf3, idx: 0xbf},
	338: {cur: 0xf3, idx: 0xbf},
	339: {cur: 0x38, idx: 0x4d9},
	340: {cur: 0xf3, idx: 0xbf},
	341: {cur: 0xf3, idx: 0xbf},
	342: {cur: 0xf3, idx: 0xbf},
	343: {cur: 0xf3, idx: 0xbf},
	344: {cur: 0xf3, idx: 0xbf},
	345: {cur: 0xf3, idx: 0xbf},
	346: {cur: 0xf3, idx: 0xbf},
	347: {cur: 0x91, idx: 0x533},
	348: {cur: 0xf3, idx: 0xbf},
	349: {cur: 0xf3, idx: 0xbf},
	350: {cur: 0xf3, idx: 0xbf},
	351: {cur: 0xd0, idx: 0x565},
	352: {cur: 0xf3, idx: 0xbf},
	353: {cur: 0x37, idx: 0x56c},
	354: {cur: 0xd0, idx: 0x56f},
	355: {cur: 0xf3, idx: 0xbf},
	356: {cur: 0x5a, idx: 0x0},
	357: {cur: 0xf3, idx: 0xbf},
	358: {cur: 0xf3, idx: 0xbf},
	359: {cur: 0xf3, idx: 0xbf},
	360: {cur: 0xf3, idx: 0xbf},
	361: {cur: 0xf3, idx: 0xbf},
	362: {cur: 0xf3, idx: 0xbf},
	363: {cur: 0xf3, idx: 0xbf},
	364: {cur: 0xf3, idx: 0xbf},
	365: {cur: 0xf3, idx: 0xbf},
	366: {cur: 0xf3, idx: 0xbf},
	367: {cur: 0x37, idx: 0x5af},
	368: {cur: 0x50, idx: 0x34c},
	369: {cur: 0x73, idx: 0x4be},
	370: {cur: 0x7f, idx: 0x34c},
	371: {cur: 0xbc, idx: 0x34c},
	372: {cur: 0xc7, idx: 0x5b2},
	373: {cur: 0xd9, idx: 0x34c},
	374: {cur: 0xf3, idx: 0xbf},
} // Size: 1524 bytes

// Total table size 18138 bytes (17KiB); checksum: 976D06A2
