/*
 * SPDX-FileCopyrightText: Copyright (c) 2024 NVIDIA CORPORATION & AFFILIATES
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __gb202_dev_fault_h__
#define __gb202_dev_fault_h__

#define NV_PFAULT                                              /* ----G */
#define NV_PFAULT_MMU_ENG_ID_GRAPHICS          384 /*       */
#define NV_PFAULT_MMU_ENG_ID_DISPLAY           1 /*       */
#define NV_PFAULT_MMU_ENG_ID_GSP               2 /*       */
#define NV_PFAULT_MMU_ENG_ID_IFB               55 /*       */
#define NV_PFAULT_MMU_ENG_ID_FLA               4 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1              256 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2              320 /*       */
#define NV_PFAULT_MMU_ENG_ID_SEC               6 /*       */
#define NV_PFAULT_MMU_ENG_ID_FSP               7 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF              10 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF0             10 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF1             11 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF2             12 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF3             13 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF4             14 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF5             15 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF6             16 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF7             17 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF8             18 /*       */
#define NV_PFAULT_MMU_ENG_ID_PERF9             19 /*       */
#define NV_PFAULT_MMU_ENG_ID_GSPLITE          20 /*       */
#define NV_PFAULT_MMU_ENG_ID_GSPLITE1          21 /*       */
#define NV_PFAULT_MMU_ENG_ID_GSPLITE2          22 /*       */
#define NV_PFAULT_MMU_ENG_ID_GSPLITE3          23 /*       */
#define NV_PFAULT_MMU_ENG_ID_GSPLITE4          24 /*       */
#define NV_PFAULT_MMU_ENG_ID_GSPLITE5          25 /*       */
#define NV_PFAULT_MMU_ENG_ID_GSPLITE6          26 /*       */
#define NV_PFAULT_MMU_ENG_ID_GSPLITE7          27 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVDEC             28 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVDEC0            28 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVDEC1            29 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVDEC2            30 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVDEC3            31 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVDEC4            32 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVDEC5            33 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVDEC6            34 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVDEC7            35 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVJPG0            36 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVJPG1            37 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVJPG2            38 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVJPG3            39 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVJPG4            40 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVJPG5            41 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVJPG6            42 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVJPG7            43 /*       */
#define NV_PFAULT_MMU_ENG_ID_GRCOPY            65 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE0               65 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE1               66 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE2               67 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE3               68 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE4               69 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE5               70 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE6               71 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE7               72 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE8               73 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE9               74 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE10               75 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE11               76 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE12               77 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE13               78 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE14               79 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE15               80 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE16               81 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE17               82 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE18               83 /*       */
#define NV_PFAULT_MMU_ENG_ID_CE19               84 /*       */
#define NV_PFAULT_MMU_ENG_ID_PWR_PMU           5 /*       */
#define NV_PFAULT_MMU_ENG_ID_PTP               3 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVENC0            44 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVENC1            45 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVENC2            46 /*       */
#define NV_PFAULT_MMU_ENG_ID_NVENC3            47 /*       */
#define NV_PFAULT_MMU_ENG_ID_OFA0              48 /*       */
#define NV_PFAULT_MMU_ENG_ID_PHYSICAL          56 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST0             85 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST1             86 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST2             87 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST3             88 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST4             89 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST5             90 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST6             91 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST7             92 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST8             93 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST9             94 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST10            95 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST11            96 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST12            97 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST13            98 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST14            99 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST15            100 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST16            101 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST17            102 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST18            103 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST19            104 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST20            105 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST21            106 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST22            107 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST23            108 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST24            109 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST25            110 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST26            111 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST27            112 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST28            113 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST29            114 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST30            115 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST31            116 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST32            117 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST33            118 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST34            119 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST35            120 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST36            121 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST37            122 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST38            123 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST39            124 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST40            125 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST41            126 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST42            127 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST43            128 /*       */
#define NV_PFAULT_MMU_ENG_ID_HOST44            129 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN0          256  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN1          257  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN2          258  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN3          259  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN4          260  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN5          261  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN6          262  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN7          263  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN8          264  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN9          265  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN10         266 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN11         267 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN12         268 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN13         269 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN14         270 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN15         271 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN16         272 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN17         273 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN18         274 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN19         275 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN20         276 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN21         277 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN22         278 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN23         279 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN24         280 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN25         281 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN26         282 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN27         283 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN28         284 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN29         285 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN30         286 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN31         287 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN32         288 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN33         289 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN34         290 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN35         291 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN36         292 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN37         293 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN38         294 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN39         295 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN40         296 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN41         297 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN42         298 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN43         299 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN44         300 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN45         301 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN46         302 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN47         303 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN48         304 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN49         305 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN50         306 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN51         307 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN52         308 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN53         309 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN54         310 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN55         311 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN56         312 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN57         313 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN58         314 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN59         315 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN60         316 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN61         317 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN62         318 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR1_FN63         319 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN0          320  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN1          321  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN2          322  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN3          323  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN4          324  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN5          325  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN6          326  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN7          327  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN8          328  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN9          329  /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN10         330 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN11         331 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN12         332 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN13         333 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN14         334 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN15         335 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN16         336 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN17         337 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN18         338 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN19         339 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN20         340 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN21         341 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN22         342 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN23         343 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN24         344 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN25         345 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN26         346 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN27         347 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN28         348 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN29         349 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN30         350 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN31         351 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN32         352 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN33         353 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN34         354 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN35         355 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN36         356 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN37         357 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN38         358 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN39         359 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN40         360 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN41         361 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN42         362 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN43         363 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN44         364 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN45         365 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN46         366 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN47         367 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN48         368 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN49         369 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN50         370 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN51         371 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN52         372 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN53         373 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN54         374 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN55         375 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN56         376 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN57         377 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN58         378 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN59         379 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN60         380 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN61         381 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN62         382 /*       */
#define NV_PFAULT_MMU_ENG_ID_BAR2_FN63         383 /*       */
#define NV_PFAULT_FAULT_TYPE_PDE                  0x00000000 /*       */
#define NV_PFAULT_FAULT_TYPE_PDE_SIZE             0x00000001 /*       */
#define NV_PFAULT_FAULT_TYPE_PTE                  0x00000002 /*       */
#define NV_PFAULT_FAULT_TYPE_VA_LIMIT_VIOLATION   0x00000003 /*       */
#define NV_PFAULT_FAULT_TYPE_UNBOUND_INST_BLOCK   0x00000004 /*       */
#define NV_PFAULT_FAULT_TYPE_PRIV_VIOLATION       0x00000005 /*       */
#define NV_PFAULT_FAULT_TYPE_RO_VIOLATION         0x00000006 /*       */
#define NV_PFAULT_FAULT_TYPE_WO_VIOLATION         0x00000007 /*       */
#define NV_PFAULT_FAULT_TYPE_PITCH_MASK_VIOLATION 0x00000008 /*       */
#define NV_PFAULT_FAULT_TYPE_WORK_CREATION        0x00000009 /*       */
#define NV_PFAULT_FAULT_TYPE_UNSUPPORTED_APERTURE 0x0000000a /*       */
#define NV_PFAULT_FAULT_TYPE_CC_VIOLATION         0x0000000b /*       */
#define NV_PFAULT_FAULT_TYPE_UNSUPPORTED_KIND     0x0000000c /*       */
#define NV_PFAULT_FAULT_TYPE_REGION_VIOLATION     0x0000000d /*       */
#define NV_PFAULT_FAULT_TYPE_POISONED             0x0000000e /*       */
#define NV_PFAULT_FAULT_TYPE_ATOMIC_VIOLATION     0x0000000f /*       */
#define NV_PFAULT_CLIENT_HUB_PD1         0x0000001E /*       */
#define NV_PFAULT_CLIENT_HUB_SSYNC1      0x00000028 /*       */
#define NV_PFAULT_CLIENT_HUB_SSYNC2      0x00000029 /*       */
#define NV_PFAULT_CLIENT_HUB_SSYNC3      0x00000036 /*       */
#define NV_PFAULT_CLIENT_HUB_SCC1        0x00000040 /*       */
#define NV_PFAULT_CLIENT_HUB_SCC_NB1     0x00000041 /*       */
#define NV_PFAULT_CLIENT_HUB_SCC2        0x00000042 /*       */
#define NV_PFAULT_CLIENT_HUB_SCC_NB2     0x00000043 /*       */
#define NV_PFAULT_CLIENT_HUB_SCC3        0x00000044 /*       */
#define NV_PFAULT_CLIENT_HUB_SCC_NB3     0x00000045 /*       */
#define NV_PFAULT_CLIENT_HUB_RASTERTWOD1 0x00000046 /*       */
#define NV_PFAULT_CLIENT_HUB_RASTERTWOD2 0x00000047 /*       */
#define NV_PFAULT_CLIENT_HUB_RASTERTWOD3 0x00000048 /*       */
#define NV_PFAULT_CLIENT_HUB_GSPLITE1    0x00000049 /*       */
#define NV_PFAULT_CLIENT_HUB_GSPLITE2    0x0000004A /*       */
#define NV_PFAULT_CLIENT_HUB_GSPLITE3    0x0000004B /*       */
#define NV_PFAULT_CLIENT_HUB_PD2         0x0000004C /*       */
#define NV_PFAULT_CLIENT_HUB_PD3         0x0000004D /*       */
#define NV_PFAULT_CLIENT_GPC_ROP_0       0x00000070 /*       */
#define NV_PFAULT_CLIENT_GPC_ROP_1       0x00000071 /*       */
#define NV_PFAULT_CLIENT_GPC_ROP_2       0x00000072 /*       */
#define NV_PFAULT_CLIENT_GPC_ROP_3       0x00000073 /*       */
#define NV_PFAULT_CLIENT_HUB_ESC          0x00000063 /*       */
#define NV_PFAULT_CLIENT_HUB_ESC0         0x00000063 /*       */
#define NV_PFAULT_CLIENT_HUB_ESC1         0x00000064 /*       */
#define NV_PFAULT_CLIENT_HUB_ESC2         0x00000065 /*       */
#define NV_PFAULT_CLIENT_HUB_ESC3         0x00000066 /*       */
#define NV_PFAULT_CLIENT_HUB_ESC4         0x00000067 /*       */
#define NV_PFAULT_CLIENT_HUB_ESC5         0x00000068 /*       */
#define NV_PFAULT_CLIENT_HUB_ESC6         0x00000069 /*       */
#define NV_PFAULT_CLIENT_HUB_ESC7         0x0000006a /*       */
#define NV_PFAULT_CLIENT_HUB_ESC8         0x0000006b /*       */
#define NV_PFAULT_CLIENT_HUB_ESC9         0x0000006c /*       */
#define NV_PFAULT_CLIENT_HUB_ESC10        0x0000006d /*       */
#define NV_PFAULT_CLIENT_HUB_ESC11        0x0000006e /*       */
#define NV_PFAULT_CLIENT_HUB_FSP         0x00000079 /*       */
#define NV_PFAULT_CLIENT_HUB_GSPLITE       0x0000007B /*       */
#define NV_PFAULT_CLIENT_HUB_GSPLITE0      0x0000007B /*       */
#define NV_PFAULT_CLIENT_HUB_VPR_SCRUBBER2 0x0000007C /*       */
#define NV_PFAULT_CLIENT_HUB_VPR_SCRUBBER3 0x0000007D /*       */
#define NV_PFAULT_CLIENT_HUB_VPR_SCRUBBER4 0x0000007E /*       */
#define NV_PFAULT_CLIENT_HUB_NVENC3        0x0000007F /*       */

#define NV_PFAULT_ACCESS_TYPE_READ       0x00000000 /*       */
#define NV_PFAULT_ACCESS_TYPE_WRITE      0x00000001 /*       */
#define NV_PFAULT_ACCESS_TYPE_ATOMIC     0x00000002 /*       */
#define NV_PFAULT_ACCESS_TYPE_PREFETCH   0x00000003 /*       */
#define NV_PFAULT_ACCESS_TYPE_VIRT_READ          0x00000000 /*       */
#define NV_PFAULT_ACCESS_TYPE_VIRT_WRITE         0x00000001 /*       */
#define NV_PFAULT_ACCESS_TYPE_VIRT_ATOMIC        0x00000002 /*       */
#define NV_PFAULT_ACCESS_TYPE_VIRT_ATOMIC_STRONG 0x00000002 /*       */
#define NV_PFAULT_ACCESS_TYPE_VIRT_PREFETCH      0x00000003 /*       */
#define NV_PFAULT_ACCESS_TYPE_VIRT_ATOMIC_WEAK   0x00000004 /*       */
#define NV_PFAULT_ACCESS_TYPE_PHYS_READ          0x00000008 /*       */
#define NV_PFAULT_ACCESS_TYPE_PHYS_WRITE         0x00000009 /*       */
#define NV_PFAULT_ACCESS_TYPE_PHYS_ATOMIC        0x0000000a /*       */
#define NV_PFAULT_ACCESS_TYPE_PHYS_PREFETCH      0x0000000b /*       */
#define NV_PFAULT_MMU_CLIENT_TYPE_GPC    0x00000000 /*       */
#define NV_PFAULT_MMU_CLIENT_TYPE_HUB    0x00000001 /*       */

#endif // __gb202_dev_fault_h__
