type t = {
  mutable database_paths : (string * string) list;
  mutable install_cmd : string;
  mutable remove_cmd : string;
  mutable update_cmd : string;
  mutable print_cmd : string;
  mutable pager_cmd : string;
}
val gui_default : t
val cli_default : t
val duplicate : t -> t
val overwrite : t -> t -> unit
val current : t
val fp : out_channel -> ('a, out_channel, unit) format -> 'a
val directory : string
val path : string -> string
val ensure_directory_presence : unit -> unit
val save : t -> string -> unit
exception Invalid_configuration_file of string
val load : t -> string -> unit
