/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import org.cojen.util.CacheEvictor;
import org.cojen.util.RefCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftValueCache<K, V>
extends RefCache<K, V> {
    private Entry<K, V>[] mEntries;

    public SoftValueCache(int capacity) {
        super(capacity);
        this.mEntries = new Entry[capacity];
        this.mThreshold = (int)((float)capacity * 0.75f);
    }

    @Override
    public synchronized V get(K key) {
        int hash = key == null ? 0 : this.keyHashCode(key);
        Entry<K, V>[] entries = this.mEntries;
        int index = (hash & Integer.MAX_VALUE) % entries.length;
        Entry<K, V> e = entries[index];
        while (e != null) {
            if (this.matches(e, key, hash)) {
                return (V)e.get();
            }
            e = e.mNext;
        }
        return null;
    }

    @Override
    public synchronized V put(K key, V value) {
        int hash = key == null ? 0 : this.keyHashCode(key);
        Entry<K, V>[] entries = this.mEntries;
        int index = (hash & Integer.MAX_VALUE) % entries.length;
        Entry<K, V> e = entries[index];
        Entry<K, V> prev = null;
        while (e != null) {
            if (this.matches(e, key, hash)) {
                Entry<K, V> newEntry;
                Object old = e.get();
                e.clear();
                if (prev == null) {
                    newEntry = new Entry<K, V>(this, hash, key, value, e.mNext);
                } else {
                    prev.mNext = e.mNext;
                    newEntry = new Entry<K, V>(this, hash, key, value, entries[index]);
                }
                entries[index] = newEntry;
                return (V)old;
            }
            prev = e;
            e = e.mNext;
        }
        if (this.mSize >= this.mThreshold) {
            this.cleanup();
            if (this.mSize >= this.mThreshold) {
                this.rehash();
                entries = this.mEntries;
                index = (hash & Integer.MAX_VALUE) % entries.length;
            }
        }
        entries[index] = new Entry<K, V>(this, hash, key, value, entries[index]);
        ++this.mSize;
        return null;
    }

    @Override
    public synchronized V remove(K key) {
        int hash = key == null ? 0 : this.keyHashCode(key);
        Entry<K, V>[] entries = this.mEntries;
        int index = (hash & Integer.MAX_VALUE) % entries.length;
        Entry<K, V> e = entries[index];
        Entry<K, V> prev = null;
        while (e != null) {
            if (this.matches(e, key, hash)) {
                Object old = e.get();
                e.clear();
                if (prev == null) {
                    entries[index] = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                }
                --this.mSize;
                return (V)old;
            }
            prev = e;
            e = e.mNext;
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        Entry<K, V>[] entries = this.mEntries;
        int i = entries.length;
        while (--i >= 0) {
            Entry<K, V> e = entries[i];
            if (e == null) continue;
            e.clear();
            entries[i] = null;
        }
        this.mSize = 0;
    }

    @Override
    public synchronized void copyKeysInto(Collection<? super K> c) {
        Entry<K, V>[] entries = this.mEntries;
        int i = entries.length;
        while (--i >= 0) {
            Entry<K, V> e = entries[i];
            while (e != null) {
                if (e.get() != null) {
                    c.add(e.mKey);
                }
                e = e.mNext;
            }
        }
    }

    @Override
    public synchronized void copyValuesInto(Collection<? super V> c) {
        Entry<K, V>[] entries = this.mEntries;
        int i = entries.length;
        while (--i >= 0) {
            Entry<K, V> e = entries[i];
            while (e != null) {
                Object value = e.get();
                if (value != null) {
                    c.add(value);
                }
                e = e.mNext;
            }
        }
    }

    @Override
    public synchronized void copyEntriesInto(Collection<? super Map.Entry<K, V>> c) {
        Entry<K, V>[] entries = this.mEntries;
        int i = entries.length;
        while (--i >= 0) {
            Entry<K, V> e = entries[i];
            while (e != null) {
                Object value = e.get();
                if (value != null) {
                    c.add(new AbstractMap.SimpleImmutableEntry(e.mKey, value));
                }
                e = e.mNext;
            }
        }
    }

    public synchronized String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder b = new StringBuilder();
        b.append('{');
        Entry<K, V>[] entries = this.mEntries;
        boolean any = false;
        int i = entries.length;
        while (--i >= 0) {
            Entry<K, V> e = entries[i];
            while (e != null) {
                Object value = e.get();
                if (value != null) {
                    if (any) {
                        b.append(',').append(' ');
                    }
                    Object key = e.mKey;
                    b.append(key).append('=').append(value);
                    any = true;
                }
                e = e.mNext;
            }
        }
        b.append('}');
        return b.toString();
    }

    synchronized void removeCleared(Entry<K, V> cleared) {
        Entry<K, V>[] entries = this.mEntries;
        int index = (cleared.mHash & Integer.MAX_VALUE) % entries.length;
        Entry<K, V> e = entries[index];
        Entry<K, V> prev = null;
        while (e != null) {
            if (e == cleared) {
                if (prev == null) {
                    entries[index] = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                }
                --this.mSize;
                return;
            }
            prev = e;
            e = e.mNext;
        }
    }

    private boolean matches(Entry<K, V> e, K key, int hash) {
        return hash == e.mHash && (key == null ? e.mKey == null : this.keyEquals(key, e.mKey));
    }

    private void cleanup() {
        Entry<K, V>[] entries = this.mEntries;
        int size = 0;
        int i = entries.length;
        while (--i >= 0) {
            Entry<K, V> e = entries[i];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e.get() == null) {
                    if (prev == null) {
                        entries[i] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                } else {
                    ++size;
                    prev = e;
                }
                e = e.mNext;
            }
        }
        this.mSize = size;
    }

    private void rehash() {
        Entry<K, V>[] oldEntries = this.mEntries;
        int newCapacity = oldEntries.length * 2 + 1;
        Entry[] newEntries = new Entry[newCapacity];
        int size = 0;
        int i = oldEntries.length;
        while (--i >= 0) {
            Entry<K, V> old = oldEntries[i];
            while (old != null) {
                Entry<K, V> e = old;
                old = old.mNext;
                if (e.get() == null) continue;
                ++size;
                int index = (e.mHash & Integer.MAX_VALUE) % newCapacity;
                e.mNext = newEntries[index];
                newEntries[index] = e;
            }
        }
        this.mEntries = newEntries;
        this.mSize = size;
        this.mThreshold = (int)((float)newCapacity * 0.75f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends SoftReference<V>
    implements CacheEvictor.Ref {
        final SoftValueCache<K, V> mCache;
        final int mHash;
        final K mKey;
        Entry<K, V> mNext;

        Entry(SoftValueCache<K, V> cache, int hash, K key, V value, Entry<K, V> next) {
            super(value, CacheEvictor.queue());
            this.mCache = cache;
            this.mHash = hash;
            this.mKey = key;
            this.mNext = next;
        }

        @Override
        public void remove() {
            this.mCache.removeCleared(this);
        }
    }
}

