/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.attribute.Attribute;

public class LocalVariableTypeTableAttribute
extends Attribute {
    public static final String ATTRIBUTE_NAME = "LocalVariableTypeTable";
    private List<LocalVariableType> localVariableTypes = new LinkedList<LocalVariableType>();

    LocalVariableTypeTableAttribute(short nameIndex, int attributeLength, DataInputStream dis) throws IOException {
        super(nameIndex, attributeLength, dis);
        dis = this.getDataInputStream();
        int local_variable_type_table_length = dis.readShort();
        for (int i = 0; i < local_variable_type_table_length; ++i) {
            short start_pc = dis.readShort();
            short length = dis.readShort();
            short name_index = dis.readShort();
            short signature_index = dis.readShort();
            short index = dis.readShort();
            this.localVariableTypes.add(new LocalVariableType(start_pc, length, name_index, signature_index, index));
        }
    }

    public List<LocalVariableType> getLocalVariableTypes() {
        return this.localVariableTypes;
    }

    public class LocalVariableType {
        private short start_pc;
        private short length;
        private short name_index;
        private short signature_index;
        private short index;

        LocalVariableType(short start_pc, short length, short name_index, short signature_index, short index) {
            this.start_pc = start_pc;
            this.length = length;
            this.name_index = name_index;
            this.signature_index = signature_index;
            this.index = index;
        }

        public short getStartPc() {
            return this.start_pc;
        }

        public short getLength() {
            return this.length;
        }

        public String getName() {
            return LocalVariableTypeTableAttribute.this.cp.getUtf8(this.name_index);
        }

        short getNameIndex() {
            return this.name_index;
        }

        public String getSignature() {
            return LocalVariableTypeTableAttribute.this.cp.getUtf8(this.signature_index);
        }

        short getSignatureIndex() {
            return this.signature_index;
        }

        public short getIndex() {
            return this.index;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("start: " + this.start_pc);
            sb.append(", length: " + this.length);
            sb.append(", name: " + this.getName());
            sb.append(", signature: " + this.getSignature());
            sb.append(", index: " + this.index);
            return sb.toString();
        }
    }
}

