#!/usr/bin/python
"""
Converts x y z l format to a e l.
With -d it converts it to e a d l.
Elevation range is -90,90.
Azimuth range is 0,360.
Comments are left as is.
Labels may be empty.
Spaces and tabs in labes collapsed into one space.
Non comments lines with less than 2 columns are ignored and a waring is raised.
"""

import sys, math

def ea2xyz(input, output, hasDistance=False) :
#	print "# Generated by xyz2ead"
	for i, line in enumerate(input.readlines()) :
		tokens = line.split()
		# Comments are left as is
		if line[0]=='#' :
			print line
			continue
		nNumbers= 3 if hasDistance else 2
		if len(tokens) < nNumbers :
			print >> sys.stderr, "Ignoring line", i
			continue
		e,a = float(tokens[0]), float(tokens[1])
		d = float(tokens[2]) if hasDistance else 3.
		label = " ".join(tokens[nNumbers:]) if len(tokens)>nNumbers else "%02i"%(i+1)
		x = d*math.cos(math.radians(a)) * math.cos(math.radians(e)) 
		y = d*math.sin(math.radians(a)) * math.cos(math.radians(e)) 
		z = d*math.sin(math.radians(e)) 
		print >> output, x, y, z, label

if __name__ == '__main__' :
	ea2xyz(sys.stdin, sys.stdout, '-d' in sys.argv)



