/*
   Copyright 2007 Attila Szegedi

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package org.dynalang.mop.beans;

import java.lang.reflect.Method;

import org.dynalang.mop.CallProtocol;

/**
 * @author Attila Szegedi
 * @version $Id: $
 */
class DynamicInstanceMethod
{
    private final Object target;
    private final DynamicMethod<Method> dynamicMethod;
    
    DynamicInstanceMethod(Object target, DynamicMethod<Method> dynamicMethod) {
        this.target = target;
        this.dynamicMethod = dynamicMethod;
    }
    
    Object call(Object[] args, CallProtocol callProtocol) {
        return dynamicMethod.call(target, callProtocol, args);
    }
}
