/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.taskdefs.XSLTLoggerAware;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.JAXPUtils;
import org.osjava.jardiff.ant.JDXSLTLiaison3;
import org.osjava.jardiff.ant.JDXSLTProcess;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JDTraXLiaison
implements JDXSLTLiaison3,
ErrorListener,
XSLTLoggerAware {
    private String systemid;
    private String factoryName = null;
    private TransformerFactory tfactory = null;
    private File stylesheet;
    private XSLTLogger logger;
    private EntityResolver entityResolver;
    private Transformer transformer;
    private Templates templates;
    private long templatesModTime;
    private URIResolver uriResolver;
    private Vector outputProperties = new Vector();
    private Vector params = new Vector();
    private Vector attributes = new Vector();

    public void setStylesheet(String systemid) {
        if (this.systemid != null) {
            this.transformer = null;
            if (this.systemid.equals(systemid)) {
                this.templates = null;
            }
        }
        this.systemid = systemid;
        this.stylesheet = null;
    }

    public void setStylesheet(File stylesheet) throws Exception {
        if (this.stylesheet != null) {
            this.transformer = null;
            if (!this.stylesheet.equals(stylesheet) || stylesheet.lastModified() != this.templatesModTime) {
                this.templates = null;
            }
        }
        this.stylesheet = stylesheet;
        this.systemid = stylesheet.toURL().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(File infile, File outfile) throws Exception {
        if (this.transformer == null) {
            this.createTransformer();
        }
        BufferedInputStream fis = null;
        OutputStream fos = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(infile));
            fos = new BufferedOutputStream(new FileOutputStream(outfile));
            StreamResult res = new StreamResult(fos);
            res.setSystemId(JAXPUtils.getSystemId((File)outfile));
            Source src = this.getSource((InputStream)fis, infile);
            this.transformer.transform(src, res);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fis != null) {
                ((InputStream)fis).close();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException ignored) {}
    }

    private Source getSource(InputStream is, File infile) throws ParserConfigurationException, SAXException {
        return this.getSource(is, JAXPUtils.getSystemId((File)infile));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Source getSource(InputStream is, String systemid) throws ParserConfigurationException, SAXException {
        void var3_6;
        Object var3_3 = null;
        if (this.entityResolver != null) {
            if (!this.getFactory().getFeature("http://javax.xml.transform.sax.SAXSource/feature")) throw new IllegalStateException("xcatalog specified, but parser doesn't support SAX");
            SAXParserFactory spFactory = SAXParserFactory.newInstance();
            spFactory.setNamespaceAware(true);
            XMLReader reader = spFactory.newSAXParser().getXMLReader();
            reader.setEntityResolver(this.entityResolver);
            SAXSource sAXSource = new SAXSource(reader, new InputSource(is));
        } else {
            StreamSource streamSource = new StreamSource(is);
        }
        var3_6.setSystemId(systemid);
        return var3_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTemplates() throws IOException, TransformerConfigurationException, ParserConfigurationException, SAXException {
        InputStream xslStream = null;
        try {
            if (this.stylesheet != null) {
                xslStream = new BufferedInputStream(new FileInputStream(this.stylesheet));
                this.templatesModTime = this.stylesheet.lastModified();
            } else {
                xslStream = new URL(this.systemid).openStream();
                this.templatesModTime = 0L;
            }
            Source src = this.getSource(xslStream, this.systemid);
            this.templates = this.getFactory().newTemplates(src);
        }
        finally {
            if (xslStream != null) {
                xslStream.close();
            }
        }
    }

    private void createTransformer() throws Exception {
        String[] pair;
        int i;
        if (this.templates == null) {
            this.readTemplates();
        }
        this.transformer = this.templates.newTransformer();
        this.transformer.setErrorListener(this);
        if (this.uriResolver != null) {
            this.transformer.setURIResolver(this.uriResolver);
        }
        for (i = 0; i < this.params.size(); ++i) {
            pair = (String[])this.params.elementAt(i);
            this.transformer.setParameter(pair[0], pair[1]);
        }
        for (i = 0; i < this.outputProperties.size(); ++i) {
            pair = (String[])this.outputProperties.elementAt(i);
            this.transformer.setOutputProperty(pair[0], pair[1]);
        }
    }

    private TransformerFactory getFactory() throws BuildException {
        if (this.tfactory != null) {
            return this.tfactory;
        }
        if (this.factoryName == null) {
            this.tfactory = TransformerFactory.newInstance();
        } else {
            try {
                Class<?> clazz = Class.forName(this.factoryName);
                this.tfactory = (TransformerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        this.tfactory.setErrorListener(this);
        for (int i = 0; i < this.attributes.size(); ++i) {
            Object[] pair = (Object[])this.attributes.elementAt(i);
            this.tfactory.setAttribute((String)pair[0], pair[1]);
        }
        if (this.uriResolver != null) {
            this.tfactory.setURIResolver(this.uriResolver);
        }
        return this.tfactory;
    }

    public void setFactory(String name) {
        this.factoryName = name;
    }

    public void setAttribute(String name, Object value) {
        Object[] pair = new Object[]{name, value};
        this.attributes.addElement(pair);
    }

    public void setOutputProperty(String name, String value) {
        String[] pair = new String[]{name, value};
        this.outputProperties.addElement(pair);
    }

    public void setEntityResolver(EntityResolver aResolver) {
        this.entityResolver = aResolver;
    }

    public void setURIResolver(URIResolver aResolver) {
        this.uriResolver = aResolver;
    }

    public void addParam(String name, String value) {
        String[] pair = new String[]{name, value};
        this.params.addElement(pair);
    }

    public void setLogger(XSLTLogger l) {
        this.logger = l;
    }

    public void error(TransformerException e) {
        this.logError(e, "Error");
    }

    public void fatalError(TransformerException e) {
        this.logError(e, "Fatal Error");
        throw new BuildException("Fatal error during transformation", (Throwable)e);
    }

    public void warning(TransformerException e) {
        this.logError(e, "Warning");
    }

    private void logError(TransformerException e, String type) {
        if (this.logger == null) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        SourceLocator locator = e.getLocator();
        if (locator != null) {
            String systemid = locator.getSystemId();
            if (systemid != null) {
                String url = systemid;
                if (url.startsWith("file:///")) {
                    url = url.substring(8);
                }
                msg.append(url);
            } else {
                msg.append("Unknown file");
            }
            int line = locator.getLineNumber();
            if (line != -1) {
                msg.append(":" + line);
                int column = locator.getColumnNumber();
                if (column != -1) {
                    msg.append(":" + column);
                }
            }
        }
        msg.append(": " + type + "! ");
        msg.append(e.getMessage());
        if (e.getCause() != null) {
            msg.append(" Cause: " + e.getCause());
        }
        this.logger.log(msg.toString());
    }

    protected String getSystemId(File file) {
        return JAXPUtils.getSystemId((File)file);
    }

    public void configure(XSLTProcess xsltTask) {
        XMLCatalog xmlCatalog;
        XSLTProcess.Factory factory = xsltTask.getFactory();
        if (factory != null) {
            this.setFactory(factory.getName());
            Enumeration attrs = factory.getAttributes();
            while (attrs.hasMoreElements()) {
                XSLTProcess.Factory.Attribute attr = (XSLTProcess.Factory.Attribute)attrs.nextElement();
                this.setAttribute(attr.getName(), attr.getValue());
            }
        }
        if ((xmlCatalog = xsltTask.getXMLCatalog()) != null) {
            this.setEntityResolver((EntityResolver)xmlCatalog);
            this.setURIResolver((URIResolver)xmlCatalog);
        }
        Enumeration props = xsltTask.getOutputProperties();
        while (props.hasMoreElements()) {
            XSLTProcess.OutputProperty prop = (XSLTProcess.OutputProperty)props.nextElement();
            this.setOutputProperty(prop.getName(), prop.getValue());
        }
    }

    public void configure(JDXSLTProcess xsltTask) {
        XMLCatalog xmlCatalog;
        JDXSLTProcess.Factory factory = xsltTask.getFactory();
        if (factory != null) {
            this.setFactory(factory.getName());
            Enumeration attrs = factory.getAttributes();
            while (attrs.hasMoreElements()) {
                JDXSLTProcess.Factory.Attribute attr = (JDXSLTProcess.Factory.Attribute)attrs.nextElement();
                this.setAttribute(attr.getName(), attr.getValue());
            }
        }
        if ((xmlCatalog = xsltTask.getXMLCatalog()) != null) {
            this.setEntityResolver((EntityResolver)xmlCatalog);
            this.setURIResolver((URIResolver)xmlCatalog);
        }
        Enumeration props = xsltTask.getOutputProperties();
        while (props.hasMoreElements()) {
            JDXSLTProcess.OutputProperty prop = (JDXSLTProcess.OutputProperty)props.nextElement();
            this.setOutputProperty(prop.getName(), prop.getValue());
        }
    }
}

