#ifndef KLOG_WORLD_H
#define KLOG_WORLD_H
/***************************************************************************
                          world.h  -  description
                             -------------------
    begin                : sept 2011
    copyright            : (C) 2011 by Jaime Robles
    email                : jaime@robles.es
 ***************************************************************************/

/*****************************************************************************
 * This file is part of KLog.                                                *
 *                                                                           *
 *    KLog is free software: you can redistribute it and/or modify           *
 *    it under the terms of the GNU General Public License as published by   *
 *    the Free Software Foundation, either version 3 of the License, or      *
 *    (at your option) any later version.                                    *
 *                                                                           *
 *    KLog is distributed in the hope that it will be useful,                *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *    GNU General Public License for more details.                           *
 *                                                                           *
 *    You should have received a copy of the GNU General Public License      *
 *    along with KLog.  If not, see <https://www.gnu.org/licenses/>.         *
 *                                                                           *
 *****************************************************************************/

//#include <QtWidgets>
#include <QString>
#include <QFile>
#include <QStringList>
//#include <QSqlRelationalTableModel>
#include <QSqlQuery>
#include <QSqlError>
#include <QProgressBar>
#include <QProgressDialog>
#include <QtGlobal>
#include <QtDebug>

#include "locator.h"
#include "dataproxy_sqlite.h"
#include "utilities.h"
//#include "klogdefinitions.h"
//#include "awards.h"


//class QStringList;

enum
{
    Entity_Name = 1,
    Entity_Continent = 2
};

class World : public QObject
{
    //friend class Awards;
    Q_OBJECT
    friend class tst_World;

public:            
    World(DataProxy_SQLite *dp, const QString &_parentFunction);
    //World(DataProxy_SQLite *dp, const QString &_klogDir, const QString &_parentFunction);
    //World(DataProxy_SQLite *dp, const QString &_klogVer, const QString &_parentFunction);

    ~World();
    bool create(const QString &_worldFile);
    bool recreate(const QString &_worldFile);
    bool readWorld();

    QString getQRZEntityName(const QString &_qrz);
    QString getEntityName(const int _entityN);

    QString getQRZEntityMainPrefix(const QString &_qrz);
    QString getEntityMainPrefix(int _dxcc);
    EntityData getEntityDataFromDXCC(const int _dxcc);    // Returns the data of one DXCC entity

    QString getQRZContinentNumber(const QString &_qrz); // Returns the continent id number
    int getContinentNumber(const int _enti); // Returns the continent id number

    QString getQRZContinentShortName(const QString &_qrz); // Returns the continent shortName (EU, AF, ...)
    QString getContinentShortName(const int _enti);

    QString getQRZLocator(const QString &_qrz); // Returns the entity locator
    QString getLocator(const int _entityN); // Returns the entity locator

    double getLongitude(const int _enti); // Returns the longitude of the Entity
    double getLatitude(const int _enti); // Returns the latitude of the Entity
    int selectEntity(const int _ent1, const int _ent2);     // Useful to return Italy 248 if 248 or 2248 (IT9) are delivered. -1 if no selection can be made
    int getEntityCqz(const int _enti);
    int getQRZCqz(const QString &_qrz);
    //int getPrefixCQz(const QString &_p);

    int getQRZItuz(const QString &_qrz);
    int getEntityItuz(const int _enti);

    int getQRZARRLId(const QString &_qrz); //Returns the ARRL id of the Entity from a QRZ & Returns -1 if not found.
    bool isNewCQz(const int _cqz);
    bool isNewEntity(const int _entityN);
    //int getBandIdFromFreq(const QString fr);
    QString getEntityPrefixes(const int _enti);
    bool isAKnownCall(const QString &_callsign);
    bool isAKnownPrefix(const QString &_prefix);

    //QStringList getEntitiesNames();
    int getHowManyEntities();
    bool hasSpecialEntities();
    bool fillEmptyDXCCInTheLog();           // Adds the DXCC to the QSOs in the log that don't have it

private slots:


private:
    //void identifyOS();
    bool insertSpecialEntities();
    bool readEntities();                        // Read all the entities and fill entities QMap

    int getHowManyEmptyDXCCorCont();
    bool updateDXCCAndContinent(const int _id, const int _dxcc, const QString &_cont);

    //bool readCTYDAT();
    bool readCTYCSV(const QString &_worldFile);
    bool addEntity(const QString &_name, const int _cq, const int _itu, const int _contId, const double _lat, const double _lon, const double _utc, const int _dxcc, const QString &_mainpref);
    bool addPrefix(const QString &_pref, const int _dxcc, const int _cqz, const int _ituz);

    //void createWorldModel();
    QStringList readZones(const QString &pref, const int _cq, const int _itu);
    bool addPrefixes(const QString &prefixes, int entityNumber, int cqz, int ituz);
    bool insertPrefixes(const QList<QPair<QString, QPair<int, QPair<int, int>>>> &pairPrefixes);
    int extractEntityNumber(const QStringList &stringList);
    bool existingDXCCId(const int _id)  const;                  // TO Check on World creation if a non-DXCC(IT9, IG9, ...) is already existing
    void emitQueryError(const QSqlQuery &query) const;
    bool executeQuery(QSqlQuery &query, const QString &queryString) const;
    //int progressBarPosition;

    bool created, read;
    //QString klogVersion;
    int cqz, ituz;//, numberOfEntities;
    QString entityName;
    QString currentPrefix; // Used in the progressBar

    bool ret;
    QStringList list, prefixAndZones;
    QString continentName, prefix;
    int continentId;
    double lat, lon, utc;
    //int utc;
    //QString line;
    //bool readingDataOfAnEntity;
    int nullValue;

    Locator *locator;
    DataProxy_SQLite *dataProxy;
    Utilities *util;
    QHash<QString, int> worldPrefixes;
    QStringList specialCalls, longPrefixes;

    QMap<EntityData, int> entities;         // Static data to speed up queries

signals:
    //void qsoFound(const QStringList _qs); // Each: QString with format: Fieldname:value
    //void queryError(QString functionFailed, QString errorCodeS, QString nativeError, QString failedQuery); // To alert about any failed query execution
    void queryError(const char *funcInfo, const QString &databaseText, const QString &text, const QString &query) const;
};


#endif // WORLD_H
