/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef SOCKETCONTROLLER_H
#define SOCKETCONTROLLER_H

#include <QWidget>
#include <QQueue>
#include <QApplication>
#include "auth/auth_tcp_client.h"
#include "file_manager.h"
#include "../../../commons/constants.h"
#include "../xml/xml_creator_client.h"
#include "../xml/xml_parser_client.h"

class SocketController : public QObject
{
    Q_OBJECT

public:
    SocketController(char* ip, int port,int f_port, QString password);
    FileManager *file_manager;
    void connect_to_server(char* ip, int port, int f_port, QString password);
    auth_tcp_client *master_tcp_client;
    auth_tcp_client *file_tcp_client;
    void error_message_dequeue(QString message);
    QQueue<File*> *file_queue;

public slots:
    void auth_succeeded_slot();
    void received_stream_slot(QString message);
    void send_to_server(QString msg);
    void ask_file_to_server(QString to, QString from, QString file_name);
    void send_file_to_server(QString to, QString from, QString file_name);
    void executeCommand(QString command, QString path);
    void process_queue();

signals:
    void client_characteristics(OsCharacteristic *characteristics);
    void refresh_directory_view(Folder *folder);
    void showMessage(QString title, QString content, int duration);
    void showLabelSignal(QString label);
    void remove_from_view(QString file_name, bool is_local);
    void file_uploaded(File *file);
    void update_percent(int current, int total);
    void command_results(QString str);
private:
    XmlParserClient *xml_parser;
    QString slash;
    char* server_ip;
    int server_port;
    int server_port_file;
    QString server_password;
    QString filePath;
};

#endif
