/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "server_central_window.h"

ServerCentralWindow::ServerCentralWindow(QWidget *parent)
    : QWidget(parent)
{	
    settings = new QSettings("OpenNetwork", "KontrolPack", this);
    controller = new ConnectionController(this);

    image = new QLabel(this);
    groupBox = new QGroupBox(this);
    QGridLayout *gridBox = new QGridLayout;

    ipCombo = new QComboBox(this);
    ipCombo->setEditable(false);
    passwordLineEdit = new QLineEdit("");
    portLineEdit = new QLineEdit(settings->value("parameters/port", "17984").toString());
    portFileLineEdit = new QLineEdit(settings->value("parameters/port-file", "17985").toString());
    passwordLineEdit->setEchoMode(QLineEdit::Password);
    ipCombo->setMinimumWidth(25);
    portLineEdit->setMinimumWidth(25);
    portLineEdit->setValidator(new QIntValidator(1, 65535, this));
    portFileLineEdit->setMinimumWidth(25);
    portFileLineEdit->setMinimumWidth(25);
    portFileLineEdit->setValidator(new QIntValidator(1, 65535, this));

#ifdef WIN32
    image->setPixmap(QPixmap(":/images/windows-computer.png"));
    QFont font("Arial", 8, true);
    QString os = QString("Microsoft Windows");
#elif defined __APPLE__
    image->setPixmap(QPixmap(":/images/mac-computer.png"));
    QFont font = QFont();
    QString os = QString("Mac OS X");
#else
    image->setPixmap(QPixmap(":/images/linux-computer.png"));
    QFont font("Arial", 10, true);
    QString os = QString("GNU/Linux based OS");
#endif

    int cpt = 2;
    QList<QNetworkInterface> interface_list = QNetworkInterface::allInterfaces();
    for (int k = 0; k < interface_list.size(); k++) {
        if (interface_list.at(k).flags().testFlag(QNetworkInterface::IsRunning)) {
            foreach (QNetworkAddressEntry entry, interface_list.at(k).addressEntries()) {
                if ( interface_list.at(k).hardwareAddress() != "00:00:00:00:00:00" && entry.ip().toString().contains(".")) {
                    cpt ++;
#ifdef WIN32
                    QLabel *adressLabel = new QLabel(entry.ip().toString());
#else
                    QLabel *adressLabel = new QLabel(interface_list.at(k).name() + " : " + entry.ip().toString());
#endif
                    adressLabel->setFont(font);
                    gridBox->addWidget(adressLabel, cpt, 0);
                    if (!entry.ip().toString().startsWith(QString(LOOPBACK), Qt::CaseInsensitive))
                        ipCombo->addItem(entry.ip().toString(), entry.ip().toString());
                }
            }
        }
    }
    ipCombo->addItem(QString(LOOPBACK), QString(LOOPBACK));

    QLabel *os_label = new QLabel(os);
    os_label->setFont(font);
    gridBox->addWidget(image, 0, 0);
    gridBox->addWidget(os_label, 1, 0);
    groupBox->setLayout(gridBox);
    statusLabel = new QLabel(tr("Status : Server stopped"), this);
    statusLabel->setFont(font);
    QLabel *label = new QLabel(tr("<strong>KontrolPack Server : Remote access over secure network</strong>"), this);
    label->setFont(font);
    QLabel *authLabel = new QLabel(tr("Choose a password to secure authentication mechanism"), this);
    authLabel->setFont(font);
    startButton = new QPushButton(QIcon(":/images/start.png"), tr("Start server"), this);
    stopButton = new QPushButton(QIcon(":/images/stop.png"), tr("Stop server"), this);
    startButton->setFont(font);
    stopButton->setFont(font);
    label->setOpenExternalLinks(true);
    stopButton->setDisabled(true);
    hostLabel = new QLabel(tr("&Server IP address :"));
    passwordLabel = new QLabel(tr("KontrolPack Master Password :"));
    portLabel = new QLabel(tr("S&erver port :"));
    portFileLabel = new QLabel(tr("S&erver File port :"));
    hostLabel->setFont(font);
    passwordLabel->setFont(font);
    portLabel->setFont(font);
    portFileLabel->setFont(font);

    hostLabel->setBuddy(ipCombo);
    portLabel->setBuddy(portLineEdit);
    portFileLabel->setBuddy(portFileLineEdit);
    passwordLabel->setBuddy(passwordLineEdit);

    QFrame *upFrame = new QFrame( this );
    upFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    QFrame *passwordFrame = new QFrame( this );
    passwordFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    QFrame *downFrame = new QFrame( this );
    downFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    QGridLayout *mainLayout = new QGridLayout;
    mainLayout->addWidget(groupBox, 0, 0, 9, 1);
    mainLayout->addWidget(label, 0, 1, 1, 2);
    setWindowFlags(Qt::Dialog);
    mainLayout->addWidget(upFrame, 1, 1, 1, 2);
    mainLayout->addWidget(authLabel, 2, 1, 1, 2);
    mainLayout->addWidget(passwordLabel, 3, 1);
    mainLayout->addWidget(passwordLineEdit, 3, 2);
    mainLayout->addWidget(passwordFrame, 4, 1, 1, 2);

    mainLayout->addWidget(hostLabel, 5, 1);
    mainLayout->addWidget(ipCombo, 5, 2);
    mainLayout->addWidget(portLabel, 6, 1);
    mainLayout->addWidget(portLineEdit, 6, 2);
    mainLayout->addWidget(portFileLabel, 7, 1);
    mainLayout->addWidget(portFileLineEdit, 7, 2);

    mainLayout->addWidget(downFrame, 8, 1, 1, 2);
    mainLayout->addWidget(statusLabel, 9, 1, 1, 2);
    mainLayout->addWidget(startButton, 10, 1);
    mainLayout->addWidget(stopButton, 10, 2);
    setLayout(mainLayout);

    ipCombo->setFocus();

    QObject::connect(controller, SIGNAL(signals_state(int, int)), this, SLOT(tcp_state(int, int)));
    QObject::connect(controller, SIGNAL(auth_succeeded(int)), this, SLOT(auth_succeeded(int)));
    QObject::connect(startButton, SIGNAL(clicked()), this, SLOT(start_server()));
    QObject::connect(stopButton, SIGNAL(clicked()), this, SLOT(stop_server()));
    QObject::connect(passwordLineEdit, SIGNAL(returnPressed()), this, SLOT(start_server()));
}

int ServerCentralWindow::start_server()
{
    if (ipCombo->itemText(ipCombo->currentIndex()) != "") {
        if (portLineEdit->text() != "") {
            if (portFileLineEdit->text() != "") {
                if (passwordLineEdit->text().size() > 7) {
                    if (passwordLineEdit->text().size() < 30) {
                        int start = controller->start_server(passwordLineEdit->text(), ipCombo->itemText(ipCombo->currentIndex()), portLineEdit->text().toInt(), portFileLineEdit->text().toInt());
                        if (start == 1 ) {
                            settings->setValue("parameters/ip", ipCombo->itemText(ipCombo->currentIndex()));
                            settings->setValue("parameters/port", portLineEdit->text());
                            settings->setValue("parameters/port-file", portFileLineEdit->text());
                            startButton->setDisabled(true);
                            stopButton->setDisabled(false);
                            this->parentWidget()->hide();
                            statusLabel->setText(tr("Status : Server started"));
                            emit showMessage("Information", "Server started...", 3000);
                        } else {
                            statusLabel->setText(tr("Status : Error : Server stopped"));
                            emit showMessage("Information", "Error starting server : Server stopped...", 3000);
                            return 0;
                        }
                    } else {
                        QMessageBox::information(this, tr("Warning"), tr("Password length must be smaller than 30 characters."));
                    }
                } else {
                    QMessageBox::information(this, tr("Warning"), tr("For security reason, password length must be at least 8."));
                }
            } else {
                QMessageBox::information(this, tr("Warning"), tr("Please, fill in the port file field."));
            }
        } else {
            QMessageBox::information(this, tr("Warning"), tr("Please, fill in the port field."));
        }
    } else {
        QMessageBox::information(this, tr("Warning"), tr("Please, fill in the IP address field."));
    }
}

void ServerCentralWindow::stop_server()
{
    controller->stop_server();
    startButton->setDisabled(false);
    stopButton->setDisabled(true);
    statusLabel->setText(tr("Status : Server stopped"));
    emit showMessage("Information", "Server stopped...", 3000);
}

/*
    #define TOKEN_WELCOME 0
    #define RSA_PUBLIC_KEY_EXCHANGE 1
    #define PASSWORD_VALIDATION 2
    #define AES_KEY_RECEPTION 3
*/
void ServerCentralWindow::tcp_state(int state, int client_nbr)
{
    switch (state)
    {
    case TOKEN_WELCOME : {
            qDebug("Server notification : Status TOKEN_WELCOME");
            emit showMessage("Information", "A remote computer is trying to connect...", 3000);
            break;
        }
    case RSA_PUBLIC_KEY_RECEPTION : {
            qDebug("Server notification : Status RSA_PUBLIC_KEY_EXCHANGE");
            break;
        }
    case PASSWORD_VALIDATION : {
            qDebug("Server notification : Status PASSWORD_VALIDATION");
            break;
        }
    case AES_KEY_RECEPTION : {
            qDebug("Server notification : Status AES_KEY_RECEPTION");
            break;
        }
    case AUTH_SUCCESS : {
            qDebug("Server notification : Status 4");

            break;
        }
    case 5 : {
            qDebug("Server notification : Status 5");

            break;
        }
    default:
        ;
    }
}

/*
Connect to the auth_succeeded
to be aware of new client authentification state.
*/
void ServerCentralWindow::auth_succeeded(int client_nbr)
{
    emit showMessage("Information", "A remote computer is connected to this computer. Authentification succeeded...", 3000);
}
