/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.disassembler;

import com.claritysys.jvm.classfile.CfEntry;
import com.claritysys.jvm.classfile.CfField;
import com.claritysys.jvm.classfile.CfMethod;
import com.claritysys.jvm.classfile.ClassFile;
import com.claritysys.jvm.classfile.ClassFileFormatException;
import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpClass;
import com.claritysys.jvm.classfile.CpEntry;
import com.claritysys.jvm.classfile.CpNameAndType;
import com.claritysys.jvm.classfile.CpRef;
import com.claritysys.jvm.classfile.CpString;
import com.claritysys.jvm.classfile.JVM;
import com.claritysys.jvm.disassembler.CodeIterator;
import com.claritysys.jvm.disassembler.IndentingWriter;
import com.claritysys.jvm.disassembler.OpcodeInfo;
import com.claritysys.jvm.disassembler.Signature;
import com.claritysys.util.Java;
import com.claritysys.util.Stopwatch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class Disassembler
implements Signature.TypeFormatter {
    private ClassFile cf;
    private ConstantPool cpool;
    private String outputFileName;
    private IndentingWriter iw;
    private Signature sigParser = new Signature(this);
    private HashMap fullToAlias = new HashMap(131);
    private HashMap aliasToFull = new HashMap(131);
    private String thisClassAlias;
    private String[] CPOOL_CACHE = new String[1024];
    private static final boolean PRINT_CODE_BYTES = false;
    private int methodArgCount;

    public static void main(String[] args) throws IOException, ClassFileFormatException {
        System.out.println();
        System.out.println("JASM Java Disassembler 1.0.0");
        System.out.println("Copyright(c)2002-2003 Clarity Systems Group, LLC");
        System.out.println("All Rights Reserved.");
        System.out.println();
        if (args.length == 0) {
            System.err.println("Usage: Disassembler <file>\n  Output is placed in current path, in out.jasm");
            System.exit(1);
        }
        Stopwatch total = new Stopwatch();
        Stopwatch watch = new Stopwatch();
        Disassembler.statusPending(" Loading class file ... ");
        watch.restart();
        ClassFile cf = ClassFile.fromFile(args[0]);
        String shortName = Java.getShortNameInternal((String)cf.getClassName());
        Disassembler.statusComplete("OK (" + watch.elapsed() + "ms)");
        String toFile = shortName + ".jasm";
        watch.restart();
        Disassembler.statusPending(" Generating " + toFile + " ... ");
        Disassembler da = new Disassembler(cf, toFile);
        da.disassemble();
        Disassembler.statusComplete("OK (" + watch.elapsed() + "ms)");
        Disassembler.statusComplete("\nDone (" + total.elapsed() + "ms)");
    }

    private static void statusPending(String msg) {
        System.out.print(msg);
        System.out.flush();
    }

    private static void statusComplete(String msg) {
        System.out.println(msg);
    }

    public Disassembler(ClassFile cf, String toFileName) {
        this.setClassFile(cf);
        this.setOutputFile(toFileName);
        this.thisClassAlias = Java.getShortName((String)cf.getClassName());
    }

    public Disassembler(ClassFile cf, Writer writer) {
        this.setClassFile(cf);
        this.setOutput(writer);
        this.thisClassAlias = Java.getShortName((String)cf.getClassName());
    }

    public boolean isThisClass(String alias) {
        return this.thisClassAlias.equals(alias);
    }

    public void disassemble() {
        this.visitJavaClass(this.cf);
        try {
            this.iw.flush();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to flush stream!");
        }
    }

    public void setClassFile(ClassFile cf) {
        this.cf = cf;
        this.cpool = cf.getConstantPool();
    }

    public void setOutputFile(String path) {
        this.outputFileName = path;
        File file = new File(path);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Output file is a directory!");
        }
        try {
            this.setOutput(new BufferedWriter(new FileWriter(file)));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to open output file '" + path + "': " + ioe);
        }
    }

    public void setOutput(Writer writer) {
        this.iw = new IndentingWriter(writer);
    }

    private String getAlias(String fullName) {
        String alias = (String)this.fullToAlias.get(fullName = fullName.replace('.', '/'));
        if (alias == null) {
            alias = Java.getShortNameInternal((String)fullName);
            if (this.aliasToFull.containsKey(alias)) {
                alias = fullName;
            }
            this.aliasToFull.put(alias, fullName);
            this.fullToAlias.put(fullName, alias);
        }
        return alias;
    }

    public String getFormattedType(String type) {
        return this.getAlias(type);
    }

    private String getMethodSig(ConstantPool cpool, int index) {
        this.ensureCacheCapacity(index);
        String[] cache = this.CPOOL_CACHE;
        String niceSig = cache[index];
        if (niceSig == null) {
            String signature = cpool.getUtf8AsString(index);
            niceSig = cache[index] = this._niceMethodSigCall(signature);
        }
        return niceSig;
    }

    String getTypeSig(ConstantPool cpool, int index) {
        this.ensureCacheCapacity(index);
        String[] cache = this.CPOOL_CACHE;
        String niceSig = cache[index];
        if (niceSig == null) {
            String signature = cpool.getUtf8AsString(index);
            this.sigParser.setSignature(signature);
            niceSig = cache[index] = this.sigParser.getType();
        }
        return niceSig;
    }

    private String getMethodTypeDeclaration(CfMethod method) {
        this.sigParser.setSignature(method.getSignature());
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.sigParser.getType()).append(" ");
        buf.append(method.getName()).append(" (");
        int firstParam = method.isStatic() ? 0 : 1;
        this.methodArgCount = this.sigParser.getParameterCount() + firstParam;
        if (this.sigParser.getParameterCount() > 0) {
            int param = firstParam;
            for (int i = 0; i < this.sigParser.getParameterCount(); ++i) {
                String type = this.sigParser.getParameter(i);
                String lvName = CodeIterator.getLocalName(method, param);
                buf.append(type).append(" ").append(lvName);
                buf.append(", ");
                ++param;
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return buf.toString();
    }

    private String _niceMethodSigCall(String sig) {
        this.sigParser.setSignature(sig);
        StringBuffer buf = new StringBuffer(64);
        buf.append("(");
        if (this.sigParser.getParameterCount() > 0) {
            for (int i = 0; i < this.sigParser.getParameterCount(); ++i) {
                String type = this.sigParser.getParameter(i);
                buf.append(type);
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        buf.append(this.sigParser.getType());
        return buf.toString();
    }

    String getCpClassName(ConstantPool cpool, int index) {
        CpClass conClass = (CpClass)cpool.getPoolEntry(index);
        return conClass.getStringName();
    }

    private void ensureCacheCapacity(int index) {
        String[] cache = this.CPOOL_CACHE;
        if (cache.length <= index) {
            cache = new String[index << 2];
            System.arraycopy(this.CPOOL_CACHE, 0, cache, 0, this.CPOOL_CACHE.length);
            this.CPOOL_CACHE = cache;
        }
    }

    String getAlias(ConstantPool cpool, int index) {
        this.ensureCacheCapacity(index);
        String[] cache = this.CPOOL_CACHE;
        String alias = cache[index];
        if (alias == null) {
            alias = cache[index] = this.getAlias(this.getCpClassName(cpool, index));
        }
        return alias;
    }

    private String getConstantAsString(ConstantPool cpool, int index) {
        CpEntry c = cpool.getPoolEntry(index);
        if (c instanceof CpString) {
            return "\"" + c.toJavaString() + "\"";
        }
        return c.toJavaString();
    }

    public void visitJavaClass(ClassFile obj) {
        int[] interfaces;
        int i;
        String packageName;
        String sourceName = obj.getSourcefile();
        if (sourceName != null) {
            this.iw.print(".source \"");
            this.iw.print(sourceName);
            this.iw.println("\"");
            this.iw.println();
        }
        if ((packageName = obj.getPackage()) != null) {
            this.iw.print("package ");
            this.iw.println(packageName.replace('.', '/'));
            this.iw.println();
        }
        ArrayList<String> imports = new ArrayList<String>();
        ConstantPool cpool = obj.getConstantPool();
        for (i = 0; i < cpool.getCount(); ++i) {
            CpEntry con = cpool.getPoolEntry(i);
            if (!(con instanceof CpClass)) continue;
            String className = ((CpClass)con).getStringName();
            String alias = this.getAlias(cpool, i);
            if (this.isThisClass(alias)) continue;
            imports.add(className);
        }
        Collections.sort(imports);
        for (i = 0; i < imports.size(); ++i) {
            String className = (String)imports.get(i);
            this.iw.print("import ");
            this.iw.println(className);
        }
        if (imports.size() > 0) {
            this.iw.println();
        }
        this.emitModifiers(obj);
        this.iw.print("class ");
        this.iw.print(this.getAlias(cpool, obj.getClassIndex()));
        this.iw.print(" ");
        String superName = obj.getSuperclassName();
        if (!superName.equals("java.lang.Object")) {
            this.iw.print("extends ");
            this.iw.print(this.getAlias(cpool, obj.getSuperclassIndex()));
            this.iw.print(" ");
        }
        if ((interfaces = obj.getInterfaces()) != null && interfaces.length > 0) {
            this.iw.print("implements ");
        }
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            this.iw.print(this.getAlias(cpool, interfaces[i2]));
            if (i2 < interfaces.length - 1) {
                this.iw.print(", ");
                continue;
            }
            this.iw.print(" ");
        }
        this.iw.println("{");
        this.iw.indent(1);
        this.iw.println();
        for (CfField field = obj.getFields(); field != null; field = field.getNext()) {
            this.visitField(field);
        }
        for (CfMethod method = obj.getMethods(); method != null; method = method.getNext()) {
            this.visitMethod(method);
        }
        this.iw.indent(-1);
        this.iw.println("}");
    }

    public void visitField(CfField obj) {
        this.emitModifiers(obj);
        String type = this.getTypeSig(obj.getConstantPool(), obj.getDescriptorIndex());
        this.iw.print(type);
        this.iw.print(" ");
        this.iw.print(obj.getName());
        CpEntry cv = obj.getConstantValue();
        if (cv != null) {
            this.iw.print(" = ");
            this.iw.print(cv.toJavaString());
        }
        this.iw.println();
    }

    public void visitMethod(CfMethod obj) {
        this.iw.println();
        this.iw.println("/**");
        this.iw.println(" * " + obj.getName());
        this.iw.println(" *");
        this.iw.println(" * maxstack: " + obj.getMaxStack());
        this.iw.println(" * maxlocals: " + obj.getMaxLocals());
        this.iw.println(" */");
        this.emitModifiers(obj);
        this.iw.print(this.getMethodTypeDeclaration(obj));
        int argCount = this.methodArgCount;
        this.iw.print(" ");
        int[] enames = obj.getExceptionCps();
        if (enames != null && enames.length > 0) {
            this.iw.print("throws ");
            for (int i = 0; i < enames.length; ++i) {
                this.iw.print(this.getAlias(obj.getConstantPool(), enames[i]));
                if (i < enames.length - 1) {
                    this.iw.print(", ");
                    continue;
                }
                this.iw.print(" ");
            }
        }
        if (!obj.isAbstract()) {
            this.iw.println("{");
            this.iw.indent(1);
            this.emitBytecode(obj, argCount);
            this.iw.indent(-1);
            this.iw.println("}");
        } else {
            this.iw.println();
        }
    }

    private void emitModifiers(CfEntry obj) {
        if (obj.isPrivate()) {
            this.iw.print("private ");
        }
        if (obj.isProtected()) {
            this.iw.print("protected ");
        }
        if (obj.isPublic()) {
            this.iw.print("public ");
        }
        if (obj.isAbstract()) {
            this.iw.print("abstract ");
        }
        if (obj.isStatic()) {
            this.iw.print("static ");
        }
        if (obj.isFinal()) {
            this.iw.print("final ");
        }
        if (obj.isNative()) {
            this.iw.print("native ");
        }
        if (obj.isSynchronized() && !(obj instanceof ClassFile)) {
            this.iw.print("synchronized ");
        }
        if (obj.isTransient()) {
            this.iw.print("transient ");
        }
        if (obj.isVolatile()) {
            this.iw.print("volatile ");
        }
    }

    private void emitBytecode(CfMethod method, int argCount) {
        int[][] OPERAND_INTERPRETATION = OpcodeInfo.OPERAND_INTERPRETATION;
        byte[] LOCAL_ARGS_IMPLIED = OpcodeInfo.LOCAL_ARGS_IMPLIED;
        String[] OPCODE_NAMES = JVM.OPCODE_NAMES;
        CodeIterator ci = new CodeIterator(this, method, argCount);
        ci.extractMarkers();
        while (ci.hasNext()) {
            CodeIterator.LineMarker marker;
            int defaultOffset;
            int skip;
            CodeIterator.LineMarker nextMarker;
            int opcode = ci.nextOp();
            boolean didBreak = false;
            boolean hadLocal = false;
            while ((nextMarker = ci.getMarker()) != null) {
                if (!didBreak) {
                    this.iw.println();
                    didBreak = true;
                }
                if (nextMarker.isLabel) {
                    this.iw.indent(-1);
                    this.iw.println(nextMarker.marker + ":");
                    this.iw.indent(1);
                    continue;
                }
                this.iw.println(nextMarker.marker);
                hadLocal = true;
            }
            if (hadLocal) {
                this.iw.println();
            }
            String mnemonic = OPCODE_NAMES[opcode];
            String implicitLocal = null;
            if (LOCAL_ARGS_IMPLIED[opcode] >= 0) {
                byte lnum = LOCAL_ARGS_IMPLIED[opcode];
                implicitLocal = ci.getLocalName(lnum);
                int pos = mnemonic.indexOf(95);
                mnemonic = mnemonic.substring(0, pos);
            }
            this.iw.print(mnemonic);
            this.iw.print("\t");
            if (implicitLocal != null) {
                this.iw.print(implicitLocal);
            }
            block18: for (int argNumber = 0; argNumber < OPERAND_INTERPRETATION[opcode].length; ++argNumber) {
                switch (OPERAND_INTERPRETATION[opcode][argNumber]) {
                    case 0: {
                        this.iw.print(Integer.toString(ci.nextU1()));
                        continue block18;
                    }
                    case 1: {
                        int i1 = ci.nextI1();
                        if (opcode == 132) {
                            if (i1 < 0) {
                                i1 = -i1;
                                this.iw.print(" -= ");
                            } else {
                                this.iw.print(" += ");
                            }
                        }
                        this.iw.print(Integer.toString(i1));
                        continue block18;
                    }
                    case 2: {
                        this.iw.print(Integer.toString(ci.nextI2()));
                        continue block18;
                    }
                    case 3: {
                        int index = ci.nextU1();
                        this.iw.print(this.getConstantAsString(this.cpool, index));
                        continue block18;
                    }
                    case 4: {
                        int index = ci.nextU2();
                        this.iw.print(this.getConstantAsString(this.cpool, index));
                        continue block18;
                    }
                    case 5: {
                        int index = ci.nextU2();
                        this.iw.print(this.getConstantAsString(this.cpool, index));
                        continue block18;
                    }
                    case 6: {
                        int index = ci.nextU1();
                        this.iw.print(ci.getLocalName(index));
                        continue block18;
                    }
                    case 7: {
                        int offset = ci.nextI2();
                        CodeIterator.LineMarker marker2 = ci.getMarkerAtOffset(offset);
                        this.iw.print(marker2.marker);
                        continue block18;
                    }
                    case 12: {
                        int offset = ci.nextI4();
                        CodeIterator.LineMarker marker2 = ci.getMarkerAtOffset(offset);
                        this.iw.print(marker2.marker);
                        continue block18;
                    }
                    case 8: {
                        int index = ci.nextU2();
                        CpRef c = (CpRef)this.cpool.getPoolEntry(index);
                        CpNameAndType cnt = c.getNameAndType();
                        String name = cnt.getName().getString();
                        String cname = this.getAlias(this.cpool, c.getCpClass().getIndex());
                        String cast = this.getTypeSig(this.cpool, cnt.getType().getIndex());
                        String memberType = ".";
                        if (opcode == 179 || opcode == 178) {
                            memberType = "$";
                        }
                        String format = this.isThisClass(cname) ? "(" + cast + ") " + name : "(" + cast + ") " + cname + memberType + name;
                        this.iw.print(format);
                        continue block18;
                    }
                    case 9: {
                        int index = ci.nextU2();
                        CpRef c = (CpRef)this.cpool.getPoolEntry(index);
                        CpNameAndType cnt = c.getNameAndType();
                        String name = cnt.getName().getString();
                        String cname = this.getAlias(this.cpool, c.getCpClass().getIndex());
                        String memberType = ".";
                        if (opcode == 184) {
                            memberType = "$";
                        }
                        String niceSig = this.getMethodSig(this.cpool, cnt.getType().getIndex());
                        String format = this.isThisClass(cname) ? name + niceSig : cname + memberType + name + niceSig;
                        this.iw.print(format);
                        continue block18;
                    }
                    case 10: {
                        continue block18;
                    }
                    case 11: {
                        int index = ci.nextU2();
                        String alias = this.getAlias(this.cpool, index);
                        this.iw.print(alias);
                        continue block18;
                    }
                    case 13: {
                        int type = ci.nextU1();
                        this.iw.print(JVM.TYPE_NAMES[type]);
                        continue block18;
                    }
                }
            }
            if (opcode == 171) {
                this.iw.println();
                this.iw.indent(1);
                skip = 4 - ci.getArgPtr() % 4;
                while (skip-- > 0) {
                    ci.nextI1();
                }
                defaultOffset = ci.nextI4();
                int pairs = ci.nextI4();
                for (int i = 0; i < pairs; ++i) {
                    int value = ci.nextI4();
                    int offset = ci.nextI4();
                    marker = ci.getMarkerAtOffset(offset);
                    this.iw.println(value + ": " + marker.marker);
                }
                CodeIterator.LineMarker marker3 = ci.getMarkerAtOffset(defaultOffset);
                this.iw.println("default: " + marker3.marker);
                this.iw.indent(-1);
            } else if (opcode == 170) {
                this.iw.println();
                this.iw.indent(1);
                skip = 4 - ci.getArgPtr() % 4;
                while (skip-- > 0) {
                    ci.nextI1();
                }
                defaultOffset = ci.nextI4();
                int lowRange = ci.nextI4();
                int highRange = ci.nextI4();
                for (int i = lowRange; i <= highRange; ++i) {
                    int target = ci.nextI4();
                    marker = ci.getMarkerAtOffset(target);
                    this.iw.println(i + ": " + marker.marker);
                }
                CodeIterator.LineMarker marker4 = ci.getMarkerAtOffset(defaultOffset);
                this.iw.println("default: " + marker4.marker);
                this.iw.indent(-1);
            }
            this.iw.println();
        }
    }
}

