/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.instrumentor.AbstractInstrumentor;
import alt.jiapi.instrumentor.CreateFieldInstrumentor;
import alt.jiapi.instrumentor.CreateMethodInstrumentor;
import alt.jiapi.instrumentor.FieldAssignInstrumentor;
import alt.jiapi.instrumentor.HeadInstrumentor;
import alt.jiapi.instrumentor.Hook;
import alt.jiapi.instrumentor.Instrumentation;
import alt.jiapi.instrumentor.InstrumentorChain;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiField;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.JiapiRuntimeException;
import alt.jiapi.reflect.Loader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.apache.log4j.Category;

public class MethodCallInstrumentor
extends AbstractInstrumentor {
    private static Category log = Category.getInstance(MethodCallInstrumentor.class);
    protected Hook hook;
    protected Class hookClass;
    protected Method hookMethod;
    protected boolean isDynamic;
    private String jiapiFieldName = "__jiapi_field";
    protected InstrumentorChain preChain;
    protected InstrumentorChain postChain;
    private HashMap preInstrumentations = new HashMap();
    private HashMap postInstrumentations = new HashMap();

    public MethodCallInstrumentor() {
    }

    public MethodCallInstrumentor(Hook hook) {
        this.setHook(hook);
    }

    public MethodCallInstrumentor(Class hookClass, Method hookMethod) {
        this.hookClass = hookClass;
        this.hookMethod = hookMethod;
        this.isDynamic = !Modifier.isStatic(hookMethod.getModifiers());
    }

    public void instrument(InstructionList il) {
        log.info((Object)("Instrumenting " + this.getCurrentClass().getName() + "." + il.getDeclaringMethod().getName()));
        JiapiMethod jm = il.getDeclaringMethod();
        int modifiers = jm.getModifiers();
        if (Modifier.isNative(modifiers) || Modifier.isAbstract(modifiers)) {
            log.info((Object)("skipping abstract or native method: " + this.getCurrentClass().getName() + "." + jm.getName()));
            this.forward(il);
            return;
        }
        if (Modifier.isInterface(modifiers)) {
            log.info((Object)("Will not instrument interface " + this.getCurrentClass().getName()));
            this.forward(il);
            return;
        }
        this.patchInstructionList(il, this.getInstrumentation());
        this.forward(il);
    }

    private void patchInstructionList(InstructionList il, Instrumentation instrumentation) {
        InstructionFactory factory = il.getInstructionFactory();
        if (factory == null) {
            throw new NullPointerException("Got null factory");
        }
        int currentMethodModifiers = il.getDeclaringMethod().getModifiers();
        JiapiClass clazz = this.getCurrentClass();
        Class<?>[] hookParams = this.hookMethod.getParameterTypes();
        if (this.isDynamic) {
            log.debug((Object)"Hook is dynamic");
            JiapiField field = null;
            try {
                field = clazz.getDeclaredField(this.jiapiFieldName);
            }
            catch (NoSuchFieldException nsfe) {
                throw new JiapiRuntimeException("No such field: " + nsfe.getMessage());
            }
            il.add(factory.getField(field));
            if (Modifier.isStatic(currentMethodModifiers)) {
                il.add(factory.pushConstant(clazz.getName()));
            } else {
                il.add(factory.pushThis());
            }
        } else {
            log.debug((Object)"Hook is static");
            il.add(factory.pushConstant(clazz.getName()));
        }
        for (int i = 1; i < hookParams.length; ++i) {
            if (hookParams[i].equals(String.class)) {
                String targetName = instrumentation.getTargetName();
                if (targetName == null) {
                    targetName = "???";
                }
                il.add(factory.pushConstant(targetName));
                continue;
            }
            if (hookParams[i].equals(Object.class)) {
                InstructionList targetCode = instrumentation.getTargetCode();
                if (targetCode != null) {
                    log.debug((Object)("Got target code: " + targetCode));
                    il.add(targetCode);
                    continue;
                }
                log.debug((Object)"No target code");
                il.add(factory.pushNull());
                continue;
            }
            if (hookParams[i].equals(Object[].class)) {
                log.warn((Object)"target arguments are not supported");
                il.add(factory.pushNull());
                continue;
            }
            log.error((Object)("Invalid Hook method: " + this.hookMethod));
        }
        Loader l = new Loader();
        try {
            JiapiClass hClass = l.loadClass(this.hookClass.getName());
            Class<?>[] hpTypes = this.hookMethod.getParameterTypes();
            String[] pTypes = new String[hpTypes.length];
            for (int i = 0; i < pTypes.length; ++i) {
                pTypes[i] = hpTypes[i].getName();
            }
            JiapiMethod hMethod = hClass.getDeclaredMethod(this.hookMethod.getName(), pTypes);
            il.add(factory.invoke(hMethod));
        }
        catch (Exception e) {
            log.error((Object)("Failed to add invoke instruction: " + e));
        }
    }

    public InstrumentorChain preInstrument() {
        if (!this.isDynamic) {
            log.info((Object)"Will not pre instrument for static calls");
            return null;
        }
        JiapiClass c = this.getCurrentClass();
        if (this.preInstrumentations.containsKey(c)) {
            return null;
        }
        this.preInstrumentations.put(c, null);
        int modifiers = c.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            log.info((Object)("Will not pre instrument interface " + c.getName()));
            return null;
        }
        this.preChain = new InstrumentorChain();
        this.preChain.add(new CreateFieldInstrumentor(9, this.hookClass.getName(), this.jiapiFieldName));
        return this.preChain;
    }

    public InstrumentorChain postInstrument() {
        if (!this.isDynamic) {
            return null;
        }
        JiapiClass c = this.getCurrentClass();
        if (this.postInstrumentations.containsKey(c)) {
            return null;
        }
        this.postInstrumentations.put(c, null);
        int modifiers = c.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            log.info((Object)("Will not post instrument interface " + c.getName()));
            return null;
        }
        this.postChain = new InstrumentorChain();
        this.postChain.add(new CreateMethodInstrumentor(8, "<clinit>"));
        this.postChain.add(new HeadInstrumentor());
        this.postChain.add(new FieldAssignInstrumentor(this.jiapiFieldName, this.hook.getInstance()));
        return this.postChain;
    }

    public void setHook(Hook hook) {
        this.hook = hook;
        this.hookMethod = hook.getHookMethod();
        this.hookClass = this.hookMethod.getDeclaringClass();
        this.jiapiFieldName = this.hookClass.getName().replace('.', '_') + "_" + hook.getInstance().hashCode();
        log.debug((Object)("Jiapi field name is '" + this.jiapiFieldName + "'"));
        this.isDynamic = !Modifier.isStatic(this.hookMethod.getModifiers());
    }

    public Hook getHook() {
        return this.hook;
    }

    public String toString() {
        return this.getClass().getName() + "#" + this.hook.getInstance().toString();
    }
}

