/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.AbstractDetailPane;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.FixedListDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.AnnotationDefaultAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.CodeAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.ConstantValueAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.EnclosingMethodAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.ExceptionsAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.GenericAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.InnerClassesAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.LineNumberTableAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.LocalVariableTableAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.LocalVariableTypeTableAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.RuntimeAnnotationsAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.SignatureAttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.SourceFileAttributeDetailPane;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.attributes.AnnotationDefaultAttribute;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;
import org.gjt.jclasslib.structures.attributes.ConstantValueAttribute;
import org.gjt.jclasslib.structures.attributes.EnclosingMethodAttribute;
import org.gjt.jclasslib.structures.attributes.ExceptionsAttribute;
import org.gjt.jclasslib.structures.attributes.InnerClassesAttribute;
import org.gjt.jclasslib.structures.attributes.LineNumberTableAttribute;
import org.gjt.jclasslib.structures.attributes.LocalVariableTableAttribute;
import org.gjt.jclasslib.structures.attributes.LocalVariableTypeTableAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.SignatureAttribute;
import org.gjt.jclasslib.structures.attributes.SourceFileAttribute;

public class AttributeDetailPane
extends AbstractDetailPane {
    private static final String SCREEN_UNKNOWN = "Unknown";
    private static final String SCREEN_CONSTANT_VALUE = "ConstantValue";
    private static final String SCREEN_CODE = "Code";
    private static final String SCREEN_EXCEPTIONS = "Exceptions";
    private static final String SCREEN_INNER_CLASSES = "InnerClasses";
    private static final String SCREEN_SOURCE_FILE = "SourceFile";
    private static final String SCREEN_LINE_NUMBER_TABLE = "LineNumberTable";
    private static final String SCREEN_LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    private static final String SCREEN_ENCLOSING_METHOD = "EnclosingMethod";
    private static final String SCREEN_SIGNATURE = "Signature";
    private static final String SCREEN_LOCAL_VARIABLE_TYPE_TABLE = "LocalVariableTypeTable";
    private static final String SCREEN_RUNTIME_ANNOTATIONS = "RuntimeAnnotations";
    private static final String SCREEN_ANNOTATION_DEFAULT = "AnnotationDefault";
    private HashMap attributeTypeToDetailPane;
    private JPanel specificInfoPane;
    private GenericAttributeDetailPane genericInfoPane;

    public AttributeDetailPane(BrowserServices browserServices) {
        super(browserServices);
    }

    protected void setupComponent() {
        this.buildGenericInfoPane();
        this.buildSpecificInfoPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.genericInfoPane, "North");
        this.add((Component)this.specificInfoPane, "Center");
    }

    public void show(TreePath treePath) {
        AttributeInfo attributeInfo = this.findAttribute(treePath);
        String string = null;
        if (attributeInfo instanceof ConstantValueAttribute) {
            string = SCREEN_CONSTANT_VALUE;
        } else if (attributeInfo instanceof CodeAttribute) {
            string = SCREEN_CODE;
        } else if (attributeInfo instanceof ExceptionsAttribute) {
            string = SCREEN_EXCEPTIONS;
        } else if (attributeInfo instanceof InnerClassesAttribute) {
            string = SCREEN_INNER_CLASSES;
        } else if (attributeInfo instanceof SourceFileAttribute) {
            string = SCREEN_SOURCE_FILE;
        } else if (attributeInfo instanceof LineNumberTableAttribute) {
            string = SCREEN_LINE_NUMBER_TABLE;
        } else if (attributeInfo instanceof LocalVariableTableAttribute) {
            string = SCREEN_LOCAL_VARIABLE_TABLE;
        } else if (attributeInfo instanceof EnclosingMethodAttribute) {
            string = SCREEN_ENCLOSING_METHOD;
        } else if (attributeInfo instanceof SignatureAttribute) {
            string = SCREEN_SIGNATURE;
        } else if (attributeInfo instanceof LocalVariableTypeTableAttribute) {
            string = SCREEN_LOCAL_VARIABLE_TYPE_TABLE;
        } else if (attributeInfo instanceof RuntimeAnnotationsAttribute) {
            string = SCREEN_RUNTIME_ANNOTATIONS;
        } else if (attributeInfo instanceof AnnotationDefaultAttribute) {
            string = SCREEN_ANNOTATION_DEFAULT;
        }
        CardLayout cardLayout = (CardLayout)this.specificInfoPane.getLayout();
        if (string == null) {
            cardLayout.show(this.specificInfoPane, SCREEN_UNKNOWN);
        } else {
            AbstractDetailPane abstractDetailPane = (AbstractDetailPane)this.attributeTypeToDetailPane.get(string);
            abstractDetailPane.show(treePath);
            cardLayout.show(this.specificInfoPane, string);
        }
        this.genericInfoPane.show(treePath);
    }

    public CodeAttributeDetailPane getCodeAttributeDetailPane() {
        return (CodeAttributeDetailPane)this.attributeTypeToDetailPane.get(SCREEN_CODE);
    }

    private void buildGenericInfoPane() {
        this.genericInfoPane = new GenericAttributeDetailPane(this.services);
        this.genericInfoPane.setBorder(this.createTitledBorder("Generic info:"));
    }

    private void buildSpecificInfoPane() {
        this.specificInfoPane = new JPanel();
        this.specificInfoPane.setBorder(this.createTitledBorder("Specific info:"));
        this.specificInfoPane.setLayout(new CardLayout());
        this.attributeTypeToDetailPane = new HashMap();
        JPanel jPanel = new JPanel();
        this.specificInfoPane.add((Component)jPanel, SCREEN_UNKNOWN);
        this.addScreen(new ConstantValueAttributeDetailPane(this.services), SCREEN_CONSTANT_VALUE);
        this.addScreen(new CodeAttributeDetailPane(this.services), SCREEN_CODE);
        this.addScreen(new ExceptionsAttributeDetailPane(this.services), SCREEN_EXCEPTIONS);
        this.addScreen(new InnerClassesAttributeDetailPane(this.services), SCREEN_INNER_CLASSES);
        this.addScreen(new SourceFileAttributeDetailPane(this.services), SCREEN_SOURCE_FILE);
        this.addScreen(new LineNumberTableAttributeDetailPane(this.services), SCREEN_LINE_NUMBER_TABLE);
        this.addScreen(new LocalVariableTableAttributeDetailPane(this.services), SCREEN_LOCAL_VARIABLE_TABLE);
        this.addScreen(new EnclosingMethodAttributeDetailPane(this.services), SCREEN_ENCLOSING_METHOD);
        this.addScreen(new SignatureAttributeDetailPane(this.services), SCREEN_SIGNATURE);
        this.addScreen(new LocalVariableTypeTableAttributeDetailPane(this.services), SCREEN_LOCAL_VARIABLE_TYPE_TABLE);
        this.addScreen(new RuntimeAnnotationsAttributeDetailPane(this.services), SCREEN_RUNTIME_ANNOTATIONS);
        this.addScreen(new AnnotationDefaultAttributeDetailPane(this.services), SCREEN_ANNOTATION_DEFAULT);
    }

    private void addScreen(AbstractDetailPane abstractDetailPane, String string) {
        if (abstractDetailPane instanceof FixedListDetailPane) {
            this.specificInfoPane.add((Component)((FixedListDetailPane)abstractDetailPane).getScrollPane(), string);
        } else {
            this.specificInfoPane.add((Component)abstractDetailPane, string);
        }
        this.attributeTypeToDetailPane.put(string, abstractDetailPane);
    }

    private Border createTitledBorder(String string) {
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, string);
        return titledBorder;
    }
}

