/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.bcel.BcelVar;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.Utility;

public class KindedAnnotationAccessVar
extends BcelVar {
    private Shadow.Kind kind;
    private UnresolvedType containingType;
    private Member member;

    public KindedAnnotationAccessVar(Shadow.Kind kind, ResolvedType type, UnresolvedType theTargetIsStoredHere, Member sig) {
        super(type, 0);
        this.kind = kind;
        this.containingType = theTargetIsStoredHere;
        this.member = sig;
    }

    public String toString() {
        return "KindedAnnotationAccessVar(" + this.getType() + ")";
    }

    public Instruction createLoad(InstructionFactory fact) {
        throw new RuntimeException("unimplemented");
    }

    public Instruction createStore(InstructionFactory fact) {
        throw new RuntimeException("unimplemented");
    }

    public InstructionList createCopyFrom(InstructionFactory fact, int oldSlot) {
        throw new RuntimeException("unimplemented");
    }

    public void appendLoad(InstructionList il, InstructionFactory fact) {
        il.append(this.createLoadInstructions(this.getType(), fact));
    }

    public InstructionList createLoadInstructions(ResolvedType toType, InstructionFactory fact) {
        InstructionList il = new InstructionList();
        Type jlClass = BcelWorld.makeBcelType(UnresolvedType.JAVA_LANG_CLASS);
        Type jlString = BcelWorld.makeBcelType(UnresolvedType.forSignature("Ljava.lang.String;"));
        Type jlClassArray = BcelWorld.makeBcelType(UnresolvedType.forSignature("[Ljava.lang.Class;"));
        Type jlaAnnotation = BcelWorld.makeBcelType(UnresolvedType.forSignature("Ljava.lang.annotation.Annotation;"));
        if (this.kind == Shadow.MethodCall || this.kind == Shadow.MethodExecution || this.kind == Shadow.PreInitialization || this.kind == Shadow.Initialization || this.kind == Shadow.ConstructorCall || this.kind == Shadow.ConstructorExecution || this.kind == Shadow.AdviceExecution || (this.kind == Shadow.FieldGet || this.kind == Shadow.FieldSet) && this.member.getKind() == Member.METHOD) {
            Type jlrMethod = BcelWorld.makeBcelType(UnresolvedType.forSignature("Ljava.lang.reflect.Method;"));
            il.append(fact.createConstant(BcelWorld.makeBcelType(this.containingType)));
            if (this.kind == Shadow.MethodCall || this.kind == Shadow.MethodExecution || this.kind == Shadow.AdviceExecution || (this.kind == Shadow.FieldGet || this.kind == Shadow.FieldSet) && this.member.getKind() == Member.METHOD || (this.kind == Shadow.ConstructorCall || this.kind == Shadow.ConstructorExecution) && this.member.getKind() == Member.METHOD) {
                il.append(fact.createConstant(this.member.getName()));
                Type[] paramTypes = null;
                paramTypes = BcelWorld.makeBcelTypes(this.member.getParameterTypes());
                this.buildArray(il, fact, jlClass, paramTypes, 1);
                il.append(fact.createInvoke("java/lang/Class", "getDeclaredMethod", jlrMethod, new Type[]{jlString, jlClassArray}, (short)182));
                String ss = toType.getName();
                il.append(fact.createConstant(new ObjectType(toType.getName())));
                il.append(fact.createInvoke("java/lang/reflect/Method", "getAnnotation", jlaAnnotation, new Type[]{jlClass}, (short)182));
                il.append(Utility.createConversion(fact, jlaAnnotation, BcelWorld.makeBcelType(toType)));
            } else {
                Type[] paramTypes = BcelWorld.makeBcelTypes(this.member.getParameterTypes());
                this.buildArray(il, fact, jlClass, paramTypes, 1);
                Type jlrCtor = BcelWorld.makeBcelType(UnresolvedType.forSignature("Ljava.lang.reflect.Constructor;"));
                il.append(fact.createInvoke("java/lang/Class", "getDeclaredConstructor", jlrCtor, new Type[]{jlClassArray}, (short)182));
                String ss = toType.getName();
                il.append(fact.createConstant(new ObjectType(toType.getName())));
                il.append(fact.createInvoke("java/lang/reflect/Constructor", "getAnnotation", jlaAnnotation, new Type[]{jlClass}, (short)182));
                il.append(Utility.createConversion(fact, jlaAnnotation, BcelWorld.makeBcelType(toType)));
            }
        } else if (this.kind == Shadow.FieldSet || this.kind == Shadow.FieldGet) {
            Type jlrField = BcelWorld.makeBcelType(UnresolvedType.forSignature("Ljava.lang.reflect.Field;"));
            il.append(fact.createConstant(BcelWorld.makeBcelType(this.containingType)));
            il.append(fact.createConstant(this.member.getName()));
            il.append(fact.createInvoke("java/lang/Class", "getDeclaredField", jlrField, new Type[]{jlString}, (short)182));
            String ss = toType.getName();
            il.append(fact.createConstant(new ObjectType(toType.getName())));
            il.append(fact.createInvoke("java/lang/reflect/Field", "getAnnotation", jlaAnnotation, new Type[]{jlClass}, (short)182));
            il.append(Utility.createConversion(fact, jlaAnnotation, BcelWorld.makeBcelType(toType)));
        } else if (this.kind == Shadow.StaticInitialization || this.kind == Shadow.ExceptionHandler) {
            il.append(fact.createConstant(BcelWorld.makeBcelType(this.containingType)));
            String ss = toType.getName();
            il.append(fact.createConstant(new ObjectType(toType.getName())));
            il.append(fact.createInvoke("java/lang/Class", "getAnnotation", jlaAnnotation, new Type[]{jlClass}, (short)182));
            il.append(Utility.createConversion(fact, jlaAnnotation, BcelWorld.makeBcelType(toType)));
        } else {
            throw new RuntimeException("Don't understand this kind " + this.kind);
        }
        return il;
    }

    private void buildArray(InstructionList il, InstructionFactory fact, Type arrayElementType, Type[] arrayEntries, int dim) {
        il.append(fact.createConstant(new Integer(arrayEntries == null ? 0 : arrayEntries.length)));
        il.append(fact.createNewArray(arrayElementType, (short)dim));
        if (arrayEntries == null) {
            return;
        }
        for (int i = 0; i < arrayEntries.length; ++i) {
            il.append(InstructionFactory.createDup(1));
            il.append(fact.createConstant(new Integer(i)));
            switch (arrayEntries[i].getType()) {
                case 13: {
                    il.append(fact.createConstant(new ObjectType(arrayEntries[i].getSignature())));
                    break;
                }
                case 4: {
                    il.append(fact.createGetStatic("java/lang/Boolean", "TYPE", arrayElementType));
                    break;
                }
                case 8: {
                    il.append(fact.createGetStatic("java/lang/Byte", "TYPE", arrayElementType));
                    break;
                }
                case 5: {
                    il.append(fact.createGetStatic("java/lang/Character", "TYPE", arrayElementType));
                    break;
                }
                case 10: {
                    il.append(fact.createGetStatic("java/lang/Integer", "TYPE", arrayElementType));
                    break;
                }
                case 11: {
                    il.append(fact.createGetStatic("java/lang/Long", "TYPE", arrayElementType));
                    break;
                }
                case 7: {
                    il.append(fact.createGetStatic("java/lang/Double", "TYPE", arrayElementType));
                    break;
                }
                case 6: {
                    il.append(fact.createGetStatic("java/lang/Float", "TYPE", arrayElementType));
                    break;
                }
                case 9: {
                    il.append(fact.createGetStatic("java/lang/Short", "TYPE", arrayElementType));
                    break;
                }
                default: {
                    il.append(fact.createConstant(arrayEntries[i]));
                }
            }
            il.append(InstructionConstants.AASTORE);
        }
    }

    public void appendLoadAndConvert(InstructionList il, InstructionFactory fact, ResolvedType toType) {
        il.append(this.createLoadInstructions(toType, fact));
    }

    public void insertLoad(InstructionList il, InstructionFactory fact) {
        il.insert(this.createLoadInstructions(this.getType(), fact));
    }
}

