#ifndef _OSL_CONFIG_H
#define _OSL_CONFIG_H

#include "osl/misc/cstdint.h"
#include <boost/static_assert.hpp>
#ifndef _WIN32
#  include <stdint.h>
#endif

#if ((defined __FreeBSD__) || (defined __CYGWIN32__) || (defined _WIN32))
#  define __WORDSIZE 32
#endif

/**
 * @def OSL_WORDSIZE_64_IN_32
 * 32bit 環境で 64bit 変数を使う
 */
// #define OSL_WORDSIZE_64_IN_32

BOOST_STATIC_ASSERT(__WORDSIZE);
/**
 * @def OSL_WORDSIZE
 * 内部データに64bitの整数を使うか32bitの整数を使うかを制御
 */
#if ((__WORDSIZE == 64) || (defined (OSL_WORDSIZE_64_IN_32)))
#  define OSL_WORDSIZE 64
#else
#  define OSL_WORDSIZE 32
#endif

#ifndef MINIMAL
#  define ALLOW_KING_ABSENCE
#endif

#ifdef OSL_USE_TBB
#  if (!defined OSL_SMP) and (! defined OSL_DFPN_SMP)
#    error "OSL_USE_TBB is for OSL_SMP"
#  endif
#  define USE_TBB_HASH 1
#  define USE_TBB_ATOMIC 1
#endif

// for helgrind or drd
// #define OSL_USE_RACE_DETECTOR

#ifdef OSL_USE_RACE_DETECTOR
#  ifndef OSL_NO_SSE
#    define OSL_NO_SSE 1
#  endif
#endif

#ifdef _MSC_VER
#pragma warning( disable : 4099 )
#pragma warning( disable : 4146 )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4267 )
#pragma warning( disable : 4661 )
#pragma warning( disable : 4800 )
#pragma warning( disable : 4805 )
#pragma warning( disable : 4906 )
#pragma warning( disable : 4996 )
#define OSL_NO_SSE 1
#endif

#endif /* _OSL_CONFIG_H */
