/* storePtypeOSquare.h
 */
#ifndef _STORE_PTYPEO_POSITION_H
#define _STORE_PTYPEO_POSITION_H
#include "osl/container/ptypeOSquareVector.h"
namespace osl
{
  namespace effect_action
  {
    /**
     * PtypeOSquareVector に格納
     */
    struct StorePtypeOSquare
    {
      container::PtypeOSquareVector *out;
      Square target;
      StorePtypeOSquare(container::PtypeOSquareVector *s, Square t) 
	: out(s), target(t)
      {
      }
      template<Player P,Ptype Type>
      void doActionPtype(Piece p)
      {
	store(p);
      }
      template<Player P>
      void doAction(Piece p, Square)
      {
	store(p);
      }
    
      void store(Piece p)
      {
	const PtypeO ptypeO = p.ptypeO();
	out->push_back(std::make_pair(ptypeO, p.square()));
      }
    };
  } // namespace effect_action
} // namespace osl
#endif // _STORE_PTYPEO_POSITION_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
