#include "osl/ptype.h"
#include "osl/ptypeTable.h"
#include <iostream>
#include <string>

bool osl::isValid(Ptype ptype)
{
  return static_cast<int>(ptype)>=PTYPE_MIN 
    && static_cast<int>(ptype)<=PTYPE_MAX;
}

bool osl::isValidPtypeO(int ptypeO)
{
  return (ptypeO >= PTYPEO_MIN) && (ptypeO <= PTYPEO_MAX);
}

std::istream& osl::operator>>(std::istream& is, osl::Ptype& ptype)
{
  std::string s;
  is >> s;
  if (s == "PTYPE_EMPTY")
    ptype = PTYPE_EMPTY;
  else if (s == "PTYPE_EDGE")
    ptype = PTYPE_EDGE;
  else if (s == "PPAWN")
    ptype = PPAWN;
  else if (s == "PLANCE")
    ptype = PLANCE;
  else if (s == "PKNIGHT")
    ptype = PKNIGHT;
  else if (s == "PSILVER")
    ptype = PSILVER;
  else if (s == "PBISHOP")
    ptype = PBISHOP;
  else if (s == "PROOK")
    ptype = PROOK;
  else if (s == "KING")
    ptype = KING;
  else if (s == "GOLD")
    ptype = GOLD;
  else if (s == "PAWN")
    ptype = PAWN;
  else if (s == "LANCE")
    ptype = LANCE;
  else if (s == "KNIGHT")
    ptype = KNIGHT;
  else if (s == "SILVER")
    ptype = SILVER;
  else if (s == "BISHOP")
    ptype = BISHOP;
  else if (s == "ROOK")
    ptype = ROOK;
  else{
    std::cerr << "Incorrect input : " << s << std::endl;
    ptype = PTYPE_EMPTY;
  }
  return is;
}

std::ostream& osl::operator<<(std::ostream& os,const osl::Ptype ptype)
{
    return os << Ptype_Table.getName(ptype);
}
  
std::ostream& osl::operator<<(std::ostream& os,const osl::PtypeO ptypeO)
{
  if (isPiece(ptypeO))
    return os << "PtypeO(" << getOwner(ptypeO) << "," 
	      << getPtype(ptypeO) << ")";
  return os << "PtypeO(" << (int)ptypeO << "," << getPtype(ptypeO) << ")";
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
