#include "osl/move_classifier/check_.h"
#include "osl/move_classifier/moveAdaptor.h"
#include "osl/move_action/store.h"
#include "osl/move_generator/allMoves.h"
#include "osl/record/csaRecord.h"
#include "osl/record/csaString.h"
#include "osl/container/moveVector.h"
#include "osl/state/historyState.h"
#include "osl/oslConfig.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <boost/progress.hpp>
#include <iostream>
#include <fstream>
typedef osl::NumEffectState test_state_t;

class CheckTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( CheckTest );
  CPPUNIT_TEST( testIsOpenCheck );
  CPPUNIT_TEST( testIsDirectCheck );
  CPPUNIT_TEST( testIsCheck );
  CPPUNIT_TEST( testFile );
  CPPUNIT_TEST_SUITE_END();
public:
  void testIsOpenCheck();
  void testIsDirectCheck();
  void testIsCheck();
  void testFile();
};
CPPUNIT_TEST_SUITE_REGISTRATION(CheckTest);

using namespace osl;
using namespace osl::move_action;
using namespace osl::move_generator;
using namespace osl::move_classifier;

void CheckTest::testIsOpenCheck(){
}
void CheckTest::testIsDirectCheck(){
}
void CheckTest::testIsCheck(){
  const char *stateString = 
    "P1-KY *  *  *  *  *  * +NY * \n"
    "P2 * -OU-KI-KI *  *  *  * +RY\n"
    "P3 * -GI-KE+KI *  *  *  * +HI\n"
    "P4 *  * -FU-KY-FU *  * -FU * \n"
    "P5-FU-FU * -KE * -FU *  *  * \n"
    "P6 *  * +FU-FU+FU * -FU *  * \n"
    "P7+FU+FU *  *  *  *  *  *  * \n"
    "P8+KY+GI+GI-UM *  *  *  *  * \n"
    "P9+OU+KE *  *  *  *  * +KE * \n"
    "P-00FU\n"
    "P-00FU\n"
    "P-00FU\n"
    "P-00FU\n"
    "P-00FU\n"
    "P-00FU\n"
    "P-00GI\n"
    "P+00KI\n"
    "P-00KA\n"
    "+\n";
  NumEffectState state((CsaString(stateString).getInitialState()));
  const Move m = Move(Square(7,1),GOLD,BLACK);
  using namespace move_classifier;
  CPPUNIT_ASSERT_EQUAL(false, PlayerMoveAdaptor<Check>::isMember(state, m));
}

template<typename State> 
static bool isCheckDoUndo(const State& state_org,Move move)
{
  State state = state_org;
  state.makeMove(move);
  return state.hasEffectAt(move.player(),state.kingSquare(alt(move.player())));
}

template<typename State> 
static bool isCheck(Player turn, const State& state,Move move)
{
  if(turn==BLACK)
    return Check<BLACK>::
      isMember(state,move.ptype(),move.from(),move.to());
  else
    return Check<WHITE>::
      isMember(state,move.ptype(),move.from(),move.to());
}

template<class State>
static void testMoveFile(const std::string& fileName){
  Record rec=CsaFile(fileName).getRecord();
  SimpleState sState=rec.getInitialState();
  State state(sState);
  vector<osl::Move> moves=rec.getMoves();
  for(unsigned int i=0;i<moves.size();i++){
    MoveVector allMoves;
    Player turn=state.turn();
    {
      Store store(allMoves);
      AllMoves<Store>::
	generate(turn,state,store);
    }
    for(size_t j=0;j<allMoves.size();j++){
      Move move=allMoves[j];
      CPPUNIT_ASSERT(isCheckDoUndo(state,move) == isCheck(turn, state,move));
    }
    state.makeMove(moves[i]);
  }
}
void CheckTest::testFile(){
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  int i=0;
  int count=50;
  if (OslConfig::inUnitTestShort()) 
    count=5;
  std::string fileName;
  while((ifs >> fileName) && ++i<count){
    if(fileName == "") 
      break;
    testMoveFile<test_state_t>(OslConfig::testCsaFile(fileName));
  }
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
