// fixedEval.t.cc
#include "osl/search/fixedEval.h"
#include "osl/oslConfig.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
using namespace osl;
using namespace osl::search;

class FixedEvalTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE(FixedEvalTest);
  CPPUNIT_TEST(testShow);
  CPPUNIT_TEST(testConstant);
  CPPUNIT_TEST_SUITE_END();
public:
  void testShow()
  {
    if (! OslConfig::verbose())
      return;
    std::cerr << "max\t" << eval::EvalTraits<BLACK>::MAX_VALUE << "\n";
    std::cerr << "foul\t" << FixedEval::winByFoul(BLACK) << "\n";
    std::cerr << "checkmate\t" << FixedEval::winByCheckmate(BLACK) << "\n";
    std::cerr << "window max\t" << FixedEval::windowMax(BLACK) << "\n";
    std::cerr << "win th\t" << FixedEval::winThreshold(BLACK) << "\n";
    std::cerr << "-inf\t" << FixedEval::minusInfty(BLACK) << "\n";
    std::cerr << "threat\t" << FixedEval::threatmatePenalty(BLACK) << "\n";
  }
  static bool isEven(int val)
  {
    return (val % 2) == 0;
  }
  void testConstant() {
    CPPUNIT_ASSERT(FixedEval::winByFoul(BLACK) > 0);
    CPPUNIT_ASSERT(FixedEval::winByFoul(WHITE) < 0);
    CPPUNIT_ASSERT(isEven(FixedEval::winByFoul(BLACK)));
    CPPUNIT_ASSERT(isEven(FixedEval::winByFoul(WHITE)));

    CPPUNIT_ASSERT_EQUAL(FixedEval::winByFoul(BLACK), FixedEval::winByLoop(BLACK));
    CPPUNIT_ASSERT_EQUAL(FixedEval::winByFoul(WHITE), FixedEval::winByLoop(WHITE));

    CPPUNIT_ASSERT(FixedEval::winByCheckmate(BLACK) > 0);
    CPPUNIT_ASSERT(FixedEval::winByCheckmate(WHITE) < 0);
    CPPUNIT_ASSERT(isEven(FixedEval::winByCheckmate(BLACK)));
    CPPUNIT_ASSERT(isEven(FixedEval::winByCheckmate(WHITE)));

    CPPUNIT_ASSERT(FixedEval::isWinValue(BLACK, FixedEval::winByCheckmate(BLACK)));
    CPPUNIT_ASSERT(FixedEval::isWinValue(WHITE, FixedEval::winByCheckmate(WHITE)));

    CPPUNIT_ASSERT(FixedEval::brinkmatePenalty(BLACK, 0) < 0);
    CPPUNIT_ASSERT(FixedEval::brinkmatePenalty(WHITE, 0) > 0);
    CPPUNIT_ASSERT(isEven(FixedEval::brinkmatePenalty(BLACK, 2)));
    CPPUNIT_ASSERT(isEven(FixedEval::brinkmatePenalty(WHITE, 3)));
    CPPUNIT_ASSERT(FixedEval::brinkmatePenalty(BLACK, 0) 
		   > FixedEval::brinkmatePenalty(BLACK, 1000));
    CPPUNIT_ASSERT(FixedEval::brinkmatePenalty(WHITE, 0) 
		   < FixedEval::brinkmatePenalty(WHITE, 1000));
    CPPUNIT_ASSERT(! FixedEval::isWinValue
		   (WHITE, FixedEval::brinkmatePenalty(BLACK, 4000)));

    CPPUNIT_ASSERT(FixedEval::threatmatePenalty(BLACK) < 0);
    CPPUNIT_ASSERT(FixedEval::threatmatePenalty(WHITE) > 0);
    CPPUNIT_ASSERT(isEven(FixedEval::threatmatePenalty(BLACK)));
    CPPUNIT_ASSERT(isEven(FixedEval::threatmatePenalty(WHITE)));

    CPPUNIT_ASSERT(FixedEval::minusInfty(BLACK) < 0);
    CPPUNIT_ASSERT(FixedEval::minusInfty(WHITE) > 0);
    CPPUNIT_ASSERT(isEven(FixedEval::minusInfty(BLACK)));
    CPPUNIT_ASSERT(isEven(FixedEval::minusInfty(WHITE)));

    CPPUNIT_ASSERT(eval::isConsistentValue(FixedEval::minusInfty(BLACK)));
    CPPUNIT_ASSERT(eval::isConsistentValue(FixedEval::minusInfty(WHITE)));

    CPPUNIT_ASSERT(FixedEval::winThreshold(BLACK) > 0);
    CPPUNIT_ASSERT(FixedEval::winThreshold(WHITE) < 0);
    CPPUNIT_ASSERT(! isEven(FixedEval::winThreshold(BLACK)));
    CPPUNIT_ASSERT(! isEven(FixedEval::winThreshold(WHITE)));

    CPPUNIT_ASSERT(FixedEval::windowMax(BLACK) > 0);
    CPPUNIT_ASSERT(FixedEval::windowMax(WHITE) < 0);
    CPPUNIT_ASSERT(isEven(FixedEval::windowMax(BLACK)));
    CPPUNIT_ASSERT(isEven(FixedEval::windowMax(WHITE)));

    CPPUNIT_ASSERT(FixedEval::winByCheckmate(BLACK) < FixedEval::winByFoul(BLACK));
    CPPUNIT_ASSERT(FixedEval::winByCheckmate(WHITE) > FixedEval::winByFoul(WHITE));

    CPPUNIT_ASSERT(FixedEval::threatmatePenalty(BLACK) < FixedEval::winByCheckmate(BLACK));
    CPPUNIT_ASSERT(FixedEval::threatmatePenalty(WHITE) > FixedEval::winByCheckmate(WHITE));
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(FixedEvalTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
