// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESGraph_TextFontDef_HeaderFile
#define _IGESGraph_TextFontDef_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IGESGraph_TextFontDef_HeaderFile
#include <Handle_IGESGraph_TextFontDef.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_IGESGraph_TextFontDef_HeaderFile
#include <Handle_IGESGraph_TextFontDef.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_IGESBasic_HArray1OfHArray1OfInteger_HeaderFile
#include <Handle_IGESBasic_HArray1OfHArray1OfInteger.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TCollection_HAsciiString;
class TColStd_HArray1OfInteger;
class IGESBasic_HArray1OfHArray1OfInteger;
class Standard_DimensionMismatch;
class Standard_OutOfRange;


//! defines IGES Text Font Definition Entity, Type <310> <br>
//!           in package IGESGraph <br>
//! <br>
//!           Used to define the appearance of characters in a text font. <br>
//!           It may be used to describe a complete font or a <br>
//!           modification to a subset of characters in another font. <br>
class IGESGraph_TextFontDef : public IGESData_IGESEntity {

public:

  
  Standard_EXPORT   IGESGraph_TextFontDef();
  //! This method is used to set the fields of the class <br>
//!           TextFontDef <br>
//!      - aFontCode         : Font Code <br>
//!      - aFontName         : Font Name <br>
//!      - aSupersededFont   : Number of superseded font <br>
//!      - aSupersededEntity : Text Definition Entity <br>
//!      - aScale            : No. of grid units = 1 text height unit <br>
//!      - allASCIICodes     : ASCII codes for characters <br>
//!      - allNextCharX & Y  : Grid locations of the next <br>
//!                            character's origin (Integer vals) <br>
//!      - allPenMotions     : No. of pen motions for the characters <br>
//!      - allPenFlags       : Pen up/down flags, <br>
//!                            0 = Down (default), 1 = Up <br>
//!      - allMovePenToX & Y : Grid locations the pen will move to <br>
//! This method initializes the fields of the class TextFontDef. <br>
//! An exception is raised if the lengths of allASCIICodes, <br>
//! allNextChars, allPenMotions, allPenFlags and allMovePenTo <br>
//! are not same. <br>
  Standard_EXPORT     void Init(const Standard_Integer aFontCode,const Handle(TCollection_HAsciiString)& aFontName,const Standard_Integer aSupersededFont,const Handle(IGESGraph_TextFontDef)& aSupersededEntity,const Standard_Integer aScale,const Handle(TColStd_HArray1OfInteger)& allASCIICodes,const Handle(TColStd_HArray1OfInteger)& allNextCharX,const Handle(TColStd_HArray1OfInteger)& allNextCharY,const Handle(TColStd_HArray1OfInteger)& allPenMotions,const Handle(IGESBasic_HArray1OfHArray1OfInteger)& allPenFlags,const Handle(IGESBasic_HArray1OfHArray1OfInteger)& allMovePenToX,const Handle(IGESBasic_HArray1OfHArray1OfInteger)& allMovePenToY) ;
  //! returns the font code. <br>
  Standard_EXPORT     Standard_Integer FontCode() const;
  //! returns the font name. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString FontName() const;
  //! True if this definition supersedes another <br>
//!           TextFontDefinition Entity, <br>
//! False if it supersedes value. <br>
  Standard_EXPORT     Standard_Boolean IsSupersededFontEntity() const;
  //! returns the font number which this entity modifies. <br>
  Standard_EXPORT     Standard_Integer SupersededFontCode() const;
  //! returns the font entity which this entity modifies. <br>
  Standard_EXPORT     Handle_IGESGraph_TextFontDef SupersededFontEntity() const;
  //! returns the number of grid units which equal one text height unit. <br>
  Standard_EXPORT     Standard_Integer Scale() const;
  //! returns the number of characters in this definition. <br>
  Standard_EXPORT     Standard_Integer NbCharacters() const;
  //! returns the ASCII code of Chnum'th character. <br>
//! Exception OutOfRange is raised if Chnum <= 0 or Chnum > NbCharacters <br>
  Standard_EXPORT     Standard_Integer ASCIICode(const Standard_Integer Chnum) const;
  //! returns grid location of origin of character next to Chnum'th char. <br>
//! Exception OutOfRange is raised if Chnum <= 0 or Chnum > NbCharacters <br>
  Standard_EXPORT     void NextCharOrigin(const Standard_Integer Chnum,Standard_Integer& NX,Standard_Integer& NY) const;
  //! returns number of pen motions for Chnum'th character. <br>
//! Exception OutOfRange is raised if Chnum <= 0 or Chnum > NbCharacters <br>
  Standard_EXPORT     Standard_Integer NbPenMotions(const Standard_Integer Chnum) const;
  //! returns pen status(True if 1, False if 0) of Motionnum'th motion <br>
//! of Chnum'th character. <br>
//! Exception raised if Chnum <= 0 or Chnum > NbCharacters or <br>
//! Motionnum <= 0 or Motionnum >  NbPenMotions <br>
  Standard_EXPORT     Standard_Boolean IsPenUp(const Standard_Integer Chnum,const Standard_Integer Motionnum) const;
  
  Standard_EXPORT     void NextPenPosition(const Standard_Integer Chnum,const Standard_Integer Motionnum,Standard_Integer& IX,Standard_Integer& IY) const;




  DEFINE_STANDARD_RTTI(IGESGraph_TextFontDef)

protected:




private: 


Standard_Integer theFontCode;
Handle_TCollection_HAsciiString theFontName;
Standard_Integer theSupersededFontCode;
Handle_IGESGraph_TextFontDef theSupersededFontEntity;
Standard_Integer theScale;
Handle_TColStd_HArray1OfInteger theASCIICodes;
Handle_TColStd_HArray1OfInteger theNextCharOriginX;
Handle_TColStd_HArray1OfInteger theNextCharOriginY;
Handle_TColStd_HArray1OfInteger theNbPenMotions;
Handle_IGESBasic_HArray1OfHArray1OfInteger thePenMotions;
Handle_IGESBasic_HArray1OfHArray1OfInteger thePenMovesToX;
Handle_IGESBasic_HArray1OfHArray1OfInteger thePenMovesToY;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
