// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_Process_HeaderFile
#define _OSD_Process_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <OSD_Error.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
class OSD_OSDError;
class TCollection_AsciiString;
class Quantity_Date;
class OSD_Path;


//! A set of system process tools
class OSD_Process 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Initializes the object and prepare for a possible dump
  Standard_EXPORT OSD_Process();
  
  //! Issues a shell command
  //! ShowWindow : flag to allow show/hide of the window ( only used on WNT )
  Standard_EXPORT   void Spawn (const TCollection_AsciiString& cmd, const Standard_Boolean ShowWindow = Standard_True) ;
  
  //! Returns the terminal used (vt100, vt200 ,sun-cmd ...)
  Standard_EXPORT   void TerminalType (TCollection_AsciiString& Name) ;
  
  //! Gets system date.
  Standard_EXPORT   Quantity_Date SystemDate() ;
  
  //! Returns the 'User Id'.
  Standard_EXPORT   Standard_Integer UserId() ;
  
  //! Returns the user name.
  Standard_EXPORT   TCollection_AsciiString UserName() ;
  
  //! Returns True if the process user is the super-user.
  Standard_EXPORT   Standard_Boolean IsSuperUser() ;
  
  //! Returns the 'Process Id'
  Standard_EXPORT   Standard_Integer ProcessId() ;
  
  //! Returns the current path where the process is.
  Standard_EXPORT   OSD_Path CurrentDirectory() ;
  
  //! Changes the current process directory.
  Standard_EXPORT   void SetCurrentDirectory (const OSD_Path& where) ;
  
  //! Returns TRUE if an error occurs
  Standard_EXPORT   Standard_Boolean Failed()  const;
  
  //! Resets error counter to zero
  Standard_EXPORT   void Reset() ;
  
  //! Raises OSD_Error
  Standard_EXPORT   void Perror() ;
  
  //! Returns error number if 'Failed' is TRUE.
  Standard_EXPORT   Standard_Integer Error()  const;




protected:





private:



  OSD_Error myError;


};







#endif // _OSD_Process_HeaderFile
