/*
 * keyindex.h - Routines to list an OpenPGP key.
 *
 * Copyright 2002-2008 Jonathan McDowell <noodles@earth.li>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __KEYINDEX_H__
#define __KEYINDEX_H__

#include <stdbool.h>

#include "keydb.h"
#include "keystructs.h"

/**
 *	key_index - List a set of OpenPGP keys.
 *	@keys: The keys to display.
 *      @verbose: Should we list sigs as well?
 *	@fingerprint: List the fingerprint?
 *	@skshash: List the sks hash?
 *	@html: Should we tailor the output for HTML?
 *
 *	This function takes a list of OpenPGP public keys and displays an index
 *	of them. Useful for debugging or the keyserver Index function.
 */
int key_index(struct onak_dbctx *dbctx,
		struct openpgp_publickey *keys, bool verbose,
		bool fingerprint, bool skshash, bool html);

/**
 *	mrkey_index - List a set of OpenPGP keys in the MRHKP format.
 *	@keys: The keys to display.
 *
 *	This function takes a list of OpenPGP public keys and displays a
 *	machine readable list of them.
 */
int mrkey_index(struct openpgp_publickey *keys);

/**
 *	html_escape - Takes a string and converts it to HTML.
 *	@src: The string to HTMLize.
 *	@src_len: The length of the source string
 *	@dst: A buffer to put the escaped string into
 *	@dst_len: Length of the destination buffer (including a trailing NULL)
 *
 *	Takes a string and escapes any HTML entities (<, >, &, ", '). Returns
 *	dst.
 */
const char *html_escape(const char *src, size_t src_len,
		char *dst, size_t dst_len);
#endif
